// Generated by delombok at Fri Apr 19 18:23:12 UTC 2024
package org.matomo.java.tracking.servlet;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

/**
 * Wraps a HttpServletRequest to be compatible with both the Jakarta and the Java EE API.
 */
public final class HttpServletRequestWrapper {
  @Nullable
  private final StringBuffer requestURL;
  @Nullable
  private final String remoteAddr;
  @Nullable
  private final String remoteUser;
  @Nullable
  private final Map<String, String> headers;
  @Nullable
  private final CookieWrapper[] cookies;

  /**
   * Returns an enumeration of all the header names this request contains. If the request has no
   * headers, this method returns an empty enumeration.
   *
   * @return an enumeration of all the header names sent with this request
   */
  public Enumeration<String> getHeaderNames() {
    return headers == null ? Collections.emptyEnumeration() : Collections.enumeration(headers.keySet());
  }

  /**
   * Returns the value of the specified request header as a String. If the request did not include a
   * header of the specified name, this method returns null. If there are multiple headers with the
   * same name, this method returns the last header in the request. The header name is case
   * insensitive. You can use this method with any request header.
   *
   * @param name a String specifying the header name (case insensitive) - must not be {@code null}.
   * @return a String containing the value of the requested header, or null if the request does not
   *        have a header of that name
   */
  @Nullable
  public String getHeader(@NonNull String name) {
    if (name == null) {
      throw new java.lang.NullPointerException("name is marked non-null but is null");
    }
    return headers == null ? null : headers.get(name.toLowerCase(Locale.ROOT));
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  HttpServletRequestWrapper(@Nullable final StringBuffer requestURL, @Nullable final String remoteAddr, @Nullable final String remoteUser, @Nullable final Map<String, String> headers, @Nullable final CookieWrapper[] cookies) {
    this.requestURL = requestURL;
    this.remoteAddr = remoteAddr;
    this.remoteUser = remoteUser;
    this.headers = headers;
    this.cookies = cookies;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class HttpServletRequestWrapperBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private StringBuffer requestURL;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String remoteAddr;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String remoteUser;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, String> headers;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private CookieWrapper[] cookies;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    HttpServletRequestWrapperBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpServletRequestWrapper.HttpServletRequestWrapperBuilder requestURL(@Nullable final StringBuffer requestURL) {
      this.requestURL = requestURL;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpServletRequestWrapper.HttpServletRequestWrapperBuilder remoteAddr(@Nullable final String remoteAddr) {
      this.remoteAddr = remoteAddr;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpServletRequestWrapper.HttpServletRequestWrapperBuilder remoteUser(@Nullable final String remoteUser) {
      this.remoteUser = remoteUser;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpServletRequestWrapper.HttpServletRequestWrapperBuilder headers(@Nullable final Map<String, String> headers) {
      this.headers = headers;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpServletRequestWrapper.HttpServletRequestWrapperBuilder cookies(@Nullable final CookieWrapper[] cookies) {
      this.cookies = cookies;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpServletRequestWrapper build() {
      return new HttpServletRequestWrapper(this.requestURL, this.remoteAddr, this.remoteUser, this.headers, this.cookies);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "HttpServletRequestWrapper.HttpServletRequestWrapperBuilder(requestURL=" + this.requestURL + ", remoteAddr=" + this.remoteAddr + ", remoteUser=" + this.remoteUser + ", headers=" + this.headers + ", cookies=" + java.util.Arrays.deepToString(this.cookies) + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static HttpServletRequestWrapper.HttpServletRequestWrapperBuilder builder() {
    return new HttpServletRequestWrapper.HttpServletRequestWrapperBuilder();
  }

  @Nullable
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StringBuffer getRequestURL() {
    return this.requestURL;
  }

  @Nullable
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRemoteAddr() {
    return this.remoteAddr;
  }

  @Nullable
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRemoteUser() {
    return this.remoteUser;
  }

  @Nullable
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getHeaders() {
    return this.headers;
  }

  @Nullable
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CookieWrapper[] getCookies() {
    return this.cookies;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof HttpServletRequestWrapper)) return false;
    final HttpServletRequestWrapper other = (HttpServletRequestWrapper) o;
    final java.lang.Object this$requestURL = this.getRequestURL();
    final java.lang.Object other$requestURL = other.getRequestURL();
    if (this$requestURL == null ? other$requestURL != null : !this$requestURL.equals(other$requestURL)) return false;
    final java.lang.Object this$remoteAddr = this.getRemoteAddr();
    final java.lang.Object other$remoteAddr = other.getRemoteAddr();
    if (this$remoteAddr == null ? other$remoteAddr != null : !this$remoteAddr.equals(other$remoteAddr)) return false;
    final java.lang.Object this$remoteUser = this.getRemoteUser();
    final java.lang.Object other$remoteUser = other.getRemoteUser();
    if (this$remoteUser == null ? other$remoteUser != null : !this$remoteUser.equals(other$remoteUser)) return false;
    final java.lang.Object this$headers = this.getHeaders();
    final java.lang.Object other$headers = other.getHeaders();
    if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) return false;
    if (!java.util.Arrays.deepEquals(this.getCookies(), other.getCookies())) return false;
    return true;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $requestURL = this.getRequestURL();
    result = result * PRIME + ($requestURL == null ? 43 : $requestURL.hashCode());
    final java.lang.Object $remoteAddr = this.getRemoteAddr();
    result = result * PRIME + ($remoteAddr == null ? 43 : $remoteAddr.hashCode());
    final java.lang.Object $remoteUser = this.getRemoteUser();
    result = result * PRIME + ($remoteUser == null ? 43 : $remoteUser.hashCode());
    final java.lang.Object $headers = this.getHeaders();
    result = result * PRIME + ($headers == null ? 43 : $headers.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getCookies());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "HttpServletRequestWrapper(requestURL=" + this.getRequestURL() + ", remoteAddr=" + this.getRemoteAddr() + ", remoteUser=" + this.getRemoteUser() + ", headers=" + this.getHeaders() + ", cookies=" + java.util.Arrays.deepToString(this.getCookies()) + ")";
  }
}
