/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.table;

import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.AgentSetBuilder;
import org.nlogo.api.AnonymousReporter;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.Dump;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.LogoException;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.core.CompilerException;
import org.nlogo.core.ExtensionObject;
import org.nlogo.core.LogoList;
import org.nlogo.core.Primitive;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;
import org.nlogo.extensions.table.JsonPrims;
import org.nlogo.extensions.table.Table;
import org.nlogo.nvm.ExtensionContext;
import org.nlogo.nvm.Reporter;

public class TableExtension
extends DefaultClassManager {
    static WeakHashMap<Table, Long> tables = new WeakHashMap();

    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("clear", (Primitive)new Clear());
        primManager.addPrimitive("get", (Primitive)new Get());
        primManager.addPrimitive("get-or-default", (Primitive)new GetOrDefault());
        primManager.addPrimitive("has-key?", (Primitive)new HasKey());
        primManager.addPrimitive("keys", (Primitive)new Keys());
        primManager.addPrimitive("length", (Primitive)new Length());
        primManager.addPrimitive("make", (Primitive)new Make());
        primManager.addPrimitive("put", (Primitive)new Put());
        primManager.addPrimitive("remove", (Primitive)new Remove());
        primManager.addPrimitive("from-list", (Primitive)new FromList());
        primManager.addPrimitive("counts", (Primitive)new Counts());
        primManager.addPrimitive("to-list", (Primitive)new ToList());
        primManager.addPrimitive("values", (Primitive)new Values());
        primManager.addPrimitive("group-items", (Primitive)new GroupItems());
        primManager.addPrimitive("group-agents", (Primitive)new GroupAgents());
        primManager.addPrimitive("from-json-file", (Primitive)new JsonPrims.FromJsonFile());
        primManager.addPrimitive("from-json", (Primitive)new JsonPrims.FromJson());
        primManager.addPrimitive("to-json", (Primitive)new JsonPrims.ToJson());
    }

    public void clearAll() {
        tables.clear();
        Table.resetNext();
    }

    public StringBuilder exportWorld() {
        StringBuilder buffer = new StringBuilder();
        for (Table table : tables.keySet()) {
            buffer.append(Dump.csv().encode(Dump.extensionObject((ExtensionObject)table, (boolean)true, (boolean)true, (boolean)false)) + "\n");
        }
        return buffer;
    }

    public void importWorld(List<String[]> lines, ExtensionManager reader, ImportErrorHandler handler) throws ExtensionException {
        for (String[] line : lines) {
            try {
                reader.readFromString(line[0]);
            }
            catch (CompilerException e) {
                handler.showError("Error importing arrays", e.getMessage(), "This array will be ignored");
            }
        }
    }

    public ExtensionObject readExtensionObject(ExtensionManager reader, String typeName, String value) throws ExtensionException {
        try {
            String[] s = value.split(":", 2);
            long id = Long.parseLong(s[0]);
            Table table = this.getOrCreateTableFromId(id);
            if (s.length > 1) {
                table.addAll((LogoList)reader.readFromString(s[1]));
            }
            return table;
        }
        catch (CompilerException ex) {
            throw new ExtensionException(ex.getMessage());
        }
    }

    private Table getOrCreateTableFromId(long id) {
        for (Table table : tables.keySet()) {
            if (table.id != id) continue;
            return table;
        }
        Table t = new Table(id);
        tables.put(t, t.id);
        return t;
    }

    public static Table getTable(Argument arg) throws ExtensionException {
        Object maybeTable = arg.get();
        if (!(maybeTable instanceof Table)) {
            throw new ExtensionException("not a table: " + Dump.logoObject((Object)maybeTable));
        }
        return (Table)maybeTable;
    }

    private static boolean isValidKey(Object key) {
        return key instanceof Double || key instanceof String || key instanceof Boolean || key instanceof LogoList && TableExtension.containsOnlyValidKeys((LogoList)key);
    }

    private static void ensureKeyValidity(Object key) throws ExtensionException {
        if (!TableExtension.isValidKey(key)) {
            throw new ExtensionException(Dump.logoObject((Object)key) + " is not a valid table key (a table key may only be a number, a string, true or false, or a list whose items are valid keys)");
        }
    }

    private static boolean containsOnlyValidKeys(LogoList list) {
        Iterator it = list.javaIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (TableExtension.isValidKey(o)) continue;
            return false;
        }
        return true;
    }

    public static class Clear
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Table t = TableExtension.getTable(args[0]);
            t.clear();
        }
    }

    public static class Get
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object key;
            Table t = TableExtension.getTable(args[0]);
            Object result = t.get(key = args[1].get());
            if (result == null) {
                throw new ExtensionException("No value for " + Dump.logoObject((Object)key) + " in table.");
            }
            return result;
        }
    }

    public static class GetOrDefault
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException {
            Table t = TableExtension.getTable(args[0]);
            Object key = args[1].get();
            return t.getOrDefault(key, args[2].get());
        }
    }

    public static class HasKey
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.BooleanType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Table t = TableExtension.getTable(args[0]);
            return t.containsKey(args[1].get());
        }
    }

    public static class Keys
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Table t = TableExtension.getTable(args[0]);
            return LogoList.fromJava(t.keySet());
        }
    }

    public static class Length
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Table t = TableExtension.getTable(args[0]);
            return (double)t.size();
        }
    }

    public static class Make
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Table t = new Table();
            tables.put(t, t.id);
            return t;
        }
    }

    public static class Put
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType(), Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Table t = TableExtension.getTable(args[0]);
            Object key = args[1].get();
            TableExtension.ensureKeyValidity(key);
            t.put(key, args[2].get());
        }
    }

    public static class Remove
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Table t = TableExtension.getTable(args[0]);
            t.remove(args[1].get());
        }
    }

    public static class FromList
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoList alist = args[0].getList();
            Table t = new Table(alist);
            tables.put(t, t.id);
            return t;
        }
    }

    public static class Counts
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoList lst = args[0].getList();
            Table t = new Table();
            tables.put(t, t.id);
            for (Object obj : lst.javaIterable()) {
                t.put(obj, 1.0 + t.getOrDefault(obj, 0.0));
            }
            return t;
        }
    }

    public static class ToList
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Table t = TableExtension.getTable(args[0]);
            return t.toList();
        }
    }

    public static class Values
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Table t = TableExtension.getTable(args[0]);
            return t.valuesList();
        }
    }

    public static class GroupItems
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType(), Syntax.ReporterType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoList lst = args[0].getList();
            AnonymousReporter classifier = args[1].getReporter();
            Table t = new Table();
            tables.put(t, t.id);
            for (Object x : lst.toJava()) {
                Object group = classifier.report(context, new Object[]{x});
                TableExtension.ensureKeyValidity(group);
                t.put(group, t.getOrDefault(group, LogoList.Empty()).lput(x));
            }
            return t;
        }
    }

    public static class GroupAgents
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.AgentsetType(), Syntax.ReporterBlockType()}, (int)Syntax.WildcardType(), (String)"OTPL", (String)"-TPL");
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            AgentSet agents = (AgentSet)args[0].getAgentSet();
            Reporter classifier = ((org.nlogo.nvm.Argument)args[1]).unevaluatedArgument();
            org.nlogo.nvm.Context childContext = new org.nlogo.nvm.Context(((ExtensionContext)context).nvmContext(), agents);
            AgentIterator agentIter = agents.shufflerator(context.getRNG());
            Table t = new Table();
            tables.put(t, t.id);
            while (agentIter.hasNext()) {
                Agent agent = agentIter.next();
                Object group = childContext.evaluateReporter(agent, classifier);
                TableExtension.ensureKeyValidity(group);
                ((AgentSetBuilder)t.computeIfAbsent(group, k -> new AgentSetBuilder(agents.kind()))).add(agent);
            }
            t.replaceAll((k, v) -> ((AgentSetBuilder)v).build());
            return t;
        }
    }
}

