/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.barcode;

import java.util.List;
import org.opencv.core.Mat;

public class BarcodeDetector {
    protected final long nativeObj;

    protected BarcodeDetector(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static BarcodeDetector __fromPtr__(long addr) {
        return new BarcodeDetector(addr);
    }

    public BarcodeDetector(String prototxt_path, String model_path) {
        this.nativeObj = BarcodeDetector.BarcodeDetector_0(prototxt_path, model_path);
    }

    public BarcodeDetector(String prototxt_path) {
        this.nativeObj = BarcodeDetector.BarcodeDetector_1(prototxt_path);
    }

    public BarcodeDetector() {
        this.nativeObj = BarcodeDetector.BarcodeDetector_2();
    }

    public boolean detect(Mat img, Mat points) {
        return BarcodeDetector.detect_0(this.nativeObj, img.nativeObj, points.nativeObj);
    }

    public boolean decode(Mat img, Mat points, List<String> decoded_info, List<Integer> decoded_type) {
        return BarcodeDetector.decode_0(this.nativeObj, img.nativeObj, points.nativeObj, decoded_info, decoded_type);
    }

    public boolean detectAndDecode(Mat img, List<String> decoded_info, List<Integer> decoded_type, Mat points) {
        return BarcodeDetector.detectAndDecode_0(this.nativeObj, img.nativeObj, decoded_info, decoded_type, points.nativeObj);
    }

    public boolean detectAndDecode(Mat img, List<String> decoded_info, List<Integer> decoded_type) {
        return BarcodeDetector.detectAndDecode_1(this.nativeObj, img.nativeObj, decoded_info, decoded_type);
    }

    protected void finalize() throws Throwable {
        BarcodeDetector.delete(this.nativeObj);
    }

    private static native long BarcodeDetector_0(String var0, String var1);

    private static native long BarcodeDetector_1(String var0);

    private static native long BarcodeDetector_2();

    private static native boolean detect_0(long var0, long var2, long var4);

    private static native boolean decode_0(long var0, long var2, long var4, List<String> var6, List<Integer> var7);

    private static native boolean detectAndDecode_0(long var0, long var2, List<String> var4, List<Integer> var5, long var6);

    private static native boolean detectAndDecode_1(long var0, long var2, List<String> var4, List<Integer> var5);

    private static native void delete(long var0);
}

