/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.Serializable;
import java.util.Arrays;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.IndexedAgentSet;
import org.nlogo.api.AgentSet;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.core.AgentKind;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public class ArrayAgentSet
extends IndexedAgentSet {
    private final Agent[] array;
    private final int arraySize;

    public ArrayAgentSet(AgentKind kind, String printName, Agent[] array) {
        this.array = array;
        super(kind, printName);
        Object object = Predef$.MODULE$.refArrayOps((Object[])array);
        this.arraySize = ArrayOps$.MODULE$.size$extension(object);
    }

    private AgentKind kind$accessor() {
        return super.kind();
    }

    private String printName$accessor() {
        return super.printName();
    }

    public Agent[] array() {
        return this.array;
    }

    @Override
    public LogoList toLogoList() {
        Object[] objectArray;
        if (!this.kind$accessor().mortal()) {
            objectArray = (Agent[])this.array().clone();
        } else {
            ArrayBuffer buf = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Agent[0]));
            AgentIterator iter = this.iterator();
            while (iter.hasNext()) {
                buf.$plus$eq((Object)iter.next());
            }
            objectArray = (Agent[])buf.toArray(ClassTag$.MODULE$.apply(Agent.class));
        }
        Object[] freshArray = objectArray;
        Arrays.sort(freshArray);
        Object object = Predef$.MODULE$.refArrayOps(freshArray);
        return LogoList$.MODULE$.fromIterator((scala.collection.Iterator<? extends Object>)ArrayOps$.MODULE$.iterator$extension(object));
    }

    @Override
    public boolean isEmpty() {
        if (!this.kind$accessor().mortal()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.array());
            return ArrayOps$.MODULE$.isEmpty$extension(object);
        }
        return !this.iterator().hasNext();
    }

    @Override
    public int count() {
        if (!this.kind$accessor().mortal()) {
            return this.arraySize;
        }
        int result = 0;
        AgentIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++result;
        }
        return result;
    }

    @Override
    public boolean checkCount(int checkValue, Function2<Object, Object, Object> check) {
        if (!this.kind$accessor().mortal()) {
            return check.apply$mcZII$sp(this.arraySize, checkValue);
        }
        int totalCount = 0;
        AgentIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            if (++totalCount <= checkValue) continue;
            check.apply$mcZII$sp(totalCount, checkValue);
        }
        return check.apply$mcZII$sp(totalCount, checkValue);
    }

    @Override
    public boolean containsSameAgents(AgentSet otherSet) {
        HashSet set = (HashSet)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new org.nlogo.api.Agent[0]));
        AgentIterator iter = this.iterator();
        while (iter.hasNext()) {
            set.$plus$eq((Object)iter.next());
        }
        return CollectionConverters$.MODULE$.IterableHasAsScala(otherSet.agents()).asScala().forall((Function1 & Serializable)elem -> set.contains(elem));
    }

    @Override
    public Agent getByIndex(int index) {
        return this.array()[index];
    }

    @Override
    public boolean contains(org.nlogo.api.Agent agent) {
        AgentIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != agent) continue;
            return true;
        }
        return false;
    }

    @Override
    public Agent randomOne(int precomputedCount, int random) {
        if (!this.kind$accessor().mortal()) {
            return this.array()[random];
        }
        AgentIterator iter = this.iterator();
        for (int i = 0; i < random; ++i) {
            iter.next();
        }
        return iter.next();
    }

    @Override
    public Agent[] randomTwo(int precomputedCount, int smallRandom, int bigRandom) {
        int i;
        if (!this.kind$accessor().mortal()) {
            return new Agent[]{this.array()[smallRandom], this.array()[bigRandom]};
        }
        AgentIterator it = this.iterator();
        for (i = 0; i < smallRandom; ++i) {
            it.next();
        }
        Agent first = it.next();
        ++i;
        while (i < bigRandom) {
            it.next();
            ++i;
        }
        Agent second = it.next();
        return new Agent[]{first, second};
    }

    @Override
    public Agent[] randomSubsetGeneral(int resultSize, int precomputedCount, MersenneTwisterFast random) {
        Agent[] result = new Agent[resultSize];
        if (precomputedCount == this.arraySize) {
            int i = 0;
            int j = 0;
            while (j < resultSize) {
                if (random.nextInt(precomputedCount - i) < resultSize - j) {
                    result[j] = this.array()[i];
                    ++j;
                }
                ++i;
            }
        } else {
            AgentIterator iter = this.iterator();
            int i = 0;
            int j = 0;
            while (j < resultSize) {
                Agent next = iter.next();
                if (random.nextInt(precomputedCount - i) < resultSize - j) {
                    result[j] = next;
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public AgentIterator iterator() {
        if (!this.kind$accessor().mortal()) {
            return new Iterator(this.array());
        }
        return new DeadSkippingIterator(this.array());
    }

    @Override
    public AgentIterator shufflerator(MersenneTwisterFast rng) {
        return new Shufflerator(rng, this.array());
    }

    public final class DeadSkippingIterator
    implements AgentIterator {
        private final Agent[] array;
        private int index;
        private final int arraySize;

        public DeadSkippingIterator(Agent[] array) {
            this.array = array;
            this.index = 0;
            Object object = Predef$.MODULE$.refArrayOps((Object[])array);
            this.arraySize = ArrayOps$.MODULE$.size$extension(object);
            while (this.index < this.arraySize && array[this.index]._id == -1L) {
                ++this.index;
            }
        }

        private Agent[] array() {
            return this.array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.arraySize;
        }

        @Override
        public Agent next() {
            int result = this.index;
            do {
                ++this.index;
            } while (this.index < this.arraySize && this.array()[this.index]._id == -1L);
            return this.array()[result];
        }
    }

    public final class Iterator
    implements AgentIterator {
        private final Agent[] array;
        private int index;
        private final int arraySize;

        public Iterator(Agent[] array) {
            this.array = array;
            this.index = 0;
            Object object = Predef$.MODULE$.refArrayOps((Object[])array);
            this.arraySize = ArrayOps$.MODULE$.size$extension(object);
        }

        private Agent[] array() {
            return this.array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.arraySize;
        }

        @Override
        public Agent next() {
            Agent result = this.array()[this.index];
            ++this.index;
            return result;
        }
    }

    public final class Shufflerator
    implements AgentIterator {
        private final MersenneTwisterFast rng;
        private int i;
        private final Agent[] copy;
        private Agent nextOne;

        public Shufflerator(MersenneTwisterFast rng, Agent[] a) {
            this.rng = rng;
            this.i = 0;
            this.copy = (Agent[])a.clone();
            this.nextOne = null;
            while (this.i < this.copy.length && this.copy[this.i] == null) {
                ++this.i;
            }
            this.fetch();
        }

        @Override
        public boolean hasNext() {
            return this.nextOne != null;
        }

        @Override
        public Agent next() {
            Agent result = this.nextOne;
            this.fetch();
            return result;
        }

        private void fetch() {
            do {
                if (this.i >= this.copy.length) {
                    this.nextOne = null;
                    return;
                }
                if (this.i < this.copy.length - 1) {
                    int r = this.i + this.rng.nextInt(this.copy.length - this.i);
                    this.nextOne = this.copy[r];
                    this.copy[r] = this.copy[this.i];
                } else {
                    this.nextOne = this.copy[this.i];
                }
                ++this.i;
            } while (this.nextOne == null || this.nextOne._id == -1L);
        }
    }
}

