/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Locale;
import org.nlogo.agent.HorizCylinder;
import org.nlogo.agent.RootsTable;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Topology$;
import org.nlogo.agent.Torus;
import org.nlogo.agent.VertCylinder;
import org.nlogo.agent.WorldJ;
import org.nlogo.api.AgentException;
import org.nlogo.api.WorldDimensionException;
import org.nlogo.core.WorldDimensions;
import scala.Int$;
import scala.collection.immutable.Seq;

public interface DimensionManagement {
    public static void $init$(DimensionManagement $this) {
        $this.rootsTable_$eq(null);
        $this._worldWidthBoxed_$eq(Int$.MODULE$.int2double(((WorldJ)((Object)$this))._worldWidth));
        $this._worldHeightBoxed_$eq(Int$.MODULE$.int2double(((WorldJ)((Object)$this))._worldHeight));
        $this._minPxcorBoxed_$eq(Int$.MODULE$.int2double(((WorldJ)((Object)$this))._minPxcor));
        $this._maxPxcorBoxed_$eq(Int$.MODULE$.int2double(((WorldJ)((Object)$this))._maxPxcor));
        $this._minPycorBoxed_$eq(Int$.MODULE$.int2double(((WorldJ)((Object)$this))._minPycor));
        $this._maxPycorBoxed_$eq(Int$.MODULE$.int2double(((WorldJ)((Object)$this))._maxPycor));
    }

    public Topology topology();

    public static Topology getTopology$(DimensionManagement $this) {
        return $this.getTopology();
    }

    default public Topology getTopology() {
        return this.topology();
    }

    public Seq<String> dimensionVariableNames();

    public RootsTable rootsTable();

    public void rootsTable_$eq(RootsTable var1);

    private void worldWidth(int i) {
        ((WorldJ)((Object)this))._worldWidth = i;
    }

    public static int worldWidth$(DimensionManagement $this) {
        return $this.worldWidth();
    }

    default public int worldWidth() {
        return ((WorldJ)((Object)this))._worldWidth;
    }

    public Double _worldWidthBoxed();

    public void _worldWidthBoxed_$eq(Double var1);

    public static Double worldWidthBoxed$(DimensionManagement $this) {
        return $this.worldWidthBoxed();
    }

    default public Double worldWidthBoxed() {
        return this._worldWidthBoxed();
    }

    private void worldHeight(int i) {
        ((WorldJ)((Object)this))._worldHeight = i;
    }

    public static int worldHeight$(DimensionManagement $this) {
        return $this.worldHeight();
    }

    default public int worldHeight() {
        return ((WorldJ)((Object)this))._worldHeight;
    }

    public Double _worldHeightBoxed();

    public void _worldHeightBoxed_$eq(Double var1);

    public static Double worldHeightBoxed$(DimensionManagement $this) {
        return $this.worldHeightBoxed();
    }

    default public Double worldHeightBoxed() {
        return this._worldHeightBoxed();
    }

    private void minPxcor(int i) {
        ((WorldJ)((Object)this))._minPxcor = i;
    }

    public static int minPxcor$(DimensionManagement $this) {
        return $this.minPxcor();
    }

    default public int minPxcor() {
        return ((WorldJ)((Object)this))._minPxcor;
    }

    public Double _minPxcorBoxed();

    public void _minPxcorBoxed_$eq(Double var1);

    public static Double minPxcorBoxed$(DimensionManagement $this) {
        return $this.minPxcorBoxed();
    }

    default public Double minPxcorBoxed() {
        return this._minPxcorBoxed();
    }

    private void maxPxcor(int i) {
        ((WorldJ)((Object)this))._maxPxcor = i;
    }

    public static int maxPxcor$(DimensionManagement $this) {
        return $this.maxPxcor();
    }

    default public int maxPxcor() {
        return ((WorldJ)((Object)this))._maxPxcor;
    }

    public Double _maxPxcorBoxed();

    public void _maxPxcorBoxed_$eq(Double var1);

    public static Double maxPxcorBoxed$(DimensionManagement $this) {
        return $this.maxPxcorBoxed();
    }

    default public Double maxPxcorBoxed() {
        return this._maxPxcorBoxed();
    }

    private void minPycor(int i) {
        ((WorldJ)((Object)this))._minPycor = i;
    }

    public static int minPycor$(DimensionManagement $this) {
        return $this.minPycor();
    }

    default public int minPycor() {
        return ((WorldJ)((Object)this))._minPycor;
    }

    public Double _minPycorBoxed();

    public void _minPycorBoxed_$eq(Double var1);

    public static Double minPycorBoxed$(DimensionManagement $this) {
        return $this.minPycorBoxed();
    }

    default public Double minPycorBoxed() {
        return this._minPycorBoxed();
    }

    private void maxPycor(int i) {
        ((WorldJ)((Object)this))._maxPycor = i;
    }

    public static int maxPycor$(DimensionManagement $this) {
        return $this.maxPycor();
    }

    default public int maxPycor() {
        return ((WorldJ)((Object)this))._maxPycor;
    }

    public Double _maxPycorBoxed();

    public void _maxPycorBoxed_$eq(Double var1);

    public static Double maxPycorBoxed$(DimensionManagement $this) {
        return $this.maxPycorBoxed();
    }

    default public Double maxPycorBoxed() {
        return this._maxPycorBoxed();
    }

    public static double patchSize$(DimensionManagement $this) {
        return $this.patchSize();
    }

    default public double patchSize() {
        return ((WorldJ)((Object)this))._patchSize;
    }

    public static boolean patchSize$(DimensionManagement $this, double patchSize) {
        return $this.patchSize(patchSize);
    }

    default public boolean patchSize(double patchSize) {
        if (((WorldJ)((Object)this))._patchSize != patchSize) {
            ((WorldJ)((Object)this))._patchSize = patchSize;
            return true;
        }
        return false;
    }

    public static boolean wrappingAllowedInX$(DimensionManagement $this) {
        return $this.wrappingAllowedInX();
    }

    default public boolean wrappingAllowedInX() {
        return this.topology() instanceof Torus || this.topology() instanceof VertCylinder;
    }

    public static boolean wrappingAllowedInY$(DimensionManagement $this) {
        return $this.wrappingAllowedInY();
    }

    default public boolean wrappingAllowedInY() {
        return this.topology() instanceof Torus || this.topology() instanceof HorizCylinder;
    }

    public static boolean isDimensionVariable$(DimensionManagement $this, String variableName) {
        return $this.isDimensionVariable(variableName);
    }

    default public boolean isDimensionVariable(String variableName) {
        return this.dimensionVariableNames().contains((Object)variableName.toUpperCase(Locale.ENGLISH));
    }

    public static WorldDimensions setDimensionVariable$(DimensionManagement $this, String variableName, int value, WorldDimensions d) {
        return $this.setDimensionVariable(variableName, value, d);
    }

    default public WorldDimensions setDimensionVariable(String variableName, int value, WorldDimensions d) throws WorldDimensionException {
        String string = variableName.toUpperCase();
        switch (string == null ? 0 : string.hashCode()) {
            case -1488212221: {
                if (!"MIN-PXCOR".equals(string)) break;
                return d.copy(value, d.copy$default$2(), d.copy$default$3(), d.copy$default$4(), d.copy$default$5(), d.copy$default$6(), d.copy$default$7());
            }
            case -1488182430: {
                if (!"MIN-PYCOR".equals(string)) break;
                return d.copy(d.copy$default$1(), d.copy$default$2(), value, d.copy$default$4(), d.copy$default$5(), d.copy$default$6(), d.copy$default$7());
            }
            case -1341812853: {
                if (!"WORLD-WIDTH".equals(string)) break;
                int newMin = this.growMin(d.minPxcor(), d.maxPxcor(), value, d.minPxcor());
                int newMax = this.growMax(d.minPxcor(), d.maxPxcor(), value, d.maxPxcor());
                return d.copy(newMin, newMax, d.copy$default$3(), d.copy$default$4(), d.copy$default$5(), d.copy$default$6(), d.copy$default$7());
            }
            case 920479714: {
                if (!"WORLD-HEIGHT".equals(string)) break;
                int newMin = this.growMin(d.minPycor(), d.maxPycor(), value, d.minPycor());
                int newMax = this.growMax(d.minPycor(), d.maxPycor(), value, d.maxPycor());
                return d.copy(d.copy$default$1(), d.copy$default$2(), newMin, newMax, d.copy$default$5(), d.copy$default$6(), d.copy$default$7());
            }
            case 2034276501: {
                if (!"MAX-PXCOR".equals(string)) break;
                return d.copy(d.copy$default$1(), value, d.copy$default$3(), d.copy$default$4(), d.copy$default$5(), d.copy$default$6(), d.copy$default$7());
            }
            case 2034306292: {
                if (!"MAX-PYCOR".equals(string)) break;
                return d.copy(d.copy$default$1(), d.copy$default$2(), d.copy$default$3(), value, d.copy$default$5(), d.copy$default$6(), d.copy$default$7());
            }
        }
        return d;
    }

    public static boolean equalDimensions$(DimensionManagement $this, WorldDimensions d) {
        return $this.equalDimensions(d);
    }

    default public boolean equalDimensions(WorldDimensions d) {
        return d.minPxcor() == this.minPxcor() && d.maxPxcor() == this.maxPxcor() && d.minPycor() == this.minPycor() && d.maxPycor() == this.maxPycor();
    }

    public static boolean validPatchCoordinates$(DimensionManagement $this, int xc, int yc) {
        return $this.validPatchCoordinates(xc, yc);
    }

    default public boolean validPatchCoordinates(int xc, int yc) {
        return xc >= ((WorldJ)((Object)this))._minPxcor && xc <= ((WorldJ)((Object)this))._maxPxcor && yc >= ((WorldJ)((Object)this))._minPycor && yc <= ((WorldJ)((Object)this))._maxPycor;
    }

    public static int growMin$(DimensionManagement $this, int min, int max, int value, int d) {
        return $this.growMin(min, max, value, d);
    }

    default public int growMin(int min, int max, int value, int d) throws WorldDimensionException {
        if (value < 1) {
            throw new WorldDimensionException();
        }
        if (max == -min) {
            if (value % 2 != 1) {
                throw new WorldDimensionException();
            }
            return -(value - 1) / 2;
        }
        if (max == 0) {
            return -(value - 1);
        }
        return d;
    }

    public static int growMax$(DimensionManagement $this, int min, int max, int value, int d) {
        return $this.growMax(min, max, value, d);
    }

    default public int growMax(int min, int max, int value, int d) throws WorldDimensionException {
        if (value < 1) {
            throw new WorldDimensionException();
        }
        if (max == -min) {
            if (value % 2 != 1) {
                throw new WorldDimensionException();
            }
            return (value - 1) / 2;
        }
        if (min == 0) {
            return value - 1;
        }
        return d;
    }

    public static int wrapAndRoundX$(DimensionManagement $this, double x) {
        return $this.wrapAndRoundX(x);
    }

    default public int wrapAndRoundX(double x) throws AgentException {
        double d;
        try {
            d = this.topology().wrapX(x);
        }
        catch (AgentException ex) {
            throw new AgentException("Cannot access patches beyond the limits of current world.");
        }
        double wrappedX = d;
        if (wrappedX > 0.0) {
            return (int)(wrappedX + 0.5);
        }
        int intPart = (int)wrappedX;
        double fractPart = (double)intPart - wrappedX;
        if (fractPart > 0.5) {
            return intPart - 1;
        }
        return intPart;
    }

    public static int wrapAndRoundY$(DimensionManagement $this, double y) {
        return $this.wrapAndRoundY(y);
    }

    default public int wrapAndRoundY(double y) throws AgentException {
        double d;
        try {
            d = this.topology().wrapY(y);
        }
        catch (AgentException ex) {
            throw new AgentException("Cannot access patches beyond the limits of current world.");
        }
        double wrappedY = d;
        if (wrappedY > 0.0) {
            return (int)(wrappedY + 0.5);
        }
        int intPart = (int)wrappedY;
        double fractPart = (double)intPart - wrappedY;
        if (fractPart > 0.5) {
            return intPart - 1;
        }
        return intPart;
    }

    public static double wrapX$(DimensionManagement $this, double x) {
        return $this.wrapX(x);
    }

    default public double wrapX(double x) throws AgentException {
        return this.topology().wrapX(x);
    }

    public static double wrapY$(DimensionManagement $this, double y) {
        return $this.wrapY(y);
    }

    default public double wrapY(double y) throws AgentException {
        return this.topology().wrapY(y);
    }

    public static double wrap$(DimensionManagement $this, double pos, double min, double max) {
        return $this.wrap(pos, min, max);
    }

    default public double wrap(double pos, double min, double max) {
        return Topology$.MODULE$.wrap(pos, min, max);
    }

    public static void copyDimensions$(DimensionManagement $this, DimensionManagement other) {
        $this.copyDimensions(other);
    }

    default public void copyDimensions(DimensionManagement other) {
        other.rootsTable_$eq(this.rootsTable());
        other.worldWidth(((WorldJ)((Object)this))._worldWidth);
        other.worldHeight(((WorldJ)((Object)this))._worldHeight);
        other.minPxcor(((WorldJ)((Object)this))._minPxcor);
        other.minPycor(((WorldJ)((Object)this))._minPycor);
        other.maxPycor(((WorldJ)((Object)this))._maxPycor);
        other.maxPxcor(((WorldJ)((Object)this))._maxPxcor);
        other.patchSize(((WorldJ)((Object)this))._patchSize);
        other._worldWidthBoxed_$eq(this._worldWidthBoxed());
        other._worldHeightBoxed_$eq(this._worldHeightBoxed());
        other._minPxcorBoxed_$eq(this._minPxcorBoxed());
        other._minPycorBoxed_$eq(this._minPycorBoxed());
        other._maxPxcorBoxed_$eq(this._maxPxcorBoxed());
        other._maxPycorBoxed_$eq(this._maxPycorBoxed());
    }
}

