/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.DrawingLine3D;
import org.nlogo.agent.DrawingLine3D$;
import org.nlogo.agent.Link3D;
import org.nlogo.agent.LinkStamp3D;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.TurtleStamp3D;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ScalaRunTime$;

public class Drawing3D
implements org.nlogo.api.Drawing3D {
    private final World3D world;
    private final ArrayBuffer<org.nlogo.api.DrawingLine3D> _lines;
    private final ArrayBuffer<org.nlogo.api.TurtleStamp3D> _turtleStamps;
    private final ArrayBuffer<org.nlogo.api.LinkStamp3D> _linkStamps;

    public Drawing3D(World3D world) {
        this.world = world;
        this._lines = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new org.nlogo.api.DrawingLine3D[0]));
        this._turtleStamps = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new org.nlogo.api.TurtleStamp3D[0]));
        this._linkStamps = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new org.nlogo.api.LinkStamp3D[0]));
    }

    @Override
    public Iterable<org.nlogo.api.DrawingLine3D> lines() {
        return CollectionConverters$.MODULE$.BufferHasAsJava(this._lines).asJava();
    }

    @Override
    public Iterable<org.nlogo.api.TurtleStamp3D> turtleStamps() {
        return CollectionConverters$.MODULE$.BufferHasAsJava(this._turtleStamps).asJava();
    }

    @Override
    public Iterable<org.nlogo.api.LinkStamp3D> linkStamps() {
        return CollectionConverters$.MODULE$.BufferHasAsJava(this._linkStamps).asJava();
    }

    public void clear() {
        this._lines.clear();
        this._turtleStamps.clear();
        this._linkStamps.clear();
    }

    private double heading(double x0, double y0, double x1, double y1) {
        double d;
        try {
            d = this.world.protractor().towards(x0, y0, x1, y1, true);
        }
        catch (AgentException agentException) {
            d = 0.0;
        }
        return d;
    }

    private double pitch(double x0, double y0, double z0, double x1, double y1, double z1) {
        return this.world.protractor().towardsPitch(x0, y0, z0, x1, y1, z1, true);
    }

    public void stamp(Agent agent) {
        Agent agent2 = agent;
        if (agent2 instanceof Turtle3D) {
            Turtle3D t = (Turtle3D)agent2;
            this._turtleStamps.$plus$eq((Object)new TurtleStamp3D(t));
            return;
        }
        if (agent2 instanceof Link3D) {
            Link3D l = (Link3D)agent2;
            this._linkStamps.$plus$eq((Object)new LinkStamp3D(l));
            return;
        }
    }

    public void drawLine(double x0, double y0, double z0, double x1, double y1, double z1, double width, Object color) {
        this.wrap(DrawingLine3D$.MODULE$.apply(x0, y0, z0, x1, y1, z1, this.heading(x0, y0, x1, y1), this.pitch(x0, y0, z0, x1, y1, z1), width, color));
    }

    public void addLine(double x0, double y0, double z0, double x1, double y1, double z1, double width, Object color) {
        this._lines.$plus$eq((Object)DrawingLine3D$.MODULE$.apply(x0, y0, z0, x1, y1, z1, this.heading(x0, y0, x1, y1), this.pitch(x0, y0, z0, x1, y1, z1), width, color));
    }

    public void addStamp(String shape, double xcor, double ycor, double zcor, double size, double heading, double pitch, double roll, Object color, double lineThickness) {
        this._turtleStamps.$plus$eq((Object)new TurtleStamp3D(shape, xcor, ycor, zcor, size, heading, pitch, roll, color, lineThickness));
    }

    public void addStamp(String shape, double x1, double y1, double z1, double x2, double y2, double z2, Object color, double lineThickness, boolean directedLink, double destSize, double heading, double pitch) {
        this._linkStamps.$plus$eq((Object)new LinkStamp3D(shape, x1, y1, z1, x2, y2, z2, color, lineThickness, directedLink, destSize, heading, pitch));
    }

    private void wrap(DrawingLine3D l) {
        double startX = l.x0();
        double startY = l.y0();
        double endX = l.x0();
        double endY = l.y0();
        double startZ = l.z0();
        double endZ = l.z0();
        if (endX < startX) {
            double temp = endX;
            endX = startX;
            startX = temp;
        }
        if (endY < startY) {
            double temp = endY;
            endY = startY;
            startY = temp;
        }
        if (endZ < startZ) {
            double temp = endZ;
            endZ = startZ;
            startZ = temp;
        }
        double xdiff = l.x1() - l.x0();
        double ydiff = l.y1() - l.y0();
        double zdiff = l.z1() - l.z0();
        double distX = l.x1() - l.x0();
        double distY = l.y1() - l.y0();
        double distZ = l.z1() - l.z0();
        double newStartX = 0.0;
        double newStartY = 0.0;
        double newStartZ = 0.0;
        double maxy = (double)this.world.maxPycor() + 0.4999999;
        double maxx = (double)this.world.maxPxcor() + 0.4999999;
        double maxz = (double)this.world.maxPzcor() + 0.4999999;
        double miny = (double)this.world.minPycor() - 0.5;
        double minx = (double)this.world.minPxcor() - 0.5;
        double minz = (double)this.world.minPzcor() - 0.5;
        double pixelSize = 1.0 / this.world.patchSize();
        do {
            endX = startX + distX;
            endY = startY + distY;
            endZ = startZ + distZ;
            if (endY < miny) {
                endX = (miny - startY) * xdiff / ydiff + startX;
                endY = miny;
                endZ = (miny - startY) * zdiff / ydiff + startZ;
                newStartY = maxy;
                newStartX = endX;
                newStartZ = endZ;
                if (newStartX == minx) {
                    newStartX = maxx;
                } else if (newStartX == maxx) {
                    newStartX = minx;
                }
                if (newStartZ == maxz) {
                    newStartZ = minz;
                } else if (newStartZ == minz) {
                    newStartZ = maxz;
                }
            }
            if (endY > maxy) {
                endX = startX + (maxy - startY) * xdiff / ydiff;
                endY = maxy;
                endZ = startZ + (maxy - startY) * zdiff / ydiff;
                newStartX = endX;
                newStartY = miny;
                newStartZ = endZ;
                if (newStartX == minx) {
                    newStartX = maxx;
                } else if (newStartX == maxx) {
                    newStartX = minx;
                }
                if (newStartZ == maxz) {
                    newStartZ = minz;
                } else if (newStartZ == minz) {
                    newStartZ = maxz;
                }
            }
            if (endX < minx) {
                endX = minx;
                endY = ydiff * (endX - startX) / xdiff + startY;
                endZ = zdiff * (endX - startX) / xdiff + startZ;
                newStartX = maxx;
                newStartY = endY;
                newStartZ = endZ;
                if (newStartY == miny) {
                    newStartY = maxy;
                } else if (newStartY == maxy) {
                    newStartY = miny;
                }
                if (newStartZ == maxz) {
                    newStartZ = minz;
                } else if (newStartZ == minz) {
                    newStartZ = maxz;
                }
            }
            if (endX > maxx) {
                endX = maxx;
                endY = ydiff * (endX - startX) / xdiff + startY;
                endZ = zdiff * (endX - startX) / xdiff + startZ;
                newStartX = minx;
                newStartY = endY;
                newStartZ = endZ;
                if (newStartY == miny) {
                    newStartY = maxy;
                } else if (newStartY == maxy) {
                    newStartY = miny;
                }
                if (newStartZ == maxz) {
                    newStartZ = minz;
                } else if (newStartZ == minz) {
                    newStartZ = maxz;
                }
            }
            if (endZ < minz) {
                endZ = minz;
                endY = ydiff * (endZ - startZ) / zdiff + startY;
                endX = xdiff * (endZ - startZ) / zdiff + startX;
                newStartZ = maxz;
                newStartY = endY;
                newStartX = endX;
                if (newStartY == miny) {
                    newStartY = maxy;
                } else if (newStartY == maxy) {
                    newStartY = miny;
                }
                if (newStartX == minx) {
                    newStartX = maxx;
                } else if (newStartX == maxx) {
                    newStartX = minx;
                }
            }
            if (endZ > maxz) {
                endZ = maxz;
                endY = ydiff * (endZ - startZ) / zdiff + startY;
                endX = xdiff * (endZ - startZ) / zdiff + startX;
                newStartZ = minz;
                newStartY = endY;
                newStartX = endX;
                if (newStartY == miny) {
                    newStartY = maxy;
                } else if (newStartY == maxy) {
                    newStartY = miny;
                }
                if (newStartX == minx) {
                    newStartX = maxx;
                } else if (newStartX == maxx) {
                    newStartX = minx;
                }
            }
            this._lines.$plus$eq((Object)DrawingLine3D$.MODULE$.apply(startX, startY, startZ, endX, endY, endZ, this.heading(startX, startY, endX, endY), this.pitch(startX, startY, startZ, endX, endY, endZ), l.width(), l.color()));
            startX = newStartX;
            startY = newStartY;
            startZ = newStartZ;
        } while (StrictMath.abs(distY -= endY - startY) >= pixelSize || StrictMath.abs(distX -= endX - startX) >= pixelSize || StrictMath.abs(distZ -= endZ - startZ) >= pixelSize);
    }
}

