/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Drawing3D;
import org.nlogo.agent.Exporter;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World3D;
import org.nlogo.api.Dump$;
import org.nlogo.core.Breed;
import org.nlogo.core.Nobody$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class Exporter3D
extends Exporter {
    private final World3D world;
    private final PrintWriter writer;

    public Exporter3D(World3D world, PrintWriter writer) {
        this.world = world;
        this.writer = writer;
        super(world, writer);
    }

    @Override
    public void exportWorld(boolean full) {
        super.exportWorld(full);
        if (full) {
            this.exportDrawing();
            return;
        }
    }

    public void exportDrawing() {
        this.writer.println(Dump$.MODULE$.csv().encode("DRAWING"));
        this.writer.println(Dump$.MODULE$.csv().encode("x0") + "," + Dump$.MODULE$.csv().encode("y0") + "," + Dump$.MODULE$.csv().encode("z0") + "," + Dump$.MODULE$.csv().encode("x1") + "," + Dump$.MODULE$.csv().encode("y1") + "," + Dump$.MODULE$.csv().encode("z1") + "," + Dump$.MODULE$.csv().encode("width") + "," + Dump$.MODULE$.csv().encode("color"));
        Drawing3D drawing = this.world.drawing();
        CollectionConverters$.MODULE$.IterableHasAsScala(drawing.lines()).asScala().foreach(line -> {
            this.writer.print(Dump$.MODULE$.csv().encode(Double.toString(line.x0())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(line.y0())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(line.z0())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(line.x1())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(line.y1())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(line.z1())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(line.width())));
            this.writer.print("," + Dump$.MODULE$.csv().data(line.color()));
            this.writer.println();
        });
        this.writer.println(Dump$.MODULE$.csv().encode("shape") + "," + Dump$.MODULE$.csv().encode("xcor") + "," + Dump$.MODULE$.csv().encode("ycor") + "," + Dump$.MODULE$.csv().encode("zcor") + "," + Dump$.MODULE$.csv().encode("size") + "," + Dump$.MODULE$.csv().encode("heading") + "," + Dump$.MODULE$.csv().encode("pitch") + "," + Dump$.MODULE$.csv().encode("roll") + "," + Dump$.MODULE$.csv().encode("color") + "," + Dump$.MODULE$.csv().encode("lineThickness"));
        CollectionConverters$.MODULE$.IterableHasAsScala(drawing.turtleStamps()).asScala().foreach(stamp -> {
            this.writer.print(Dump$.MODULE$.csv().encode(stamp.shape()));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.xcor())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.ycor())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.zcor())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.size())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.heading())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.pitch())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.roll())));
            this.writer.print("," + Dump$.MODULE$.csv().data(stamp.color()));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.lineThickness())));
            this.writer.println();
        });
        this.writer.println(Dump$.MODULE$.csv().encode("shape") + "," + Dump$.MODULE$.csv().encode("x1") + "," + Dump$.MODULE$.csv().encode("y1") + "," + Dump$.MODULE$.csv().encode("z1") + "," + Dump$.MODULE$.csv().encode("x2") + "," + Dump$.MODULE$.csv().encode("y2") + "," + Dump$.MODULE$.csv().encode("z2") + "," + Dump$.MODULE$.csv().encode("color") + "," + Dump$.MODULE$.csv().encode("lineThickness") + "," + Dump$.MODULE$.csv().encode("directedLink") + "," + Dump$.MODULE$.csv().encode("destSize") + "," + Dump$.MODULE$.csv().encode("heading") + "," + Dump$.MODULE$.csv().encode("pitch"));
        CollectionConverters$.MODULE$.IterableHasAsScala(drawing.linkStamps()).asScala().foreach(stamp -> {
            this.writer.print(Dump$.MODULE$.csv().encode(stamp.shape()));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.x1())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.y1())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.z1())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.x2())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.y2())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.z2())));
            this.writer.print("," + Dump$.MODULE$.csv().data(stamp.color()));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.lineThickness())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Boolean.toString(stamp.isDirectedLink())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.linkDestinationSize())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.heading())));
            this.writer.print("," + Dump$.MODULE$.csv().encode(Double.toString(stamp.pitch())));
            this.writer.println();
        });
        this.writer.println();
    }

    @Override
    public void exportGlobals() {
        this.writer.println(Dump$.MODULE$.csv().encode("GLOBALS"));
        this.writer.print(Dump$.MODULE$.csv().encode("min-pxcor") + "," + Dump$.MODULE$.csv().encode("max-pxcor") + "," + Dump$.MODULE$.csv().encode("min-pycor") + "," + Dump$.MODULE$.csv().encode("max-pycor") + "," + Dump$.MODULE$.csv().encode("min-pzcor") + "," + Dump$.MODULE$.csv().encode("max-pzcor") + "," + Dump$.MODULE$.csv().encode("perspective") + "," + Dump$.MODULE$.csv().encode("subject") + "," + Dump$.MODULE$.csv().encode("nextIndex") + "," + Dump$.MODULE$.csv().encode("directed-links") + "," + Dump$.MODULE$.csv().encode("ticks"));
        Seq<String> globals = this.world.program().globals();
        ArrayList<String> sortedGlobals = new ArrayList<String>(globals.size());
        HashMap globalVarIndices = new HashMap();
        ((IterableOnceOps)globals.zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String g = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                globalVarIndices.put(globals.apply(i), BoxesRunTime.boxToInteger((int)i));
                return sortedGlobals.add((String)globals.apply(i));
            }
            throw new MatchError((Object)tuple2);
        });
        Collections.sort(sortedGlobals);
        Object subject = Option$.MODULE$.apply((Object)this.world.observer().targetAgent()).getOrElse(Exporter3D::$anonfun$1);
        this.writer.print("," + Dump$.MODULE$.csv().variableNameRow(sortedGlobals));
        this.writer.println();
        this.writer.print(Dump$.MODULE$.csv().encode(Integer.toString(this.world.minPxcor())) + "," + Dump$.MODULE$.csv().encode(Integer.toString(this.world.maxPxcor())) + "," + Dump$.MODULE$.csv().encode(Integer.toString(this.world.minPycor())) + "," + Dump$.MODULE$.csv().encode(Integer.toString(this.world.maxPycor())) + "," + Dump$.MODULE$.csv().encode(Integer.toString(this.world.minPzcor())) + "," + Dump$.MODULE$.csv().encode(Integer.toString(this.world.maxPzcor())) + "," + Dump$.MODULE$.csv().encode(Integer.toString(this.world.observer().perspective().export())) + "," + Dump$.MODULE$.csv().data(subject) + "," + Dump$.MODULE$.csv().encode(Long.toString(this.world.nextTurtleIndex())) + "," + Dump$.MODULE$.csv().data(this.world.links().isDirected() ? "DIRECTED" : (this.world.links().isUndirected() ? "UNDIRECTED" : "NEITHER")) + "," + Dump$.MODULE$.csv().encode(Dump$.MODULE$.number(this.world.tickCounter().ticks())));
        ((IterableOnceOps)globals.zipWithIndex()).foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String g = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                this.writer.print(",");
                this.writer.print(Dump$.MODULE$.csv().data(this.world.observer().getVariable((Integer)globalVarIndices.get(sortedGlobals.get(i)))));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.writer.println();
        this.writer.println();
    }

    @Override
    public void exportTurtles() {
        this.writer.println(Dump$.MODULE$.csv().encode("TURTLES"));
        ArrayList<String> allTurtleVars = new ArrayList<String>(CollectionConverters$.MODULE$.SeqHasAsJava(this.world.program().turtlesOwn()).asJava());
        int turtlesVarSize = this.world.program().turtlesOwn().size();
        Map breedVarIndices = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.world.program().breeds().values().foreach(current -> current.owns().foreach(breedVarName -> {
            if (!breedVarIndices.contains(breedVarName)) {
                allTurtleVars.add((String)breedVarName);
                breedVarIndices.update(breedVarName, (Object)BoxesRunTime.boxToInteger((int)(allTurtleVars.size() - 1)));
                return;
            }
        }));
        this.writer.println(Dump$.MODULE$.csv().variableNameRow(allTurtleVars));
        AgentIterator it = this.world.turtles().iterator();
        while (it.hasNext()) {
            Turtle turtle = (Turtle)it.next();
            this.writer.print(Dump$.MODULE$.csv().data(turtle.getTurtleVariable(Turtle.VAR_WHO)));
            AgentSet breed = (AgentSet)turtle.getTurtleVariable(Turtle3D.VAR_BREED3D);
            String key = breed.printName();
            ObjectRef breedOwns = ObjectRef.create(null);
            ObjectRef thisBreedVarIndices = ObjectRef.create((Object)null);
            ObjectRef sortedBreedOwns = ObjectRef.create((Object)null);
            if (!key.equals("TURTLES")) {
                breedOwns.elem = ((Breed)this.world.program().breeds().apply((Object)key)).owns();
                thisBreedVarIndices.elem = (int[])Array$.MODULE$.fill(((Seq)breedOwns.elem).size(), Exporter3D::exportTurtles$$anonfun$2, ClassTag$.MODULE$.apply(Integer.TYPE));
                sortedBreedOwns.elem = (String[])Array$.MODULE$.fill(((Seq)breedOwns.elem).size(), Exporter3D::exportTurtles$$anonfun$3, ClassTag$.MODULE$.apply(String.class));
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ((Seq)breedOwns.elem).size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                    ((String[])sortedBreedOwns$1.elem)[j] = (String)((Seq)breedOwns$1.elem).apply(j);
                    ((int[])thisBreedVarIndices$1.elem)[j] = BoxesRunTime.unboxToInt((Object)breedVarIndices.apply(((Seq)breedOwns$1.elem).apply(j)));
                });
                this.sortIndicesAndVars((String[])sortedBreedOwns.elem, (int[])thisBreedVarIndices.elem);
            } else {
                thisBreedVarIndices.elem = new int[]{0};
            }
            IntRef index = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), allTurtleVars.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                this.writer.print(",");
                if (j < turtlesVarSize) {
                    this.writer.print(Dump$.MODULE$.csv().data(turtle.getTurtleVariable(j)));
                    return;
                }
                if (index$1.elem < ((int[])thisBreedVarIndices$2.elem).length && j == ((int[])thisBreedVarIndices$2.elem)[index$1.elem]) {
                    this.writer.print(Dump$.MODULE$.csv().data(turtle.getTurtleVariable(this.world.breedsOwnIndexOf(breed, ((String[])sortedBreedOwns$2.elem)[index$1.elem]))));
                    ++index$1.elem;
                    return;
                }
            });
            this.writer.println();
        }
        this.writer.println();
    }

    private static final Object $anonfun$1() {
        return Nobody$.MODULE$;
    }

    private static final int exportTurtles$$anonfun$2() {
        return 0;
    }

    private static final String exportTurtles$$anonfun$3() {
        return null;
    }
}

