/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.api.Agent;
import org.nlogo.api.Turtle;

public class HeadingSmoother {
    private double thirdPersonOldHeading = 0.0;
    private double firstPersonOldHeading = 0.0;
    private double angleChange = 1.0;
    private double oldHeading = 0.0;

    public double follow(Agent agent) {
        this.thirdPersonUpdate(agent);
        return this.thirdPersonOldHeading;
    }

    public double watch(Agent agent) {
        this.firstPersonUpdate(agent);
        return this.firstPersonOldHeading;
    }

    private void thirdPersonUpdate(Agent agent) {
        double heading;
        double d;
        Agent agent2 = agent;
        if (agent2 instanceof Turtle) {
            Turtle t = (Turtle)agent2;
            d = t.heading();
        } else {
            d = heading = 0.0;
        }
        if (this.thirdPersonOldHeading + this.angleChange <= heading) {
            this.thirdPersonOldHeading = heading - this.thirdPersonOldHeading > 180.0 ? (this.thirdPersonOldHeading -= this.angleChange) : (this.thirdPersonOldHeading += this.angleChange);
        } else if (this.thirdPersonOldHeading - this.angleChange >= heading) {
            this.thirdPersonOldHeading = this.thirdPersonOldHeading - heading > 180.0 ? (this.thirdPersonOldHeading += this.angleChange) : (this.thirdPersonOldHeading -= this.angleChange);
        } else {
            this.thirdPersonOldHeading = heading;
            this.angleChange = 1.0;
        }
        if (this.thirdPersonOldHeading >= 360.0) {
            this.thirdPersonOldHeading -= 360.0;
        } else if (this.thirdPersonOldHeading < 0.0) {
            this.thirdPersonOldHeading += 360.0;
        }
        if (heading == this.oldHeading) {
            this.angleChange *= 1.5;
        } else {
            this.angleChange /= 1.5;
            if (this.angleChange < 1.0) {
                this.angleChange = 1.0;
            }
        }
        this.oldHeading = heading;
    }

    private void firstPersonUpdate(Agent agent) {
        double heading;
        double d;
        Agent agent2 = agent;
        if (agent2 instanceof Turtle) {
            Turtle t = (Turtle)agent2;
            d = t.heading();
        } else {
            d = heading = 0.0;
        }
        if (this.firstPersonOldHeading + this.angleChange <= heading) {
            this.firstPersonOldHeading = heading - this.firstPersonOldHeading > 180.0 ? (this.firstPersonOldHeading -= this.angleChange) : (this.firstPersonOldHeading += this.angleChange);
        } else if (this.firstPersonOldHeading - this.angleChange >= heading) {
            this.firstPersonOldHeading = this.firstPersonOldHeading - heading > 180.0 ? (this.firstPersonOldHeading += this.angleChange) : (this.firstPersonOldHeading -= this.angleChange);
        } else {
            this.firstPersonOldHeading = heading;
            this.angleChange = 6.0;
        }
        if (this.firstPersonOldHeading >= 360.0) {
            this.firstPersonOldHeading -= 360.0;
        } else if (this.firstPersonOldHeading < 0.0) {
            this.firstPersonOldHeading += 360.0;
        }
        this.angleChange *= 1.75;
    }
}

