/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.agent.World2D;
import org.nlogo.api.AgentException;
import org.nlogo.core.AgentKind$Patch$;
import org.nlogo.core.AgentKind$Turtle$;
import scala.Int$;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.runtime.BoxesRunTime;

public class InRadiusOrCone
implements World.InRadiusOrCone {
    private final World2D world;
    private Patch[] patches;
    private int end;

    public InRadiusOrCone(World2D world) {
        this.world = world;
        this.patches = null;
        this.end = 0;
    }

    public World2D world() {
        return this.world;
    }

    @Override
    public List<Agent> inRadius(Agent agent, AgentSet sourceSet, double radius, boolean wrap) {
        ArrayList<Agent> result;
        block21: {
            HashSet<Object> cachedIDs;
            int patchY;
            int patchX;
            double startY;
            double startX;
            int i;
            int dy;
            int dx;
            double gRoot;
            int worldHeight;
            int worldWidth;
            block20: {
                boolean sourceSetIsWorldPatches;
                Tuple4 tuple4;
                Patch patch;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.world().worldWidth()), (Object)BoxesRunTime.boxToInteger((int)this.world().worldHeight()));
                worldWidth = tuple2._1$mcI$sp();
                worldHeight = tuple2._2$mcI$sp();
                result = new ArrayList<Agent>();
                gRoot = 0.0;
                dx = 0;
                dy = 0;
                i = 0;
                Agent agent2 = agent;
                if (agent2 instanceof Turtle) {
                    Turtle t = (Turtle)agent2;
                    patch = t.currentPatch;
                } else if (agent2 instanceof Patch) {
                    Patch p;
                    patch = p = (Patch)agent2;
                } else {
                    throw new IllegalStateException();
                }
                Patch centerPatch = patch;
                Agent agent3 = agent;
                if (agent3 instanceof Turtle) {
                    Turtle t = (Turtle)agent3;
                    tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)t.xcor), (Object)BoxesRunTime.boxToDouble((double)t.ycor), (Object)BoxesRunTime.boxToInteger((int)centerPatch.pxcor), (Object)BoxesRunTime.boxToInteger((int)centerPatch.pycor));
                } else if (agent3 instanceof Patch) {
                    Patch p = (Patch)agent3;
                    tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)p.pxcor), (Object)BoxesRunTime.boxToDouble((double)p.pycor), (Object)BoxesRunTime.boxToInteger((int)p.pxcor), (Object)BoxesRunTime.boxToInteger((int)p.pycor));
                } else {
                    throw new IllegalStateException();
                }
                Tuple4 tuple42 = tuple4;
                if (tuple42 == null) {
                    throw new MatchError((Object)tuple42);
                }
                double startX2 = BoxesRunTime.unboxToDouble((Object)tuple42._1());
                double startY2 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
                int patchX2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
                int patchY2 = BoxesRunTime.unboxToInt((Object)tuple42._4());
                Tuple4 tuple43 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)startX2), (Object)BoxesRunTime.boxToDouble((double)startY2), (Object)BoxesRunTime.boxToInteger((int)patchX2), (Object)BoxesRunTime.boxToInteger((int)patchY2));
                startX = BoxesRunTime.unboxToDouble((Object)tuple43._1());
                startY = BoxesRunTime.unboxToDouble((Object)tuple43._2());
                patchX = BoxesRunTime.unboxToInt((Object)tuple43._3());
                patchY = BoxesRunTime.unboxToInt((Object)tuple43._4());
                cachedIDs = this.initCachedIDs(sourceSet);
                this.initPatches();
                if (radius <= 1.0 && radius > 0.0) {
                    this.setPatches1(centerPatch);
                } else if (radius <= (double)2) {
                    this.setPatches2(centerPatch);
                } else {
                    this.setPatches(startX, startY, radius);
                }
                if (sourceSet.kind() != AgentKind$Patch$.MODULE$) break block20;
                boolean bl = sourceSetIsWorldPatches = sourceSet == this.world().patches();
                while (i < this.end) {
                    Patch patch2 = this.patches[i];
                    if ((sourceSetIsWorldPatches || cachedIDs.contains(BoxesRunTime.boxToLong((long)patch2.id()))) && this.world().protractor().distance(Int$.MODULE$.int2double(patch2.pxcor), Int$.MODULE$.int2double(patch2.pycor), startX, startY, wrap) <= radius) {
                        result.add(patch2);
                    }
                    ++i;
                }
                break block21;
            }
            if (sourceSet.kind() != AgentKind$Turtle$.MODULE$) break block21;
            boolean sourceSetIsWorldTurtles = sourceSet == this.world().turtles();
            boolean sourceSetIsBreedSet = sourceSet.isBreedSet();
            int worldWidth2 = worldWidth / 2;
            int worldHeight2 = worldHeight / 2;
            while (i < this.end) {
                Patch patch = this.patches[i];
                dx = Math.abs(patch.pxcor - patchX);
                if (this.world().topology().xWraps() && dx > worldWidth2) {
                    dx = worldWidth - dx;
                }
                dy = Math.abs(patch.pycor - patchY);
                if (this.world().topology().yWraps() && dy > worldHeight2) {
                    dy = worldHeight - dy;
                }
                if ((gRoot = this.world().rootsTable().gridRoot(dx * dx + dy * dy)) <= radius + 1.415) {
                    for (Turtle turtle : patch.turtlesHere()) {
                        if (!sourceSetIsWorldTurtles && (!sourceSetIsBreedSet || sourceSet != turtle.getBreed()) && !cachedIDs.contains(BoxesRunTime.boxToLong((long)turtle.id())) || !(gRoot <= radius - 1.415) && !(this.world().protractor().distance(turtle.xcor, turtle.ycor, startX, startY, wrap) <= radius)) continue;
                        result.add(turtle);
                    }
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public List<Agent> inCone(Turtle startTurtle, AgentSet sourceSet, double radius, double angle, boolean wrap) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.world().worldWidth()), (Object)BoxesRunTime.boxToInteger((int)this.world().worldHeight()));
        int worldWidth = tuple2._1$mcI$sp();
        int worldHeight = tuple2._2$mcI$sp();
        int m = 0;
        int n = 0;
        if (wrap) {
            if (this.world().wrappingAllowedInX()) {
                m = (int)StrictMath.ceil(radius / (double)worldWidth);
            }
            if (this.world().wrappingAllowedInY()) {
                n = (int)StrictMath.ceil(radius / (double)worldHeight);
            }
        }
        ArrayList<Agent> result = new ArrayList<Agent>();
        double half = angle / (double)2;
        double gRoot = 0.0;
        int dx = 0;
        int dy = 0;
        int i = 0;
        HashSet<Object> cachedIDs = this.initCachedIDs(sourceSet);
        this.initPatches();
        if (radius <= 1.0 && radius > 0.0) {
            this.setPatches1(startTurtle.currentPatch);
        } else if (radius <= (double)2) {
            this.setPatches2(startTurtle.currentPatch);
        } else {
            this.setPatches(startTurtle.xcor, startTurtle.ycor, radius);
        }
        ArrayList<Tuple2> offsets = new ArrayList<Tuple2>();
        int looseRadius = (int)StrictMath.ceil(radius) + 1;
        for (int x = -m; x <= m; ++x) {
            for (int y = -n; y <= n; ++y) {
                if (!this.closestPointIsInRadius(startTurtle.xcor, startTurtle.ycor, x, y, Int$.MODULE$.int2double(looseRadius))) continue;
                offsets.add(Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToInteger((int)y)));
            }
        }
        if (sourceSet.kind() == AgentKind$Patch$.MODULE$) {
            boolean sourceSetIsWorldPatches;
            boolean bl = sourceSetIsWorldPatches = sourceSet == this.world().patches();
            while (i < this.end) {
                Patch patch = this.patches[i];
                if (patch != null) {
                    Iterator offsetIterator = offsets.iterator();
                    boolean found = false;
                    while (!found && offsetIterator.hasNext()) {
                        Tuple2 tuple22 = (Tuple2)offsetIterator.next();
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        int offsetX = tuple22._1$mcI$sp();
                        int offsetY = tuple22._2$mcI$sp();
                        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(offsetX, offsetY);
                        int offsetX2 = sp2._1$mcI$sp();
                        int offsetY2 = sp2._2$mcI$sp();
                        if (!sourceSetIsWorldPatches && !cachedIDs.contains(BoxesRunTime.boxToLong((long)patch.id())) || !this.isInCone(Int$.MODULE$.int2double(patch.pxcor + worldWidth * offsetX2), Int$.MODULE$.int2double(patch.pycor + worldHeight * offsetY2), startTurtle.xcor, startTurtle.ycor, radius, half, startTurtle.heading)) continue;
                        result.add(patch);
                        found = true;
                    }
                }
                ++i;
            }
        } else {
            boolean sourceSetIsWorldTurtles = sourceSet == this.world().turtles();
            boolean sourceSetIsBreedSet = sourceSet.isBreedSet();
            int worldWidth2 = worldWidth / 2;
            int worldHeight2 = worldHeight / 2;
            while (i < this.end) {
                Patch patch = this.patches[i];
                dx = Math.abs(patch.pxcor - startTurtle.currentPatch.pxcor);
                if (dx > worldWidth2) {
                    dx = worldWidth - dx;
                }
                if ((dy = Math.abs(patch.pycor - startTurtle.currentPatch.pycor)) > worldHeight2) {
                    dy = worldHeight - dy;
                }
                if ((gRoot = this.world().rootsTable().gridRoot(dx * dx + dy * dy)) <= radius + 1.415) {
                    for (Turtle turtle : patch.turtlesHere()) {
                        boolean found = false;
                        Iterator offsetIterator = offsets.iterator();
                        while (!found && offsetIterator.hasNext()) {
                            Tuple2 tuple23 = (Tuple2)offsetIterator.next();
                            if (tuple23 == null) {
                                throw new MatchError((Object)tuple23);
                            }
                            int offsetX = tuple23._1$mcI$sp();
                            int offsetY = tuple23._2$mcI$sp();
                            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(offsetX, offsetY);
                            int offsetX3 = sp3._1$mcI$sp();
                            int offsetY3 = sp3._2$mcI$sp();
                            if (!sourceSetIsWorldTurtles && (!sourceSetIsBreedSet || sourceSet != turtle.getBreed()) && !cachedIDs.contains(BoxesRunTime.boxToLong((long)turtle.id())) || !this.isInCone(turtle.xcor + (double)(worldWidth * offsetX3), turtle.ycor + (double)(worldHeight * offsetY3), startTurtle.xcor, startTurtle.ycor, radius, half, startTurtle.heading)) continue;
                            result.add(turtle);
                            found = true;
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private boolean closestPointIsInRadius(double x, double y, int offsetX, int offsetY, double r) {
        double closestX = 0.0;
        double closestY = 0.0;
        closestY = offsetY < 0 ? Int$.MODULE$.int2double(this.world().maxPycor() + offsetY * this.world().worldHeight()) : (offsetY > 0 ? Int$.MODULE$.int2double(this.world().minPycor() + offsetY * this.world().worldHeight()) : y);
        closestX = offsetX < 0 ? Int$.MODULE$.int2double(this.world().maxPxcor() + offsetX * this.world().worldWidth()) : (offsetX > 0 ? Int$.MODULE$.int2double(this.world().minPxcor() + offsetX * this.world().worldWidth()) : x);
        return this.world().protractor().distance(closestX, closestY, x, y, false) <= r;
    }

    private boolean isInCone(double x, double y, double cx, double cy, double r, double half, double h) {
        if (x == cx && y == cy) {
            return true;
        }
        if (this.world().protractor().distance(cx, cy, x, y, false) > r) {
            return false;
        }
        double theta = 0.0;
        try {
            theta = this.world().protractor().towards(cx, cy, x, y, false);
        }
        catch (AgentException e) {
            throw new IllegalStateException(e.toString());
        }
        double diff = StrictMath.abs(theta - h);
        return diff <= half || (double)360 - diff <= half;
    }

    private void initPatches() {
        if (this.patches == null || this.patches.length != this.world().patches().count()) {
            this.patches = new Patch[this.world().patches().count()];
            return;
        }
    }

    private void setPatches1(Patch centerPatch) {
        int i;
        Agent[] neighbors = ((ArrayAgentSet)centerPatch.getNeighbors()).array();
        this.patches[0] = centerPatch;
        for (i = 0; i < neighbors.length; ++i) {
            this.patches[i + 1] = (Patch)neighbors[i];
        }
        this.end = i + 1;
    }

    private void setPatches2(Patch centerPatch) {
        this.setPatches1(centerPatch);
        if (this.world().wrappingAllowedInX() && this.world().worldWidth() < 5 || this.world().wrappingAllowedInY() && this.world().worldHeight() < 5 || !this.world().wrappingAllowedInX() && (centerPatch.pxcor - this.world().minPxcor() < 2 || this.world().maxPxcor() - centerPatch.pxcor < 2) || !this.world().wrappingAllowedInY() && (centerPatch.pycor - this.world().minPycor() < 2 || this.world().maxPycor() - centerPatch.pycor < 2)) {
            int i;
            LinkedHashSet<Patch> allNeighbors = new LinkedHashSet<Patch>();
            for (i = 0; i < this.end; ++i) {
                Patch p = this.patches[i];
                allNeighbors.add(p);
                allNeighbors.add(p.getPatchNorth());
                allNeighbors.add(p.getPatchNorthEast());
                allNeighbors.add(p.getPatchEast());
                allNeighbors.add(p.getPatchSouthEast());
                allNeighbors.add(p.getPatchSouth());
                allNeighbors.add(p.getPatchSouthWest());
                allNeighbors.add(p.getPatchWest());
                allNeighbors.add(p.getPatchNorthWest());
            }
            allNeighbors.remove(null);
            i = 0;
            Iterator allNeighborsIterator = allNeighbors.iterator();
            while (allNeighborsIterator.hasNext()) {
                this.patches[i] = (Patch)allNeighborsIterator.next();
                ++i;
            }
            this.end = i;
            return;
        }
        this.patches[9] = this.patches[1].getPatchNorth();
        this.patches[10] = this.patches[2].getPatchEast();
        this.patches[11] = this.patches[3].getPatchSouth();
        this.patches[12] = this.patches[4].getPatchWest();
        this.patches[13] = this.patches[5].getPatchNorth();
        this.patches[14] = this.patches[5].getPatchNorthEast();
        this.patches[15] = this.patches[5].getPatchEast();
        this.patches[16] = this.patches[6].getPatchEast();
        this.patches[17] = this.patches[6].getPatchSouthEast();
        this.patches[18] = this.patches[6].getPatchSouth();
        this.patches[19] = this.patches[7].getPatchSouth();
        this.patches[20] = this.patches[7].getPatchSouthWest();
        this.patches[21] = this.patches[7].getPatchWest();
        this.patches[22] = this.patches[8].getPatchWest();
        this.patches[23] = this.patches[8].getPatchNorthWest();
        this.patches[24] = this.patches[8].getPatchNorth();
        this.end = 25;
    }

    private void setPatches(double X, double Y, double R) {
        int x = (int)StrictMath.round(X);
        int y = (int)StrictMath.round(Y);
        int r = (int)R + 1;
        Iterator<Tuple2<Object, Object>> regionIterator = this.world().topology().getRegion(x, y, r).iterator();
        int length = 0;
        int curr = 0;
        Tuple2<Object, Object> region = new Tuple2<Object, Object>(0, 0);
        Agent[] worldPatches = ((ArrayAgentSet)this.world().patches()).array();
        while (regionIterator.hasNext()) {
            region = regionIterator.next();
            length = region._2$mcI$sp() - region._1$mcI$sp();
            System.arraycopy(worldPatches, region._1$mcI$sp(), this.patches, curr, length);
            curr += length;
        }
        this.end = curr;
    }

    private HashSet<Object> initCachedIDs(AgentSet sourceSet) {
        HashSet<Object> cachedIDs = null;
        if (!sourceSet.isBreedSet()) {
            cachedIDs = new HashSet(sourceSet.count());
            AgentIterator sourceTurtles = sourceSet.iterator();
            while (sourceTurtles.hasNext()) {
                Agent t = sourceTurtles.next();
                cachedIDs.add(BoxesRunTime.boxToLong((long)t.id()));
            }
        } else {
            cachedIDs = new HashSet<Object>(0);
        }
        return cachedIDs;
    }
}

