/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.nlogo.agent.AgentColors;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.AgentSet$;
import org.nlogo.agent.AgentSetBuilder;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.core.AgentKind$Link$;
import org.nlogo.core.AgentKind$Patch$;
import org.nlogo.core.AgentKind$Turtle$;
import org.nlogo.core.Breed;
import org.nlogo.core.Fail$;
import org.nlogo.core.LogoList;
import org.nlogo.core.Token;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$CloseBrace$;
import org.nlogo.core.TokenType$Ident$;
import org.nlogo.core.TokenType$Literal$;
import org.nlogo.core.TokenType$OpenBracket$;
import org.nlogo.core.TokenType$Reporter$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public class LiteralAgentParser
implements Function1<Iterator<Token>, Object> {
    private final org.nlogo.api.World _world;
    private final Function2<Token, Iterator<Token>, Object> readLiteralPrefix;
    private final String ERR_EXPECTED_BREED;
    private final String ERR_EXPECTED_CLOSEBRACE;
    private final String ERR_NOT_AN_AGENTSET;
    private final String ERR_NOT_A_BREED;
    private final String ERR_BAD_AGENT;
    public final String org$nlogo$agent$LiteralAgentParser$$ERR_BAD_PATCH_SET_ARGS;
    private final String ERR_BAD_PATCH_ARGS;
    private final String ERR_BAD_TURTLE_ARG;
    private final String ERR_BAD_TURTLE_SET_ARGS;
    private final String ERR_BAD_LINK_ARGS;
    private final String ERR_BAD_LINK_SET_ARGS;
    private final String ERR_ILLEGAL_AGENT_LITERAL;
    private final String SET_TYPE_ALLPATCHES;
    private final String SET_TYPE_ALLTURTLES;
    private final String SET_TYPE_ALLLINKS;
    private final String SET_TYPE_BREED;
    private final String SET_TYPE_OBSERVER;

    public LiteralAgentParser(org.nlogo.api.World _world, Function2<Token, Iterator<Token>, Object> readLiteralPrefix) {
        this._world = _world;
        this.readLiteralPrefix = readLiteralPrefix;
        this.ERR_EXPECTED_BREED = "Expected breed";
        this.ERR_EXPECTED_CLOSEBRACE = "Expected closing brace.";
        this.ERR_NOT_AN_AGENTSET = " is not an agentset";
        this.ERR_NOT_A_BREED = " is not a breed";
        this.ERR_BAD_AGENT = "Not an agent";
        this.org$nlogo$agent$LiteralAgentParser$$ERR_BAD_PATCH_SET_ARGS = "Patch agentsets are given by a set of 2 element integer lists containing a patch's pxcor and pycor";
        this.ERR_BAD_PATCH_ARGS = "pxcor and pycor must be floats";
        this.ERR_BAD_TURTLE_ARG = "a turtle's who number must be an integer";
        this.ERR_BAD_TURTLE_SET_ARGS = "Turtle agentsets are given by a set of turtles' who numbers";
        this.ERR_BAD_LINK_ARGS = "end1 and end2 must be floats";
        this.ERR_BAD_LINK_SET_ARGS = "Link agentsets are given by a set of links' endpoints and breeds";
        this.ERR_ILLEGAL_AGENT_LITERAL = "Can only have literal agents and agentsets if importing.";
        this.SET_TYPE_ALLPATCHES = "ALL-PATCHES";
        this.SET_TYPE_ALLTURTLES = "ALL-TURTLES";
        this.SET_TYPE_ALLLINKS = "ALL-LINKS";
        this.SET_TYPE_BREED = "BREED";
        this.SET_TYPE_OBSERVER = "OBSERVER";
    }

    public World world() {
        return (World)this._world;
    }

    public Object apply(Iterator<Token> tokens) {
        Token token = (Token)tokens.next();
        Fail$.MODULE$.cAssert(((List)new .colon.colon((Object)TokenType$Ident$.MODULE$, (List)new .colon.colon((Object)TokenType$Reporter$.MODULE$, (List)Nil$.MODULE$))).contains((Object)token.tpe()), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$1), token);
        String agentsetTypeString = (String)token.value();
        if (agentsetTypeString.equalsIgnoreCase(this.SET_TYPE_BREED)) {
            Token breedToken = (Token)tokens.next();
            TokenType tokenType = breedToken.tpe();
            TokenType$Ident$ tokenType$Ident$ = TokenType$Ident$.MODULE$;
            Fail$.MODULE$.cAssert(!(tokenType != null ? !tokenType.equals(tokenType$Ident$) : tokenType$Ident$ != null), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$2), breedToken);
            Token closeBrace = (Token)tokens.next();
            TokenType tokenType2 = closeBrace.tpe();
            TokenType$CloseBrace$ tokenType$CloseBrace$ = TokenType$CloseBrace$.MODULE$;
            Fail$.MODULE$.cAssert(!(tokenType2 != null ? !tokenType2.equals(tokenType$CloseBrace$) : tokenType$CloseBrace$ != null), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$3), closeBrace);
            String breedString = (String)breedToken.value();
            TreeAgentSet b = this.world().getBreed(breedString);
            TreeAgentSet breed = b != null ? b : this.world().getLinkBreed(breedString);
            Fail$.MODULE$.cAssert(breed != null, (Function0<String>)((Function0 & Serializable)() -> this.apply$$anonfun$4(breedString)), token);
            return breed;
        }
        if (((List)new .colon.colon((Object)this.SET_TYPE_ALLTURTLES, (List)new .colon.colon((Object)this.SET_TYPE_ALLPATCHES, (List)new .colon.colon((Object)this.SET_TYPE_ALLLINKS, (List)Nil$.MODULE$)))).contains((Object)agentsetTypeString.toUpperCase())) {
            Token closeBrace = (Token)tokens.next();
            TokenType tokenType = closeBrace.tpe();
            TokenType$CloseBrace$ tokenType$CloseBrace$ = TokenType$CloseBrace$.MODULE$;
            Fail$.MODULE$.cAssert(!(tokenType != null ? !tokenType.equals(tokenType$CloseBrace$) : tokenType$CloseBrace$ != null), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$5), closeBrace);
            String string = agentsetTypeString.toUpperCase();
            String string2 = this.SET_TYPE_ALLTURTLES;
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return this.world().turtles();
            }
            String string4 = this.SET_TYPE_ALLLINKS;
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                return this.world().links();
            }
            String string6 = this.SET_TYPE_ALLPATCHES;
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                return this.world().patches();
            }
            String s = string;
            throw new IllegalStateException();
        }
        if (agentsetTypeString.equalsIgnoreCase(this.SET_TYPE_OBSERVER)) {
            Token closeBrace = (Token)tokens.next();
            TokenType tokenType = closeBrace.tpe();
            TokenType$CloseBrace$ tokenType$CloseBrace$ = TokenType$CloseBrace$.MODULE$;
            Fail$.MODULE$.cAssert(!(tokenType != null ? !tokenType.equals(tokenType$CloseBrace$) : tokenType$CloseBrace$ != null), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$6), closeBrace);
            return AgentSet$.MODULE$.fromAgent(this.world().observer());
        }
        if (this.world().program().breeds().values().exists((Function1 & Serializable)_$1 -> {
            String string = _$1.singular();
            String string2 = agentsetTypeString.toUpperCase();
            return !(string != null ? !string.equals(string2) : string2 != null);
        })) {
            Token token2 = (Token)tokens.next();
            TokenType tokenType = token2.tpe();
            TokenType$Literal$ tokenType$Literal$ = TokenType$Literal$.MODULE$;
            Fail$.MODULE$.cAssert(!(tokenType != null ? !tokenType.equals(tokenType$Literal$) : tokenType$Literal$ != null) && token2.value() instanceof Double, (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$8), token2);
            Token closeBrace = (Token)tokens.next();
            TokenType tokenType3 = closeBrace.tpe();
            TokenType$CloseBrace$ tokenType$CloseBrace$ = TokenType$CloseBrace$.MODULE$;
            Fail$.MODULE$.cAssert(!(tokenType3 != null ? !tokenType3.equals(tokenType$CloseBrace$) : tokenType$CloseBrace$ != null), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$9), closeBrace);
            return this.world().getOrCreateTurtle(Int$.MODULE$.int2long(((Double)token2.value()).intValue()));
        }
        if (this.world().program().linkBreeds().values().exists((Function1 & Serializable)_$2 -> {
            String string = _$2.singular();
            String string2 = agentsetTypeString.toUpperCase();
            return !(string != null ? !string.equals(string2) : string2 != null);
        })) {
            Double end1 = this.parseEnd(tokens);
            Double end2 = this.parseEnd(tokens);
            Token closeBrace = (Token)tokens.next();
            TokenType tokenType = closeBrace.tpe();
            TokenType$CloseBrace$ tokenType$CloseBrace$ = TokenType$CloseBrace$.MODULE$;
            Fail$.MODULE$.cAssert(!(tokenType != null ? !tokenType.equals(tokenType$CloseBrace$) : tokenType$CloseBrace$ != null), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$11), closeBrace);
            return this.world().getOrCreateLink(end1, end2, this.world().getLinkBreed(((Breed)this.world().program().linkBreeds().values().find((Function1 & Serializable)_$3 -> {
                String string = _$3.singular();
                String string2 = agentsetTypeString.toUpperCase();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).get()).name()));
        }
        Object object = token.value();
        String string = "TURTLES";
        if (!(object != null ? !object.equals(string) : string != null)) {
            AgentSetBuilder builder = new AgentSetBuilder(AgentKind$Turtle$.MODULE$);
            Token token3 = (Token)tokens.next();
            while (true) {
                TokenType tokenType = token3.tpe();
                TokenType$CloseBrace$ tokenType$CloseBrace$ = TokenType$CloseBrace$.MODULE$;
                if (!(tokenType == null ? tokenType$CloseBrace$ != null : !tokenType.equals(tokenType$CloseBrace$))) break;
                Object value = this.readLiteralPrefix.apply((Object)token3, tokens);
                Fail$.MODULE$.cAssert(value instanceof Double, (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$13), token3);
                builder.add(this.world().getOrCreateTurtle(Int$.MODULE$.int2long(((Double)value).intValue())));
                token3 = (Token)tokens.next();
            }
            return builder.build();
        }
        Object object2 = token.value();
        String string8 = "LINKS";
        if (!(object2 != null ? !object2.equals(string8) : string8 != null)) {
            AgentSetBuilder builder = new AgentSetBuilder(AgentKind$Link$.MODULE$);
            Token token4 = (Token)tokens.next();
            while (true) {
                TokenType tokenType = token4.tpe();
                TokenType$CloseBrace$ tokenType$CloseBrace$ = TokenType$CloseBrace$.MODULE$;
                if (!(tokenType == null ? tokenType$CloseBrace$ != null : !tokenType.equals(tokenType$CloseBrace$))) break;
                TokenType tokenType4 = token4.tpe();
                TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
                Fail$.MODULE$.cAssert(!(tokenType4 != null ? !tokenType4.equals(tokenType$OpenBracket$) : tokenType$OpenBracket$ != null), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$14), token4);
                LogoList listVal = (LogoList)this.readLiteralPrefix.apply((Object)token4, tokens);
                Fail$.MODULE$.cAssert(listVal.size() == 3 && listVal.get(0) instanceof Double && listVal.get(1) instanceof Double && listVal.get(2) instanceof AgentSet, (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$15), token4);
                Link link = this.world().getOrCreateLink((Double)listVal.get(0), (Double)listVal.get(1), (AgentSet)listVal.get(2));
                if (link != null) {
                    builder.add(link);
                }
                token4 = (Token)tokens.next();
            }
            return builder.build();
        }
        Object object3 = token.value();
        String string9 = "PATCHES";
        if (!(object3 != null ? !object3.equals(string9) : string9 != null)) {
            AgentSetBuilder builder = new AgentSetBuilder(AgentKind$Patch$.MODULE$);
            ObjectRef token5 = ObjectRef.create((Object)((Token)tokens.next()));
            while (true) {
                int n;
                TokenType tokenType = ((Token)token5.elem).tpe();
                TokenType$CloseBrace$ tokenType$CloseBrace$ = TokenType$CloseBrace$.MODULE$;
                if (!(tokenType == null ? tokenType$CloseBrace$ != null : !tokenType.equals(tokenType$CloseBrace$))) break;
                TokenType tokenType5 = ((Token)token5.elem).tpe();
                TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
                Fail$.MODULE$.cAssert(!(tokenType5 != null ? !tokenType5.equals(tokenType$OpenBracket$) : tokenType$OpenBracket$ != null), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$16), (Token)token5.elem);
                World world = this.world();
                if (world instanceof World3D) {
                    World3D w = (World3D)world;
                    n = 3;
                } else if (world != null) {
                    World w = world;
                    n = 2;
                } else {
                    throw new MatchError((Object)world);
                }
                int expectedArity = n;
                LogoList listVal = (LogoList)this.readLiteralPrefix.apply((Object)((Token)token5.elem), tokens);
                Fail$.MODULE$.cAssert(listVal.size() == expectedArity && listVal.scalaIterator().forall((Function1 & Serializable)_$4 -> _$4 instanceof Double), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$18), (Token)token5.elem);
                Seq doubledPatchSet = listVal.scalaIterator().collect((PartialFunction)new Serializable(token5, this){
                    private final ObjectRef token$1;
                    private final /* synthetic */ LiteralAgentParser $outer;
                    {
                        this.token$1 = token$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Object x) {
                        Object object = x;
                        if (object instanceof Double) {
                            Double d = (Double)object;
                            return true;
                        }
                        Object other = object;
                        return true;
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        double d;
                        Object object = x;
                        if (object instanceof Double) {
                            Double d2 = (Double)object;
                            d = d2;
                        } else {
                            Object other = object;
                            Fail$.MODULE$.cAssert(other instanceof Double, (Function0<String>)((Function0 & Serializable)this::applyOrElse$$anonfun$1), (Token)this.token$1.elem);
                            d = 0.0;
                        }
                        return BoxesRunTime.boxToDouble((double)d);
                    }

                    private final String applyOrElse$$anonfun$1() {
                        return this.$outer.org$nlogo$agent$LiteralAgentParser$$ERR_BAD_PATCH_SET_ARGS;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1()}, serializedLambda);
                    }
                }).toSeq();
                builder.add(this.getPatchAt((Token)token5.elem, (Seq<Object>)doubledPatchSet));
                token5.elem = (Token)tokens.next();
            }
            return builder.build();
        }
        if (((List)new .colon.colon((Object)"TURTLE", (List)new .colon.colon((Object)"PATCH", (List)new .colon.colon((Object)"LINK", (List)Nil$.MODULE$)))).contains(token.value())) {
            AgentColors result = this.parseLiteralAgent(token, tokens);
            Token closeBrace = (Token)tokens.next();
            TokenType tokenType = closeBrace.tpe();
            TokenType$CloseBrace$ tokenType$CloseBrace$ = TokenType$CloseBrace$.MODULE$;
            Fail$.MODULE$.cAssert(!(tokenType != null ? !tokenType.equals(tokenType$CloseBrace$) : tokenType$CloseBrace$ != null), (Function0<String>)((Function0 & Serializable)this::apply$$anonfun$19), closeBrace);
            return result;
        }
        throw Fail$.MODULE$.exception(agentsetTypeString + this.ERR_NOT_AN_AGENTSET, token);
    }

    private AgentColors parseLiteralAgent(Token token, Iterator<Token> tokens) {
        Fail$.MODULE$.cAssert(this.world() != null, (Function0<String>)((Function0 & Serializable)this::parseLiteralAgent$$anonfun$1), token);
        Object object = token.value();
        if ("PATCH".equals(object)) {
            World world = this.world();
            if (world instanceof World3D) {
                World3D w = (World3D)world;
                return this.getPatchAt(token, (Seq<Object>)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{this.parsePcor(tokens), this.parsePcor(tokens), this.parsePcor(tokens)}));
            }
            if (world != null) {
                World w = world;
                return this.getPatchAt(token, (Seq<Object>)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{this.parsePcor(tokens), this.parsePcor(tokens)}));
            }
            throw new MatchError((Object)world);
        }
        if ("TURTLE".equals(object)) {
            Token token2 = (Token)tokens.next();
            TokenType tokenType = token2.tpe();
            TokenType$Literal$ tokenType$Literal$ = TokenType$Literal$.MODULE$;
            Fail$.MODULE$.cAssert(!(tokenType != null ? !tokenType.equals(tokenType$Literal$) : tokenType$Literal$ != null) && token2.value() instanceof Double, (Function0<String>)((Function0 & Serializable)this::parseLiteralAgent$$anonfun$2), token2);
            return this.world().getOrCreateTurtle(((Double)token2.value()).longValue());
        }
        if ("LINK".equals(object)) {
            return this.world().getOrCreateLink(this.parseEnd(tokens), this.parseEnd(tokens), (AgentSet)this.world().links());
        }
        throw Fail$.MODULE$.exception(this.ERR_BAD_AGENT, token);
    }

    private Patch getPatchAt(Token token, Seq<Object> cors) {
        org.nlogo.api.Patch patch;
        block4: {
            try {
                if (cors.length() == 2) {
                    patch = this.world().getPatchAt(BoxesRunTime.unboxToDouble((Object)cors.apply(0)), BoxesRunTime.unboxToDouble((Object)cors.apply(1)));
                    break block4;
                }
                if (cors.length() == 3) {
                    patch = ((World3D)this.world()).getPatchAt(BoxesRunTime.unboxToDouble((Object)cors.apply(0)), BoxesRunTime.unboxToDouble((Object)cors.apply(1)), BoxesRunTime.unboxToDouble((Object)cors.apply(2)));
                    break block4;
                }
                throw Fail$.MODULE$.exception("Invalid patch coordinates ( " + cors.mkString(", ") + " ) ", token);
            }
            catch (AgentException agentException) {
                throw Fail$.MODULE$.exception("Invalid patch coordinates ( " + cors.mkString(", ") + " ) ", token);
            }
        }
        return patch;
    }

    private double parsePcor(Iterator<Token> tokens) {
        Token token = (Token)tokens.next();
        TokenType tokenType = token.tpe();
        TokenType$Literal$ tokenType$Literal$ = TokenType$Literal$.MODULE$;
        Fail$.MODULE$.cAssert(!(tokenType != null ? !tokenType.equals(tokenType$Literal$) : tokenType$Literal$ != null) && token.value() instanceof Double, (Function0<String>)((Function0 & Serializable)this::parsePcor$$anonfun$1), token);
        return Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)token.value()));
    }

    private Double parseEnd(Iterator<Token> tokens) {
        Token token = (Token)tokens.next();
        TokenType tokenType = token.tpe();
        TokenType$Literal$ tokenType$Literal$ = TokenType$Literal$.MODULE$;
        Fail$.MODULE$.cAssert(!(tokenType != null ? !tokenType.equals(tokenType$Literal$) : tokenType$Literal$ != null) && token.value() instanceof Double, (Function0<String>)((Function0 & Serializable)this::parseEnd$$anonfun$1), token);
        return (Double)token.value();
    }

    private final String apply$$anonfun$1() {
        return this.ERR_EXPECTED_BREED;
    }

    private final String apply$$anonfun$2() {
        return this.ERR_EXPECTED_BREED;
    }

    private final String apply$$anonfun$3() {
        return this.ERR_EXPECTED_CLOSEBRACE;
    }

    private final String apply$$anonfun$4(String breedString$1) {
        return breedString$1 + this.ERR_NOT_A_BREED;
    }

    private final String apply$$anonfun$5() {
        return this.ERR_EXPECTED_CLOSEBRACE;
    }

    private final String apply$$anonfun$6() {
        return this.ERR_EXPECTED_CLOSEBRACE;
    }

    private final String apply$$anonfun$8() {
        return this.ERR_BAD_TURTLE_ARG;
    }

    private final String apply$$anonfun$9() {
        return this.ERR_EXPECTED_CLOSEBRACE;
    }

    private final String apply$$anonfun$11() {
        return this.ERR_EXPECTED_CLOSEBRACE;
    }

    private final String apply$$anonfun$13() {
        return this.ERR_BAD_TURTLE_SET_ARGS;
    }

    private final String apply$$anonfun$14() {
        return this.ERR_BAD_LINK_SET_ARGS;
    }

    private final String apply$$anonfun$15() {
        return this.ERR_BAD_LINK_SET_ARGS;
    }

    private final String apply$$anonfun$16() {
        return this.org$nlogo$agent$LiteralAgentParser$$ERR_BAD_PATCH_SET_ARGS;
    }

    private final String apply$$anonfun$18() {
        return this.org$nlogo$agent$LiteralAgentParser$$ERR_BAD_PATCH_SET_ARGS;
    }

    private final String apply$$anonfun$19() {
        return this.ERR_EXPECTED_CLOSEBRACE;
    }

    private final String parseLiteralAgent$$anonfun$1() {
        return this.ERR_ILLEGAL_AGENT_LITERAL;
    }

    private final String parseLiteralAgent$$anonfun$2() {
        return this.ERR_BAD_TURTLE_ARG;
    }

    private final String parsePcor$$anonfun$1() {
        return this.ERR_BAD_PATCH_ARGS;
    }

    private final String parseEnd$$anonfun$1() {
        return this.ERR_BAD_LINK_ARGS;
    }
}

