/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.HeadingSmoother;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Link;
import org.nlogo.api.Numbers$;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Perspective;
import org.nlogo.api.Perspective$Observe$;
import org.nlogo.api.Vect;
import org.nlogo.api.Version$;
import scala.Int$;
import scala.Option;
import scala.Some$;

public interface OrientatableObserver {
    public static void $init$(OrientatableObserver $this) {
        $this.oxcor_$eq(0.0);
        $this.oycor_$eq(0.0);
        $this.ozcor_$eq(0.0);
        $this.perspective_$eq(Perspective$Observe$.MODULE$);
        $this.org$nlogo$agent$OrientatableObserver$_setter_$_orientation_$eq(new Orientation($this, (Observer)$this));
        $this.org$nlogo$agent$OrientatableObserver$_setter_$orientation_$eq((Option)Some$.MODULE$.apply((Object)$this._orientation()));
        $this.org$nlogo$agent$OrientatableObserver$_setter_$org$nlogo$agent$OrientatableObserver$$headingSmoother_$eq(new HeadingSmoother());
        $this.resetPerspective();
    }

    public double oxcor();

    public void oxcor_$eq(double var1);

    public double oycor();

    public void oycor_$eq(double var1);

    public double ozcor();

    public void ozcor_$eq(double var1);

    public static void oxcor$(OrientatableObserver $this, double d) {
        $this.oxcor(d);
    }

    default public void oxcor(double d) {
        this.oxcor_$eq(d);
    }

    public static void oycor$(OrientatableObserver $this, double d) {
        $this.oycor(d);
    }

    default public void oycor(double d) {
        this.oycor_$eq(d);
    }

    public static void ozcor$(OrientatableObserver $this, double d) {
        $this.ozcor(d);
    }

    default public void ozcor(double d) {
        this.ozcor_$eq(d);
    }

    public Perspective perspective();

    public void perspective_$eq(Perspective var1);

    public Orientation _orientation();

    public void org$nlogo$agent$OrientatableObserver$_setter_$_orientation_$eq(Orientation var1);

    public Option<ObserverOrientation> orientation();

    public void org$nlogo$agent$OrientatableObserver$_setter_$orientation_$eq(Option var1);

    public HeadingSmoother org$nlogo$agent$OrientatableObserver$$headingSmoother();

    public void org$nlogo$agent$OrientatableObserver$_setter_$org$nlogo$agent$OrientatableObserver$$headingSmoother_$eq(HeadingSmoother var1);

    public static void setPerspective$(OrientatableObserver $this, Perspective perspective) {
        $this.setPerspective(perspective);
    }

    default public void setPerspective(Perspective perspective) {
        this.perspective_$eq(perspective);
        this.updatePosition();
    }

    public static void resetPerspective$(OrientatableObserver $this) {
        $this.resetPerspective();
    }

    default public void resetPerspective() {
        this.setPerspective(Perspective$Observe$.MODULE$);
        this.home();
    }

    public static void orbitRight$(OrientatableObserver $this, double delta) {
        $this.orbitRight(delta);
    }

    default public void orbitRight(double delta) {
        this._orientation().orbitRight(delta);
    }

    public static void orbitUp$(OrientatableObserver $this, double delta) {
        $this.orbitUp(delta);
    }

    default public void orbitUp(double delta) {
        this._orientation().orbitUp(delta);
    }

    public static void setRotationPoint$(OrientatableObserver $this, Vect v) {
        $this.setRotationPoint(v);
    }

    default public void setRotationPoint(Vect v) {
        this._orientation().rotationPoint_$eq(v);
    }

    public static void heading$(OrientatableObserver $this, double heading) {
        $this.heading(heading);
    }

    default public void heading(double heading) {
        this._orientation().heading_$eq((heading % (double)360 + (double)360) % (double)360);
    }

    public static void pitch$(OrientatableObserver $this, double pitch) {
        $this.pitch(pitch);
    }

    default public void pitch(double pitch) {
        this._orientation().pitch_$eq((pitch % (double)360 + (double)360) % (double)360);
    }

    public static void roll$(OrientatableObserver $this, double roll) {
        $this.roll(roll);
    }

    default public void roll(double roll) {
        this._orientation().roll_$eq((roll % (double)360 + (double)360) % (double)360);
    }

    public static void setRotationPoint$(OrientatableObserver $this, double x, double y, double z) {
        $this.setRotationPoint(x, y, z);
    }

    default public void setRotationPoint(double x, double y, double z) {
        this._orientation().rotationPoint_$eq(new Vect(x, y, z));
    }

    public static void oxyandzcor$(OrientatableObserver $this, double oxcor, double oycor, double ozcor) {
        $this.oxyandzcor(oxcor, oycor, ozcor);
    }

    default public void oxyandzcor(double oxcor, double oycor, double ozcor) {
        this.oxcor_$eq(oxcor);
        this.oycor_$eq(oycor);
        this.ozcor_$eq(ozcor);
    }

    public static double distance$(OrientatableObserver $this, org.nlogo.api.Turtle t) {
        return $this.distance(t);
    }

    default public double distance(org.nlogo.api.Turtle t) {
        return this.distance(t.xcor(), t.ycor());
    }

    public static double distance$(OrientatableObserver $this, double x, double y) {
        return $this.distance(x, y);
    }

    default public double distance(double x, double y) {
        return StrictMath.sqrt((x - this.oxcor()) * (x - this.oxcor()) + (y - this.oycor()) * (y - this.oycor()) + this.ozcor() * this.ozcor());
    }

    public static boolean atHome2D$(OrientatableObserver $this) {
        return $this.atHome2D();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean atHome2D() {
        Perspective perspective = this.perspective();
        Perspective$Observe$ perspective$Observe$ = Perspective$Observe$.MODULE$;
        if (perspective == null) {
            if (perspective$Observe$ != null) {
                return false;
            }
        } else if (!perspective.equals(perspective$Observe$)) return false;
        if (this.oxcor() != 0.0) return false;
        if (this.oycor() != 0.0) return false;
        return true;
    }

    public static boolean atHome3D$(OrientatableObserver $this) {
        return $this.atHome3D();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean atHome3D() {
        Perspective perspective = this.perspective();
        Perspective$Observe$ perspective$Observe$ = Perspective$Observe$.MODULE$;
        if (perspective == null) {
            if (perspective$Observe$ != null) {
                return false;
            }
        } else if (!perspective.equals(perspective$Observe$)) return false;
        if (this.oxcor() != 0.0) return false;
        if (this.oycor() != 0.0) return false;
        if (this.ozcor() != (double)StrictMath.max(((Observer)this).world().worldWidth(), ((Observer)this).world().worldHeight()) * 1.5) return false;
        if (!this._orientation().atHome3D()) return false;
        return true;
    }

    public static void home$(OrientatableObserver $this) {
        $this.home();
    }

    default public void home() {
        this.oxcor_$eq((double)((Observer)this).world().minPxcor() + (double)(((Observer)this).world().maxPxcor() - ((Observer)this).world().minPxcor()) / 2.0);
        this.oycor_$eq((double)((Observer)this).world().minPycor() + (double)(((Observer)this).world().maxPycor() - ((Observer)this).world().minPycor()) / 2.0);
        this.ozcor_$eq((double)StrictMath.max(((Observer)this).world().worldWidth(), ((Observer)this).world().worldHeight()) * 1.5);
        this._orientation().heading_$eq(0.0);
        this._orientation().pitch_$eq(90.0);
        this._orientation().roll_$eq(0.0);
        this.setRotationPoint(this.oxcor(), this.oycor(), 0.0);
    }

    public static void face$(OrientatableObserver $this, org.nlogo.api.Agent agent) {
        $this.face(agent);
    }

    default public void face(org.nlogo.api.Agent agent) {
        block6: {
            try {
                this.heading(((Observer)this).world().protractor().towards((org.nlogo.api.Agent)((Object)this), agent, false));
            }
            catch (AgentException ex) {
                this.heading(0.0);
            }
            try {
                this.pitch(-((Observer)this).world().protractor().towardsPitch((org.nlogo.api.Agent)((Object)this), agent, false));
            }
            catch (AgentException ex) {
                this.pitch(0.0);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof UnsupportedOperationException) {
                    UnsupportedOperationException ex = (UnsupportedOperationException)throwable2;
                    if (!Version$.MODULE$.is3D()) break block6;
                }
                throw throwable;
            }
        }
        this.setRotationPoint(agent);
    }

    public static void face$(OrientatableObserver $this, double x, double y) {
        $this.face(x, y);
    }

    default public void face(double x, double y) {
        try {
            this.heading(((Observer)this).world().protractor().towards((org.nlogo.api.Agent)((Object)this), x, y, false));
        }
        catch (AgentException ex) {
            this.heading(0.0);
        }
        try {
            this.pitch(-((Observer)this).world().protractor().towardsPitch((org.nlogo.api.Agent)((Object)this), x, y, 0.0, false));
        }
        catch (AgentException ex) {
            this.pitch(0.0);
        }
        this.setRotationPoint(x, y, 0.0);
    }

    public static void setRotationPoint$(OrientatableObserver $this, org.nlogo.api.Agent agent) {
        $this.setRotationPoint(agent);
    }

    default public void setRotationPoint(org.nlogo.api.Agent agent) {
        org.nlogo.api.Agent agent2 = agent;
        if (agent2 instanceof org.nlogo.api.Turtle) {
            org.nlogo.api.Turtle t = (org.nlogo.api.Turtle)agent2;
            this.setRotationPoint(t.xcor(), t.ycor(), 0.0);
            return;
        }
        if (agent2 instanceof Link) {
            Link l = (Link)agent2;
            this.setRotationPoint(l.midpointX(), l.midpointY(), 0.0);
            return;
        }
        if (agent2 instanceof org.nlogo.api.Patch) {
            org.nlogo.api.Patch p = (org.nlogo.api.Patch)agent2;
            this.setRotationPoint(Int$.MODULE$.int2double(p.pxcor()), Int$.MODULE$.int2double(p.pycor()), 0.0);
            return;
        }
    }

    public static Vect rotationPoint$(OrientatableObserver $this) {
        return $this.rotationPoint();
    }

    default public Vect rotationPoint() {
        return this._orientation().rotationPoint();
    }

    public static void moveto$(OrientatableObserver $this, Agent otherAgent) {
        $this.moveto(otherAgent);
    }

    default public void moveto(Agent otherAgent) throws AgentException {
        Agent agent = otherAgent;
        if (agent instanceof Turtle) {
            Turtle t = (Turtle)agent;
            this.oxyandzcor(t.xcor, t.ycor, 0.0);
        } else if (agent instanceof Patch) {
            Patch p = (Patch)agent;
            this.oxyandzcor(Int$.MODULE$.int2double(p.pxcor), Int$.MODULE$.int2double(p.pycor), 0.0);
        } else {
            throw new AgentException("you can't move-to a link");
        }
        this.face(this._orientation().rotationPoint().x(), this._orientation().rotationPoint().y());
    }

    public static boolean updatePosition$(OrientatableObserver $this) {
        return $this.updatePosition();
    }

    default public boolean updatePosition() {
        Perspective.Watch w;
        Perspective perspective = this.perspective();
        if (Perspective$Observe$.MODULE$.equals(perspective)) {
            return false;
        }
        if (perspective instanceof Perspective.Watch && (w = (Perspective.Watch)perspective).targetAgent() != null) {
            if (((Observer)this).targetAgent().id() == -1L) {
                this.resetPerspective();
                return true;
            }
            this.setRotationPoint(((Observer)this).targetAgent());
            this.face(((Observer)this).targetAgent());
            return false;
        }
        if (perspective instanceof AgentFollowingPerspective) {
            Perspective rideOrFollow = (Perspective)((Object)((AgentFollowingPerspective)((Object)perspective)));
            if (((Observer)this).targetAgent() != null) {
                if (((Observer)this).targetAgent().id() == -1L) {
                    this.resetPerspective();
                    return true;
                }
                Turtle turtle = (Turtle)((Observer)this).targetAgent();
                this.oxyandzcor(turtle.xcor, turtle.ycor, 0.0);
                double newHeading = this.org$nlogo$agent$OrientatableObserver$$headingSmoother().follow(((Observer)this).targetAgent());
                Perspective perspective2 = this.perspective();
                if (perspective2 instanceof Perspective.Follow) {
                    Perspective.Follow f = (Perspective.Follow)perspective2;
                    this.heading(newHeading);
                } else {
                    this.heading(turtle.heading);
                }
                this.pitch(0.0);
                this.roll(0.0);
                return false;
            }
            return false;
        }
        throw new IllegalStateException();
    }

    public static void translate$(OrientatableObserver $this, double thetaX, double thetaY) {
        $this.translate(thetaX, thetaY);
    }

    default public void translate(double thetaX, double thetaY) {
        double headingR = StrictMath.toRadians(this._orientation().heading());
        double sinH = StrictMath.sin(headingR);
        double cosH = StrictMath.cos(headingR);
        this.oxcor_$eq(this.oxcor() - (cosH * thetaX + sinH * thetaY) * 0.1);
        this.oycor_$eq(this.oycor() + (sinH * thetaX - cosH * thetaY) * 0.1);
        this._orientation().rotationPoint_$eq(new Vect(this._orientation().rotationPoint().x() - (cosH * thetaX + sinH * thetaY) * 0.1, this._orientation().rotationPoint().y() + (sinH * thetaX - cosH * thetaY) * 0.1, this._orientation().rotationPoint().z()));
    }

    public class Orientation
    implements ObserverOrientation {
        private final Observer observer;
        private double pitch;
        private double heading;
        private double roll;
        private Vect rotationPoint;
        private final double infinitesimal;
        private final /* synthetic */ OrientatableObserver $outer;

        public Orientation(OrientatableObserver $outer, Observer observer) {
            this.observer = observer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.pitch = 0.0;
            this.heading = 0.0;
            this.roll = 0.0;
            this.rotationPoint = null;
            this.infinitesimal = Numbers$.MODULE$.Infinitesimal();
        }

        @Override
        public double pitch() {
            return this.pitch;
        }

        public void pitch_$eq(double x$1) {
            this.pitch = x$1;
        }

        @Override
        public double heading() {
            return this.heading;
        }

        public void heading_$eq(double x$1) {
            this.heading = x$1;
        }

        @Override
        public double roll() {
            return this.roll;
        }

        public void roll_$eq(double x$1) {
            this.roll = x$1;
        }

        public Vect rotationPoint() {
            return this.rotationPoint;
        }

        public void rotationPoint_$eq(Vect x$1) {
            this.rotationPoint = x$1;
        }

        private final double truncateTiny(double d) {
            if (StrictMath.abs(d) < this.infinitesimal) {
                return 0.0;
            }
            return d;
        }

        @Override
        public double dist() {
            return StrictMath.sqrt((this.rotationPoint().x() - this.observer.oxcor()) * (this.rotationPoint().x() - this.observer.oxcor()) + (this.rotationPoint().y() - this.observer.oycor()) * (this.rotationPoint().y() - this.observer.oycor()) + (this.rotationPoint().z() - this.observer.ozcor()) * (this.rotationPoint().z() - this.observer.ozcor()));
        }

        @Override
        public double dx() {
            return this.truncateTiny(StrictMath.cos(StrictMath.toRadians(this.$outer._orientation().pitch())) * StrictMath.sin(StrictMath.toRadians(this.$outer._orientation().heading())));
        }

        @Override
        public double dy() {
            return this.truncateTiny(StrictMath.cos(StrictMath.toRadians(this.$outer._orientation().pitch())) * StrictMath.cos(StrictMath.toRadians(this.$outer._orientation().heading())));
        }

        @Override
        public double dz() {
            return this.truncateTiny(StrictMath.sin(StrictMath.toRadians(this.$outer._orientation().pitch())));
        }

        public boolean atHome3D() {
            return this.heading() == 0.0 && this.pitch() == (double)90 && this.roll() == 0.0 && this.rotationPoint().x() == 0.0 && this.rotationPoint().y() == 0.0 && this.rotationPoint().z() == 0.0;
        }

        public double normalizeDegrees(double d) {
            return (d % (double)360 + (double)360) % (double)360;
        }

        public void orbitRight(double _delta) {
            double delta = -_delta;
            double newHeading = this.heading() + delta;
            double dxy = this.dist() * StrictMath.cos(StrictMath.toRadians(this.pitch()));
            double x = -dxy * StrictMath.sin(StrictMath.toRadians(newHeading));
            double y = -dxy * StrictMath.cos(StrictMath.toRadians(newHeading));
            this.observer.oxyandzcor(x + this.rotationPoint().x(), y + this.rotationPoint().y(), this.$outer.ozcor());
            this.heading_$eq(this.normalizeDegrees(newHeading));
        }

        public void orbitUp(double _delta) {
            double delta = -_delta;
            double newPitch = this.pitch() - delta;
            double z = this.dist() * StrictMath.sin(StrictMath.toRadians(newPitch));
            double dxy = this.dist() * StrictMath.cos(StrictMath.toRadians(newPitch));
            double x = -dxy * StrictMath.sin(StrictMath.toRadians(this.heading()));
            double y = -dxy * StrictMath.cos(StrictMath.toRadians(this.heading()));
            if (z + this.$outer._orientation().rotationPoint().z() > 0.0 && newPitch < (double)90) {
                this.observer.oxyandzcor(x + this.rotationPoint().x(), y + this.rotationPoint().y(), z + this.rotationPoint().z());
                this.pitch_$eq(this.normalizeDegrees(newPitch));
                return;
            }
        }

        public final /* synthetic */ OrientatableObserver org$nlogo$agent$OrientatableObserver$Orientation$$$outer() {
            return this.$outer;
        }
    }
}

