/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Agent$;
import org.nlogo.agent.AgentColors;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.Exceptions;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.Breed;
import org.nlogo.core.I18N;
import org.nlogo.core.LogoList;
import org.nlogo.core.Program;
import org.nlogo.log.LogManager;
import scala.Option;
import scala.collection.immutable.Set;

public abstract class Turtle
extends Agent
implements org.nlogo.api.Turtle,
AgentColors {
    public static final int VAR_WHO = 0;
    public static final int VAR_COLOR = 1;
    public static final int VAR_HEADING = 2;
    public static final int VAR_XCOR = 3;
    public static final int VAR_YCOR = 4;
    static final int VAR_SHAPE = 5;
    public static final int VAR_LABEL = 6;
    private static final int VAR_LABELCOLOR = 7;
    static final int VAR_BREED = 8;
    private static final int VAR_HIDDEN = 9;
    private static final int VAR_SIZE = 10;
    private static final int VAR_PENSIZE = 11;
    private static final int VAR_PENMODE = 12;
    public int LAST_PREDEFINED_VAR = 12;
    public int NUMBER_PREDEFINED_VARS = this.LAST_PREDEFINED_VAR + 1;
    public static final String PEN_UP = "up".intern();
    public static final String PEN_DOWN = "down".intern();
    public static final String PEN_ERASE = "erase".intern();
    Patch currentPatch = null;
    double heading = 0.0;
    double cachedHeading = 0.0;
    double cachedSine = 0.0;
    double cachedCosine = 1.0;
    double xcor;
    double ycor;
    private final Set<Turtle> setOfSelf = Agent$.MODULE$.turtleSet(this);
    public static final int BIT = 2;
    private List<Link> links = null;

    @Override
    public void setId(long id) {
        super.setId(id);
        this._variables[0] = (double)id;
    }

    @Override
    public AgentKind kind() {
        return AgentKindJ.Turtle();
    }

    void initvars(Double xcor, Double ycor, AgentSet breed) {
        this._variables[1] = Color.BoxedBlack();
        this.heading = 0.0;
        this._variables[2] = World.Zero();
        this.xcor = xcor;
        this._variables[3] = xcor;
        this.ycor = ycor;
        this._variables[4] = ycor;
        this._variables[5] = this._world.turtleBreedShapes().breedShape(breed);
        this._variables[6] = "";
        this._variables[7] = Color.BoxedWhite();
        this._variables[8] = breed;
        this._variables[9] = Boolean.FALSE;
        this._variables[10] = World.One();
        this._variables[11] = World.One();
        this._variables[12] = PEN_UP;
    }

    public Turtle(World world, AgentSet breed, Double xcor, Double ycor) {
        this(world, breed, xcor, ycor, true);
    }

    Turtle(World world, AgentSet breed, Double xcor, Double ycor, boolean getId) {
        super(world);
        Object[] variables = new Object[world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)breed)];
        this.setVariables(variables);
        if (getId) {
            this.setId(world.newTurtleId());
            world.turtles().add(this);
        }
        this.initvars(xcor, ycor, breed);
        for (int i = this.LAST_PREDEFINED_VAR + 1; i < variables.length; ++i) {
            variables[i] = World.Zero();
        }
        if (breed != world.turtles()) {
            ((TreeAgentSet)breed).add(this);
        }
        this.getPatchHere().addTurtle(this);
    }

    Turtle(World world, long id) {
        this(world, world.turtles(), World.Zero(), World.Zero(), false);
        this.setId(id);
        world.turtles().add(this);
    }

    Turtle(World world) {
        super(world);
    }

    public abstract Turtle hatch(TreeAgentSet var1);

    @Override
    public abstract Patch getPatchAtOffsets(double var1, double var3) throws AgentException;

    public abstract Patch getPatchAtHeadingAndDistance(double var1, double var3) throws AgentException;

    @Override
    public abstract void jump(double var1) throws AgentException;

    @Override
    public abstract Patch getPatchHere();

    public abstract void moveToPatchCenter();

    public abstract void home();

    public abstract void face(Agent var1, boolean var2);

    public abstract void turnRight(double var1);

    public abstract double dx();

    public abstract double dy();

    abstract void drawLine(double var1, double var3, double var5, double var7);

    abstract Turtle makeTurtle(World var1);

    public Turtle hatch() {
        return this.hatch(this.getBreed());
    }

    public void die() {
        if (this._id == -1L) {
            return;
        }
        this._world.linkManager().cleanupTurtle(this);
        Patch patch = this.getPatchHere();
        patch.removeTurtle(this);
        TreeAgentSet breed = this.getBreed();
        if (breed != this._world.turtles()) {
            breed.remove(this.agentKey());
        }
        this._world.removeLineThickness(this);
        this._world.turtles().remove(this.agentKey());
        long oldId = this.id();
        this.setId(-1L);
        Observer observer = this._world.observer();
        if (this == observer.targetAgent()) {
            observer.updatePosition();
        }
        LogManager.turtleRemoved(oldId, breed.printName());
    }

    @Override
    public double lineThickness() {
        if (this._world != null) {
            return this._world.lineThickness(this);
        }
        return 0.0;
    }

    @Override
    public Agent realloc(Program oldProgram, Program newProgram) {
        return this.realloc(oldProgram, newProgram, null);
    }

    Agent realloc(Program oldProgram, Program program, AgentSet oldBreed) {
        int oldpos;
        String name;
        int i;
        boolean compiling;
        boolean bl = compiling = oldProgram != null;
        if (compiling && this.getBreed() != this._world.turtles() && this._world.getBreed(this.getBreed().printName()) == null) {
            return this;
        }
        Object[] oldvars = this._variables;
        Object[] variables = new Object[this._world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)this.getBreed())];
        int turtlesOwnSize = this._world.getVariablesArraySize((org.nlogo.api.Turtle)null, (org.nlogo.api.AgentSet)this._world.turtles());
        int numberToCopyDirectly = compiling ? this.NUMBER_PREDEFINED_VARS : turtlesOwnSize;
        System.arraycopy(oldvars, 0, variables, 0, numberToCopyDirectly);
        if (compiling) {
            for (i = this.NUMBER_PREDEFINED_VARS; i < turtlesOwnSize; ++i) {
                name = this._world.turtlesOwnNameAt(i);
                oldpos = oldProgram.turtlesOwn().indexOf((Object)name);
                if (oldpos == -1) {
                    variables[i] = World.Zero();
                    continue;
                }
                variables[i] = oldvars[oldpos];
                oldvars[oldpos] = null;
            }
        }
        for (i = turtlesOwnSize; i < variables.length; ++i) {
            name = this._world.breedsOwnNameAt(this.getBreed(), i);
            int n = oldpos = compiling ? this.oldBreedsOwnIndexOf(oldProgram, this.getBreed(), name) : this._world.breedsOwnIndexOf(oldBreed, name);
            if (oldpos == -1) {
                variables[i] = World.Zero();
                continue;
            }
            variables[i] = oldvars[oldpos];
            oldvars[oldpos] = null;
        }
        this.setVariables(variables);
        return null;
    }

    private int oldBreedsOwnIndexOf(Program oldProgram, AgentSet breed, String name) {
        Option found = oldProgram.breeds().get((Object)breed.printName());
        if (found.isEmpty()) {
            return -1;
        }
        int result = ((Breed)found.get()).owns().indexOf((Object)name);
        if (result == -1) {
            return -1;
        }
        return oldProgram.turtlesOwn().size() + result;
    }

    @Override
    public String variableName(int vn) {
        if (vn < this._world.program().turtlesOwn().size()) {
            return this._world.turtlesOwnNameAt(vn);
        }
        return this._world.breedsOwnNameAt(this.getBreed(), vn);
    }

    @Override
    public void setVariable(int vn, Object value) throws AgentException {
        this.setTurtleVariable(vn, value);
    }

    @Override
    public Object getTurtleOrLinkVariable(String varName) {
        return this.getTurtleVariable(this._world.program().turtlesOwn().indexOf((Object)varName));
    }

    @Override
    public Object getTurtleVariable(int vn) {
        return this.getVariable(vn);
    }

    @Override
    public Object getVariable(int vn) {
        Object[] variables = this._variables;
        if (vn == 0 && variables[0] == null) {
            variables[0] = (double)this._id;
        } else if (vn == 2 && variables[2] == null) {
            variables[2] = this.heading;
        } else if (vn == 3 && variables[3] == null) {
            variables[3] = this.xcor;
        } else if (vn == 4 && variables[4] == null) {
            variables[4] = this.ycor;
        }
        return variables[vn];
    }

    public double getTurtleVariableDouble(int vn) {
        switch (vn) {
            case 0: {
                return this._id;
            }
            case 2: {
                return this.heading;
            }
            case 3: {
                return this.xcor;
            }
            case 4: {
                return this.ycor;
            }
            case 10: {
                return this.size();
            }
            case 11: {
                return this.penSize();
            }
        }
        throw new IllegalArgumentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.notADoubleVariable", vn));
    }

    @Override
    public Object getLinkBreedVariable(String name) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantAccessLinkWithoutSpecifyingLink"));
    }

    @Override
    public Object getBreedVariable(String name) throws AgentException {
        int vn = this._world.breedsOwnIndexOf(this.getBreed(), name);
        if (name != null && vn == -1) {
            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.breedDoesNotOwnVariable", this.getBreed().printName(), name));
        }
        return this.getTurtleVariable(vn);
    }

    public boolean ownsVariable(String name) {
        int vn = this._world.breedsOwnIndexOf(this.getBreed(), name);
        if (vn != -1) {
            return true;
        }
        vn = this._world.turtlesOwnIndexOf(name);
        return vn != -1;
    }

    public Object getVariable(String name) throws AgentException {
        int vn = this._world.breedsOwnIndexOf(this.getBreed(), name);
        if (vn == -1) {
            vn = this._world.turtlesOwnIndexOf(name);
        }
        if (vn != -1) {
            return this.getTurtleVariable(vn);
        }
        throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.breedDoesNotOwnVariable", this.toString(), name));
    }

    @Override
    public Object getLinkVariable(int vn) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantAccessLinkWithoutSpecifyingLink"));
    }

    @Override
    public Object getPatchVariable(int vn) {
        return this.getPatchHere().getPatchVariable(vn);
    }

    @Override
    public void setTurtleOrLinkVariable(String varName, Object value) throws AgentException {
        this.setTurtleVariable(this._world.program().turtlesOwn().indexOf((Object)varName), value);
    }

    @Override
    public void setTurtleVariable(int vn, double value) throws AgentException {
        switch (vn) {
            case 1: {
                this.colorDouble(value);
                break;
            }
            case 2: {
                this.heading(value);
                break;
            }
            case 3: {
                this.xcor(value);
                break;
            }
            case 4: {
                this.ycor(value);
                break;
            }
            case 10: {
                this.size(value);
                break;
            }
            case 11: {
                this.penSize(value);
                break;
            }
            case 0: {
                throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantChangeWho"));
            }
            default: {
                throw new IllegalArgumentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.notADoubleVariable", vn));
            }
        }
    }

    @Override
    public void setTurtleVariable(int vn, Object value) throws AgentException {
        if (vn > this.LAST_PREDEFINED_VAR) {
            this._variables[vn] = value;
        } else {
            switch (vn) {
                case 1: {
                    if (value instanceof Double) {
                        this.colorDouble((Double)value);
                        break;
                    }
                    if (value instanceof LogoList) {
                        this.color((LogoList)value, 1);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], Double.class, value);
                    break;
                }
                case 2: {
                    if (value instanceof Double) {
                        this.heading((Double)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], Double.class, value);
                    break;
                }
                case 3: {
                    if (value instanceof Double) {
                        this.xcor((Double)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], Double.class, value);
                    break;
                }
                case 4: {
                    if (value instanceof Double) {
                        this.ycor((Double)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], Double.class, value);
                    break;
                }
                case 5: {
                    if (value instanceof String) {
                        String newShape = this._world.checkTurtleShapeName((String)value);
                        if (newShape == null) {
                            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.shapeUndefined", value));
                        }
                        this.shape(newShape);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], String.class, value);
                    break;
                }
                case 6: {
                    this.label(value);
                    break;
                }
                case 7: {
                    if (value instanceof Double) {
                        this.labelColor((Double)value);
                        break;
                    }
                    if (value instanceof LogoList) {
                        this.labelColor((LogoList)value, 7);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], Double.class, value);
                    break;
                }
                case 8: {
                    if (value instanceof AgentSet) {
                        AgentSet breed = (AgentSet)value;
                        if (breed != this._world.turtles() && !this._world.isBreed(breed)) {
                            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantSetBreedToNonBreedAgentSet"));
                        }
                        this.setBreed(breed);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], AgentSet.class, value);
                    break;
                }
                case 9: {
                    if (value instanceof Boolean) {
                        this.hidden((Boolean)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], Boolean.class, value);
                    break;
                }
                case 10: {
                    if (value instanceof Double) {
                        this.size((Double)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], Double.class, value);
                    break;
                }
                case 12: {
                    if (value instanceof String) {
                        this.penMode((String)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], String.class, value);
                    break;
                }
                case 11: {
                    if (value instanceof Double) {
                        this.penSize((Double)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[vn], Double.class, value);
                    break;
                }
                case 0: {
                    throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantChangeWho"));
                }
                default: {
                    throw new IllegalStateException(I18N.errorsJ().getN("org.nlogo.agent.Agent.cantSetUnknownVariable", vn));
                }
            }
        }
        this._world.notifyWatchers(this, vn, value);
    }

    @Override
    public void setBreedVariable(String name, Object value) throws AgentException {
        int vn = this._world.breedsOwnIndexOf(this.getBreed(), name);
        if (name != null && vn == -1) {
            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.breedDoesNotOwnVariable", this.getBreed().printName(), name));
        }
        this.setTurtleVariable(vn, value);
    }

    @Override
    public void setPatchVariable(int vn, Object value) throws AgentException {
        this.getPatchHere().setPatchVariable(vn, value);
    }

    @Override
    public void setPatchVariable(int vn, double value) throws AgentException {
        this.getPatchHere().setPatchVariable(vn, value);
    }

    @Override
    public void setLinkVariable(int vn, Object value) throws AgentException {
        throw new AgentException("a turtle can't set a link variable without specifying which link");
    }

    @Override
    public void setLinkVariable(int vn, double value) throws AgentException {
        throw new AgentException("a turtle can't set a link variable without specifying which link");
    }

    @Override
    public void setLinkBreedVariable(String name, Object value) throws AgentException {
        throw new AgentException("a turtle can't set a link variable without specifying which link");
    }

    @Override
    public Object color() {
        return this._variables[1];
    }

    public void colorDouble(Double boxedColor) {
        double c = boxedColor;
        if (c < 0.0 || c >= (double)Color.MaxColor()) {
            c = Color.modulateDouble(c);
            boxedColor = c;
        }
        this._variables[1] = boxedColor;
    }

    public void colorDoubleUnchecked(Double boxedColor) {
        this._variables[1] = boxedColor;
    }

    public void color(LogoList rgb, int varIndex) throws AgentException {
        this.validRGBList(rgb, true);
        this._variables[varIndex] = rgb;
        if (rgb.size() > 3) {
            this._world.mayHavePartiallyTransparentObjects(true);
        }
    }

    @Override
    public double heading() {
        return this.heading;
    }

    @Override
    public void heading(double heading) {
        double originalHeading = this.heading;
        this.headingHelper(heading);
        if (this._world.tieManager().hasTies()) {
            this._world.tieManager().turtleTurned(this, heading, originalHeading);
        }
    }

    public void heading(double heading, Set<Turtle> seenTurtles) {
        double originalHeading = this.heading;
        this.headingHelper(heading);
        if (this._world.tieManager().hasTies()) {
            this._world.tieManager().turtleTurned(this, heading, originalHeading, seenTurtles);
        }
    }

    private void headingHelper(double heading) {
        if (heading < 0.0 || heading >= 360.0) {
            heading = (heading % 360.0 + 360.0) % 360.0;
        }
        this.heading = heading;
        this._variables[2] = null;
        Observer observer = this._world.observer();
        if (this == observer.targetAgent()) {
            observer.updatePosition();
        }
    }

    public void heading(Double heading) {
        double originalHeading = this.heading;
        double h = heading;
        double wrapped = h < 0.0 || h >= 360.0 ? (h % 360.0 + 360.0) % 360.0 : h;
        this.heading = wrapped;
        this._variables[2] = h == wrapped ? heading : null;
        Observer observer = this._world.observer();
        if (this == observer.targetAgent()) {
            observer.updatePosition();
        }
        if (this._world.tieManager().hasTies()) {
            this._world.tieManager().turtleTurned(this, h, originalHeading);
        }
    }

    public void moveTo(Agent otherAgent) throws AgentException {
        double y;
        double x;
        if (otherAgent instanceof Turtle) {
            Turtle t = (Turtle)otherAgent;
            x = t.xcor();
            y = t.ycor();
        } else if (otherAgent instanceof Patch) {
            Patch p = (Patch)otherAgent;
            x = p.pxcor;
            y = p.pycor;
        } else {
            throw new AgentException("you can't move-to a link");
        }
        this.xandycor(this.shortestPathX(x), this.shortestPathY(y));
    }

    public double shortestPathY(double y) throws AgentException {
        if (this.penMode() != PEN_DOWN) {
            return y;
        }
        double yprime = (y = this._world.wrapY(y)) > this.ycor ? y - (double)this._world.worldHeight() : y + (double)this._world.worldHeight();
        if (!this._world.wrappingAllowedInY()) {
            yprime = y;
        }
        if (StrictMath.abs(y - this.ycor) > StrictMath.abs(yprime - this.ycor)) {
            y = yprime;
        }
        return y;
    }

    public double shortestPathX(double x) throws AgentException {
        if (this.penMode() != PEN_DOWN) {
            return x;
        }
        double xprime = (x = this._world.wrapX(x)) > this.xcor ? x - (double)this._world.worldWidth() : x + (double)this._world.worldWidth();
        if (!this._world.wrappingAllowedInX()) {
            xprime = x;
        }
        if (StrictMath.abs(x - this.xcor) > StrictMath.abs(xprime - this.xcor)) {
            x = xprime;
        }
        return x;
    }

    @Override
    public double xcor() {
        return this.xcor;
    }

    public void xcor(double xcor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double oldX = this.xcor;
        this.drawLine(this.xcor, this.ycor, this.shortestPathX(xcor), this.ycor);
        this.xcor = this._world.wrapX(xcor);
        this._variables[3] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this._world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this._world.tieManager().hasTies()) {
            this._world.tieManager().turtleMoved(this, xcor, this.ycor, oldX, this.ycor);
        }
    }

    public void xcor(Double xcor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double x = xcor;
        double oldX = this.xcor;
        double wrapped = this._world.wrapX(x);
        this.drawLine(this.xcor, this.ycor, this.shortestPathX(x), this.ycor);
        this.xcor = wrapped;
        this._variables[3] = x == wrapped ? xcor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this._world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this._world.tieManager().hasTies()) {
            this._world.tieManager().turtleMoved(this, x, this.ycor, oldX, this.ycor);
        }
    }

    @Override
    public double ycor() {
        return this.ycor;
    }

    public void ycor(double ycor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double oldY = this.ycor;
        this.drawLine(this.xcor, this.ycor, this.xcor, this.shortestPathY(ycor));
        this.ycor = this._world.wrapY(ycor);
        this._variables[4] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this._world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this._world.tieManager().hasTies()) {
            this._world.tieManager().turtleMoved(this, this.xcor, ycor, this.xcor, oldY);
        }
    }

    public void ycor(Double ycor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double y = ycor;
        double oldY = this.ycor;
        double wrapped = this._world.wrapY(y);
        this.drawLine(this.xcor, this.ycor, this.xcor, this.shortestPathY(y));
        this.ycor = wrapped;
        this._variables[4] = y == wrapped ? ycor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this._world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this._world.tieManager().hasTies()) {
            this._world.tieManager().turtleMoved(this, this.xcor, y, this.xcor, oldY);
        }
    }

    public void xandycor(double xcor, double ycor) throws AgentException {
        this.xandycorHelper(xcor, ycor, false);
    }

    public void xandycor(double xcor, double ycor, Set<Turtle> seenTurtles, boolean isJump) throws AgentException {
        this.xandycorHelper(xcor, ycor, seenTurtles, isJump);
    }

    public void xandycorHelper(double xcor, double ycor, boolean isJump) throws AgentException {
        this.xandycorHelper(xcor, ycor, this.setOfSelf, isJump);
    }

    public void xandycorHelper(double xcor, double ycor, Set<Turtle> seenTurtles, boolean isJump) throws AgentException {
        Observer observer;
        double oldX = this.xcor;
        double oldY = this.ycor;
        Patch originalPatch = this.getPatchHere();
        double newX = this._world.wrapX(xcor);
        double newY = this._world.wrapY(ycor);
        if (!isJump) {
            this.drawLine(this.xcor, this.ycor, xcor, ycor);
        }
        this.xcor = newX;
        this.ycor = newY;
        this._variables[3] = null;
        this._variables[4] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this._world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this._world.tieManager().hasTies()) {
            this._world.tieManager().turtleMoved(this, xcor, ycor, oldX, oldY, seenTurtles);
        }
    }

    public void xandycor(Double xcor, Double ycor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double x = xcor;
        double y = ycor;
        double oldX = this.xcor;
        double oldY = this.ycor;
        double wrappedX = this._world.wrapX(x);
        double wrappedY = this._world.wrapY(y);
        this.drawLine(this.xcor, this.ycor, x, y);
        this.xcor = wrappedX;
        this.ycor = wrappedY;
        this._variables[3] = x == wrappedX ? xcor : null;
        this._variables[4] = y == wrappedY ? ycor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this._world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this._world.tieManager().hasTies()) {
            this._world.tieManager().turtleMoved(this, x, y, oldX, oldY);
        }
    }

    public void face(double x, double y, boolean wrap) {
        try {
            this.heading(this._world.protractor().towards(this, x, y, wrap));
        }
        catch (AgentException ex) {
            Exceptions.ignore(ex);
        }
    }

    public static double subtractHeadings(double h1, double h2) {
        double diff;
        if (h1 < 0.0 || h1 >= 360.0) {
            h1 = (h1 % 360.0 + 360.0) % 360.0;
        }
        if (h2 < 0.0 || h2 >= 360.0) {
            h2 = (h2 % 360.0 + 360.0) % 360.0;
        }
        if ((diff = h1 - h2) > -180.0 && diff <= 180.0) {
            return diff;
        }
        if (diff > 0.0) {
            return diff - 360.0;
        }
        return diff + 360.0;
    }

    @Override
    public String shape() {
        return (String)this._variables[5];
    }

    public void shape(String shape) {
        this._variables[5] = shape;
    }

    public Object label() {
        return this._variables[6];
    }

    @Override
    public boolean hasLabel() {
        return !(this.label() instanceof String) || ((String)this.label()).length() != 0;
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this._variables[6]);
    }

    public void label(Object label) {
        this._variables[6] = label;
    }

    @Override
    public Object labelColor() {
        return this._variables[7];
    }

    public void labelColor(double labelColor) {
        this._variables[7] = Color.modulateDouble(labelColor);
    }

    public void labelColor(LogoList rgb, int valueIndex) throws AgentException {
        this.validRGBList(rgb, true);
        this._variables[valueIndex] = rgb;
    }

    @Override
    public TreeAgentSet getBreed() {
        return (TreeAgentSet)this._variables[8];
    }

    @Override
    public int getBreedIndex() {
        TreeAgentSet mybreed = this.getBreed();
        if (mybreed == this._world.turtles()) {
            return 0;
        }
        int j = 0;
        Iterator iter = this._world.breeds().values().iterator();
        while (iter.hasNext()) {
            if (mybreed == iter.next()) {
                return j;
            }
            ++j;
        }
        return 0;
    }

    public void setBreed(AgentSet breed) {
        AgentSet oldBreed = null;
        if (this._variables[8] instanceof AgentSet) {
            oldBreed = (AgentSet)this._variables[8];
            if (breed == oldBreed) {
                return;
            }
            if (oldBreed != this._world.turtles()) {
                ((TreeAgentSet)this._variables[8]).remove(this.agentKey());
            }
        }
        if (breed != this._world.turtles()) {
            ((TreeAgentSet)breed).add(this);
        }
        this._variables[8] = breed;
        this.shape(this._world.turtleBreedShapes().breedShape(breed));
        this.realloc(null, this._world.program(), oldBreed);
    }

    @Override
    public boolean hidden() {
        return (Boolean)this._variables[9];
    }

    public void hidden(boolean hidden) {
        this._variables[9] = hidden ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public double size() {
        return (Double)this._variables[10];
    }

    public void size(double size) {
        this._variables[10] = size;
    }

    public double penSize() {
        return (Double)this._variables[11];
    }

    public void penSize(double penSize) {
        this._variables[11] = penSize;
    }

    public String penMode() {
        return (String)this._variables[12];
    }

    public void penMode(String penMode) {
        this._variables[12] = penMode.intern();
    }

    public String toString() {
        return this._world.getBreedSingular(this.getBreed()).toLowerCase() + " " + this._id;
    }

    @Override
    public String classDisplayName() {
        return this._world.getBreedSingular(this.getBreed()).toLowerCase();
    }

    @Override
    public int agentBit() {
        return 2;
    }

    @Override
    public int alpha() {
        return Color.getColor(this.color()).getAlpha();
    }

    public boolean isLinkedWith(Turtle dest, AgentSet linkSet) {
        if (this.links == null || this.links.isEmpty()) {
            return false;
        }
        boolean checkAllBreeds = linkSet == this._world.links();
        boolean isBreedSet = !linkSet.isBreedSet();
        for (Link link : this.links) {
            Turtle otherEnd;
            if (!checkAllBreeds && !(isBreedSet ? linkSet == link.getBreed() : linkSet.contains(link)) || (otherEnd = link._end1 == this ? link._end2 : link._end1) != dest) continue;
            return true;
        }
        return false;
    }

    public boolean isLinkedTo(Turtle dest, AgentSet linkSet) {
        if (this.links == null || this.links.isEmpty()) {
            return false;
        }
        boolean checkAllBreeds = linkSet == this._world.links();
        boolean isBreedSet = !linkSet.isBreedSet();
        for (Link link : this.links) {
            Turtle otherEnd;
            if (!checkAllBreeds && !(isBreedSet ? linkSet == link.getBreed() : linkSet.contains(link)) || !(link.isDirectedLink() ? link._end1 == this && link._end2 == dest : (otherEnd = link._end1 == this ? link._end2 : link._end1) == dest)) continue;
            return true;
        }
        return false;
    }

    public void addLink(Link link) {
        if (this.links == null) {
            this.links = new ArrayList<Link>(1);
        }
        this.links.add(link);
    }

    public boolean removeLink(Link link) {
        return this.links != null && this.links.remove(link);
    }

    public Link[] links() {
        return this.links == null ? new Link[]{} : this.links.toArray(new Link[this.links.size()]);
    }

    public Link[] selectLinks(boolean out, boolean in, AgentSet linkSet) {
        boolean notBreedSet;
        if (this.links == null || this.links.isEmpty()) {
            return new Link[0];
        }
        boolean allBreeds = linkSet == this._world.links();
        boolean bl = notBreedSet = !linkSet.isBreedSet();
        if (allBreeds && out && in) {
            return this.links();
        }
        Link[] result = new Link[this.links.size()];
        int writeTo = 0;
        for (Link link : this.links) {
            if (!allBreeds && linkSet != link.getBreed() && (!notBreedSet || !linkSet.contains(link)) || !(out && in || out && link._end1 == this || in && link._end2 == this) && link.isDirectedLink()) continue;
            result[writeTo] = link;
            ++writeTo;
        }
        if (writeTo == result.length) {
            return result;
        }
        return Arrays.copyOfRange(result, 0, writeTo);
    }
}

