/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.nlogo.api.APIVersion$;
import org.nlogo.api.LocalFile;
import org.nlogo.api.Version$;
import org.nlogo.core.FileMode$Write$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public final class FileIO$
implements Serializable {
    public static final FileIO$ MODULE$ = new FileIO$();

    private FileIO$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileIO$.class);
    }

    public String fileToString(File file) throws IOException {
        BufferedSource f = Source$.MODULE$.fromFile(file, "UTF-8");
        String result = f.mkString();
        f.close();
        return result;
    }

    public String fileToString(String path) throws IOException {
        BufferedSource file = Source$.MODULE$.fromFile(path, "UTF-8");
        String result = file.mkString();
        file.close();
        return result;
    }

    public String fileToString(String path, String encoding) throws IOException {
        BufferedSource file = Source$.MODULE$.fromFile(path, "UTF-8");
        String result = file.mkString();
        file.close();
        return result;
    }

    public String url2String(String sampleURL) throws IOException {
        String badStart;
        if (sampleURL.startsWith("/")) {
            return this.getResourceAsString(sampleURL);
        }
        String massagedURL = !System.getProperty("os.name").startsWith("Mac") ? (sampleURL.indexOf(badStart = "file://") != -1 ? "file:/" + StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(sampleURL), StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(badStart))) : sampleURL) : sampleURL;
        return this.reader2String(new InputStreamReader(new URL(massagedURL).openStream(), "UTF-8"));
    }

    public Iterator<String> getResourceLines(String path) {
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(path)));
        return package$.MODULE$.Iterator().continually(() -> FileIO$.getResourceLines$$anonfun$1(in)).takeWhile((Function1 & Serializable)_$1 -> _$1 != null);
    }

    public String[] getResourceAsStringArray(String path) {
        return (String[])this.getResourceLines(path).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public String getResourceAsString(String path) {
        return this.getResourceLines(path).mkString("", "\n", "\n");
    }

    public void writeFile(String path, String text) throws IOException {
        this.writeFile(path, text, false);
    }

    public void writeImageFile(BufferedImage image, String filename, String format) throws IOException {
        FileOutputStream stream = new FileOutputStream(new File(filename));
        ImageIO.write((RenderedImage)image, format, stream);
        stream.close();
    }

    public String reader2String(Reader reader) throws IOException {
        return this.reader2String(reader, 8192);
    }

    public String reader2String(Reader reader, int bufferSize) {
        if (bufferSize <= 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        StringBuilder sb = new StringBuilder();
        char[] buffer = (char[])Array$.MODULE$.fill(bufferSize, FileIO$::$anonfun$1, ClassTag$.MODULE$.apply(Character.TYPE));
        package$.MODULE$.Iterator().continually(() -> FileIO$.reader2String$$anonfun$1(reader, buffer)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable)_$2 -> _$2 != -1).foreach((Function1 & Serializable)_$3 -> sb.appendAll(buffer, 0, BoxesRunTime.unboxToInt((Object)_$3)));
        reader.close();
        return sb.toString();
    }

    public int reader2String$default$2() {
        return 8192;
    }

    public void writeFile(String path, String text, boolean convertToPlatformLineBreaks) throws IOException {
        LocalFile file = new LocalFile(path);
        try {
            file.open(FileMode$Write$.MODULE$);
            if (!convertToPlatformLineBreaks) {
                file.print(text);
            } else {
                BufferedReader lineReader = new BufferedReader(new StringReader(text));
                Iterator lines = package$.MODULE$.Iterator().continually(() -> FileIO$.$anonfun$2(lineReader)).takeWhile((Function1 & Serializable)_$4 -> _$4 != null);
                lines.foreach(line -> file.println((String)line));
            }
            file.close(true);
        }
        finally {
            file.close(false);
        }
    }

    public String perUserFile(String file, boolean createNecessaryDirs) {
        String res = this.perUserPath(file);
        if (createNecessaryDirs) {
            Files.createDirectories(Paths.get(res, new String[0]).getParent(), new FileAttribute[0]);
        }
        return res;
    }

    public boolean perUserFile$default$2() {
        return true;
    }

    public String perUserDir(String dir, boolean create) {
        String res = this.perUserPath(dir);
        if (create) {
            Files.createDirectories(Paths.get(res, new String[0]), new FileAttribute[0]);
        }
        return res;
    }

    public boolean perUserDir$default$2() {
        return true;
    }

    private String perUserPath(String path) {
        String string;
        List list;
        Option option;
        Regex minorVersionRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+\\.\\d+).*"));
        String string2 = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(Version$.MODULE$.version()), "NetLogo ")), "3D ");
        if (string2 == null || (option = minorVersionRegex.unapplySeq((CharSequence)string2)).isEmpty() || (list = (List)option.get()).lengthCompare(1) != 0) {
            String v = string2;
            throw new IllegalStateException();
        }
        String v = string = (String)list.apply(0);
        String version = v;
        String os = System.getProperty("os.name").toUpperCase();
        String appData = os.contains("WIN") ? System.getenv("APPDATA") + "\\NetLogo" : (os.contains("MAC") ? System.getProperty("user.home") + "/Library/Application Support/NetLogo" : System.getProperty("user.home") + "/.netlogo");
        return appData + File.separator + version + File.separator + path;
    }

    public Path perUserExtensionFile(String file, boolean createNecessaryDirs) {
        Path res = this.perUserExtensionPath(file);
        if (createNecessaryDirs) {
            Files.createDirectories(res.getParent(), new FileAttribute[0]);
        }
        return res;
    }

    public boolean perUserExtensionFile$default$2() {
        return true;
    }

    public Path perUserExtensionDir(String dir, boolean createNecessaryDirs) {
        Path res = this.perUserExtensionPath(dir);
        if (createNecessaryDirs) {
            Files.createDirectories(res, new FileAttribute[0]);
        }
        return res;
    }

    public boolean perUserExtensionDir$default$2() {
        return true;
    }

    private Path perUserExtensionPath(String path) {
        String os = System.getProperty("os.name").toUpperCase();
        String appData = os.contains("WIN") ? System.getenv("APPDATA") + "\\NetLogo" : (os.contains("MAC") ? System.getProperty("user.home") + "/Library/Application Support/NetLogo" : System.getProperty("user.home") + "/.netlogo");
        return Paths.get(appData, APIVersion$.MODULE$.version(), path);
    }

    public Option<Path> resolvePath(String name) {
        return this.resolvePath(name, (Option<Path>)None$.MODULE$);
    }

    public Option<Path> resolvePath(String name, Path peerFile) {
        return this.resolvePath(name, (Option<Path>)Some$.MODULE$.apply((Object)peerFile));
    }

    public Option<Path> resolvePath(String name, Option<Path> peerFile) {
        None$ none$;
        block3: {
            try {
                Path path = Paths.get(name, new String[0]);
                if (path.isAbsolute()) {
                    none$ = Some$.MODULE$.apply((Object)path);
                    break block3;
                }
                none$ = peerFile.flatMap((Function1 & Serializable)p -> Option$.MODULE$.apply((Object)p.toAbsolutePath().getParent()).map((Function1 & Serializable)_$5 -> _$5.resolve(name))).orElse(() -> FileIO$.resolvePath$$anonfun$2(name)).map((Function1 & Serializable)_$6 -> _$6.toAbsolutePath());
            }
            catch (InvalidPathException e) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public String ensureExtension(String path, String extension) {
        if (path.endsWith("." + extension)) {
            return path;
        }
        return path + "." + extension;
    }

    private static final String getResourceLines$$anonfun$1(BufferedReader in$1) {
        return in$1.readLine();
    }

    private static final char $anonfun$1() {
        return '\u0000';
    }

    private static final int reader2String$$anonfun$1(Reader reader$1, char[] buffer$1) {
        return reader$1.read(buffer$1);
    }

    private static final String $anonfun$2(BufferedReader lineReader$1) {
        return lineReader$1.readLine();
    }

    private static final Option resolvePath$$anonfun$2(String name$3) {
        return Some$.MODULE$.apply((Object)Paths.get(System.getProperty("user.home"), name$3));
    }
}

