/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.Writer;
import java.net.URI;
import org.nlogo.api.ComponentSerialization;
import org.nlogo.api.LabProtocol;
import org.nlogo.api.ModelFormat;
import org.nlogo.core.Model;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.util.Try;

public class FormatterPair<A, B extends ModelFormat<A, B>> {
    private final B modelFormat;
    private final Seq<ComponentSerialization<A, B>> serializers;
    private final ClassTag<A> aTag;

    public FormatterPair(B modelFormat, Seq<ComponentSerialization<A, B>> serializers, ClassTag<A> aTag) {
        this.modelFormat = modelFormat;
        this.serializers = serializers;
        this.aTag = aTag;
    }

    public B modelFormat() {
        return this.modelFormat;
    }

    public Seq<ComponentSerialization<A, B>> serializers() {
        return this.serializers;
    }

    public boolean isCompatible(String source) {
        return this.modelFormat().isCompatible(source);
    }

    public boolean isCompatible(URI uri) {
        return this.modelFormat().isCompatible(uri);
    }

    public boolean isCompatible(Model model) {
        return this.modelFormat().isCompatible(model);
    }

    public Class<?> serializationClass() {
        return this.aTag.runtimeClass();
    }

    public Class<? extends B> formatClass() {
        return this.modelFormat().getClass();
    }

    public FormatterPair<A, B> addSerializer(ComponentSerialization<A, B> s) {
        return new FormatterPair<A, B>(this.modelFormat(), (Seq)this.serializers().$colon$plus(s), this.aTag);
    }

    public FormatterPair<A, B> addSerializers(Seq<ComponentSerialization<A, B>> s) {
        return new FormatterPair<A, B>(this.modelFormat(), (Seq)this.serializers().$plus$plus(s), this.aTag);
    }

    public String name() {
        return this.modelFormat().name();
    }

    public Try<Model> load(URI uri) {
        return this.modelFormat().load(uri, this.serializers());
    }

    public Try<Model> load(String source) {
        return this.modelFormat().load(source, this.serializers());
    }

    public Try<URI> save(Model model, URI uri) {
        return this.modelFormat().save(model, uri, this.serializers());
    }

    public Try<String> sourceString(Model model) {
        return this.modelFormat().sourceString(model, this.serializers());
    }

    public Model emptyModel() {
        return this.modelFormat().emptyModel(this.serializers());
    }

    public Try<Tuple2<Seq<LabProtocol>, Set<String>>> readExperiments(String source, boolean editNames, Set<String> existingNames) {
        return this.modelFormat().readExperiments(source, editNames, existingNames);
    }

    public Try<BoxedUnit> writeExperiments(Seq<LabProtocol> experiments, Writer writer) {
        return this.modelFormat().writeExperiments(experiments, writer);
    }
}

