/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.nlogo.api.Graphics2DWrapper$;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.core.Shape$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.util.Properties$;

public class Graphics2DWrapper
implements GraphicsInterface {
    private final Graphics2D g;
    private final boolean renderLabelsAsRectangles;
    private List<AffineTransform> transforms;
    private List<Stroke> strokes;

    public static boolean $lessinit$greater$default$2() {
        return Graphics2DWrapper$.MODULE$.$lessinit$greater$default$2();
    }

    public Graphics2DWrapper(Graphics2D g, boolean renderLabelsAsRectangles) {
        this.g = g;
        this.renderLabelsAsRectangles = renderLabelsAsRectangles;
        this.transforms = package$.MODULE$.Nil();
        this.strokes = package$.MODULE$.Nil();
    }

    public Graphics2DWrapper(Graphics2D g) {
        this(g, false);
    }

    @Override
    public String location(double x, double y) {
        return "(" + (this.g.getTransform().getTranslateX() + x) + " , " + (this.g.getTransform().getTranslateY() + y) + ")";
    }

    @Override
    public void draw(Shape shape) {
        this.g.draw(shape);
    }

    @Override
    public void drawImage(BufferedImage image) {
        this.g.drawImage(image, null, 0, 0);
    }

    @Override
    public void drawImage(Image image, int x, int y, int width, int height) {
        this.g.drawImage(image, x, y, width, height, null);
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        this.g.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    @Override
    public void drawLabel(String label, double x, double y, double patchSize) {
        if (this.renderLabelsAsRectangles) {
            this.push();
            this.translate(x, y);
            this.fillRect(0, 0, 5, 5);
            this.pop();
            return;
        }
        FontMetrics fm = this.g.getFontMetrics();
        Object[] lines = label.split("\n");
        this.g.translate(x - (double)fm.stringWidth(lines[0]), 0.0);
        if (patchSize >= (double)(fm.getMaxAscent() + fm.getMaxDescent())) {
            this.g.translate(0.0, y - (double)fm.getMaxDescent());
        } else {
            double centerAdjustment = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(0.0), patchSize / (double)4 - (double)(fm.getMaxAscent() / 4));
            this.g.translate(0.0, y - centerAdjustment);
        }
        Object object = Predef$.MODULE$.refArrayOps(lines);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        ArrayOps$.MODULE$.foreach$extension(object2, x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                this.g.drawString(line, 0.0f, (float)(1 * fm.getHeight() * i));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public void fillCircle(double x, double y, double xDiameter, double yDiameter, double scale, double angle) {
        this.g.fill(new Ellipse2D.Double(x, y, xDiameter, yDiameter));
    }

    @Override
    public void drawCircle(double x, double y, double xDiameter, double yDiameter, double scale, double angle) {
        double sizeCorrection = (double)(-Shape$.MODULE$.Width()) / scale;
        double xCorrection = this.getXCorrection(sizeCorrection, angle);
        double yCorrection = this.getYCorrection(sizeCorrection, angle);
        this.g.draw(new Ellipse2D.Double(x + xCorrection, y + yCorrection, xDiameter + sizeCorrection, yDiameter + sizeCorrection));
    }

    @Override
    public void fillRect(double x, double y, double width, double height, double scale, double angle) {
        this.g.fill(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public void drawRect(double x, double y, double width, double height, double scale, double angle) {
        double sizeCorrection = (double)(-Shape$.MODULE$.Width()) / scale;
        this.g.draw(new Rectangle2D.Double(x, y, width + sizeCorrection, height + sizeCorrection));
    }

    private double getXCorrection(double sizeCorrection, double angle) {
        if (angle == 0.0) {
            return 0.0;
        }
        return sizeCorrection * (StrictMath.cos((angle + (double)135) / 180.0 * Math.PI) + 0.7071067811865476) / -1.4142135623730951;
    }

    private double getYCorrection(double sizeCorrection, double angle) {
        if (angle == 0.0) {
            return 0.0;
        }
        return sizeCorrection * (StrictMath.sin((angle - (double)45) / 180.0 * Math.PI) + 0.7071067811865476) / -1.4142135623730951;
    }

    @Override
    public void fill(Shape shape) {
        this.g.fill(shape);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(x, y, width, height);
    }

    @Override
    public void pop() {
        this.g.setTransform((AffineTransform)this.transforms.head());
        this.transforms = (List)this.transforms.tail();
        this.g.setStroke((Stroke)this.strokes.head());
        this.strokes = (List)this.strokes.tail();
    }

    @Override
    public void push() {
        this.transforms = this.transforms.$colon$colon((Object)this.g.getTransform());
        this.strokes = this.strokes.$colon$colon((Object)this.g.getStroke());
    }

    @Override
    public void rotate(double theta) {
        this.g.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.g.rotate(theta, x, y);
    }

    @Override
    public void rotate(double theta, double x, double y, double offset) {
        this.g.rotate(theta, x + offset / (double)2, y + offset / (double)2);
    }

    @Override
    public void scale(double x, double y) {
        this.g.scale(x, y);
    }

    @Override
    public void scale(double x, double y, double shapeWidth) {
        this.g.scale(x / shapeWidth, y / shapeWidth);
    }

    @Override
    public void antiAliasing(boolean on) {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, on ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void setInterpolation() {
        if (Properties$.MODULE$.isMac()) {
            this.g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            return;
        }
    }

    @Override
    public void setStrokeControl() {
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    @Override
    public void setColor(Color c) {
        this.g.setColor(c);
    }

    @Override
    public void setComposite(Composite comp) {
        this.g.setComposite(comp);
    }

    @Override
    public void setStroke(double width) {
        this.g.setStroke(new BasicStroke((float)RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(width), 1.0)));
    }

    @Override
    public void setStrokeFromLineThickness(double lineThickness, double scale, double cellSize, double shapeWidth) {
        this.setStroke(shapeWidth / scale * (lineThickness == 0.0 ? 1.0 : lineThickness * cellSize));
    }

    @Override
    public void setStroke(float width, float[] dashes) {
        this.g.setStroke(new BasicStroke(width, 1, 1, 1.0f, dashes, 0.0f));
    }

    public void setPenWidth(double penSize) {
        float width = (float)RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(penSize), 1.0);
        if (((BasicStroke)this.g.getStroke()).getLineWidth() != width) {
            this.g.setStroke(new BasicStroke(width, 1, 0));
            return;
        }
    }

    @Override
    public void translate(double x, double y) {
        this.g.translate(x, y);
    }

    @Override
    public void drawPolygon(int[] xcors, int[] ycors, int length) {
        this.g.drawPolygon(xcors, ycors, length);
    }

    @Override
    public void fillPolygon(int[] xcors, int[] ycors, int length) {
        this.g.fillPolygon(xcors, ycors, length);
    }

    @Override
    public void drawPolyline(int[] xcors, int[] ycors, int length) {
        this.g.drawPolyline(xcors, ycors, length);
    }

    @Override
    public void dispose() {
        this.g.dispose();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }
}

