/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.nlogo.api.ExtensionInstaller;
import org.nlogo.api.FileIO$;
import org.nlogo.api.LibraryInfoDownloader$;
import org.nlogo.api.LibraryManager$;
import org.nlogo.api.MetadataLoadingException;
import org.nlogo.core.LibraryInfo;
import org.nlogo.core.LibraryInfo$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public class LibraryManager
implements org.nlogo.core.LibraryManager {
    private final String userInstalledsPath = FileIO$.MODULE$.perUserExtensionFile("installed-libraries.conf", FileIO$.MODULE$.perUserExtensionFile$default$2()).toString();
    private final ExtensionInstaller extInstaller;
    private Seq<LibraryInfo> libraries;
    private Seq<Function1<Seq<LibraryInfo>, BoxedUnit>> infoChangeCallbacks;
    private final String allLibsPath;

    public LibraryManager(Path userExtPath, Function0<BoxedUnit> unloadExtensions) {
        this.extInstaller = new ExtensionInstaller(userExtPath, unloadExtensions);
        this.libraries = (Seq)((SeqOps)Nil$.MODULE$);
        this.infoChangeCallbacks = (Seq)((SeqOps)Nil$.MODULE$);
        this.allLibsPath = FileIO$.MODULE$.perUserExtensionFile(LibraryManager$.org$nlogo$api$LibraryManager$$$allLibsName, FileIO$.MODULE$.perUserExtensionFile$default$2()).toString();
        if (!Files.exists(Paths.get(this.userInstalledsPath, new String[0]), new LinkOption[0])) {
            try {
                Files.createFile(Paths.get(this.userInstalledsPath, new String[0]), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        }
        this.reloadMetadata(true, this.reloadMetadata$default$2());
    }

    public String allLibsPath() {
        return this.allLibsPath;
    }

    public Seq<LibraryInfo> getExtensionInfos() {
        return this.libraries;
    }

    @Override
    public Option<LibraryInfo> lookupExtension(String name, String version) {
        return this.libraries.find((Function1 & Serializable)ext -> {
            String string = ext.codeName();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    @Override
    public void installExtension(LibraryInfo ext) {
        if (Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled())) {
            this.extInstaller.install(ext);
            this.updateInstalledVersion("extensions", ext, this.updateInstalledVersion$default$3());
            return;
        }
    }

    public void uninstallExtension(LibraryInfo ext) {
        if (Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled())) {
            this.extInstaller.uninstall(ext);
            this.updateInstalledVersion("extensions", ext, true);
            return;
        }
    }

    @Override
    public void reloadMetadata() {
        this.reloadMetadata(false, this.reloadMetadata$default$2());
    }

    public void reloadMetadata(boolean isFirstLoad, boolean useBundled) {
        LibraryManager$.MODULE$.org$nlogo$api$LibraryManager$$$reloadMetadata(isFirstLoad, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.updateLists(new File(this.allLibsPath()), isFirstLoad, useBundled));
    }

    public boolean reloadMetadata$default$1() {
        return false;
    }

    public boolean reloadMetadata$default$2() {
        return true;
    }

    public void onLibInfoChange(Function1<Seq<LibraryInfo>, BoxedUnit> callback) {
        this.infoChangeCallbacks = (Seq)this.infoChangeCallbacks.$colon$plus(callback);
    }

    public Future<BoxedUnit> updateMetadata() {
        return LibraryManager$.org$nlogo$api$LibraryManager$$$metadataURLFuture.map(metadataURL -> LibraryInfoDownloader$.MODULE$.apply((URL)metadataURL).flatMap((Function1 & Serializable)_$2 -> (Future)_$2.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                if (BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)tuple2._2())) {
                    return Option$.MODULE$.apply(this.updateLists(file, this.updateLists$default$2(), this.updateLists$default$3()));
                }
            }
            return None$.MODULE$;
        }).getOrElse(LibraryManager::updateMetadata$$anonfun$1$$anonfun$1$$anonfun$2), ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> updateLists(File configFile, boolean isFirstLoad, boolean useBundled) {
        Future future;
        try {
            Config config = ConfigFactory.parseFile((File)configFile);
            Config installedLibsConf = useBundled ? ConfigFactory.parseFile((File)new File(this.userInstalledsPath)).withFallback((ConfigMergeable)LibraryManager$.org$nlogo$api$LibraryManager$$$bundledsConfig) : ConfigFactory.parseFile((File)new File(this.userInstalledsPath));
            future = Future$.MODULE$.apply((Function0 & Serializable)() -> {
                this.updateLists$$anonfun$1(config, installedLibsConf, useBundled);
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global());
        }
        catch (ConfigException ex) {
            if (isFirstLoad) {
                future = LibraryManager$.org$nlogo$api$LibraryManager$$$metadataURLFuture.map(url -> LibraryInfoDownloader$.MODULE$.invalidateCache((URL)url), ExecutionContext.Implicits$.MODULE$.global());
            }
            throw new MetadataLoadingException(ex);
        }
        return future;
    }

    public boolean updateLists$default$2() {
        return false;
    }

    public boolean updateLists$default$3() {
        return true;
    }

    private Future<BoxedUnit> updateList(Config config, Config installedLibsConf, String category, boolean useBundled) {
        return LibraryManager$.org$nlogo$api$LibraryManager$$$branchURLFuture.map(branchURL -> {
            this.libraries = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(config.getConfigList(category)).asScala().map((Function1 & Serializable)c -> {
                String name = c.getString("name");
                String codeName = c.getString("codeName");
                String shortDesc = c.getString("shortDescription");
                String longDesc = c.getString("longDescription");
                String version = c.getString("version");
                URL homepage = new URL(c.getString("homepage"));
                String installedVersionPath = category + ".\"" + codeName + "\".installedVersion";
                Option installedVersion = LibraryManager.getStringOption$1(installedLibsConf, installedVersionPath, LibraryManager.getStringOption$default$3$1());
                boolean bundled = useBundled && LibraryManager$.org$nlogo$api$LibraryManager$$$bundledsConfig.hasPath(installedVersionPath) && installedVersion.isEmpty();
                Option minNetLogoVersion = LibraryManager.getStringOption$1(c, "minNetLogoVersion", LibraryManager.getStringOption$default$3$1());
                return LibraryInfo$.MODULE$.apply(name, codeName, shortDesc, longDesc, version, homepage, bundled, (Option<String>)installedVersion, (Option<String>)minNetLogoVersion, (URL)branchURL);
            })).toSeq();
            this.infoChangeCallbacks.foreach(_$3 -> _$3.apply(this.libraries));
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<BoxedUnit> updateInstalledVersion(String category, LibraryInfo lib, boolean uninstall) {
        Future<BoxedUnit> future;
        LibraryManager libraryManager = this;
        synchronized (libraryManager) {
            Config userInstalleds = ConfigFactory.parseFile((File)new File(this.userInstalledsPath));
            Config updatedInstalleds = uninstall ? userInstalleds.withoutPath(category + ".\"" + lib.codeName() + "\"") : userInstalleds.withValue(category + ".\"" + lib.codeName() + "\".installedVersion", ConfigValueFactory.fromAnyRef((Object)lib.version()));
            ConfigRenderOptions renderOpts = ConfigRenderOptions.defaults().setOriginComments(false);
            String newInstalleds = updatedInstalleds.root().render(renderOpts);
            FileIO$.MODULE$.writeFile(this.userInstalledsPath, newInstalleds, false);
            future = this.updateLists(new File(this.allLibsPath()), false, this.updateLists$default$3());
        }
        return future;
    }

    private boolean updateInstalledVersion$default$3() {
        return false;
    }

    private static final Future updateMetadata$$anonfun$1$$anonfun$1$$anonfun$2() {
        return Future$.MODULE$.unit();
    }

    private final void updateLists$$anonfun$1(Config config$1, Config installedLibsConf$1, boolean useBundled$2) {
        this.updateList(config$1, installedLibsConf$1, "extensions", useBundled$2);
    }

    private static final Option getStringOption$1(Config c, String path, Option option) {
        if (c.hasPath(path)) {
            return Option$.MODULE$.apply((Object)c.getString(path));
        }
        return option;
    }

    private static final Option getStringOption$default$3$1() {
        return None$.MODULE$;
    }
}

