/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import org.nlogo.api.AbstractModelLoader;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.ModelType;
import org.nlogo.api.ModelType$New$;
import org.nlogo.api.Version$;
import org.nlogo.app.App$;
import org.nlogo.app.DirtyMonitor$TempFileModelTracker$;
import org.nlogo.app.ModelConfig$;
import org.nlogo.app.ModelSaver;
import org.nlogo.window.Events;
import org.nlogo.workspace.ModelTracker;
import org.nlogo.workspace.SaveModel;
import org.nlogo.workspace.SaveModel$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Try;

public class DirtyMonitor
implements Events.BeforeLoadEvent.Handler,
Events.AfterLoadEvent.Handler,
Events.WidgetAddedEvent.Handler,
Events.WidgetRemovedEvent.Handler,
Events.DirtyEvent.Handler,
Events.ModelSavedEvent.Handler,
Events.ExternalFileSavedEvent.Handler,
SaveModel.Controller {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DirtyMonitor.class.getDeclaredField("TempFileModelTracker$lzy1"));
    private final JFrame frame;
    private final ModelSaver modelSaver;
    private final AbstractModelLoader modelLoader;
    public final ModelTracker org$nlogo$app$DirtyMonitor$$modelTracker;
    private boolean loading;
    private boolean _modelDirty;
    private Option<File> lastAutoSaveFile;
    private Timer dirtyTimer;
    private volatile Object TempFileModelTracker$lzy1;

    public DirtyMonitor(JFrame frame, ModelSaver modelSaver, AbstractModelLoader modelLoader, ModelTracker modelTracker, Function1<Option<String>, String> title, JFrame codeWindow) {
        this.frame = frame;
        this.modelSaver = modelSaver;
        this.modelLoader = modelLoader;
        this.org$nlogo$app$DirtyMonitor$$modelTracker = modelTracker;
        this.loading = true;
        this._modelDirty = false;
        this.lastAutoSaveFile = None$.MODULE$;
        this.dirtyTimer = new Timer();
    }

    public void discardNewAutoSaves() {
        Option$.MODULE$.apply((Object)this.org$nlogo$app$DirtyMonitor$$modelTracker.getModelPath()).foreach(modelPath -> ModelConfig$.MODULE$.discardNewAutoSaves((String)modelPath));
    }

    public boolean modelDirty() {
        return this._modelDirty && !this.loading;
    }

    private void setDirty(boolean dirty, Option<String> path) {
        if (dirty && !this.loading) {
            this.dirtyTimer.cancel();
            this.dirtyTimer.purge();
            this.dirtyTimer = new Timer();
            this.dirtyTimer.schedule(new TimerTask(this){
                private final /* synthetic */ DirtyMonitor $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    this.$outer.org$nlogo$app$DirtyMonitor$$doAutoSave();
                }
            }, 5000L);
        }
        if (!path.isDefined() && dirty != this._modelDirty && !this.loading) {
            this._modelDirty = dirty;
            if (System.getProperty("os.name").startsWith("Mac")) {
                this.frame.getRootPane().putClientProperty("Window.documentModified", BoxesRunTime.boxToBoolean((boolean)dirty));
            }
        }
        App$.MODULE$.app().setWindowTitles();
    }

    private Option<String> setDirty$default$2() {
        return None$.MODULE$;
    }

    public void org$nlogo$app$DirtyMonitor$$doAutoSave() {
        if (this.modelDirty()) {
            try {
                SaveModel$.MODULE$.apply(this.modelSaver.currentModel(), this.modelLoader, this, this.TempFileModelTracker(), Version$.MODULE$).foreach(f -> ((Try)f.apply()).foreach(savedUri -> {
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        Files.setAttribute(Paths.get(savedUri), "dos:hidden", BoxesRunTime.boxToBoolean((boolean)true), new LinkOption[0]);
                    }
                    ModelType modelType = this.org$nlogo$app$DirtyMonitor$$modelTracker.getModelType();
                    ModelType$New$ modelType$New$ = ModelType$New$.MODULE$;
                    if (!(modelType != null ? !modelType.equals(modelType$New$) : modelType$New$ != null)) {
                        try {
                            this.lastAutoSaveFile.foreach((Function1 & Serializable)_$1 -> _$1.delete());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.lastAutoSaveFile = Option$.MODULE$.apply((Object)new File(savedUri.getPath()));
                }));
            }
            catch (IOException ex) {
                Exceptions$.MODULE$.ignore(ex);
            }
            return;
        }
    }

    @Override
    public void handle(Events.ModelSavedEvent e) {
        this.setDirty(false, this.setDirty$default$2());
    }

    @Override
    public void handle(Events.ExternalFileSavedEvent e) {
        this.setDirty(false, (Option<String>)Some$.MODULE$.apply((Object)e.path));
    }

    @Override
    public void handle(Events.BeforeLoadEvent e) {
        this.setDirty(false, this.setDirty$default$2());
        this.loading = true;
    }

    @Override
    public void handle(Events.AfterLoadEvent e) {
        this.setDirty(false, this.setDirty$default$2());
        this.loading = false;
    }

    @Override
    public void handle(Events.DirtyEvent e) {
        this.setDirty(true, e.path);
    }

    @Override
    public void handle(Events.WidgetAddedEvent e) {
        this.setDirty(true, this.setDirty$default$2());
    }

    @Override
    public void handle(Events.WidgetRemovedEvent e) {
        this.setDirty(true, this.setDirty$default$2());
    }

    public final DirtyMonitor$TempFileModelTracker$ TempFileModelTracker() {
        Object object = this.TempFileModelTracker$lzy1;
        if (object instanceof DirtyMonitor$TempFileModelTracker$) {
            return (DirtyMonitor$TempFileModelTracker$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DirtyMonitor$TempFileModelTracker$)this.TempFileModelTracker$lzyINIT1();
    }

    private Object TempFileModelTracker$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.TempFileModelTracker$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    DirtyMonitor$TempFileModelTracker$ dirtyMonitor$TempFileModelTracker$ = null;
                    try {
                        dirtyMonitor$TempFileModelTracker$ = new DirtyMonitor$TempFileModelTracker$(this);
                        serializable = dirtyMonitor$TempFileModelTracker$ == null ? LazyVals.NullValue$.MODULE$ : dirtyMonitor$TempFileModelTracker$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.TempFileModelTracker$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return dirtyMonitor$TempFileModelTracker$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Option<URI> chooseFilePath(ModelType modelType) {
        return this.TempFileModelTracker().getModelFileUri();
    }

    @Override
    public boolean shouldSaveModelOfDifferingVersion(String version) {
        return true;
    }

    @Override
    public void warnInvalidFileFormat(String format) {
    }
}

