/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.util.Try$;

public class FileWatcherThread
extends Thread {
    private final List<Path> paths;
    private final Function0<Object> callback;
    private final WatchService watchService;
    private final Map<WatchKey, Path> keyPathMap;

    public FileWatcherThread(List<Path> paths, Function0<Object> callback) {
        this.paths = paths;
        this.callback = callback;
        this.watchService = FileSystems.getDefault().newWatchService();
        Set parentSet = paths.map((Function1 & Serializable)_$1 -> _$1.getParent()).toSet();
        this.keyPathMap = ((IterableOnceOps)((IterableOps)parentSet.map((Function1 & Serializable)x -> Try$.MODULE$.apply(() -> this.$init$$$anonfun$2$$anonfun$1(x)).toOption())).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Tuple2<WatchKey, Path> f(Path x) {
        WatchKey watchKey = (WatchKey)Predef$.MODULE$.ArrowAssoc((Object)x.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)watchKey, (Object)x);
    }

    @Override
    public void run() {
        try {
            boolean done = false;
            while (!done && !this.isInterrupted()) {
                WatchKey key = this.watchService.take();
                Iterator events = CollectionConverters$.MODULE$.ListHasAsScala(key.pollEvents()).asScala().iterator();
                Option maybeDirPath = this.keyPathMap.get((Object)key);
                while (!done && maybeDirPath.isDefined() && events.hasNext()) {
                    Path eventPath = (Path)((WatchEvent)events.next()).context();
                    Path fullEventPath = ((Path)maybeDirPath.get()).resolve(eventPath);
                    if (!this.paths.contains((Object)fullEventPath)) continue;
                    done = this.callback.apply$mcZ$sp();
                }
                key.reset();
            }
        }
        catch (InterruptedException e) {
        }
    }

    private final Tuple2 $init$$$anonfun$2$$anonfun$1(Path x$1) {
        return this.f(x$1);
    }
}

