/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.nlogo.api.Exceptions$;
import org.nlogo.app.FileManager;
import org.nlogo.app.ModelEntry;
import org.nlogo.app.OpenRecentFileAction$;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.I18N$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.swing.UserAction;
import org.nlogo.swing.UserAction$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class OpenRecentFileAction
extends AbstractAction
implements UserAction.MenuAction {
    private final Frame parent;
    private final ModelEntry modelEntry;
    private final FileManager fileManager;

    public static String FilesGroup() {
        return OpenRecentFileAction$.MODULE$.FilesGroup();
    }

    public static String trimForDisplay(String string) {
        return OpenRecentFileAction$.MODULE$.trimForDisplay(string);
    }

    public OpenRecentFileAction(Frame parent, ModelEntry modelEntry, FileManager fileManager, int index) {
        this.parent = parent;
        this.modelEntry = modelEntry;
        this.fileManager = fileManager;
        super(OpenRecentFileAction$.MODULE$.trimForDisplay(modelEntry.path()));
        this.category_$eq(UserAction$.MODULE$.FileCategory());
        this.subcategory_$eq(UserAction$.MODULE$.FileRecentSubcategory());
        this.group_$eq(OpenRecentFileAction$.MODULE$.FilesGroup());
        this.rank_$eq(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.open(this.modelEntry);
    }

    public void open(ModelEntry modelEntry) {
        try {
            this.fileManager.aboutToCloseFiles();
            this.fileManager.openFromPath(modelEntry.path(), modelEntry.modelType(), this.fileManager.openFromPath$default$3());
        }
        catch (UserCancelException ex) {
            Exceptions$.MODULE$.ignore(ex);
        }
        catch (FileNotFoundException ex) {
            new OptionPane(this.parent, I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().getN("file.open.error.doesNotExist", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{modelEntry.path()})), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
        }
        catch (IOException ex) {
            new OptionPane(this.parent, I18N$.MODULE$.gui().get("common.messages.error"), ex.getMessage(), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
        }
    }
}

