/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compile;

import java.io.Serializable;
import org.nlogo.compile.api.CommandBlock;
import org.nlogo.compile.api.Expression;
import org.nlogo.compile.api.ProcedureDefinition;
import org.nlogo.compile.api.ReporterApp;
import org.nlogo.compile.api.Statement;
import org.nlogo.compile.api.Statements;
import org.nlogo.core.CompilerException;
import org.nlogo.core.SourceLocation$;
import org.nlogo.core.Token;
import org.nlogo.core.TokenType$Keyword$;
import org.nlogo.core.TypeNames$;
import org.nlogo.nvm.AssemblerAssistant;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.CustomAssembled;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Reporter;
import org.nlogo.prim._call;
import org.nlogo.prim._done;
import org.nlogo.prim._fastrecurse;
import org.nlogo.prim._goto;
import org.nlogo.prim._return;
import org.nlogo.prim._returnreport;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public class Assembler {
    public final ArrayBuffer<Command> org$nlogo$compile$Assembler$$code = new ArrayBuffer();

    public void assemble(ProcedureDefinition procdef) {
        Procedure proc = procdef.procedure();
        this.assembleStatements(procdef.statements());
        _returnreport ret = proc.isReporter() ? new _returnreport() : (proc.isLambda() ? new _done() : new _return());
        ret.token_$eq(new Token("END", TokenType$Keyword$.MODULE$, ret, SourceLocation$.MODULE$.apply(proc.end(), proc.end(), proc.filename())));
        this.org$nlogo$compile$Assembler$$code.$plus$eq((Object)ret);
        ((List)this.org$nlogo$compile$Assembler$$code.toList().zipWithIndex()).foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Command cmd = (Command)tuple2._1();
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                cmd.next = n + 1;
                cmd.offset += n;
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        proc.code_$eq((Command[])((IterableOnceOps)this.org$nlogo$compile$Assembler$$code.map((Function1 & Serializable)cmd -> Assembler.tailRecurse$1(proc, cmd))).toArray(ClassTag$.MODULE$.apply(Command.class)));
    }

    public ArrayBuffer<Command> assembleStatements(Statements stmts) {
        stmts.body().foreach((Function1 & Serializable)stmt -> {
            Command command = stmt.command();
            if (command instanceof CustomAssembled) {
                Command ca = (Command)((Object)((CustomAssembled)((Object)command)));
                ((CustomAssembled)((Object)ca)).assemble(new Assistant(this, (Statement)stmt));
                return BoxedUnit.UNIT;
            }
            return this.org$nlogo$compile$Assembler$$code.$plus$eq((Object)stmt.command());
        });
        return this.org$nlogo$compile$Assembler$$code;
    }

    private static final boolean isTailRecursive$1(Procedure proc$1, _call call) {
        String string = call.procedure.name();
        String string2 = proc$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null) && proc$1.args().isEmpty();
    }

    private static final Command tailRecurse$1(Procedure proc$2, Command cmd) {
        _call call;
        Command command = cmd;
        if (command instanceof _call && Assembler.isTailRecursive$1(proc$2, call = (_call)command)) {
            return new _fastrecurse(call);
        }
        return cmd;
    }

    public static final Buffer org$nlogo$compile$Assembler$Assistant$$_$goTo$$anonfun$1() {
        return (Buffer)Buffer$.MODULE$.empty();
    }

    public static final /* synthetic */ void org$nlogo$compile$Assembler$Assistant$$_$goTo$$anonfun$2(_goto gt$1, int pos$1, int l) {
        gt$1.offset = l - pos$1;
    }

    public class Assistant
    implements AssemblerAssistant {
        private final Statement stmt;
        private int branchMark;
        private final Map<Object, Buffer<Tuple2<Object, _goto>>> goTos;
        private final Map<Object, Object> labels;
        private final /* synthetic */ Assembler $outer;

        public Assistant(Assembler $outer, Statement stmt) {
            this.stmt = stmt;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.branchMark = -1;
            this.goTos = (Map)Map$.MODULE$.empty();
            this.labels = (Map)Map$.MODULE$.empty();
        }

        @Override
        public void add(Command cmd) {
            if (cmd == this.stmt.command()) {
                if (this.branchMark == -1) {
                    this.branchMark = this.$outer.org$nlogo$compile$Assembler$$code.size();
                } else {
                    this.stmt.command().offset = this.branchMark - this.$outer.org$nlogo$compile$Assembler$$code.size();
                }
            }
            this.$outer.org$nlogo$compile$Assembler$$code.$plus$eq((Object)cmd);
        }

        @Override
        public void goTo(int label) {
            int pos = this.$outer.org$nlogo$compile$Assembler$$code.size();
            _goto gt = new _goto();
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pos));
            ((Buffer)this.goTos.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)label), Assembler::org$nlogo$compile$Assembler$Assistant$$_$goTo$$anonfun$1)).append((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)gt));
            this.labels.get((Object)BoxesRunTime.boxToInteger((int)label)).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> Assembler.org$nlogo$compile$Assembler$Assistant$$_$goTo$$anonfun$2(gt, pos, arg_0)));
            this.add(gt);
        }

        public int goTo$default$1() {
            return 0;
        }

        @Override
        public void comeFrom(int label) {
            this.labels.update((Object)BoxesRunTime.boxToInteger((int)label), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$nlogo$compile$Assembler$$code.size()));
            this.goTos.get((Object)BoxesRunTime.boxToInteger((int)label)).foreach(_$1 -> _$1.foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    int pos = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    _goto gt = (_goto)tuple2._2();
                    gt.offset = this.$outer.org$nlogo$compile$Assembler$$code.size() - pos;
                    return;
                }
                throw new MatchError((Object)tuple2);
            }));
        }

        public int comeFrom$default$1() {
            return 0;
        }

        @Override
        public void block() {
            this.block(this.stmt.args().size() - 1);
        }

        @Override
        public void block(int pos) {
            Expression expression = (Expression)this.stmt.args().apply(pos);
            if (expression instanceof CommandBlock) {
                CommandBlock block = (CommandBlock)expression;
                this.$outer.assembleStatements(block.statements());
                return;
            }
            Expression arg = expression;
            throw new CompilerException(this.stmt.command().displayName() + " expected a command block here but got " + TypeNames$.MODULE$.aName(arg.reportedType()) + ".", arg.start(), arg.end(), arg.filename());
        }

        @Override
        public int argCount() {
            return this.stmt.args().size();
        }

        @Override
        public Reporter arg(int i) {
            Expression expression = (Expression)this.stmt.args().apply(i);
            if (expression instanceof ReporterApp) {
                ReporterApp rep = (ReporterApp)expression;
                return rep.reporter();
            }
            Expression arg = expression;
            throw new CompilerException(this.stmt.command().displayName() + " expected a reporter here but got a block.", arg.start(), arg.end(), arg.filename());
        }

        @Override
        public void removeArg(int i) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.stmt.command().args);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(object, i));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])this.stmt.command().args);
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(object2, ArrayOps$.MODULE$.drop$extension(object3, i + 1), ClassTag$.MODULE$.apply(Reporter.class)));
            this.stmt.command().args = (Reporter[])ArrayOps$.MODULE$.toArray$extension(object4, ClassTag$.MODULE$.apply(Reporter.class));
        }

        @Override
        public void resume() {
            if (this.branchMark == -1) {
                this.branchMark = this.$outer.org$nlogo$compile$Assembler$$code.size();
                return;
            }
            this.stmt.command().offset = this.offset();
        }

        @Override
        public int offset() {
            if (this.branchMark == -1) {
                throw new IllegalStateException();
            }
            return this.$outer.org$nlogo$compile$Assembler$$code.size() - this.branchMark;
        }

        @Override
        public void done() {
            this.$outer.org$nlogo$compile$Assembler$$code.$plus$eq((Object)new _done());
        }

        @Override
        public int next() {
            return this.$outer.org$nlogo$compile$Assembler$$code.size();
        }

        public final /* synthetic */ Assembler org$nlogo$compile$Assembler$Assistant$$$outer() {
            return this.$outer;
        }
    }
}

