/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compile;

import java.io.Serializable;
import org.nlogo.api.LogoException;
import org.nlogo.compile.ArgumentStuffer;
import org.nlogo.compile.api.DefaultAstVisitor;
import org.nlogo.compile.api.Expression;
import org.nlogo.compile.api.ReporterApp;
import org.nlogo.core.CompilerException$;
import org.nlogo.core.Fail$;
import org.nlogo.core.LogoList;
import org.nlogo.core.Nobody$;
import org.nlogo.core.Pure;
import org.nlogo.nvm.Reporter;
import org.nlogo.prim._constboolean;
import org.nlogo.prim._constdouble;
import org.nlogo.prim._constlist;
import org.nlogo.prim._conststring;
import org.nlogo.prim._nobody;
import scala.Function1;

public class ConstantFolder
extends DefaultAstVisitor {
    public Reporter makeConstantReporter(Object value) {
        Reporter reporter;
        Object object = value;
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            reporter = new _constboolean(b);
        } else if (object instanceof Double) {
            Double d = (Double)object;
            reporter = new _constdouble(d);
        } else if (object instanceof LogoList) {
            LogoList l = (LogoList)object;
            reporter = new _constlist(l);
        } else if (object instanceof String) {
            String s = (String)object;
            reporter = new _conststring(s);
        } else if (Nobody$.MODULE$.equals(object)) {
            reporter = new _nobody();
        } else {
            throw new IllegalArgumentException(value.getClass().getName());
        }
        return reporter;
    }

    @Override
    public void visitReporterApp(ReporterApp app) {
        super.visitReporterApp(app);
        if (app.reporter() instanceof Pure && !app.args().isEmpty() && app.args().forall((Function1 & Serializable)e -> this.isConstant((Expression)e))) {
            Reporter newReporter = this.makeConstantReporter(this.applyReporter(app));
            newReporter.copyMetadataFrom(app.reporter());
            app.reporter_$eq(newReporter);
            app.clearArgs();
            return;
        }
    }

    private boolean isConstant(Expression e) {
        Expression expression = e;
        if (expression instanceof ReporterApp) {
            ReporterApp app = (ReporterApp)expression;
            return app.reporter() instanceof Pure && app.args().isEmpty();
        }
        return false;
    }

    private Object applyReporter(ReporterApp app) {
        Object object;
        Reporter r = app.reporter();
        app.accept(new ArgumentStuffer());
        r.init(null);
        try {
            object = r.report(null);
        }
        catch (LogoException ex) {
            throw Fail$.MODULE$.exception(CompilerException$.MODULE$.RuntimeErrorAtCompileTimePrefix() + ex.getMessage(), app);
        }
        return object;
    }
}

