/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Font;
import java.awt.event.TextListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.nlogo.api.CompilerServices;
import org.nlogo.editor.AbstractEditorArea;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.DocumentProperties$;
import org.nlogo.editor.DumbIndenter;
import org.nlogo.editor.EditorArea;
import org.nlogo.editor.EditorConfiguration$;
import org.nlogo.editor.EditorListener;
import org.nlogo.editor.EditorMenu;
import org.nlogo.editor.FocusTraversalListener;
import org.nlogo.editor.HighlightEditorKit;
import org.nlogo.editor.InstallableAction;
import org.nlogo.editor.KeyBinding$;
import org.nlogo.editor.LinePainter;
import org.nlogo.editor.TransferFocusAction;
import org.nlogo.editor.TransferFocusBackwardAction;
import org.nlogo.swing.TextActions;
import org.nlogo.swing.TextActions$;
import org.nlogo.swing.UserAction;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EditorConfiguration
implements Product,
Serializable {
    private final int rows;
    private final int columns;
    private final Font font;
    private final TextListener listener;
    private final CompilerServices compiler;
    private final Colorizer colorizer;
    private final Map<KeyStroke, TextAction> additionalActions;
    private final Seq<UserAction.MenuAction> contextActions;
    private final Seq<UserAction.MenuAction> menuActions;
    private final boolean enableFocusTraversal;
    private final boolean highlightCurrentLine;
    private final boolean showLineNumbers;
    private final boolean is3Dlanguage;
    private final EditorMenu menu;
    private final Function0<Option<JScrollPane>> scrollPaneGetter;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(EditorConfiguration$.class.getDeclaredField("platformMonospacedFont$lzy1"));

    public static EditorConfiguration apply(int n, int n2, Font font, TextListener textListener, CompilerServices compilerServices, Colorizer colorizer, Map<KeyStroke, TextAction> map, Seq<UserAction.MenuAction> seq, Seq<UserAction.MenuAction> seq2, boolean bl, boolean bl2, boolean bl3, boolean bl4, EditorMenu editorMenu, Function0<Option<JScrollPane>> function0) {
        return EditorConfiguration$.MODULE$.apply(n, n2, font, textListener, compilerServices, colorizer, map, seq, seq2, bl, bl2, bl3, bl4, editorMenu, function0);
    }

    public static EditorConfiguration default(int n, int n2, CompilerServices compilerServices, Colorizer colorizer) {
        return EditorConfiguration$.MODULE$.default(n, n2, compilerServices, colorizer);
    }

    public static Seq<UserAction.MenuAction> defaultContextActions(Colorizer colorizer) {
        return EditorConfiguration$.MODULE$.defaultContextActions(colorizer);
    }

    public static Font defaultFont() {
        return EditorConfiguration$.MODULE$.defaultFont();
    }

    public static EditorConfiguration fromProduct(Product product) {
        return EditorConfiguration$.MODULE$.fromProduct(product);
    }

    public static String platformMonospacedFont() {
        return EditorConfiguration$.MODULE$.platformMonospacedFont();
    }

    public static EditorConfiguration unapply(EditorConfiguration editorConfiguration) {
        return EditorConfiguration$.MODULE$.unapply(editorConfiguration);
    }

    public EditorConfiguration(int rows, int columns, Font font, TextListener listener, CompilerServices compiler, Colorizer colorizer, Map<KeyStroke, TextAction> additionalActions, Seq<UserAction.MenuAction> contextActions, Seq<UserAction.MenuAction> menuActions, boolean enableFocusTraversal, boolean highlightCurrentLine, boolean showLineNumbers, boolean is3Dlanguage, EditorMenu menu, Function0<Option<JScrollPane>> scrollPaneGetter) {
        this.rows = rows;
        this.columns = columns;
        this.font = font;
        this.listener = listener;
        this.compiler = compiler;
        this.colorizer = colorizer;
        this.additionalActions = additionalActions;
        this.contextActions = contextActions;
        this.menuActions = menuActions;
        this.enableFocusTraversal = enableFocusTraversal;
        this.highlightCurrentLine = highlightCurrentLine;
        this.showLineNumbers = showLineNumbers;
        this.is3Dlanguage = is3Dlanguage;
        this.menu = menu;
        this.scrollPaneGetter = scrollPaneGetter;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.rows());
        n = Statics.mix((int)n, (int)this.columns());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.font()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.listener()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.compiler()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.colorizer()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.additionalActions()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.contextActions()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.menuActions()));
        n = Statics.mix((int)n, (int)(this.enableFocusTraversal() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.highlightCurrentLine() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.showLineNumbers() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.is3Dlanguage() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.menu()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.scrollPaneGetter()));
        return Statics.finalizeHash((int)n, (int)15);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof EditorConfiguration)) return false;
        EditorConfiguration editorConfiguration = (EditorConfiguration)object;
        if (this.rows() != editorConfiguration.rows()) return false;
        if (this.columns() != editorConfiguration.columns()) return false;
        if (this.enableFocusTraversal() != editorConfiguration.enableFocusTraversal()) return false;
        if (this.highlightCurrentLine() != editorConfiguration.highlightCurrentLine()) return false;
        if (this.showLineNumbers() != editorConfiguration.showLineNumbers()) return false;
        if (this.is3Dlanguage() != editorConfiguration.is3Dlanguage()) return false;
        Font font = this.font();
        Font font2 = editorConfiguration.font();
        if (font == null) {
            if (font2 != null) {
                return false;
            }
        } else if (!((Object)font).equals(font2)) return false;
        TextListener textListener = this.listener();
        TextListener textListener2 = editorConfiguration.listener();
        if (textListener == null) {
            if (textListener2 != null) {
                return false;
            }
        } else if (!textListener.equals(textListener2)) return false;
        CompilerServices compilerServices = this.compiler();
        CompilerServices compilerServices2 = editorConfiguration.compiler();
        if (compilerServices == null) {
            if (compilerServices2 != null) {
                return false;
            }
        } else if (!compilerServices.equals(compilerServices2)) return false;
        Colorizer colorizer = this.colorizer();
        Colorizer colorizer2 = editorConfiguration.colorizer();
        if (colorizer == null) {
            if (colorizer2 != null) {
                return false;
            }
        } else if (!colorizer.equals(colorizer2)) return false;
        Map<KeyStroke, TextAction> map = this.additionalActions();
        Map<KeyStroke, TextAction> map2 = editorConfiguration.additionalActions();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Seq<UserAction.MenuAction> seq = this.contextActions();
        Seq<UserAction.MenuAction> seq2 = editorConfiguration.contextActions();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<UserAction.MenuAction> seq3 = this.menuActions();
        Seq<UserAction.MenuAction> seq4 = editorConfiguration.menuActions();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        EditorMenu editorMenu = this.menu();
        EditorMenu editorMenu2 = editorConfiguration.menu();
        if (editorMenu == null) {
            if (editorMenu2 != null) {
                return false;
            }
        } else if (!editorMenu.equals(editorMenu2)) return false;
        Function0<Option<JScrollPane>> function0 = this.scrollPaneGetter();
        Function0<Option<JScrollPane>> function02 = editorConfiguration.scrollPaneGetter();
        if (function0 == null) {
            if (function02 != null) {
                return false;
            }
        } else if (!function0.equals(function02)) return false;
        if (!editorConfiguration.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof EditorConfiguration;
    }

    public int productArity() {
        return 15;
    }

    public String productPrefix() {
        return "EditorConfiguration";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
            case 9: {
                return BoxesRunTime.boxToBoolean((boolean)this._10());
            }
            case 10: {
                return BoxesRunTime.boxToBoolean((boolean)this._11());
            }
            case 11: {
                return BoxesRunTime.boxToBoolean((boolean)this._12());
            }
            case 12: {
                return BoxesRunTime.boxToBoolean((boolean)this._13());
            }
            case 13: {
                return this._14();
            }
            case 14: {
                return this._15();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "rows";
            }
            case 1: {
                return "columns";
            }
            case 2: {
                return "font";
            }
            case 3: {
                return "listener";
            }
            case 4: {
                return "compiler";
            }
            case 5: {
                return "colorizer";
            }
            case 6: {
                return "additionalActions";
            }
            case 7: {
                return "contextActions";
            }
            case 8: {
                return "menuActions";
            }
            case 9: {
                return "enableFocusTraversal";
            }
            case 10: {
                return "highlightCurrentLine";
            }
            case 11: {
                return "showLineNumbers";
            }
            case 12: {
                return "is3Dlanguage";
            }
            case 13: {
                return "menu";
            }
            case 14: {
                return "scrollPaneGetter";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public Font font() {
        return this.font;
    }

    public TextListener listener() {
        return this.listener;
    }

    public CompilerServices compiler() {
        return this.compiler;
    }

    public Colorizer colorizer() {
        return this.colorizer;
    }

    public Map<KeyStroke, TextAction> additionalActions() {
        return this.additionalActions;
    }

    public Seq<UserAction.MenuAction> contextActions() {
        return this.contextActions;
    }

    public Seq<UserAction.MenuAction> menuActions() {
        return this.menuActions;
    }

    public boolean enableFocusTraversal() {
        return this.enableFocusTraversal;
    }

    public boolean highlightCurrentLine() {
        return this.highlightCurrentLine;
    }

    public boolean showLineNumbers() {
        return this.showLineNumbers;
    }

    public boolean is3Dlanguage() {
        return this.is3Dlanguage;
    }

    public EditorMenu menu() {
        return this.menu;
    }

    public Function0<Option<JScrollPane>> scrollPaneGetter() {
        return this.scrollPaneGetter;
    }

    public EditorConfiguration withFont(Font font) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), font, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public EditorConfiguration withListener(TextListener listener) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), listener, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public EditorConfiguration withFocusTraversalEnabled(boolean isEnabled) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), isEnabled, this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public EditorConfiguration withCurrentLineHighlighted(boolean isHighlighted) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), isHighlighted, this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public EditorConfiguration withLineNumbers(boolean show) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), show, this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public EditorConfiguration withContextActions(Seq<UserAction.MenuAction> actions) {
        Seq seq = (Seq)this.contextActions().$plus$plus(actions);
        int n = this.copy$default$1();
        int n2 = this.copy$default$2();
        Font font = this.copy$default$3();
        TextListener textListener = this.copy$default$4();
        CompilerServices compilerServices = this.copy$default$5();
        Colorizer colorizer = this.copy$default$6();
        Map<KeyStroke, TextAction> map = this.copy$default$7();
        Seq<UserAction.MenuAction> seq2 = this.copy$default$9();
        boolean bl = this.copy$default$10();
        boolean bl2 = this.copy$default$11();
        boolean bl3 = this.copy$default$12();
        boolean bl4 = this.copy$default$13();
        EditorMenu editorMenu = this.copy$default$14();
        Function0<Option<JScrollPane>> function0 = this.copy$default$15();
        return this.copy(n, n2, font, textListener, compilerServices, colorizer, map, (Seq<UserAction.MenuAction>)seq, seq2, bl, bl2, bl3, bl4, editorMenu, function0);
    }

    public EditorConfiguration withMenuActions(Seq<UserAction.MenuAction> actions) {
        Seq seq = (Seq)this.menuActions().$plus$plus(actions);
        int n = this.copy$default$1();
        int n2 = this.copy$default$2();
        Font font = this.copy$default$3();
        TextListener textListener = this.copy$default$4();
        CompilerServices compilerServices = this.copy$default$5();
        Colorizer colorizer = this.copy$default$6();
        Map<KeyStroke, TextAction> map = this.copy$default$7();
        Seq<UserAction.MenuAction> seq2 = this.copy$default$8();
        boolean bl = this.copy$default$10();
        boolean bl2 = this.copy$default$11();
        boolean bl3 = this.copy$default$12();
        boolean bl4 = this.copy$default$13();
        EditorMenu editorMenu = this.copy$default$14();
        Function0<Option<JScrollPane>> function0 = this.copy$default$15();
        return this.copy(n, n2, font, textListener, compilerServices, colorizer, map, seq2, (Seq<UserAction.MenuAction>)seq, bl, bl2, bl3, bl4, editorMenu, function0);
    }

    public EditorConfiguration forThreeDLanguage(boolean is3D) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), is3D, this.copy$default$14(), this.copy$default$15());
    }

    public EditorConfiguration addKeymap(KeyStroke key, TextAction action) {
        KeyStroke keyStroke = (KeyStroke)Predef$.MODULE$.ArrowAssoc((Object)key);
        Map map = (Map)this.additionalActions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)keyStroke, (Object)action));
        int n = this.copy$default$1();
        int n2 = this.copy$default$2();
        Font font = this.copy$default$3();
        TextListener textListener = this.copy$default$4();
        CompilerServices compilerServices = this.copy$default$5();
        Colorizer colorizer = this.copy$default$6();
        Seq<UserAction.MenuAction> seq = this.copy$default$8();
        Seq<UserAction.MenuAction> seq2 = this.copy$default$9();
        boolean bl = this.copy$default$10();
        boolean bl2 = this.copy$default$11();
        boolean bl3 = this.copy$default$12();
        boolean bl4 = this.copy$default$13();
        EditorMenu editorMenu = this.copy$default$14();
        Function0<Option<JScrollPane>> function0 = this.copy$default$15();
        return this.copy(n, n2, font, textListener, compilerServices, colorizer, (Map<KeyStroke, TextAction>)map, seq, seq2, bl, bl2, bl3, bl4, editorMenu, function0);
    }

    public EditorConfiguration withKeymap(Map<KeyStroke, TextAction> keymap) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), keymap, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public EditorConfiguration withMenu(EditorMenu newMenu) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), newMenu, this.copy$default$15());
    }

    public EditorConfiguration withScrollPaneGetter(Function0<Option<JScrollPane>> getter) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), getter);
    }

    public void configureEditorArea(EditorArea editor) {
        editor.setEditorKit(new HighlightEditorKit(this.colorizer()));
        EditorListener editorListener = new EditorListener(e -> this.listener().textValueChanged(null));
        editorListener.install(editor);
        DocumentProperties$.MODULE$.install(editor);
        DumbIndenter indenter = new DumbIndenter(editor);
        editor.setIndenter(indenter);
        if (this.highlightCurrentLine()) {
            new LinePainter(editor);
        }
        editor.setFont(this.font());
        editor.setFocusTraversalKeysEnabled(this.enableFocusTraversal());
        FocusTraversalListener focusTraversalListener = new FocusTraversalListener(editor);
        editor.addFocusListener(focusTraversalListener);
        editor.addMouseListener(focusTraversalListener);
        if (this.enableFocusTraversal()) {
            editor.getInputMap().put(KeyBinding$.MODULE$.keystroke(9, KeyBinding$.MODULE$.keystroke$default$2()), new TransferFocusAction());
            editor.getInputMap().put(KeyBinding$.MODULE$.keystroke(9, 64), new TransferFocusBackwardAction());
        } else {
            editor.getInputMap().put(KeyBinding$.MODULE$.keystroke(9, 128), new TransferFocusAction());
            editor.getInputMap().put(KeyBinding$.MODULE$.keystroke(9, 192), new TransferFocusBackwardAction());
        }
        this.additionalActions().foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                KeyStroke k = (KeyStroke)tuple2._1();
                TextAction v = (TextAction)tuple2._2();
                editor.getInputMap().put(k, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        ((IterableOnceOps)this.contextActions().$plus$plus(this.menuActions())).foreach(x$1 -> {
            UserAction.MenuAction menuAction = x$1;
            if (menuAction instanceof InstallableAction) {
                InstallableAction e = (InstallableAction)((Object)menuAction);
                e.install(editor);
                return;
            }
        });
        TextActions$.MODULE$.applyToComponent(editor);
    }

    public void configureAdvancedEditorArea(AbstractEditorArea editor) {
        DocumentProperties$.MODULE$.install((JTextComponent)((Object)editor));
        EditorListener editorListener = new EditorListener(e -> this.listener().textValueChanged(null));
        editorListener.install((JTextComponent)((Object)editor));
        DumbIndenter indenter = new DumbIndenter((JTextComponent)((Object)editor));
        editor.setIndenter(indenter);
        ((JComponent)((Object)editor)).setFont(this.font());
        ((IterableOnceOps)this.contextActions().$plus$plus(this.menuActions())).foreach(x$1 -> {
            UserAction.MenuAction menuAction = x$1;
            if (menuAction instanceof InstallableAction) {
                InstallableAction e = (InstallableAction)((Object)menuAction);
                e.install(editor);
                return;
            }
        });
        this.additionalActions().foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                KeyStroke k = (KeyStroke)tuple2._1();
                TextAction v = (TextAction)tuple2._2();
                ((JComponent)((Object)editor)).getInputMap().put(k, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if (EditorConfiguration$.MODULE$.org$nlogo$editor$EditorConfiguration$$$os("Mac")) {
            Tuple2 tuple2 = (Tuple2)Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(8, 512));
            Tuple2 tuple22 = (Tuple2)Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(65, 128));
            Tuple2 tuple23 = (Tuple2)Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(69, 128));
            Tuple2 tuple24 = (Tuple2)Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(75, 128));
            ((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tuple2, (Object)"RTA.DeletePrevWordAction"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tuple22, (Object)"caret-begin-line"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tuple23, (Object)"caret-end-line"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tuple24, (Object)"RTA.DeleteRestOfLineAction"), (List)Nil$.MODULE$))))).foreach(x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    int key = tuple2._1$mcI$sp();
                    int mod = tuple2._2$mcI$sp();
                    String action = (String)tuple22._2();
                    ((JComponent)((Object)editor)).getInputMap().put(KeyStroke.getKeyStroke(key, mod), action);
                    return;
                }
                throw new MatchError((Object)tuple22);
            });
        }
        ((JComponent)((Object)editor)).getInputMap().put(KeyStroke.getKeyStroke(127, 128), new TextActions.CorrectDeleteNextWordAction((JTextComponent)((Object)editor)));
        EditorConfiguration.removeQuote$1(((JComponent)((Object)editor)).getInputMap());
    }

    public Seq<UserAction.MenuAction> permanentActions() {
        return (Seq)this.additionalActions().values().toSeq().$plus$plus(this.menuActions());
    }

    public Seq<Action> editorOnlyActions() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    public EditorConfiguration copy(int rows, int columns, Font font, TextListener listener, CompilerServices compiler, Colorizer colorizer, Map<KeyStroke, TextAction> additionalActions, Seq<UserAction.MenuAction> contextActions, Seq<UserAction.MenuAction> menuActions, boolean enableFocusTraversal, boolean highlightCurrentLine, boolean showLineNumbers, boolean is3Dlanguage, EditorMenu menu, Function0<Option<JScrollPane>> scrollPaneGetter) {
        return new EditorConfiguration(rows, columns, font, listener, compiler, colorizer, additionalActions, contextActions, menuActions, enableFocusTraversal, highlightCurrentLine, showLineNumbers, is3Dlanguage, menu, scrollPaneGetter);
    }

    public int copy$default$1() {
        return this.rows();
    }

    public int copy$default$2() {
        return this.columns();
    }

    public Font copy$default$3() {
        return this.font();
    }

    public TextListener copy$default$4() {
        return this.listener();
    }

    public CompilerServices copy$default$5() {
        return this.compiler();
    }

    public Colorizer copy$default$6() {
        return this.colorizer();
    }

    public Map<KeyStroke, TextAction> copy$default$7() {
        return this.additionalActions();
    }

    public Seq<UserAction.MenuAction> copy$default$8() {
        return this.contextActions();
    }

    public Seq<UserAction.MenuAction> copy$default$9() {
        return this.menuActions();
    }

    public boolean copy$default$10() {
        return this.enableFocusTraversal();
    }

    public boolean copy$default$11() {
        return this.highlightCurrentLine();
    }

    public boolean copy$default$12() {
        return this.showLineNumbers();
    }

    public boolean copy$default$13() {
        return this.is3Dlanguage();
    }

    public EditorMenu copy$default$14() {
        return this.menu();
    }

    public Function0<Option<JScrollPane>> copy$default$15() {
        return this.scrollPaneGetter();
    }

    public int _1() {
        return this.rows();
    }

    public int _2() {
        return this.columns();
    }

    public Font _3() {
        return this.font();
    }

    public TextListener _4() {
        return this.listener();
    }

    public CompilerServices _5() {
        return this.compiler();
    }

    public Colorizer _6() {
        return this.colorizer();
    }

    public Map<KeyStroke, TextAction> _7() {
        return this.additionalActions();
    }

    public Seq<UserAction.MenuAction> _8() {
        return this.contextActions();
    }

    public Seq<UserAction.MenuAction> _9() {
        return this.menuActions();
    }

    public boolean _10() {
        return this.enableFocusTraversal();
    }

    public boolean _11() {
        return this.highlightCurrentLine();
    }

    public boolean _12() {
        return this.showLineNumbers();
    }

    public boolean _13() {
        return this.is3Dlanguage();
    }

    public EditorMenu _14() {
        return this.menu();
    }

    public Function0<Option<JScrollPane>> _15() {
        return this.scrollPaneGetter();
    }

    private static final void removeQuote$1(InputMap map) {
        while (true) {
            Object object;
            if (map.keys() != null && ArrayOps$.MODULE$.exists$extension(object = Predef$.MODULE$.refArrayOps((Object[])map.keys()), (Function1 & Serializable)_$2 -> _$2.getKeyChar() == '\"')) {
                map.remove(KeyStroke.getKeyStroke('\"'));
                return;
            }
            if (map.getParent() == null) break;
            map = map.getParent();
        }
    }
}

