/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.fileformat;

import java.io.BufferedWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.nlogo.api.ComponentSerialization;
import org.nlogo.api.LabProtocol;
import org.nlogo.api.ModelFormat;
import org.nlogo.api.Version$;
import org.nlogo.api.VersionHistory$;
import org.nlogo.core.ExternalResource;
import org.nlogo.core.Model;
import org.nlogo.core.Model$;
import org.nlogo.core.OptionalSection;
import org.nlogo.core.Shape;
import org.nlogo.core.Widget;
import org.nlogo.core.XMLElement;
import org.nlogo.core.model.WidgetReader;
import org.nlogo.fileformat.AbstractNLogoFormat$CodeComponent$;
import org.nlogo.fileformat.AbstractNLogoFormat$InfoComponent$;
import org.nlogo.fileformat.AbstractNLogoFormat$InterfaceComponent$;
import org.nlogo.fileformat.AbstractNLogoFormat$LinkShapesComponent$;
import org.nlogo.fileformat.AbstractNLogoFormat$VectorShapesComponent$;
import org.nlogo.fileformat.AbstractNLogoFormat$VersionComponent$;
import org.nlogo.fileformat.InfoConverter$;
import org.nlogo.fileformat.LabLoader$;
import org.nlogo.fileformat.LabSaver$;
import org.nlogo.fileformat.NLogoFormatException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;

public interface AbstractNLogoFormat<A extends ModelFormat<String[], A>>
extends ModelFormat<String[], A> {
    public static void $init$(AbstractNLogoFormat $this) {
        $this.org$nlogo$fileformat$AbstractNLogoFormat$_setter_$Separator_$eq("@#$#@#$#@");
        $this.org$nlogo$fileformat$AbstractNLogoFormat$_setter_$SeparatorRegex_$eq("(?m)^@#\\$#@#\\$#@$");
    }

    public boolean is3DFormat();

    @Override
    public String name();

    public String Separator();

    public void org$nlogo$fileformat$AbstractNLogoFormat$_setter_$Separator_$eq(String var1);

    public String SeparatorRegex();

    public void org$nlogo$fileformat$AbstractNLogoFormat$_setter_$SeparatorRegex_$eq(String var1);

    public Map<String, WidgetReader> widgetReaders();

    public static Try sections$(AbstractNLogoFormat $this, URI location) {
        return $this.sections(location);
    }

    @Override
    default public Try<Map<String, String[]>> sections(URI location) {
        return Try$.MODULE$.apply(() -> AbstractNLogoFormat.sections$$anonfun$1(location)).flatMap((Function1 & Serializable)s -> {
            Try<Map<String, String[]>> sections = this.sectionsFromSource(s.mkString());
            s.close();
            return sections;
        });
    }

    public static Seq sectionNames$(AbstractNLogoFormat $this) {
        return $this.sectionNames();
    }

    default public Seq<String> sectionNames() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"code", "interface", "info", "turtleshapes", "version", "previewcommands", "systemdynamics", "behaviorspace", "hubnetclient", "linkshapes", "modelsettings", "deltatick"})).map((Function1 & Serializable)s -> "org.nlogo.modelsection." + s);
    }

    public static Try writeSections$(AbstractNLogoFormat $this, Map sections, URI location) {
        return $this.writeSections((Map<String, String[]>)sections, location);
    }

    @Override
    default public Try<URI> writeSections(Map<String, String[]> sections, URI location) {
        return Try$.MODULE$.apply(() -> AbstractNLogoFormat.writeSections$$anonfun$1(location)).flatMap((Function1 & Serializable)filePath -> this.sectionsToSource(sections).flatMap((Function1 & Serializable)fileText -> Try$.MODULE$.apply(() -> AbstractNLogoFormat.writeSections$$anonfun$2$$anonfun$1$$anonfun$1(filePath, fileText, location))));
    }

    public static Try sectionsToSource$(AbstractNLogoFormat $this, Map sections) {
        return $this.sectionsToSource((Map<String, String[]>)sections);
    }

    @Override
    default public Try<String> sectionsToSource(Map<String, String[]> sections) {
        return Try$.MODULE$.apply(() -> this.sectionsToSource$$anonfun$1(sections));
    }

    public static Try sectionsFromSource$(AbstractNLogoFormat $this, String source) {
        return $this.sectionsFromSource(source);
    }

    @Override
    default public Try<Map<String, String[]>> sectionsFromSource(String source) {
        Failure failure;
        block3: {
            try {
                Object object = Predef$.MODULE$.refArrayOps((Object[])source.split(this.SeparatorRegex()));
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$5 -> StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(_$5)).toSeq(), ClassTag$.MODULE$.apply(Seq.class)));
                Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)s -> {
                    if (s.headOption().contains((Object)"")) {
                        return (Seq)s.tail();
                    }
                    return s;
                }, ClassTag$.MODULE$.apply(Seq.class)));
                String[][] sectionLines = (String[][])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$6 -> (String[])_$6.toArray(ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class).wrap());
                if (sectionLines.length < this.sectionNames().length()) {
                    Object object4;
                    Object object5 = Predef$.MODULE$.refArrayOps(sectionLines[0]);
                    failure = ArrayOps$.MODULE$.contains$extension(object5, (Object)"xml") || ArrayOps$.MODULE$.contains$extension(object4 = Predef$.MODULE$.refArrayOps(sectionLines[0]), (Object)"XML") ? Failure$.MODULE$.apply((Throwable)new NLogoFormatException("This is not a valid " + this.name() + " file, but you may be able to open it by changing the file extension to match the file type")) : Failure$.MODULE$.apply((Throwable)new NLogoFormatException("Expected " + this.name() + " file to have 12 sections, this had " + sectionLines.length));
                    break block3;
                }
                failure = Success$.MODULE$.apply((Object)((IterableOnceOps)this.sectionNames().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])sectionLines))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            catch (Exception ex) {
                failure = Failure$.MODULE$.apply((Throwable)ex);
            }
        }
        return failure;
    }

    public static Try readExperiments$(AbstractNLogoFormat $this, String source, boolean editNames, Set existingNames) {
        return $this.readExperiments(source, editNames, (Set<String>)existingNames);
    }

    @Override
    default public Try<Tuple2<Seq<LabProtocol>, Set<String>>> readExperiments(String source, boolean editNames, Set<String> existingNames) {
        return Failure$.MODULE$.apply((Throwable)new Exception());
    }

    public static Try writeExperiments$(AbstractNLogoFormat $this, Seq experiments, Writer writer) {
        return $this.writeExperiments((Seq<LabProtocol>)experiments, writer);
    }

    @Override
    default public Try<BoxedUnit> writeExperiments(Seq<LabProtocol> experiments, Writer writer) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            AbstractNLogoFormat.writeExperiments$$anonfun$1(writer, experiments);
            return BoxedUnit.UNIT;
        });
    }

    public static AbstractNLogoFormat$CodeComponent$ CodeComponent$(AbstractNLogoFormat $this) {
        return $this.CodeComponent();
    }

    default public AbstractNLogoFormat$CodeComponent$ CodeComponent() {
        return new AbstractNLogoFormat$CodeComponent$(this);
    }

    public static AbstractNLogoFormat$InfoComponent$ InfoComponent$(AbstractNLogoFormat $this) {
        return $this.InfoComponent();
    }

    default public AbstractNLogoFormat$InfoComponent$ InfoComponent() {
        return new AbstractNLogoFormat$InfoComponent$(this);
    }

    public static AbstractNLogoFormat$VersionComponent$ VersionComponent$(AbstractNLogoFormat $this) {
        return $this.VersionComponent();
    }

    default public AbstractNLogoFormat$VersionComponent$ VersionComponent() {
        return new AbstractNLogoFormat$VersionComponent$(this);
    }

    public static AbstractNLogoFormat$InterfaceComponent$ InterfaceComponent$(AbstractNLogoFormat $this) {
        return $this.InterfaceComponent();
    }

    default public AbstractNLogoFormat$InterfaceComponent$ InterfaceComponent() {
        return new AbstractNLogoFormat$InterfaceComponent$(this);
    }

    public static AbstractNLogoFormat$VectorShapesComponent$ VectorShapesComponent$(AbstractNLogoFormat $this) {
        return $this.VectorShapesComponent();
    }

    default public AbstractNLogoFormat$VectorShapesComponent$ VectorShapesComponent() {
        return new AbstractNLogoFormat$VectorShapesComponent$(this);
    }

    public static AbstractNLogoFormat$LinkShapesComponent$ LinkShapesComponent$(AbstractNLogoFormat $this) {
        return $this.LinkShapesComponent();
    }

    default public AbstractNLogoFormat$LinkShapesComponent$ LinkShapesComponent() {
        return new AbstractNLogoFormat$LinkShapesComponent$(this);
    }

    public static ComponentSerialization codeComponent$(AbstractNLogoFormat $this) {
        return $this.codeComponent();
    }

    @Override
    default public ComponentSerialization<String[], A> codeComponent() {
        return this.CodeComponent();
    }

    public static ComponentSerialization infoComponent$(AbstractNLogoFormat $this) {
        return $this.infoComponent();
    }

    @Override
    default public ComponentSerialization<String[], A> infoComponent() {
        return this.InfoComponent();
    }

    public static ComponentSerialization interfaceComponent$(AbstractNLogoFormat $this) {
        return $this.interfaceComponent();
    }

    @Override
    default public ComponentSerialization<String[], A> interfaceComponent() {
        return this.InterfaceComponent();
    }

    public static ComponentSerialization version$(AbstractNLogoFormat $this) {
        return $this.version();
    }

    @Override
    default public ComponentSerialization<String[], A> version() {
        return this.VersionComponent();
    }

    public static ComponentSerialization shapesComponent$(AbstractNLogoFormat $this) {
        return $this.shapesComponent();
    }

    @Override
    default public ComponentSerialization<String[], A> shapesComponent() {
        return this.VectorShapesComponent();
    }

    public static ComponentSerialization linkShapesComponent$(AbstractNLogoFormat $this) {
        return $this.linkShapesComponent();
    }

    @Override
    default public ComponentSerialization<String[], A> linkShapesComponent() {
        return this.LinkShapesComponent();
    }

    private static BufferedSource sections$$anonfun$1(URI location$1) {
        String string = location$1.getScheme();
        String string2 = "jar";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Source$.MODULE$.fromInputStream(location$1.toURL().openStream(), Codec$.MODULE$.UTF8());
        }
        return Source$.MODULE$.fromURI(location$1, Codec$.MODULE$.UTF8());
    }

    private static Path writeSections$$anonfun$1(URI location$2) {
        return Paths.get(location$2);
    }

    private static URI writeSections$$anonfun$2$$anonfun$1$$anonfun$1(Path filePath$2, String fileText$1, URI location$5) {
        URI uRI;
        try (BufferedWriter writer = Files.newBufferedWriter(filePath$2, new OpenOption[0]);){
            writer.write(fileText$1);
            writer.flush();
            uRI = location$5;
        }
        return uRI;
    }

    private static String[] $anonfun$1() {
        return new String[0];
    }

    private String sectionsToSource$$anonfun$1(Map sections$2) {
        return ((IterableOnceOps)this.sectionNames().map((Function1 & Serializable)name -> {
            Object[] sectionLines;
            block5: {
                block4: {
                    Object object;
                    sectionLines = (String[])sections$2.getOrElse(name, AbstractNLogoFormat::$anonfun$1);
                    Object object2 = Predef$.MODULE$.refArrayOps(sectionLines);
                    if (ArrayOps$.MODULE$.isEmpty$extension(object2)) {
                        return "\n";
                    }
                    Object object3 = Predef$.MODULE$.refArrayOps(sectionLines);
                    if (((String)ArrayOps$.MODULE$.head$extension(object3)).isEmpty() || ((String)ArrayOps$.MODULE$.head$extension(object = Predef$.MODULE$.refArrayOps(sectionLines))).startsWith("\n")) break block4;
                    String string = name;
                    String string2 = "org.nlogo.modelsection.code";
                    if (string != null ? !string.equals(string2) : string2 != null) break block5;
                }
                return Predef$.MODULE$.wrapRefArray(sectionLines).mkString("", "\n", "\n");
            }
            return Predef$.MODULE$.wrapRefArray(sectionLines).mkString("\n", "\n", "\n");
        })).mkString(this.Separator());
    }

    private static void writeExperiments$$anonfun$1(Writer writer$1, Seq experiments$1) {
        writer$1.write(LabLoader$.MODULE$.XMLVER() + "\n" + LabLoader$.MODULE$.DOCTYPE() + "\n");
        writer$1.write(LabSaver$.MODULE$.save((Iterable<LabProtocol>)experiments$1));
    }

    public static /* synthetic */ Model org$nlogo$fileformat$AbstractNLogoFormat$CodeComponent$$$_$addDefault$$anonfun$1(Model m) {
        return m.copy("", m.copy$default$2(), m.copy$default$3(), m.copy$default$4(), m.copy$default$5(), m.copy$default$6(), m.copy$default$7(), m.copy$default$8(), m.copy$default$9());
    }

    private static Model deserialize$$anonfun$1$$anonfun$1(Model m$1, String[] lines$1) {
        return m$1.copy(Predef$.MODULE$.wrapRefArray((Object[])lines$1).mkString("\n"), m$1.copy$default$2(), m$1.copy$default$3(), m$1.copy$default$4(), m$1.copy$default$5(), m$1.copy$default$6(), m$1.copy$default$7(), m$1.copy$default$8(), m$1.copy$default$9());
    }

    public static /* synthetic */ Try org$nlogo$fileformat$AbstractNLogoFormat$CodeComponent$$$_$deserialize$$anonfun$1(String[] lines$2, Model m) {
        return Try$.MODULE$.apply(() -> AbstractNLogoFormat.deserialize$$anonfun$1$$anonfun$1(m, lines$2));
    }

    private static Model deserialize$$anonfun$2$$anonfun$1(Model m$2, String[] s$1) {
        String finalInfo = VersionHistory$.MODULE$.olderThan42pre2(m$2.version()) ? (String)InfoConverter$.MODULE$.convert().apply((Object)Predef$.MODULE$.wrapRefArray((Object[])s$1).mkString("\n")) : Predef$.MODULE$.wrapRefArray((Object[])s$1).mkString("\n");
        return m$2.copy(m$2.copy$default$1(), m$2.copy$default$2(), finalInfo, m$2.copy$default$4(), m$2.copy$default$5(), m$2.copy$default$6(), m$2.copy$default$7(), m$2.copy$default$8(), m$2.copy$default$9());
    }

    public static /* synthetic */ Try org$nlogo$fileformat$AbstractNLogoFormat$InfoComponent$$$_$deserialize$$anonfun$2(String[] s$2, Model m) {
        return Try$.MODULE$.apply(() -> AbstractNLogoFormat.deserialize$$anonfun$2$$anonfun$1(m, s$2));
    }

    public static /* synthetic */ Model org$nlogo$fileformat$AbstractNLogoFormat$VersionComponent$$$_$addDefault$$anonfun$3(Model _$7) {
        String string = Version$.MODULE$.version();
        String string2 = _$7.copy$default$1();
        Seq<Widget> seq = _$7.copy$default$2();
        String string3 = _$7.copy$default$3();
        Seq<Shape.VectorShape> seq2 = _$7.copy$default$5();
        Seq<Shape.LinkShape> seq3 = _$7.copy$default$6();
        Seq<OptionalSection<?>> seq4 = _$7.copy$default$7();
        Seq<ExternalResource> seq5 = _$7.copy$default$8();
        Seq<XMLElement> seq6 = _$7.copy$default$9();
        return _$7.copy(string2, seq, string3, string, seq2, seq3, seq4, seq5, seq6);
    }

    public static /* synthetic */ Model org$nlogo$fileformat$AbstractNLogoFormat$InterfaceComponent$$$_$addDefault$$anonfun$4(Model _$8) {
        Seq seq = (Seq)((SeqOps)new .colon.colon((Object)Model$.MODULE$.defaultView(), (List)Nil$.MODULE$));
        String string = _$8.copy$default$1();
        String string2 = _$8.copy$default$3();
        String string3 = _$8.copy$default$4();
        Seq<Shape.VectorShape> seq2 = _$8.copy$default$5();
        Seq<Shape.LinkShape> seq3 = _$8.copy$default$6();
        Seq<OptionalSection<?>> seq4 = _$8.copy$default$7();
        Seq<ExternalResource> seq5 = _$8.copy$default$8();
        Seq<XMLElement> seq6 = _$8.copy$default$9();
        return _$8.copy(string, (Seq<Widget>)seq, string2, string3, seq2, seq3, seq4, seq5, seq6);
    }

    public static /* synthetic */ Object org$nlogo$fileformat$AbstractNLogoFormat$InterfaceComponent$$$_$parseWidgets$$anonfun$1(ListBuffer widget$1, ListBuffer widgets$8, String line) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line))) {
            return widget$1.$plus$eq((Object)line);
        }
        if (!widget$1.forall((Function1 & Serializable)_$9 -> _$9.isEmpty())) {
            widgets$8.$plus$eq((Object)widget$1.toList());
        }
        widget$1.clear();
        return BoxedUnit.UNIT;
    }

    public static /* synthetic */ Model org$nlogo$fileformat$AbstractNLogoFormat$VectorShapesComponent$$$_$addDefault$$anonfun$5(Model _$10) {
        Seq<Shape.VectorShape> seq = Model$.MODULE$.defaultTurtleShapes();
        String string = _$10.copy$default$1();
        Seq<Widget> seq2 = _$10.copy$default$2();
        String string2 = _$10.copy$default$3();
        String string3 = _$10.copy$default$4();
        Seq<Shape.LinkShape> seq3 = _$10.copy$default$6();
        Seq<OptionalSection<?>> seq4 = _$10.copy$default$7();
        Seq<ExternalResource> seq5 = _$10.copy$default$8();
        Seq<XMLElement> seq6 = _$10.copy$default$9();
        return _$10.copy(string, seq2, string2, string3, seq, seq3, seq4, seq5, seq6);
    }

    public static /* synthetic */ Model org$nlogo$fileformat$AbstractNLogoFormat$LinkShapesComponent$$$_$addDefault$$anonfun$6(Model m) {
        Seq seq = Model$.MODULE$.defaultLinkShapes().toSeq();
        String string = m.copy$default$1();
        Seq<Widget> seq2 = m.copy$default$2();
        String string2 = m.copy$default$3();
        String string3 = m.copy$default$4();
        Seq<Shape.VectorShape> seq3 = m.copy$default$5();
        Seq<OptionalSection<?>> seq4 = m.copy$default$7();
        Seq<ExternalResource> seq5 = m.copy$default$8();
        Seq<XMLElement> seq6 = m.copy$default$9();
        return m.copy(string, seq2, string2, string3, seq3, (Seq<Shape.LinkShape>)seq, seq4, seq5, seq6);
    }
}

