/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.gl2.GLUgl2;
import java.awt.Point;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Drawing3D;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.Exceptions;
import org.nlogo.api.Link;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Patch;
import org.nlogo.api.Patch3D;
import org.nlogo.api.Perspective;
import org.nlogo.api.Turtle;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.api.World3D;
import org.nlogo.api.WorldWithWorldRenderable;
import org.nlogo.gl.render.Direction;
import org.nlogo.gl.render.DirectionalLight;
import org.nlogo.gl.render.Euclidean;
import org.nlogo.gl.render.ExportRenderer;
import org.nlogo.gl.render.ExportRenderer2D;
import org.nlogo.gl.render.GLViewSettings;
import org.nlogo.gl.render.JOGLLoader;
import org.nlogo.gl.render.LightManager;
import org.nlogo.gl.render.LinkRenderer;
import org.nlogo.gl.render.MouseState;
import org.nlogo.gl.render.PatchRenderer;
import org.nlogo.gl.render.PickListener;
import org.nlogo.gl.render.Picker;
import org.nlogo.gl.render.RGBA;
import org.nlogo.gl.render.Renderer3D;
import org.nlogo.gl.render.ShapeManager;
import org.nlogo.gl.render.ShapeRenderer;
import org.nlogo.gl.render.TurtleRenderer;
import org.nlogo.gl.render.WorldRenderer;
import org.nlogo.gl.render.WorldRenderer3D;
import org.nlogo.shape.InvalidShapeDescriptionException;
import org.nlogo.util.SysInfo;

public class Renderer
implements GLEventListener {
    final WorldWithWorldRenderable world;
    final ViewSettings renderer;
    private final TurtleRenderer turtleRenderer;
    private final PatchRenderer patchRenderer;
    final WorldRenderer worldRenderer;
    final LinkRenderer linkRenderer;
    final ShapeRenderer shapeRenderer;
    final MouseState mouseState = new MouseState();
    final LightManager lightManager = new LightManager();
    int width;
    int height;
    private float ratio;
    public static final float WORLD_SCALE = 0.3f;
    public static final float PICK_THRESHOLD = 0.23f;
    private final List<Agent> opaqueAgents = new ArrayList<Agent>();
    private final PriorityQueue<Agent> transparentAgents;
    final GLUgl2 glu = new GLUgl2();
    ShapeManager shapeManager;
    PickListener pickListener;
    private DoubleBuffer modelMatrix;
    private DoubleBuffer projMatrix;
    private IntBuffer viewPort;
    boolean addsLights = true;
    private Agent outlineAgent = null;

    public Renderer(WorldWithWorldRenderable world, ViewSettings graphicsSettings, DrawingInterface drawing, GLViewSettings glSettings) {
        this(world, graphicsSettings, drawing, glSettings, new ShapeRenderer(world));
    }

    public Renderer(WorldWithWorldRenderable world, ViewSettings graphicsSettings, DrawingInterface drawing, GLViewSettings glSettings, ShapeRenderer shapeRenderer) {
        this.modelMatrix = DoubleBuffer.wrap(new double[16]);
        this.projMatrix = DoubleBuffer.wrap(new double[16]);
        this.viewPort = IntBuffer.wrap(new int[4]);
        this.world = world;
        this.transparentAgents = new PriorityQueue<Agent>(100, new Euclidean(world.observer()));
        this.renderer = graphicsSettings;
        this.shapeRenderer = shapeRenderer;
        this.turtleRenderer = this.createTurtleRenderer(world);
        this.linkRenderer = this.createLinkRenderer(world);
        this.patchRenderer = this.createPatchRenderer(world, drawing);
        this.worldRenderer = this.createWorldRenderer(world, this.patchRenderer, drawing, this.turtleRenderer, glSettings);
    }

    public Renderer(Renderer glrenderer) {
        this.world = glrenderer.world;
        this.transparentAgents = new PriorityQueue<Agent>(100, new Euclidean(this.world.observer()));
        this.renderer = glrenderer.renderer;
        this.worldRenderer = glrenderer.worldRenderer;
        this.turtleRenderer = glrenderer.turtleRenderer;
        this.patchRenderer = glrenderer.patchRenderer;
        this.linkRenderer = glrenderer.linkRenderer;
        this.shapeRenderer = glrenderer.shapeRenderer;
        this.shapeManager = glrenderer.shapeManager;
        this.worldRenderer.shapeManager_$eq(this.shapeManager);
        this.shapeRenderer.shapeManager_$eq(this.shapeManager);
    }

    public void update() {
        this.worldRenderer.shapeManager_$eq(this.shapeManager);
        this.shapeRenderer.shapeManager_$eq(this.shapeManager);
    }

    public void dispose(GLAutoDrawable autoDrawable) {
    }

    TurtleRenderer createTurtleRenderer(World world) {
        return new TurtleRenderer(world, this.shapeRenderer);
    }

    WorldRenderer createWorldRenderer(World world, PatchRenderer patchRenderer, DrawingInterface drawing, TurtleRenderer turtleRenderer, GLViewSettings settings) {
        return new WorldRenderer(world, patchRenderer, drawing, turtleRenderer, this.linkRenderer, settings);
    }

    PatchRenderer createPatchRenderer(World world, DrawingInterface drawing) {
        return new PatchRenderer(world, drawing, this.shapeRenderer);
    }

    LinkRenderer createLinkRenderer(World world) {
        return new LinkRenderer(world, this.shapeRenderer);
    }

    public ExportRenderer createExportRenderer() {
        return new ExportRenderer2D(this);
    }

    public void displayChanged(GLAutoDrawable gLDrawable, boolean modeChanged, boolean deviceChanged) {
    }

    public void init(GLAutoDrawable gLDrawable) {
        GL2 gl = (GL2)gLDrawable.getGL();
        ClassLoader classLoader = this.getClass().getClassLoader();
        SysInfo.getJOGLInfoString_$eq("JOGL: " + JOGLLoader.getVersion(classLoader));
        SysInfo.getGLInfoString_$eq("OpenGL graphics: " + gl.glGetString(7937) + "\nOpenGL version: " + gl.glGetString(7938) + "\nOpenGL vendor: " + gl.glGetString(7936));
        gl.glShadeModel(7425);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClearDepth(1.0);
        gl.glEnable(2929);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4353);
        if (this.addsLights) {
            this.lightManager.init(gl);
            DirectionalLight light1 = new DirectionalLight(new Direction(Float.valueOf(-1.0f), Float.valueOf(-0.3f), Float.valueOf(0.4f)));
            light1.ambient_$eq(new RGBA(Float.valueOf(0.25f), Float.valueOf(0.25f), Float.valueOf(0.25f), Float.valueOf(1.0f)));
            light1.diffuse_$eq(new RGBA(Float.valueOf(0.35f), Float.valueOf(0.35f), Float.valueOf(0.35f), Float.valueOf(1.0f)));
            light1.specular_$eq(new RGBA(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
            this.lightManager.addLight(light1);
            DirectionalLight light2 = new DirectionalLight(new Direction(Float.valueOf(1.0f), Float.valueOf(0.6f), Float.valueOf(-0.5f)));
            light2.ambient_$eq(new RGBA(Float.valueOf(0.25f), Float.valueOf(0.25f), Float.valueOf(0.25f), Float.valueOf(1.0f)));
            light2.diffuse_$eq(new RGBA(Float.valueOf(0.35f), Float.valueOf(0.35f), Float.valueOf(0.35f), Float.valueOf(1.0f)));
            light2.specular_$eq(new RGBA(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
            this.lightManager.addLight(light2);
        }
        gl.glEnable(2977);
        gl.glColorMaterial(1028, 5634);
        gl.glEnable(2903);
        gl.glCullFace(1029);
        gl.glEnable(2884);
        this.shapeManager = new ShapeManager(gl, (GLU)this.glu, this.world.turtleShapeList(), this.world.linkShapeList(), this.shapeManager == null ? null : this.shapeManager.customShapes, this instanceof Renderer3D);
        this.worldRenderer.init(gl, this.shapeManager);
        this.shapeRenderer.shapeManager_$eq(this.shapeManager);
        int[] StencilBits = new int[1];
        gl.glGetIntegerv(3415, IntBuffer.wrap(StencilBits));
        this.shapeRenderer.stencilSupport_$eq(StencilBits[0] > 0);
    }

    public void reshape(GLAutoDrawable gLDrawable, int x, int y, int width, int height) {
        GL2 gl = (GL2)gLDrawable.getGL();
        if (System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            this.width = width;
            this.height = height > 0 ? height : 1;
        } else {
            this.width = width;
            this.height = height > 0 ? height : 1;
        }
        this.ratio = (float)this.width / (float)this.height;
        this.mainViewport(gl);
    }

    private void mainViewport(GL2 gl) {
        gl.glViewport(0, 0, this.width, this.height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        double zClip = Math.max(this.world.worldWidth(), this.world.worldHeight()) * 4;
        this.glu.gluPerspective(45.0, (double)this.ratio, 0.1, zClip);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void display(GLAutoDrawable gLDrawable) {
        GL2 gl = (GL2)gLDrawable.getGL();
        gl.glClear(16640);
        this.shapeManager.checkQueue(gl, (GLU)this.glu, this.world.turtleShapeList(), this.world.linkShapeList());
        this.render(gl);
        gl.glFlush();
    }

    void renderClippingPlane(GL2 gl, double[] eqn, int plane) {
        DoubleBuffer eqnBuffer = DoubleBuffer.wrap(eqn);
        gl.glClipPlane(plane, eqnBuffer);
        gl.glEnable(plane);
    }

    void setClippingPlanes(GL2 gl) {
        this.renderClippingPlane(gl, new double[]{1.0, 0.0, 0.0, (float)(-((double)this.world.minPxcor() - 0.5) * (double)0.3f) + 0.01f}, 12288);
        this.renderClippingPlane(gl, new double[]{-1.0, 0.0, 0.0, (float)(((double)this.world.maxPxcor() + 0.5) * (double)0.3f) + 0.01f}, 12289);
        this.renderClippingPlane(gl, new double[]{0.0, -1.0, 0.0, (float)(((double)this.world.maxPycor() + 0.5) * (double)0.3f) + 0.01f}, 12290);
        this.renderClippingPlane(gl, new double[]{0.0, 1.0, 0.0, (float)(-((double)this.world.minPycor() - 0.5) * (double)0.3f) + 0.01f}, 12291);
    }

    void disableClippingPlanes(GL2 gl) {
        gl.glDisable(12288);
        gl.glDisable(12289);
        gl.glDisable(12290);
        gl.glDisable(12291);
        gl.glPopMatrix();
    }

    boolean agentIsVisible(Agent agent) {
        if (agent instanceof Turtle) {
            Turtle turtle = (Turtle)agent;
            boolean riding_agent = this.world.observer().perspective().kind() == 1 && this.world.observer().targetAgent() == turtle;
            return !riding_agent && !turtle.hidden() && ((double)turtle.alpha() > 0.0 || turtle.hasLabel());
        }
        if (agent instanceof Link) {
            Link link = (Link)agent;
            return !link.hidden() && ((double)link.alpha() > 0.0 || link.hasLabel());
        }
        if (agent instanceof Patch3D) {
            Patch3D patch = (Patch3D)agent;
            return (double)patch.alpha() > 0.0 || patch.hasLabel();
        }
        if (agent instanceof Patch) {
            return true;
        }
        throw new IllegalStateException("Agent must be an instance of Turtle, Patch, or Link.");
    }

    private boolean isPartiallyTransparent(Agent agent) {
        int alpha = agent.alpha();
        return alpha > 0 && alpha < 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void render(GL2 gl) {
        gl.glLoadIdentity();
        WorldWithWorldRenderable worldWithWorldRenderable = this.world;
        synchronized (worldWithWorldRenderable) {
            Perspective perspective = this.world.observer().perspective();
            Agent targetAgent = this.world.observer().targetAgent();
            this.worldRenderer.observePerspective(gl);
            this.worldRenderer.renderCrossHairs(gl);
            if (this.addsLights) {
                this.lightManager.applyLighting();
            }
            this.renderWorld(gl, this.world);
            this.setClippingPlanes(gl);
            double lineScale = this.calculateLineScale();
            boolean sortingNeeded = this.world.mayHavePartiallyTransparentObjects();
            if (!sortingNeeded) {
                this.worldRenderer.renderPatchShapes(gl, this.outlineAgent, this.renderer.fontSize(), this.renderer.patchSize());
                this.linkRenderer.renderLinks(gl, (GLU)this.glu, this.renderer.fontSize(), this.renderer.patchSize(), this.outlineAgent);
                this.turtleRenderer.renderTurtles(gl, (GLU)this.glu, this.renderer.fontSize(), this.renderer.patchSize(), this.outlineAgent);
                if (this.world instanceof World3D) {
                    this.worldRenderer.renderDrawing(gl);
                }
            } else {
                gl.glEnable(3042);
                gl.glBlendFunc(770, 771);
                this.opaqueAgents.clear();
                this.transparentAgents.clear();
                for (Agent agent : this.world.turtles().agents()) {
                    if (!this.agentIsVisible(agent)) continue;
                    if (this.isPartiallyTransparent(agent)) {
                        this.transparentAgents.add(agent);
                        continue;
                    }
                    this.opaqueAgents.add(agent);
                }
                for (Agent agent : this.world.patches().agents()) {
                    if (!this.agentIsVisible(agent)) continue;
                    if (this.isPartiallyTransparent(agent)) {
                        this.transparentAgents.add(agent);
                        continue;
                    }
                    this.opaqueAgents.add(agent);
                }
                for (Agent agent : this.world.links().agents()) {
                    if (!this.agentIsVisible(agent)) continue;
                    if (this.isPartiallyTransparent(agent)) {
                        this.transparentAgents.add(agent);
                        continue;
                    }
                    this.opaqueAgents.add(agent);
                }
                if (this.world instanceof World3D) {
                    for (Link link : ((Drawing3D)this.world.getDrawing()).linkStamps()) {
                        if (!this.agentIsVisible(link)) continue;
                        if (this.isPartiallyTransparent(link)) {
                            this.transparentAgents.add(link);
                            continue;
                        }
                        this.opaqueAgents.add(link);
                    }
                    for (Turtle turtle : ((Drawing3D)this.world.getDrawing()).turtleStamps()) {
                        if (!this.agentIsVisible(turtle)) continue;
                        if (this.isPartiallyTransparent(turtle)) {
                            this.transparentAgents.add(turtle);
                            continue;
                        }
                        this.opaqueAgents.add(turtle);
                    }
                    ((WorldRenderer3D)this.worldRenderer).renderTrails(gl);
                }
                for (Agent agent : this.opaqueAgents) {
                    this.renderAgent(gl, agent, lineScale);
                }
                while (!this.transparentAgents.isEmpty()) {
                    Agent agent = (Agent)this.transparentAgents.remove();
                    this.renderAgent(gl, agent, lineScale);
                }
                gl.glDisable(3042);
            }
            if (this.outlineAgent instanceof Patch) {
                this.patchRenderer.renderOutline(gl, (Patch)this.outlineAgent);
            }
            this.disableClippingPlanes(gl);
            if (targetAgent instanceof Turtle) {
                this.turtleRenderer.renderHighlight(gl, (Turtle)targetAgent);
            } else if (targetAgent instanceof Patch) {
                this.patchRenderer.renderHightlight(gl, (Patch)targetAgent);
            }
            if (this.mouseState.on() || this.mouseState.pickRequest()) {
                this.storeMatricies(gl);
                if (this.mouseState.pickRequest()) {
                    this.performPick();
                }
                if (perspective.kind() != 0 && this.mouseState.inside() && this.mouseState.point() != null) {
                    this.updateMouseCors();
                }
            }
        }
    }

    void renderAgent(GL2 gl, Agent agent, Double lineScale) {
        if (agent instanceof Turtle) {
            this.turtleRenderer.renderWrappedTurtle(gl, (Turtle)agent, this.renderer.fontSize(), this.renderer.patchSize(), agent == this.outlineAgent, lineScale);
        } else if (agent instanceof Patch3D) {
            this.worldRenderer.renderIndividualPatchShapes(gl, (Patch3D)agent, this.outlineAgent, this.renderer.fontSize(), this.renderer.patchSize());
        } else if (agent instanceof Link) {
            this.linkRenderer.renderIndividualLinks(gl, (GLU)this.glu, (Link)agent, this.renderer.fontSize(), this.renderer.patchSize(), this.outlineAgent);
        }
    }

    void renderWorld(GL2 gl, World world) {
        gl.glPushMatrix();
        this.translateWorld(gl, world);
        this.worldRenderer.renderWorld(gl, this.renderer.fontSize(), this.renderer.patchSize());
        this.worldRenderer.renderDrawing(gl);
        gl.glPopMatrix();
    }

    double calculateLineScale() {
        Perspective p = this.world.observer().perspective();
        double distance = p instanceof AgentFollowingPerspective ? (double)((AgentFollowingPerspective)((Object)p)).followDistance() : ((ObserverOrientation)this.world.observer().orientation().get()).dist();
        if (distance != 0.0) {
            double width = this.world.worldWidth();
            double height = this.world.worldHeight();
            double maxDimension = Math.max(width, height);
            if (this.world instanceof World3D) {
                double depth = ((World3D)((Object)this.world)).worldDepth();
                maxDimension = Math.max(maxDimension, depth);
            }
            return 1.5 * maxDimension / distance;
        }
        return 0.0;
    }

    public void outlineAgent(Agent agent) {
        this.outlineAgent = agent;
    }

    public void cleanUp() {
        this.worldRenderer.cleanUp();
    }

    public void queuePick(Point mousePt, PickListener pickListener) {
        this.mouseState.pickRequest_$eq(true);
        this.mouseState.point_$eq(mousePt);
        this.pickListener = pickListener;
    }

    void performPick() {
        ArrayList<Agent> agents = new ArrayList<Agent>(5);
        double[][] ray = this.generatePickRay(this.mouseState.point().getX(), (double)this.height - this.mouseState.point().getY());
        this.pickPatches(agents, ray);
        this.pickTurtles(agents, ray);
        this.pickLinks(agents, ray);
        this.pickListener.pick(this.mouseState.point(), agents);
        this.mouseState.pickRequest_$eq(false);
    }

    private void storeMatricies(GL2 gl) {
        gl.glGetDoublev(2982, this.modelMatrix);
        gl.glGetDoublev(2983, this.projMatrix);
        gl.glGetIntegerv(2978, this.viewPort);
    }

    double[][] generatePickRay(double mouseX, double mouseY) {
        double[][] ray = new double[2][3];
        this.glu.gluUnProject(mouseX, mouseY, 0.0, this.modelMatrix, this.projMatrix, this.viewPort, DoubleBuffer.wrap(ray[0]));
        this.glu.gluUnProject(mouseX, mouseY, 1.0, this.modelMatrix, this.projMatrix, this.viewPort, DoubleBuffer.wrap(ray[1]));
        return ray;
    }

    double wrapX(double x) {
        try {
            return this.world.wrapX(x);
        }
        catch (AgentException e) {
            return x;
        }
    }

    double wrapY(double y) {
        try {
            return this.world.wrapY(y);
        }
        catch (AgentException e) {
            return y;
        }
    }

    void pickPatches(List<Agent> agents, double[][] ray) {
        double scale = 3.3333332008785725;
        double t = (ray[0][2] + (double)0.15f) / (ray[0][2] - ray[1][2]);
        double xi = scale * (ray[0][0] + (ray[1][0] - ray[0][0]) * t);
        double yi = scale * (ray[0][1] + (ray[1][1] - ray[0][1]) * t);
        if (xi < (double)this.world.maxPxcor() + 0.5 && xi >= (double)this.world.minPxcor() - 0.5 && yi < (double)this.world.maxPycor() + 0.5 && yi >= (double)this.world.minPycor() - 0.5) {
            xi = this.wrapX(xi + this.world.followOffsetX());
            yi = this.wrapY(yi + this.world.followOffsetY());
            this.mouseState.xcor_$eq(xi);
            this.mouseState.ycor_$eq(yi);
            if (agents != null) {
                try {
                    Patch patch = this.world.getPatchAt(xi, yi);
                    agents.add(patch);
                }
                catch (AgentException e) {
                    Exceptions.ignore(e);
                }
            }
        }
    }

    void pickTurtles(List<Agent> agents, double[][] ray) {
        for (Agent a : this.world.turtles().agents()) {
            double lengb;
            double crossZ;
            double ux;
            double vx;
            double crossY;
            double vy;
            double uz;
            double size;
            double[] coord;
            double vz;
            double uy;
            double crossX;
            double lengt;
            double dist;
            Turtle turtle = (Turtle)a;
            if (turtle.hidden() || !((dist = (lengt = Math.sqrt((crossX = (uy = ray[1][1] - ray[0][1]) * (vz = ray[0][2] - (coord = this.getTurtleCoords(turtle, size = turtle.size()))[2]) - (uz = ray[1][2] - ray[0][2]) * (vy = ray[0][1] - coord[1])) * crossX + (crossY = uz * (vx = ray[0][0] - coord[0]) - (ux = ray[1][0] - ray[0][0]) * vz) * crossY + (crossZ = ux * vy - uy * vx) * crossZ)) / (lengb = Math.sqrt(ux * ux + uy * uy + uz * uz))) <= size * (double)0.23f)) continue;
            agents.add(turtle);
        }
    }

    void pickLinks(List<Agent> agents, double[][] ray) {
        for (Agent a : this.world.links().agents()) {
            double[] end2;
            double[] end1;
            double dist;
            Link link = (Link)a;
            if (link.hidden() || !((dist = Picker.distanceFromRayToSegment(ray, end1 = this.getTurtleCoords(link.end1(), 0.0), end2 = this.getTurtleCoords(link.end2(), 0.0))) <= (double)0.23f)) continue;
            agents.add(link);
        }
    }

    double[] getTurtleCoords(Turtle turtle, double height) {
        return new double[]{this.world.wrappedObserverX(turtle.xcor()) * (double)0.3f, this.world.wrappedObserverY(turtle.ycor()) * (double)0.3f, 0.0};
    }

    public void setMouseMode(boolean mode) {
        this.mouseState.on_$eq(mode);
    }

    public double mouseXCor() {
        return this.mouseState.xcor();
    }

    public double mouseYCor() {
        return this.mouseState.ycor();
    }

    public boolean mouseDown() {
        return this.mouseState.down();
    }

    public void mouseDown(boolean mouseDown) {
        this.mouseState.down_$eq(mouseDown);
    }

    public boolean mouseInside() {
        return this.mouseState.inside();
    }

    public void resetMouseCors() {
        this.mouseState.xcor_$eq(0.0);
        this.mouseState.ycor_$eq(0.0);
    }

    public void setMouseCors(Point mousePt) {
        double[][] ray = this.generatePickRay(mousePt.getX(), (double)this.height - mousePt.getY());
        this.pickPatches(null, ray);
        this.mouseState.point_$eq(mousePt);
    }

    public void updateMouseCors() {
        double[][] ray = this.generatePickRay(this.mouseState.point().getX(), (double)this.height - this.mouseState.point().getY());
        this.pickPatches(null, ray);
    }

    public void mouseInside(double mx, double my) {
        double[][] ray = this.generatePickRay(mx, (double)this.height - my);
        double scale = 3.3333332538604736;
        double t = (ray[0][2] + (double)0.15f) / (ray[0][2] - ray[1][2]);
        double xi = scale * (ray[0][0] + (ray[1][0] - ray[0][0]) * t);
        double yi = scale * (ray[0][1] + (ray[1][1] - ray[0][1]) * t);
        this.mouseState.inside_$eq(xi < (double)this.world.maxPxcor() + 0.5 && xi >= (double)this.world.minPxcor() - 0.5 && yi < (double)this.world.maxPycor() + 0.5 && yi >= (double)this.world.minPycor() - 0.5);
    }

    public void showCrossHairs(boolean visible) {
        this.worldRenderer.showCrossHairs_$eq(visible);
    }

    public void addCustomShapes(String filename) throws IOException, InvalidShapeDescriptionException {
        this.shapeManager.addCustomShapes(filename);
    }

    public void invalidateTurtleShape(String shape) {
        this.shapeManager.invalidateTurtleShape(shape);
    }

    public void invalidateLinkShape(String shape) {
        this.shapeManager.invalidateLinkShape(shape);
    }

    public void translateWorld(GL2 gl, World world) {
        gl.glTranslated((double)(world.maxPxcor() + world.minPxcor()) / 2.0 * (double)0.3f, (double)(world.maxPycor() + world.minPycor()) / 2.0 * (double)0.3f, 0.0);
    }
}

