/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.Observer;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Patch;
import org.nlogo.api.Patch3D;
import org.nlogo.api.Perspective;
import org.nlogo.api.Turtle;
import org.nlogo.api.World;
import org.nlogo.gl.render.DrawingRenderer;
import org.nlogo.gl.render.DrawingRendererInterface;
import org.nlogo.gl.render.GLViewSettings;
import org.nlogo.gl.render.LinkRenderer;
import org.nlogo.gl.render.PatchRenderer;
import org.nlogo.gl.render.ShapeManager;
import org.nlogo.gl.render.TurtleRenderer;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public class WorldRenderer {
    private final World world;
    private final PatchRenderer patchRenderer;
    private final GLViewSettings settings;
    private final Observer observer;
    private final DrawingRendererInterface drawingRenderer;
    private ShapeManager shapeManager;
    private boolean showCrossHairs;

    public WorldRenderer(World world, PatchRenderer patchRenderer, DrawingInterface drawing, TurtleRenderer turtleRenderer, LinkRenderer linkRenderer, GLViewSettings settings) {
        this.world = world;
        this.patchRenderer = patchRenderer;
        this.settings = settings;
        this.observer = world.observer();
        this.drawingRenderer = this.createDrawingRenderer(world, drawing, turtleRenderer, linkRenderer);
        this.shapeManager = null;
        this.showCrossHairs = false;
    }

    public Observer observer() {
        return this.observer;
    }

    public DrawingRendererInterface drawingRenderer() {
        return this.drawingRenderer;
    }

    public ShapeManager shapeManager() {
        return this.shapeManager;
    }

    public void shapeManager_$eq(ShapeManager x$1) {
        this.shapeManager = x$1;
    }

    public DrawingRendererInterface createDrawingRenderer(World world, DrawingInterface drawing, TurtleRenderer turtleRenderer, LinkRenderer linkRenderer) {
        return new DrawingRenderer(world, drawing);
    }

    public void init(GL2 gl, ShapeManager shapeManager) {
        this.shapeManager_$eq(shapeManager);
        this.drawingRenderer().init(gl);
    }

    public void observePerspective(GL2 gl) {
        None$ none$;
        DoubleRef x = DoubleRef.create((double)(this.observer().oxcor() - this.world.followOffsetX()));
        DoubleRef y = DoubleRef.create((double)(this.observer().oycor() - this.world.followOffsetY()));
        DoubleRef z = DoubleRef.create((double)this.observer().ozcor());
        ObserverOrientation orientation = (ObserverOrientation)this.observer().orientation().get();
        double heading = orientation.heading();
        DoubleRef pitch = DoubleRef.create((double)orientation.pitch());
        Perspective perspective = this.observer().perspective();
        if (perspective instanceof AgentFollowingPerspective) {
            Perspective afp = (Perspective)((Object)((AgentFollowingPerspective)((Object)perspective)));
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)((AgentFollowingPerspective)((Object)afp)).targetAgent(), (Object)BoxesRunTime.boxToInteger((int)((AgentFollowingPerspective)((Object)afp)).followDistance())));
        } else {
            none$ = None$.MODULE$;
        }
        None$ agentAndDist = none$;
        agentAndDist.foreach(x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                double d;
                Agent agent = (Agent)tuple2._1();
                int dist = BoxesRunTime.unboxToInt((Object)tuple2._2());
                double distance = Int$.MODULE$.int2double(dist);
                Agent agent2 = agent;
                if (agent2 instanceof Turtle) {
                    Turtle t = (Turtle)agent2;
                    if (distance > 0.0) {
                        distance += t.size();
                    }
                }
                Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$1.elem), (Object)BoxesRunTime.boxToDouble((double)y$1.elem), (Object)BoxesRunTime.boxToDouble((double)z$1.elem));
                double oldx = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                double oldy = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double oldz = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                x$1.elem -= distance * package$.MODULE$.sin(package$.MODULE$.toRadians(heading));
                y$1.elem -= distance * package$.MODULE$.cos(package$.MODULE$.toRadians(heading));
                z$1.elem = distance * 0.5;
                DoubleRef doubleRef = pitch;
                try {
                    d = -this.world.protractor().towardsPitch(x$1.elem, y$1.elem, z$1.elem, oldx, oldy, oldz, false);
                }
                catch (AgentException ex) {
                    d = 0.0;
                }
                double d2 = d;
                DoubleRef doubleRef2 = doubleRef;
                doubleRef = null;
                doubleRef2.elem = d2;
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        gl.glRotated(90.0, -1.0, 0.0, 0.0);
        gl.glRotated(heading, 0.0, 0.0, 1.0);
        gl.glRotated(pitch.elem, package$.MODULE$.cos(package$.MODULE$.toRadians(heading)), -package$.MODULE$.sin(package$.MODULE$.toRadians(heading)), 0.0);
        gl.glTranslated(-x.elem * (double)0.3f, -y.elem * (double)0.3f, -z.elem * (double)0.3f);
    }

    public double[] getXYandZ(Turtle turtle) {
        return new double[]{turtle.xcor(), turtle.ycor(), 0.0};
    }

    public double[] getOrientation(Turtle turtle) {
        return new double[]{turtle.heading(), 0.0, 0.0};
    }

    public boolean showCrossHairs() {
        return this.showCrossHairs;
    }

    public void showCrossHairs_$eq(boolean x$1) {
        this.showCrossHairs = x$1;
    }

    public double[] getCrosshairCoords() {
        return new double[]{this.observer().oxcor() - this.world.followOffsetX(), this.observer().oycor() - this.world.followOffsetY(), this.observer().ozcor()};
    }

    public void renderCrossHairs(GL2 gl) {
        if (this.showCrossHairs()) {
            double[] coords = this.getCrosshairCoords();
            Perspective perspective = this.observer().perspective();
            if (!(perspective instanceof AgentFollowingPerspective)) {
                ObserverOrientation orientation = (ObserverOrientation)this.observer().orientation().get();
                double dist = orientation.dist();
                coords[0] = coords[0] + dist * orientation.dx();
                coords[1] = coords[1] + dist * orientation.dy();
                coords[2] = coords[2] - dist * orientation.dz();
            }
            coords[0] = coords[0] * (double)0.3f;
            coords[1] = coords[1] * (double)0.3f;
            coords[2] = coords[2] * (double)0.3f;
            gl.glPushMatrix();
            gl.glTranslated(coords[0], coords[1], coords[2]);
            gl.glCallList(this.shapeManager().getShape("@@@CROSSHAIRS@@@").displayListIndex());
            gl.glPopMatrix();
            return;
        }
    }

    public void renderWorld(GL2 gl, int fontSize, double patchSize) {
        if (this.world.patches() != null) {
            this.patchRenderer.renderPatches(gl);
            if (this.settings.wireframeOn()) {
                this.renderWorldWireFrame(gl);
                return;
            }
            return;
        }
    }

    public void renderIndividualPatchShapes(GL2 gl, Patch3D patch, Agent outlineAgent, int fontSize, double patchSize) {
        Agent agent = outlineAgent;
        if (agent instanceof Patch) {
            Patch p = (Patch)agent;
            this.patchRenderer.renderOutline(gl, p);
        }
        this.patchRenderer.renderIndividualLabels(gl, patch, fontSize, patchSize);
    }

    public void renderPatchShapes(GL2 gl, Agent outlineAgent, int fontSize, double patchSize) {
        Agent agent = outlineAgent;
        if (agent instanceof Patch) {
            Patch p = (Patch)agent;
            this.patchRenderer.renderOutline(gl, p);
        }
        this.patchRenderer.renderLabels(gl, fontSize, patchSize);
    }

    public void renderDrawing(GL2 gl) {
        this.drawingRenderer().renderDrawing(gl);
    }

    public void renderWorldWireFrame(GL2 gl) {
        float[] coords = this.getWorldDimensions(this.world);
        gl.glPolygonMode(1032, 6913);
        gl.glDisable(2896);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glPushMatrix();
        gl.glScalef(coords[0], coords[1], coords[2]);
        gl.glCallList(this.shapeManager().getShape("@@@WIREFRAME@@@").displayListIndex());
        gl.glPopMatrix();
        gl.glPolygonMode(1032, 6914);
        gl.glEnable(2896);
    }

    public float[] getWorldDimensions(World world) {
        return new float[]{world.worldWidth(), world.worldHeight(), 1.0f};
    }

    public void cleanUp() {
        this.patchRenderer.deleteTexture();
        this.drawingRenderer().clear();
    }
}

