/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.view;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.nlogo.agent.Observer;
import org.nlogo.agent.World;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Perspective;
import org.nlogo.api.Perspective$Follow$;
import org.nlogo.awt.Mouse$;
import org.nlogo.gl.view.MouseMotionHandler$InterfaceMode$;
import org.nlogo.gl.view.MouseMotionHandler$OrbitMode$;
import org.nlogo.gl.view.MouseMotionHandler$TranslateMode$;
import org.nlogo.gl.view.MouseMotionHandler$ZoomMode$;
import org.nlogo.gl.view.View;
import scala.Float$;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.runtime.RichDouble$;

public class MouseMotionHandler
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private final View view;
    private Mode movementMode;
    private int prevMouseX;
    private int prevMouseY;
    private final World world;

    public MouseMotionHandler(View view) {
        this.view = view;
        this.movementMode = MouseMotionHandler$OrbitMode$.MODULE$;
        this.prevMouseX = 0;
        this.prevMouseY = 0;
        this.world = view.viewManager().world();
    }

    public World world() {
        return this.world;
    }

    public void setMovementMode(Mode mode) {
        Mode mode2 = mode;
        MouseMotionHandler$InterfaceMode$ mouseMotionHandler$InterfaceMode$ = MouseMotionHandler$InterfaceMode$.MODULE$;
        if (!(mode2 != null ? !mode2.equals(mouseMotionHandler$InterfaceMode$) : mouseMotionHandler$InterfaceMode$ != null)) {
            this.view.renderer().setMouseMode(true);
            this.view.display();
        } else {
            Mode mode3 = this.movementMode;
            MouseMotionHandler$InterfaceMode$ mouseMotionHandler$InterfaceMode$2 = MouseMotionHandler$InterfaceMode$.MODULE$;
            if (!(mode3 != null ? !mode3.equals(mouseMotionHandler$InterfaceMode$2) : mouseMotionHandler$InterfaceMode$2 != null)) {
                this.view.renderer().setMouseMode(false);
            }
        }
        this.movementMode = mode;
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        Mode mode = this.movementMode;
        MouseMotionHandler$InterfaceMode$ mouseMotionHandler$InterfaceMode$ = MouseMotionHandler$InterfaceMode$.MODULE$;
        if (!(mode != null ? !mode.equals(mouseMotionHandler$InterfaceMode$) : mouseMotionHandler$InterfaceMode$ != null)) {
            this.view.renderer().mouseInside(Int$.MODULE$.int2double(evt.getX()), Int$.MODULE$.int2double(evt.getY()));
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        Mode mode = this.movementMode;
        MouseMotionHandler$InterfaceMode$ mouseMotionHandler$InterfaceMode$ = MouseMotionHandler$InterfaceMode$.MODULE$;
        if (!(mode != null ? !mode.equals(mouseMotionHandler$InterfaceMode$) : mouseMotionHandler$InterfaceMode$ != null)) {
            this.view.renderer().mouseInside(Int$.MODULE$.int2double(evt.getX()), Int$.MODULE$.int2double(evt.getY()));
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.prevMouseX = evt.getX();
        this.prevMouseY = evt.getY();
        if (!evt.isPopupTrigger()) {
            Mode mode = this.movementMode;
            MouseMotionHandler$InterfaceMode$ mouseMotionHandler$InterfaceMode$ = MouseMotionHandler$InterfaceMode$.MODULE$;
            if (!(mode != null ? !mode.equals(mouseMotionHandler$InterfaceMode$) : mouseMotionHandler$InterfaceMode$ != null) && Mouse$.MODULE$.hasButton1(evt)) {
                this.view.renderer().mouseDown(true);
                return;
            }
        }
        if (evt.isPopupTrigger()) {
            this.view.doPopup(evt);
        }
        this.view.renderer().showCrossHairs(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        this.view.renderer().showCrossHairs(false);
        if (evt.isPopupTrigger()) ** GOTO lbl-1000
        v0 = this.movementMode;
        var2_2 = MouseMotionHandler$InterfaceMode$.MODULE$;
        if (!(v0 != null ? v0.equals(var2_2) == false : var2_2 != null) && Mouse$.MODULE$.hasButton1(evt)) {
            this.view.renderer().mouseDown(false);
        } else if (evt.isPopupTrigger()) {
            this.view.doPopup(evt);
        }
        this.view.display();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Observer observer = this.world().observer();
        double zoomDist = -((double)e.getUnitsToScroll());
        Perspective perspective = observer.perspective();
        if (perspective instanceof AgentFollowingPerspective) {
            Perspective afp = (Perspective)((Object)((AgentFollowingPerspective)((Object)perspective)));
            zoomDist = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(zoomDist), Int$.MODULE$.int2double(((AgentFollowingPerspective)((Object)afp)).followDistance()));
            int newDist = (int)((double)((AgentFollowingPerspective)((Object)afp)).followDistance() - zoomDist);
            if (newDist <= 100) {
                observer.setPerspective(Perspective$Follow$.MODULE$.apply(((AgentFollowingPerspective)((Object)afp)).targetAgent(), newDist));
            }
        } else {
            ObserverOrientation orientation = (ObserverOrientation)observer.orientation().get();
            double dist = orientation.dist();
            zoomDist = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(zoomDist), dist);
            observer.oxyandzcor(observer.oxcor() + zoomDist * orientation.dx(), observer.oycor() + zoomDist * orientation.dy(), observer.ozcor() - zoomDist * orientation.dz());
        }
        this.view.display();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        Mode mode = this.movementMode;
        MouseMotionHandler$InterfaceMode$ mouseMotionHandler$InterfaceMode$ = MouseMotionHandler$InterfaceMode$.MODULE$;
        if (!(mode != null ? !mode.equals(mouseMotionHandler$InterfaceMode$) : mouseMotionHandler$InterfaceMode$ != null)) {
            this.view.renderer().mouseDown(true);
            this.view.renderer().setMouseCors(evt.getPoint());
            this.view.renderer().mouseInside(Int$.MODULE$.int2double(evt.getX()), Int$.MODULE$.int2double(evt.getY()));
            return;
        }
        this.handleDrag(evt);
    }

    private void handleDrag(MouseEvent evt) {
        MouseMotionHandler$TranslateMode$ mode = evt.isAltDown() ? MouseMotionHandler$TranslateMode$.MODULE$ : (evt.isShiftDown() ? MouseMotionHandler$ZoomMode$.MODULE$ : this.movementMode);
        int x = evt.getX();
        int y = evt.getY();
        float thetaX = (float)(x - this.prevMouseX) / 2.0f;
        float thetaY = (float)(this.prevMouseY - y) / 2.0f;
        this.prevMouseX = x;
        this.prevMouseY = y;
        Observer observer = this.world().observer();
        Perspective perspective = observer.perspective();
        if (perspective instanceof AgentFollowingPerspective) {
            Perspective afp = (Perspective)((Object)((AgentFollowingPerspective)((Object)perspective)));
            int newDist = (int)((float)((AgentFollowingPerspective)((Object)afp)).followDistance() - thetaY);
            if (newDist >= 0 && newDist <= 100) {
                observer.setPerspective(Perspective$Follow$.MODULE$.apply(((AgentFollowingPerspective)((Object)afp)).targetAgent(), newDist));
            }
        } else {
            MouseMotionHandler$TranslateMode$ mouseMotionHandler$TranslateMode$ = mode;
            if (MouseMotionHandler$OrbitMode$.MODULE$.equals(mouseMotionHandler$TranslateMode$)) {
                observer.orbitRight(Float$.MODULE$.float2double(-thetaX));
                observer.orbitUp(Float$.MODULE$.float2double(-thetaY));
            } else if (MouseMotionHandler$ZoomMode$.MODULE$.equals(mouseMotionHandler$TranslateMode$)) {
                ObserverOrientation orientation = (ObserverOrientation)observer.orientation().get();
                if ((double)thetaY < orientation.dist()) {
                    observer.oxyandzcor(observer.oxcor() + (double)thetaY * orientation.dx(), observer.oycor() + (double)thetaY * orientation.dy(), observer.ozcor() - (double)thetaY * orientation.dz());
                }
            } else if (MouseMotionHandler$TranslateMode$.MODULE$.equals(mouseMotionHandler$TranslateMode$)) {
                observer.translate(Float$.MODULE$.float2double(thetaX), Float$.MODULE$.float2double(thetaY));
            } else if (!MouseMotionHandler$InterfaceMode$.MODULE$.equals(mouseMotionHandler$TranslateMode$)) {
                throw new MatchError((Object)mouseMotionHandler$TranslateMode$);
            }
        }
        this.view.display();
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        Mode mode = this.movementMode;
        MouseMotionHandler$InterfaceMode$ mouseMotionHandler$InterfaceMode$ = MouseMotionHandler$InterfaceMode$.MODULE$;
        if (!(mode != null ? !mode.equals(mouseMotionHandler$InterfaceMode$) : mouseMotionHandler$InterfaceMode$ != null)) {
            this.view.renderer().setMouseCors(evt.getPoint());
            this.view.renderer().mouseInside(Int$.MODULE$.int2double(evt.getX()), Int$.MODULE$.int2double(evt.getY()));
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    public static interface Mode {
    }
}

