/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.headless;

import java.io.Serializable;
import java.util.Locale;
import org.nlogo.agent.BooleanConstraint;
import org.nlogo.agent.ChooserConstraint;
import org.nlogo.agent.CompilationManagement;
import org.nlogo.agent.ConstantSliderConstraint;
import org.nlogo.agent.InputBoxConstraint;
import org.nlogo.agent.NumericConstraint;
import org.nlogo.api.LabProtocol;
import org.nlogo.api.LogoException;
import org.nlogo.api.NetLogoLegacyDialect$;
import org.nlogo.api.NetLogoThreeDDialect$;
import org.nlogo.api.PlotCompilationErrorAction;
import org.nlogo.api.PlotCompilationErrorAction$Ignore$;
import org.nlogo.api.PlotCompilationErrorAction$Output$;
import org.nlogo.api.PlotCompilationErrorAction$Throw$;
import org.nlogo.api.PreviewCommands;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.ValueConstraint;
import org.nlogo.api.Version$;
import org.nlogo.core.Button;
import org.nlogo.core.CompilerException;
import org.nlogo.core.ConstraintSpecification;
import org.nlogo.core.ConstraintSpecification$BooleanConstraintSpecification$;
import org.nlogo.core.ConstraintSpecification$BoundedNumericConstraintSpecification$;
import org.nlogo.core.ConstraintSpecification$ChoiceConstraintSpecification$;
import org.nlogo.core.ConstraintSpecification$NumericConstraintSpecification$;
import org.nlogo.core.ConstraintSpecification$NumericInputConstraintSpecification$;
import org.nlogo.core.ConstraintSpecification$StringInputConstraintSpecification$;
import org.nlogo.core.Dialect;
import org.nlogo.core.LogoList$;
import org.nlogo.core.Model;
import org.nlogo.core.Monitor;
import org.nlogo.core.OptionalSection;
import org.nlogo.core.Plot;
import org.nlogo.core.Program;
import org.nlogo.core.Program$;
import org.nlogo.core.Shape;
import org.nlogo.core.Widget;
import org.nlogo.headless.HeadlessWorkspace;
import org.nlogo.nvm.CompilerResults;
import org.nlogo.nvm.Procedure;
import org.nlogo.plot.PlotLoader$;
import org.nlogo.shape.LinkShape$;
import org.nlogo.shape.ShapeConverter$;
import org.nlogo.shape.VectorShape$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;

public class HeadlessModelOpener {
    private final HeadlessWorkspace ws;

    public HeadlessModelOpener(HeadlessWorkspace ws) {
        this.ws = ws;
    }

    public void openFromModel(Model model, boolean shouldAutoInstallLibs) throws LogoException, CompilerException {
        if (this.ws.modelOpened()) {
            throw new IllegalStateException();
        }
        this.ws.setOpenModel(model);
        if (!Version$.MODULE$.compatibleVersion(model.version())) {
            throw new IllegalStateException("unknown NetLogo version: " + model.version());
        }
        this.ws.loadWorld(model.view(), this.ws);
        model.plots().foreach((Function1 & Serializable)plot -> PlotLoader$.MODULE$.loadPlot((Plot)plot, this.ws.plotManager().newPlot("")));
        Dialect dialect = Version$.MODULE$.is3D(model.version()) ? NetLogoThreeDDialect$.MODULE$ : NetLogoLegacyDialect$.MODULE$;
        this.ws.aggregateManager().load(model, this.ws);
        Seq additionalSources = this.ws.aggregateManager().isLoaded() ? (Seq)((SeqOps)new .colon.colon((Object)this.ws.aggregateManager(), (List)Nil$.MODULE$)) : (Seq)((SeqOps)Nil$.MODULE$);
        String code = model.code();
        Program program = Program$.MODULE$.fromDialect(dialect);
        Program newProg = program.copy(model.interfaceGlobals(), program.copy$default$2(), program.copy$default$3(), program.copy$default$4(), program.copy$default$5(), program.copy$default$6(), program.copy$default$7(), program.copy$default$8());
        CompilerResults results = this.ws.compiler().compileProgram(code, (Seq<SourceOwner>)additionalSources, newProg, this.ws.getExtensionManager(), this.ws.getLibraryManager(), this.ws.getCompilationEnvironment(), shouldAutoInstallLibs);
        this.ws.procedures_$eq((ListMap)results.proceduresMap());
        this.ws.codeBits.clear();
        model.optionalSectionValue("org.nlogo.modelsection.previewcommands", ClassTag$.MODULE$.apply(OptionalSection.class)).foreach(_$1 -> this.ws.setPreviewCommands((PreviewCommands)_$1));
        this.attachWorldShapes(model.turtleShapes(), model.linkShapes());
        this.ws.getPrimaryWorkspace().getExperimentManager().setGUIExperiments((Seq<LabProtocol>)((Seq)model.optionalSectionValue("org.nlogo.modelsection.behaviorspace", ClassTag$.MODULE$.apply(OptionalSection.class)).getOrElse(HeadlessModelOpener::openFromModel$$anonfun$3)));
        if (model.hasValueForOptionalSection("org.nlogo.modelsection.hubnetclient")) {
            this.ws.getHubNetManager().foreach(_$2 -> _$2.load(model));
        }
        this.ws.init();
        ((CompilationManagement)((Object)this.ws.world())).program(results.program());
        if (this.ws.compilerTestingMode()) {
            this.testCompileWidgets((Seq<Button>)((Seq)model.widgets().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Widget x) {
                    Widget widget = x;
                    if (widget instanceof Button) {
                        Button b = (Button)widget;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Widget x, Function1 function1) {
                    Widget widget = x;
                    if (widget instanceof Button) {
                        Button b = (Button)widget;
                        return b;
                    }
                    return function1.apply((Object)x);
                }
            })), (Seq<Monitor>)((Seq)model.widgets().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Widget x) {
                    Widget widget = x;
                    if (widget instanceof Monitor) {
                        Monitor m = (Monitor)widget;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Widget x, Function1 function1) {
                    Widget widget = x;
                    if (widget instanceof Monitor) {
                        Monitor m = (Monitor)widget;
                        return m;
                    }
                    return function1.apply((Object)x);
                }
            })));
            return;
        }
        this.finish(model.constraints(), results.program(), model.interfaceGlobalCommands().mkString("\n"), this.ws.getPlotCompilationErrorAction());
    }

    public boolean openFromModel$default$2() {
        return false;
    }

    private void attachWorldShapes(Seq<Shape.VectorShape> turtleShapes, Seq<Shape.LinkShape> linkShapes) {
        this.ws.world().turtleShapes().replaceShapes((Iterable<Shape>)((Iterable)turtleShapes.map((Function1 & Serializable)v -> ShapeConverter$.MODULE$.baseVectorShapeToVectorShape((Shape.VectorShape)v))));
        if (turtleShapes.isEmpty()) {
            this.ws.world().turtleShapes().add(VectorShape$.MODULE$.getDefaultShape());
        }
        this.ws.world().linkShapes().replaceShapes((Iterable<Shape>)((Iterable)linkShapes.map((Function1 & Serializable)l -> ShapeConverter$.MODULE$.baseLinkShapeToLinkShape((Shape.LinkShape)l))));
        if (linkShapes.isEmpty()) {
            this.ws.world().linkShapes().add(LinkShape$.MODULE$.getDefaultLinkShape());
            return;
        }
    }

    private void finish(Map<String, ConstraintSpecification> constraints, Program program, String interfaceGlobalCommands, PlotCompilationErrorAction plotCompilationErrorAction) {
        this.ws.world().realloc();
        List<CompilerException> errors = this.ws.plotManager().compileAllPlots();
        if (errors.nonEmpty()) {
            PlotCompilationErrorAction plotCompilationErrorAction2 = plotCompilationErrorAction;
            if (PlotCompilationErrorAction$Throw$.MODULE$.equals(plotCompilationErrorAction2)) {
                throw (Throwable)errors.apply(0);
            }
            if (PlotCompilationErrorAction$Output$.MODULE$.equals(plotCompilationErrorAction2)) {
                errors.foreach(x -> Predef$.MODULE$.println(x));
            } else if (!PlotCompilationErrorAction$Ignore$.MODULE$.equals(plotCompilationErrorAction2)) {
                throw new MatchError((Object)plotCompilationErrorAction2);
            }
        }
        constraints.foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Option<Double> option;
                ValueConstraint valueConstraint;
                String vname = (String)tuple2._1();
                ConstraintSpecification spec = (ConstraintSpecification)tuple2._2();
                ConstraintSpecification constraintSpecification = spec;
                if (constraintSpecification instanceof ConstraintSpecification.BoundedNumericConstraintSpecification) {
                    ConstraintSpecification.BoundedNumericConstraintSpecification boundedNumericConstraintSpecification = ConstraintSpecification$BoundedNumericConstraintSpecification$.MODULE$.unapply((ConstraintSpecification.BoundedNumericConstraintSpecification)constraintSpecification);
                    Double d = boundedNumericConstraintSpecification._1();
                    Double d2 = boundedNumericConstraintSpecification._2();
                    Double d3 = boundedNumericConstraintSpecification._3();
                    Double d4 = boundedNumericConstraintSpecification._4();
                    Double min = d;
                    Double d5 = d2;
                    Double max = d3;
                    Double step = d4;
                    ConstantSliderConstraint constraint = new ConstantSliderConstraint(min, max, step);
                    constraint.defaultValue_$eq(Predef$.MODULE$.double2Double(d5.doubleValue()));
                    valueConstraint = constraint;
                } else if (constraintSpecification instanceof ConstraintSpecification.NumericConstraintSpecification && !(option = ConstraintSpecification$NumericConstraintSpecification$.MODULE$.unapply((ConstraintSpecification.NumericConstraintSpecification)constraintSpecification)).isEmpty()) {
                    Double d;
                    Double d6 = d = (Double)option.get();
                    valueConstraint = new NumericConstraint(d6);
                } else if (constraintSpecification instanceof ConstraintSpecification.ChoiceConstraintSpecification) {
                    ConstraintSpecification.ChoiceConstraintSpecification choiceConstraintSpecification = ConstraintSpecification$ChoiceConstraintSpecification$.MODULE$.unapply((ConstraintSpecification.ChoiceConstraintSpecification)constraintSpecification);
                    List<Object> list = choiceConstraintSpecification._1();
                    int n = choiceConstraintSpecification._2();
                    List<Object> vals = list;
                    int defaultIndex = n;
                    valueConstraint = new ChooserConstraint(LogoList$.MODULE$.fromIterator((Iterator<? extends Object>)vals.iterator()), defaultIndex);
                } else if (constraintSpecification instanceof ConstraintSpecification.BooleanConstraintSpecification) {
                    Boolean bl;
                    ConstraintSpecification.BooleanConstraintSpecification booleanConstraintSpecification = ConstraintSpecification$BooleanConstraintSpecification$.MODULE$.unapply((ConstraintSpecification.BooleanConstraintSpecification)constraintSpecification);
                    Boolean bl2 = bl = booleanConstraintSpecification._1();
                    valueConstraint = new BooleanConstraint(bl2);
                } else if (constraintSpecification instanceof ConstraintSpecification.StringInputConstraintSpecification) {
                    ConstraintSpecification.StringInputConstraintSpecification stringInputConstraintSpecification = ConstraintSpecification$StringInputConstraintSpecification$.MODULE$.unapply((ConstraintSpecification.StringInputConstraintSpecification)constraintSpecification);
                    String string = stringInputConstraintSpecification._1();
                    String string2 = stringInputConstraintSpecification._2();
                    String typeName = string;
                    String string3 = string2;
                    valueConstraint = new InputBoxConstraint(typeName, string3);
                } else if (constraintSpecification instanceof ConstraintSpecification.NumericInputConstraintSpecification) {
                    ConstraintSpecification.NumericInputConstraintSpecification numericInputConstraintSpecification = ConstraintSpecification$NumericInputConstraintSpecification$.MODULE$.unapply((ConstraintSpecification.NumericInputConstraintSpecification)constraintSpecification);
                    String string = numericInputConstraintSpecification._1();
                    Double d = numericInputConstraintSpecification._2();
                    String typeName = string;
                    Double d7 = d;
                    valueConstraint = new InputBoxConstraint(typeName, d7);
                } else {
                    throw new IllegalStateException();
                }
                ValueConstraint con = valueConstraint;
                this.ws.world().observer().setConstraint(this.ws.world().observerOwnsIndexOf(vname.toUpperCase(Locale.ENGLISH)), con);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.ws.command(interfaceGlobalCommands);
    }

    private void testCompileWidgets(Seq<Button> buttons, Seq<Monitor> monitors) {
        List<CompilerException> errors = this.ws.plotManager().compileAllPlots();
        if (errors.nonEmpty()) {
            throw (Throwable)errors.apply(0);
        }
        buttons.foreach(button -> button.source().foreach((Function1 & Serializable)source -> {
            Procedure procedure;
            try {
                procedure = this.ws.compileCommands((String)source, button.buttonKind());
            }
            catch (CompilerException ex) {
                Predef$.MODULE$.println((Object)("compiling: \"" + button + "\""));
                throw ex;
            }
            return procedure;
        }));
        monitors.foreach(monitor -> monitor.source().foreach((Function1 & Serializable)source -> {
            Procedure procedure;
            try {
                procedure = this.ws.compileReporter((String)source);
            }
            catch (CompilerException ex) {
                Predef$.MODULE$.println((Object)("compiling: \"" + monitor + "\""));
                throw ex;
            }
            return procedure;
        }));
    }

    private static final Seq openFromModel$$anonfun$3() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }
}

