/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;
import javax.swing.JFrame;
import org.nlogo.analytics.Analytics$;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.ExtensionManager;
import org.nlogo.awt.EventQueue$;
import org.nlogo.awt.Hierarchy$;
import org.nlogo.awt.Images$;
import org.nlogo.awt.Positioning$;
import org.nlogo.core.I18N$;
import org.nlogo.hubnet.client.ClientApp$;
import org.nlogo.hubnet.client.ClientPanel;
import org.nlogo.hubnet.client.ErrorHandler;
import org.nlogo.hubnet.client.LoginCallback;
import org.nlogo.hubnet.client.LoginDialog;
import org.nlogo.hubnet.client.RoboClientPanel;
import org.nlogo.swing.Implicits$;
import org.nlogo.swing.ModalProgress;
import org.nlogo.swing.ModalProgressPanel;
import org.nlogo.swing.ModalProgressTask$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.window.ClientAppInterface;
import org.nlogo.window.DefaultEditorFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

public class ClientApp
extends JFrame
implements ErrorHandler,
ClientAppInterface,
ModalProgress {
    private ModalProgressPanel org$nlogo$swing$ModalProgress$$panel;
    private Option org$nlogo$swing$ModalProgress$$loop;
    private ClientPanel clientPanel;
    private LoginDialog loginDialog;
    private boolean isLocal;

    public static void mainHelper(String[] stringArray, CompilerServices compilerServices, ExtensionManager extensionManager) {
        ClientApp$.MODULE$.mainHelper(stringArray, compilerServices, extensionManager);
    }

    public ClientApp() {
        super("HubNet");
        ModalProgress.$init$(this);
        this.clientPanel = null;
        this.loginDialog = null;
        this.isLocal = false;
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        Statics.releaseFence();
    }

    @Override
    public ModalProgressPanel org$nlogo$swing$ModalProgress$$panel() {
        return this.org$nlogo$swing$ModalProgress$$panel;
    }

    public Option org$nlogo$swing$ModalProgress$$loop() {
        return this.org$nlogo$swing$ModalProgress$$loop;
    }

    public void org$nlogo$swing$ModalProgress$$loop_$eq(Option x$1) {
        this.org$nlogo$swing$ModalProgress$$loop = x$1;
    }

    @Override
    public void org$nlogo$swing$ModalProgress$_setter_$org$nlogo$swing$ModalProgress$$panel_$eq(ModalProgressPanel x$0) {
        this.org$nlogo$swing$ModalProgress$$panel = x$0;
    }

    @Override
    public void startup(String userid, String hostip, int port, boolean isLocal, boolean isRobo, long waitTime, CompilerServices compiler, ExtensionManager extensionManager) {
        DefaultEditorFactory editorFactory = new DefaultEditorFactory(compiler);
        EventQueue$.MODULE$.invokeLater(() -> {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    Exceptions$.MODULE$.handle(e);
                }
            });
            this.isLocal = isLocal;
            this.setIconImage(Images$.MODULE$.loadImageResource("/images/hubnet.png"));
            this.getContentPane().setLayout(new BorderLayout());
            this.loginDialog = new LoginDialog((Frame)this, userid, hostip, port);
            this.clientPanel = isRobo ? new RoboClientPanel(editorFactory, this, waitTime, compiler, extensionManager) : new ClientPanel(editorFactory, this, compiler, extensionManager);
            this.getContentPane().add((Component)this.clientPanel, "Center");
            this.pack();
            Positioning$.MODULE$.center(this, null);
            this.syncTheme();
            if (isLocal) {
                JFunction0.mcV.sp & Serializable killLocalListener = (JFunction0.mcV.sp & Serializable)() -> {
                    this.clientPanel.logout();
                    this.dispose();
                };
                this.addWindowListener(Implicits$.MODULE$.thunk2windowAdapter(killLocalListener));
                this.loginDialog.addWindowListener(Implicits$.MODULE$.thunk2windowAdapter(killLocalListener));
                this.org$nlogo$hubnet$client$ClientApp$$login("Local " + ++ClientApp$.org$nlogo$hubnet$client$ClientApp$$$localClientIndex, hostip, port);
                return;
            }
            this.addWindowListener(Implicits$.MODULE$.thunk2windowAdapter((JFunction0.mcV.sp & Serializable)() -> this.handleExit()));
            Positioning$.MODULE$.center(this.loginDialog, null);
            this.loginDialog.addWindowListener(Implicits$.MODULE$.thunk2windowAdapter((JFunction0.mcV.sp & Serializable)() -> this.handleQuit()));
            this.doLogin();
        });
    }

    private void doLogin() {
        if (!this.isLocal) {
            this.loginDialog.go(new LoginCallback(this){
                private final /* synthetic */ ClientApp $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void apply(String user, String host, int port) {
                    this.$outer.org$nlogo$hubnet$client$ClientApp$$login(user, host, port);
                }
            });
            return;
        }
    }

    @Override
    public void completeLogin() {
        this.setVisible(true);
    }

    public void org$nlogo$hubnet$client$ClientApp$$login(String userid, String hostip, int port) {
        ObjectRef exs = ObjectRef.create((Object)None$.MODULE$);
        ModalProgressTask$.MODULE$.onUIThread(Hierarchy$.MODULE$.getFrame(this), "Entering...", () -> {
            exs$1.elem = this.clientPanel.login(userid, hostip, port);
        });
        Option option = (Option)exs.elem;
        if (option instanceof Some) {
            String ex = (String)((Some)option).value();
            this.handleLoginFailure(ex);
            this.clientPanel.disconnect(ex.toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.loginDialog.setVisible(false);
            this.clientPanel.requestFocus();
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean showExitMessage(String title, String message) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        return new OptionPane(this.loginDialog, title, message, OptionPane$Options$.MODULE$.OkCancel(), OptionPane$Icons$.MODULE$.Info()).getSelectedIndex() == 0;
    }

    @Override
    public void handleDisconnect(String activityName, boolean connected, String reason) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        if (this.isLocal) {
            this.dispose();
            return;
        }
        if (connected) {
            new OptionPane(this, I18N$.MODULE$.gui().get("edit.hubnet.disconnected"), I18N$.MODULE$.gui().getN("edit.hubnet.disconnected.message", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{activityName})), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Info());
            this.dispose();
            this.doLogin();
            return;
        }
    }

    @Override
    public void handleLoginFailure(String errorMessage) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        new OptionPane(this, I18N$.MODULE$.gui().get("edit.hubnet.loginFailed"), errorMessage, OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
        this.loginDialog.setVisible(true);
    }

    public void handleExit() {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        if (this.showExitMessage(I18N$.MODULE$.gui().get("edit.hubnet.exit"), I18N$.MODULE$.gui().get("edit.hubnet.exit.message"))) {
            this.clientPanel.logout();
            this.setVisible(false);
            this.dispose();
            this.doLogin();
            return;
        }
    }

    public void handleQuit() {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        boolean shouldExit = this.showExitMessage(I18N$.MODULE$.gui().get("edit.hubnet.quit"), I18N$.MODULE$.gui().get("edit.hubnet.quit.message"));
        if (shouldExit) {
            System.exit(0);
            return;
        }
    }

    @Override
    public void syncTheme() {
        this.getContentPane().setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.clientPanel.syncTheme();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            Analytics$.MODULE$.hubNetClientOpen();
        }
        super.setVisible(visible);
    }
}

