/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.client;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import org.nlogo.agent.AbstractExporter;
import org.nlogo.agent.ConstantSliderConstraint;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.DummyLogoThunkFactory;
import org.nlogo.api.Dump$;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.HubNetInterface;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.PlotState;
import org.nlogo.api.Version$;
import org.nlogo.awt.EventQueue$;
import org.nlogo.awt.Hierarchy$;
import org.nlogo.core.I18N$;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.core.Shape;
import org.nlogo.hubnet.client.ClientAWTEvent;
import org.nlogo.hubnet.client.ClientAWTExceptionEvent;
import org.nlogo.hubnet.client.ClientGUI;
import org.nlogo.hubnet.client.ClientView;
import org.nlogo.hubnet.client.ErrorHandler;
import org.nlogo.hubnet.connection.AbstractConnection;
import org.nlogo.hubnet.connection.ConnectionTypes$;
import org.nlogo.hubnet.connection.Streamable$;
import org.nlogo.hubnet.mirroring.HubNetLine;
import org.nlogo.hubnet.mirroring.HubNetLinkStamp;
import org.nlogo.hubnet.mirroring.HubNetPlotPoint;
import org.nlogo.hubnet.mirroring.HubNetTurtleStamp;
import org.nlogo.hubnet.mirroring.OverrideList;
import org.nlogo.hubnet.protocol.ActivityCommand;
import org.nlogo.hubnet.protocol.AgentPerspectiveMessage;
import org.nlogo.hubnet.protocol.AgentPerspectiveMessage$;
import org.nlogo.hubnet.protocol.ClearOverrideMessage$;
import org.nlogo.hubnet.protocol.ComputerInterface;
import org.nlogo.hubnet.protocol.DisableView$;
import org.nlogo.hubnet.protocol.EnterMessage$;
import org.nlogo.hubnet.protocol.ExitMessage;
import org.nlogo.hubnet.protocol.ExitMessage$;
import org.nlogo.hubnet.protocol.HandshakeFromClient;
import org.nlogo.hubnet.protocol.HandshakeFromServer;
import org.nlogo.hubnet.protocol.LoginFailure;
import org.nlogo.hubnet.protocol.LoginFailure$;
import org.nlogo.hubnet.protocol.Message;
import org.nlogo.hubnet.protocol.OverrideMessage;
import org.nlogo.hubnet.protocol.OverrideMessage$;
import org.nlogo.hubnet.protocol.PlotControl;
import org.nlogo.hubnet.protocol.PlotControl$;
import org.nlogo.hubnet.protocol.PlotUpdate;
import org.nlogo.hubnet.protocol.PlotUpdate$;
import org.nlogo.hubnet.protocol.Text;
import org.nlogo.hubnet.protocol.Text$;
import org.nlogo.hubnet.protocol.Text$MessageType$CLEAR$;
import org.nlogo.hubnet.protocol.Text$MessageType$TEXT$;
import org.nlogo.hubnet.protocol.Text$MessageType$USER$;
import org.nlogo.hubnet.protocol.ViewUpdate;
import org.nlogo.hubnet.protocol.ViewUpdate$;
import org.nlogo.hubnet.protocol.WidgetControl;
import org.nlogo.hubnet.protocol.WidgetControl$;
import org.nlogo.plot.CorePlotExporter;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotManager;
import org.nlogo.plot.PlotPen;
import org.nlogo.plot.PlotPoint;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.Transparent;
import org.nlogo.theme.ThemeSync;
import org.nlogo.util.Utils$;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.EditorFactory;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.NetLogoExecutionContext$;
import org.nlogo.window.PlotWidget;
import org.nlogo.window.PlotWidgetExport;
import org.nlogo.window.PlotWidgetExport$ExportAllPlots$;
import org.nlogo.window.PlotWidgetExport$ExportSinglePlot$;
import org.nlogo.window.Widget;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ClientPanel
extends JPanel
implements Transparent,
Events.AddJobEvent.Handler,
Events.ExportPlotEvent.Handler,
Events.InterfaceGlobalEvent.Handler,
Events.AddSliderConstraintEvent.Handler,
ThemeSync {
    private final EditorFactory editorFactory;
    private final ErrorHandler errorHandler;
    private final CompilerServices compiler;
    private final ExtensionManager extensionManager;
    private Option<ClientGUI> clientGUI;
    private Option<ClientView> viewWidget;
    private final PlotManager plotManager;
    private String userid;
    private String hostip;
    private int port;
    private String activityName;
    private Listener listener;
    private final AtomicBoolean connected;

    public ClientPanel(EditorFactory editorFactory, ErrorHandler errorHandler, CompilerServices compiler, ExtensionManager extensionManager) {
        this.editorFactory = editorFactory;
        this.errorHandler = errorHandler;
        this.compiler = compiler;
        this.extensionManager = extensionManager;
        super(new BorderLayout());
        Transparent.$init$(this);
        this.clientGUI = None$.MODULE$;
        this.viewWidget = None$.MODULE$;
        this.plotManager = new PlotManager(new DummyLogoThunkFactory(), new MersenneTwisterFast());
        this.userid = null;
        this.hostip = null;
        this.port = 0;
        this.activityName = null;
        this.listener = null;
        this.connected = new AtomicBoolean(false);
    }

    public Option<ClientGUI> clientGUI() {
        return this.clientGUI;
    }

    public void clientGUI_$eq(Option<ClientGUI> x$1) {
        this.clientGUI = x$1;
    }

    public Option<ClientView> viewWidget() {
        return this.viewWidget;
    }

    public void viewWidget_$eq(Option<ClientView> x$1) {
        this.viewWidget = x$1;
    }

    public void setDisplayOn(boolean on) {
        this.viewWidget().foreach(_$1 -> _$1.setDisplayOn(on));
    }

    public void sendMouseMessage(double mouseXCor, double mouseYCor, boolean down) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        LogoList coords = LogoList$.MODULE$.apply((scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToDouble((double)mouseXCor), BoxesRunTime.boxToDouble((double)mouseYCor)}));
        this.sendDataAndWait(new ActivityCommand(down ? "View" : "Mouse Up", coords));
    }

    public void handlePlotUpdate(PlotInterface msg) {
        this.clientGUI().foreach(gui -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])gui.getInterfaceComponents());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Component x) {
                    Component component = x;
                    if (component instanceof PlotWidget) {
                        PlotWidget pw = (PlotWidget)component;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Component x, Function1 function1) {
                    Component component = x;
                    if (component instanceof PlotWidget) {
                        PlotWidget pw = (PlotWidget)component;
                        return pw;
                    }
                    return function1.apply((Object)x);
                }
            }, ClassTag$.MODULE$.apply(PlotWidget.class)));
            ArrayOps$.MODULE$.foreach$extension(object2, pw -> {
                String string = pw.plot().name();
                String string2 = msg.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    pw.plot().clear();
                    this.updatePlot((Plot)msg, pw.plot());
                    pw.makeDirty();
                    pw.repaintIfNeeded();
                    return;
                }
            });
        });
    }

    private void updatePlot(Plot plot1, Plot plot2) {
        plot2.currentPen_$eq(plot2.getPen(((PlotPen)plot1.currentPen().get()).name()));
        plot2.state_$eq(plot1.state());
        plot1.pens().foreach(pen1 -> {
            PlotPen pen2 = pen1.temporary() ? plot2.createPlotPen(pen1.name(), true) : (PlotPen)plot2.getPen(pen1.name()).get();
            pen2.x_$eq(pen1.x());
            pen2.color_$eq(pen1.color());
            pen2.interval_$eq(pen1.interval());
            pen2.isDown_$eq(pen1.isDown());
            pen2.mode_$eq(pen1.mode());
            pen2.points_$eq((Vector<PlotPoint>)((Vector)pen2.points().$plus$plus(pen1.points())));
        });
    }

    @Override
    public void handle(Events.AddJobEvent e) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        ButtonWidget button = (ButtonWidget)e.owner;
        this.sendDataAndWait(new ActivityCommand(button.displayName(), BoxesRunTime.boxToBoolean((boolean)button.foreverOn())));
        button.popUpStoppingButton();
    }

    @Override
    public void handle(Events.ExportPlotEvent e) {
        PlotWidgetExport plotWidgetExport = e.plotExport;
        if (PlotWidgetExport$ExportAllPlots$.MODULE$.equals(plotWidgetExport)) {
            throw new UnsupportedOperationException("can't export all plots yet.");
        }
        if (plotWidgetExport instanceof PlotWidgetExport.ExportSinglePlot) {
            PlotWidgetExport.ExportSinglePlot exportSinglePlot = PlotWidgetExport$ExportSinglePlot$.MODULE$.unapply((PlotWidgetExport.ExportSinglePlot)plotWidgetExport);
            Plot plot = exportSinglePlot._1();
            Plot plot2 = plot;
            if (plot2 != null) {
                Future$.MODULE$.successful((Object)e.exportFilename).foreach(filename -> {
                    try {
                        new AbstractExporter((String)filename, plot2){
                            private final Plot plot$3;
                            {
                                this.plot$3 = plot$1;
                                super(filename$1);
                            }

                            public void export(PrintWriter writer) {
                                new CorePlotExporter(this.plot$3, Dump$.MODULE$.csv()).export(writer);
                            }
                        }.export("plot", "HubNet Client", "");
                    }
                    catch (IOException ex) {
                        Exceptions$.MODULE$.handle(ex);
                    }
                }, NetLogoExecutionContext$.MODULE$.backgroundExecutionContext());
                return;
            }
            return;
        }
        throw new MatchError((Object)plotWidgetExport);
    }

    @Override
    public void handle(Events.InterfaceGlobalEvent e) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        this.sendDataAndWait(new ActivityCommand(e.widget.name(), e.widget.valueObject()));
    }

    @Override
    public void handle(Events.AddSliderConstraintEvent e) {
        e.slider.setSliderConstraint(new ConstantSliderConstraint(e){
            {
                this.defaultValue_$eq(e$1.value);
            }
        });
    }

    private void handleWidgetControlMessage(Object value, String widgetName) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        String string = widgetName;
        String string2 = "VIEW";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Object object = value;
            if (object instanceof HubNetTurtleStamp) {
                HubNetTurtleStamp t = (HubNetTurtleStamp)object;
                this.viewWidget().foreach(_$2 -> _$2.renderer().stamp(t));
            } else if (object instanceof HubNetLinkStamp) {
                HubNetLinkStamp ls = (HubNetLinkStamp)object;
                this.viewWidget().foreach(_$3 -> _$3.renderer().stamp(ls));
            } else if (object instanceof HubNetLine) {
                HubNetLine l = (HubNetLine)object;
                this.viewWidget().foreach(_$4 -> _$4.renderer().drawLine(l));
            } else {
                this.viewWidget().foreach(_$5 -> _$5.renderer().clearDrawing());
            }
        } else {
            String string3 = widgetName;
            String string4 = "ALL PLOTS";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                this.plotManager.clearAll();
                this.clientGUI().foreach(gui -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])gui.getInterfaceComponents());
                    Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(Component x) {
                            Component component = x;
                            if (component instanceof PlotWidget) {
                                PlotWidget pw = (PlotWidget)component;
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(Component x, Function1 function1) {
                            Component component = x;
                            if (component instanceof PlotWidget) {
                                PlotWidget pw = (PlotWidget)component;
                                return pw;
                            }
                            return function1.apply((Object)x);
                        }
                    }, ClassTag$.MODULE$.apply(PlotWidget.class)));
                    ArrayOps$.MODULE$.foreach$extension(object2, pw -> {
                        pw.makeDirty();
                        pw.repaintIfNeeded();
                    });
                });
            }
        }
        this.clientGUI().foreach(gui -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])gui.getInterfaceComponents());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(widgetName){
                private final String widgetName$2;
                {
                    this.widgetName$2 = widgetName$3;
                }

                public final boolean isDefinedAt(Component x) {
                    Component component = x;
                    if (component instanceof Widget) {
                        Widget w = (Widget)component;
                        String string = w.displayName();
                        String string2 = this.widgetName$2;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Component x, Function1 function1) {
                    Component component = x;
                    if (component instanceof Widget) {
                        Widget w = (Widget)component;
                        String string = w.displayName();
                        String string2 = this.widgetName$2;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return w;
                        }
                    }
                    return function1.apply((Object)x);
                }
            }, ClassTag$.MODULE$.apply(Widget.class)));
            ArrayOps$.MODULE$.foreach$extension(object2, x$1 -> {
                Widget widget = x$1;
                if (widget instanceof InterfaceGlobalWidget) {
                    Widget i = (Widget)((Object)((InterfaceGlobalWidget)((Object)widget)));
                    ((InterfaceGlobalWidget)((Object)i)).valueObject(value);
                    return;
                }
                if (widget instanceof MonitorWidget) {
                    MonitorWidget m = (MonitorWidget)widget;
                    m.value(value);
                    return;
                }
            });
        });
    }

    private Option<Widget> findWidget(String name) {
        return this.clientGUI().flatMap((Function1 & Serializable)gui -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])gui.getInterfaceComponents());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(name){
                private final String name$2;
                {
                    this.name$2 = name$3;
                }

                public final boolean isDefinedAt(Component x) {
                    Component component = x;
                    if (component instanceof Widget) {
                        Widget w = (Widget)component;
                        String string = w.displayName();
                        String string2 = this.name$2;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Component x, Function1 function1) {
                    Component component = x;
                    if (component instanceof Widget) {
                        Widget w = (Widget)component;
                        String string = w.displayName();
                        String string2 = this.name$2;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return w;
                        }
                    }
                    return function1.apply((Object)x);
                }
            }, ClassTag$.MODULE$.apply(Widget.class)));
            return ArrayOps$.MODULE$.headOption$extension(object2);
        });
    }

    private void handlePlotControlMessage(Object value, String plotName) {
        Widget widget;
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        Option<Widget> option = this.findWidget(plotName);
        if (option instanceof Some && (widget = (Widget)((Some)option).value()) instanceof PlotWidget) {
            PlotWidget plotWidget = (PlotWidget)widget;
            Object object = value;
            if (object instanceof String) {
                String s = (String)object;
                plotWidget.plot().currentPen_$eq((PlotPen)plotWidget.plot().getPen(s).getOrElse(() -> ClientPanel.handlePlotControlMessage$$anonfun$1(plotWidget, s)));
                return;
            }
            if (object instanceof Integer) {
                int i = BoxesRunTime.unboxToInt((Object)object);
                ((PlotPen)plotWidget.plot().currentPen().get()).color_$eq(i);
                return;
            }
            if (object instanceof Boolean) {
                boolean b = BoxesRunTime.unboxToBoolean((Object)object);
                ((PlotPen)plotWidget.plot().currentPen().get()).isDown_$eq(b);
                plotWidget.makeDirty();
                plotWidget.repaintIfNeeded();
                return;
            }
            if (object instanceof HubNetPlotPoint) {
                HubNetPlotPoint p = (HubNetPlotPoint)object;
                if (p.specifiesXCor()) {
                    ((PlotPen)plotWidget.plot().currentPen().get()).plot(p.xcor(), p.ycor());
                } else {
                    ((PlotPen)plotWidget.plot().currentPen().get()).plot(p.ycor());
                }
                plotWidget.makeDirty();
                plotWidget.repaintIfNeeded();
                return;
            }
            if (object instanceof Character) {
                char c = BoxesRunTime.unboxToChar((Object)object);
                try {
                    char c2 = c;
                    switch (c2) {
                        case 'c': {
                            plotWidget.plot().clear();
                            plotWidget.makeDirty();
                            plotWidget.repaintIfNeeded();
                            break;
                        }
                        case 'r': {
                            ((PlotPen)plotWidget.plot().currentPen().get()).hardReset();
                            plotWidget.makeDirty();
                            plotWidget.repaintIfNeeded();
                            break;
                        }
                        case 'p': {
                            ((PlotPen)plotWidget.plot().currentPen().get()).softReset();
                            plotWidget.makeDirty();
                            plotWidget.repaintIfNeeded();
                            break;
                        }
                        case 'n': {
                            PlotState plotState = plotWidget.plot().state();
                            plotWidget.plot().state_$eq(plotState.copy(true, true, plotState.copy$default$3(), plotState.copy$default$4(), plotState.copy$default$5(), plotState.copy$default$6()));
                            break;
                        }
                        case 'f': {
                            PlotState plotState = plotWidget.plot().state();
                            plotWidget.plot().state_$eq(plotState.copy(false, false, plotState.copy$default$3(), plotState.copy$default$4(), plotState.copy$default$5(), plotState.copy$default$6()));
                            break;
                        }
                        case 'x': {
                            PlotState plotState = plotWidget.plot().state();
                            plotWidget.plot().state_$eq(plotState.copy(true, plotState.copy$default$2(), plotState.copy$default$3(), plotState.copy$default$4(), plotState.copy$default$5(), plotState.copy$default$6()));
                            break;
                        }
                        case 'z': {
                            PlotState plotState = plotWidget.plot().state();
                            plotWidget.plot().state_$eq(plotState.copy(false, plotState.copy$default$2(), plotState.copy$default$3(), plotState.copy$default$4(), plotState.copy$default$5(), plotState.copy$default$6()));
                            break;
                        }
                        case 'y': {
                            PlotState plotState = plotWidget.plot().state();
                            plotWidget.plot().state_$eq(plotState.copy(plotState.copy$default$1(), true, plotState.copy$default$3(), plotState.copy$default$4(), plotState.copy$default$5(), plotState.copy$default$6()));
                            break;
                        }
                        case 'w': {
                            PlotState plotState = plotWidget.plot().state();
                            plotWidget.plot().state_$eq(plotState.copy(plotState.copy$default$1(), false, plotState.copy$default$3(), plotState.copy$default$4(), plotState.copy$default$5(), plotState.copy$default$6()));
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                catch (RuntimeException ex) {
                    Exceptions$.MODULE$.handle(ex);
                }
                return;
            }
            if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                ((PlotPen)plotWidget.plot().currentPen().get()).mode_$eq(s);
                plotWidget.makeDirty();
                plotWidget.repaintIfNeeded();
                return;
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                ((PlotPen)plotWidget.plot().currentPen().get()).interval_$eq(d);
                return;
            }
            if (object instanceof List) {
                List list = (List)object;
                Object object2 = list.apply(0);
                if (BoxesRunTime.equals((Object)BoxesRunTime.boxToCharacter((char)'x'), (Object)object2)) {
                    double min = BoxesRunTime.unboxToDouble((Object)list.apply(1));
                    double max = BoxesRunTime.unboxToDouble((Object)list.apply(2));
                    PlotState plotState = plotWidget.plot().state();
                    plotWidget.plot().state_$eq(plotState.copy(plotState.copy$default$1(), plotState.copy$default$2(), min, max, plotState.copy$default$5(), plotState.copy$default$6()));
                    plotWidget.makeDirty();
                    plotWidget.repaintIfNeeded();
                    return;
                }
                double min = BoxesRunTime.unboxToDouble((Object)list.apply(1));
                double max = BoxesRunTime.unboxToDouble((Object)list.apply(2));
                PlotState plotState = plotWidget.plot().state();
                plotWidget.plot().state_$eq(plotState.copy(plotState.copy$default$1(), plotState.copy$default$2(), plotState.copy$default$3(), plotState.copy$default$4(), min, max));
                plotWidget.makeDirty();
                plotWidget.repaintIfNeeded();
                return;
            }
            throw new Exception("Unexpected message: " + value);
        }
    }

    public void completeLogin(HandshakeFromServer handshake) {
        this.errorHandler.completeLogin();
        this.activityName = handshake.activityName();
        this.clientGUI().foreach(x$0 -> this.remove((Component)x$0));
        this.plotManager.forgetAll();
        ClientView view = new ClientView(this);
        this.viewWidget_$eq((Option<ClientView>)Some$.MODULE$.apply((Object)view));
        ClientGUI gui = new ClientGUI(this.editorFactory, view, this.plotManager, this.compiler, this.extensionManager);
        this.clientGUI_$eq((Option<ClientGUI>)Some$.MODULE$.apply((Object)gui));
        this.add((Component)gui, "Center");
        gui.setStatus(this.userid, this.activityName, this.hostip, this.port);
        HubNetInterface.ClientInterface clientInterface = handshake.clientInterface();
        if (!(clientInterface instanceof ComputerInterface)) {
            throw new IllegalStateException();
        }
        ComputerInterface c = (ComputerInterface)clientInterface;
        ComputerInterface clientInterface2 = c;
        scala.collection.immutable.Seq<org.nlogo.core.Widget> widgets = clientInterface2.widgets();
        new Events.LoadWidgetsEvent(widgets, false).raise(this);
        new Events.AfterLoadEvent().raise(this);
        gui.setChoices((Map<String, LogoList>)clientInterface2.chooserChoices().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        view.renderer().replaceTurtleShapes((Seq<Shape>)clientInterface2.turtleShapes());
        view.renderer().replaceLinkShapes((Seq<Shape>)clientInterface2.linkShapes());
        this.sendDataAndWait(EnterMessage$.MODULE$);
        this.connected().set(true);
        EventQueue$.MODULE$.invokeLater(() -> {
            Hierarchy$.MODULE$.getFrame(this).pack();
            gui.requestFocus();
        });
    }

    public void handleProtocolMessage(Message message) {
        Message message2 = message;
        if (message2 instanceof HandshakeFromServer) {
            HandshakeFromServer h = (HandshakeFromServer)message2;
            this.completeLogin(h);
            return;
        }
        if (message2 instanceof LoginFailure) {
            String string;
            LoginFailure loginFailure = LoginFailure$.MODULE$.unapply((LoginFailure)message2);
            String content = string = loginFailure._1();
            this.handleLoginFailure(content);
            return;
        }
        if (message2 instanceof ExitMessage) {
            String string;
            ExitMessage exitMessage = ExitMessage$.MODULE$.unapply((ExitMessage)message2);
            String reason = string = exitMessage._1();
            this.disconnect(reason);
            return;
        }
        if (message2 instanceof WidgetControl) {
            WidgetControl widgetControl = WidgetControl$.MODULE$.unapply((WidgetControl)message2);
            Object object = widgetControl._1();
            String string = widgetControl._2();
            Object content = object;
            String tag = string;
            this.handleWidgetControlMessage(content, tag);
            return;
        }
        if (DisableView$.MODULE$.equals(message2)) {
            this.setDisplayOn(false);
            return;
        }
        if (message2 instanceof ViewUpdate) {
            byte[] byArray;
            ViewUpdate viewUpdate = ViewUpdate$.MODULE$.unapply((ViewUpdate)message2);
            byte[] worldData = byArray = viewUpdate._1();
            this.viewWidget().foreach(_$6 -> _$6.updateDisplay(worldData));
            return;
        }
        if (message2 instanceof PlotControl) {
            PlotControl plotControl = PlotControl$.MODULE$.unapply((PlotControl)message2);
            Object object = plotControl._1();
            String string = plotControl._2();
            Object content = object;
            String plotName = string;
            this.handlePlotControlMessage(content, plotName);
            return;
        }
        if (message2 instanceof PlotUpdate) {
            PlotInterface plotInterface;
            PlotUpdate plotUpdate = PlotUpdate$.MODULE$.unapply((PlotUpdate)message2);
            PlotInterface plot = plotInterface = plotUpdate._1();
            this.handlePlotUpdate(plot);
            return;
        }
        if (message2 instanceof OverrideMessage) {
            OverrideMessage overrideMessage = OverrideMessage$.MODULE$.unapply((OverrideMessage)message2);
            Object object = overrideMessage._1();
            boolean bl = overrideMessage._2();
            Object data = object;
            boolean clear = bl;
            this.viewWidget().foreach(_$7 -> _$7.handleOverrideList((OverrideList)data, clear));
            return;
        }
        if (ClearOverrideMessage$.MODULE$.equals(message2)) {
            this.viewWidget().foreach(_$8 -> _$8.clearOverrides());
            return;
        }
        if (message2 instanceof AgentPerspectiveMessage) {
            byte[] byArray;
            AgentPerspectiveMessage agentPerspectiveMessage = AgentPerspectiveMessage$.MODULE$.unapply((AgentPerspectiveMessage)message2);
            byte[] bytes = byArray = agentPerspectiveMessage._1();
            this.viewWidget().foreach(_$9 -> _$9.handleAgentPerspective(bytes));
            return;
        }
        if (message2 instanceof Text) {
            Text text = Text$.MODULE$.unapply((Text)message2);
            String string = text._1();
            Text.MessageType messageType = text._2();
            String content = string;
            Text.MessageType messageType2 = messageType;
            Text.MessageType messageType3 = messageType2;
            if (Text$MessageType$TEXT$.MODULE$.equals(messageType3)) {
                this.clientGUI().foreach(_$10 -> _$10.addMessage(content.toString()));
                return;
            }
            if (Text$MessageType$USER$.MODULE$.equals(messageType3)) {
                new OptionPane(Hierarchy$.MODULE$.getFrame(this), I18N$.MODULE$.gui().get("common.messages.userMessage"), content.toString(), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)I18N$.MODULE$.gui().get("common.buttons.ok"), (List)new .colon.colon((Object)I18N$.MODULE$.gui().get("common.buttons.halt"), (List)Nil$.MODULE$)))), OptionPane$Icons$.MODULE$.Info());
                return;
            }
            if (Text$MessageType$CLEAR$.MODULE$.equals(messageType3)) {
                this.clientGUI().foreach(_$11 -> _$11.clearMessages());
                return;
            }
            throw new MatchError((Object)messageType3);
        }
        throw new Exception("Unexpected message: " + message);
    }

    public AtomicBoolean connected() {
        return this.connected;
    }

    public Option<String> login(String userid, String hostip, int port) {
        Some some;
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        this.userid = userid;
        this.hostip = hostip;
        this.port = port;
        try {
            Socket socket = new Socket(hostip, port);
            socket.setSoTimeout(0);
            this.listener = new Listener(userid, socket);
            this.listener.start();
            this.sendDataAndWait(Version$.MODULE$.version());
            some = None$.MODULE$;
        }
        catch (NoRouteToHostException e) {
            some = Some$.MODULE$.apply((Object)("Login failed:\n" + hostip + " could not be reached."));
        }
        catch (UnknownHostException e) {
            some = Some$.MODULE$.apply((Object)("Login failed:\n" + hostip + " does not resolve to a valid IP address."));
        }
        catch (ConnectException e) {
            some = Some$.MODULE$.apply((Object)("Login failed:\nThere was no server running at " + hostip + " on port " + port));
        }
        catch (Throwable e) {
            some = Some$.MODULE$.apply((Object)("Login failed:\nUnknown cause:\n" + Utils$.MODULE$.getStackTrace(e)));
        }
        return some;
    }

    public void handleLoginFailure(String errorMessage) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        this.listener.disconnect(errorMessage);
        this.errorHandler.handleLoginFailure(errorMessage);
    }

    public void disconnect(String reason) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        if (this.listener != null) {
            this.listener.disconnect(reason);
            return;
        }
        this.org$nlogo$hubnet$client$ClientPanel$$handleDisconnect(reason);
    }

    public void logout() {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        if (this.connected().compareAndSet(true, false)) {
            this.listener.stopWriting();
            this.sendDataAndWait(ExitMessage$.MODULE$.apply("Client Exited"));
            return;
        }
    }

    public void org$nlogo$hubnet$client$ClientPanel$$handleDisconnect(String reason) {
        boolean wasConnected = this.connected().compareAndSet(true, false);
        EventQueue$.MODULE$.invokeLater(() -> this.errorHandler.handleDisconnect(this.activityName, wasConnected, reason));
    }

    @Override
    public void processEvent(AWTEvent e) {
        if (e instanceof ClientAWTEvent) {
            Object object = e.getSource();
            ClientPanel clientPanel = this;
            if (!(object != null ? !object.equals(clientPanel) : clientPanel != null)) {
                ClientAWTEvent clientEvent = (ClientAWTEvent)e;
                try {
                    if (clientEvent instanceof ClientAWTExceptionEvent) {
                        this.handleEx((Exception)clientEvent.info(), ((ClientAWTExceptionEvent)clientEvent).sendingException());
                    } else if (clientEvent.receivedData()) {
                        this.receiveData(clientEvent.info());
                    }
                }
                catch (RuntimeException ex) {
                    Exceptions$.MODULE$.handle(ex);
                }
                return;
            }
        }
        super.processEvent(e);
    }

    private void handleEx(Exception e, boolean sendingEx) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        e.printStackTrace();
        if (this.listener != null && !sendingEx) {
            this.logout();
        }
        this.disconnect(e.toString());
    }

    public void sendDataAndWait(Object obj) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        if (this.listener != null) {
            try {
                this.listener.waitForSendData(obj);
            }
            catch (IOException e) {
                Exceptions$.MODULE$.warn(e);
            }
            return;
        }
        System.err.println("Attempted to send data on a shutdown listener, ignoring.");
    }

    private void receiveData(Object a) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        Object object = a;
        if (object instanceof Message) {
            Message m = (Message)object;
            this.handleProtocolMessage(m);
            return;
        }
        if (object instanceof String) {
            String info = (String)object;
            if (!this.connected().get()) {
                String string = info;
                String string2 = Version$.MODULE$.version();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.sendDataAndWait(new HandshakeFromClient(this.listener.clientId(), ConnectionTypes$.MODULE$.COMP_CONNECTION()));
                    return;
                }
                this.handleLoginFailure("The version of the HubNet Client you are using does not match the version of the server. Please use the HubNet Client that comes with " + info);
                return;
            }
            return;
        }
        throw new Exception("Unexpected data: " + a);
    }

    @Override
    public void syncTheme() {
        this.clientGUI().foreach(_$12 -> _$12.syncTheme());
    }

    private static final PlotPen handlePlotControlMessage$$anonfun$1(PlotWidget plotWidget$1, String s$1) {
        return plotWidget$1.plot().createPlotPen(s$1, true);
    }

    public class Listener
    extends AbstractConnection {
        private String clientId;

        public Listener(String userName, Socket socket) {
            if (ClientPanel.this == null) {
                throw new NullPointerException();
            }
            super("Listener: " + userName, Streamable$.MODULE$.apply(socket));
            this.clientId = userName;
            this.stopWriting();
        }

        public String clientId() {
            return this.clientId;
        }

        public void clientId_$eq(String x$1) {
            this.clientId = x$1;
        }

        @Override
        public void receiveData(Object data) {
            ClientPanel.this.getToolkit().getSystemEventQueue().postEvent(new ClientAWTEvent(ClientPanel.this, data, true));
        }

        @Override
        public void handleEx(Exception e, boolean sendingEx) {
            ClientPanel.this.getToolkit().getSystemEventQueue().postEvent(new ClientAWTExceptionEvent((Object)ClientPanel.this, e, sendingEx));
        }

        @Override
        public void disconnect(String reason) {
            super.disconnect(reason);
            ClientPanel.this.org$nlogo$hubnet$client$ClientPanel$$handleDisconnect(reason);
        }

        public final /* synthetic */ ClientPanel org$nlogo$hubnet$client$ClientPanel$Listener$$$outer() {
            return ClientPanel.this;
        }
    }
}

