/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.client;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.Turtle;
import org.nlogo.api.ViewSettings;
import org.nlogo.core.AgentKind$Link$;
import org.nlogo.core.AgentKind$Turtle$;
import org.nlogo.core.ShapeListTracker;
import org.nlogo.hubnet.mirroring.ClientWorld;
import org.nlogo.hubnet.mirroring.HubNetLine;
import org.nlogo.hubnet.mirroring.HubNetLinkStamp;
import org.nlogo.hubnet.mirroring.HubNetTurtleStamp;
import org.nlogo.hubnet.mirroring.LinkData;
import org.nlogo.hubnet.mirroring.PatchData;
import org.nlogo.hubnet.mirroring.TurtleData;
import org.nlogo.render.AbstractRenderer;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.jdk.CollectionConverters$;
import scala.runtime.Nothing$;

public class ClientRenderer
extends AbstractRenderer {
    private final ClientWorld world;

    public ClientRenderer(ClientWorld world) {
        this.world = world;
        super(world, new ShapeListTracker(AgentKind$Turtle$.MODULE$), new ShapeListTracker(AgentKind$Link$.MODULE$));
    }

    @Override
    public void paintTurtles(GraphicsInterface g, double patchSize) {
        CollectionConverters$.MODULE$.IterableHasAsScala(this.world.getTurtles()).asScala().foreach(data -> this.turtleDrawer.drawTurtle(g, this.topology, (Turtle)data, patchSize));
    }

    @Override
    public void paintLinks(GraphicsInterface g, double patchSize) {
        CollectionConverters$.MODULE$.IterableHasAsScala(this.world.getLinks()).asScala().foreach(data -> this.linkDrawer.drawLink(g, this.topology, (Link)data, patchSize, false));
    }

    @Override
    public void paintPatchLabels(GraphicsInterface g, double patchSize) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.world.getPatches());
        ArrayOps$.MODULE$.foreach$extension(object, data -> {
            if (data.hasLabel()) {
                this.drawPatchLabel(g, (PatchData)data, patchSize);
                return;
            }
        });
    }

    private void drawPatchLabel(GraphicsInterface g, PatchData patch, double patchSize) {
        this.topology.drawLabelHelper(g, Int$.MODULE$.int2double(patch.pxcor()), Int$.MODULE$.int2double(patch.pycor()), patch.plabel(), patch.plabelColor(), patchSize, 1.0);
    }

    @Override
    public boolean anyTurtles() {
        return CollectionConverters$.MODULE$.IterableHasAsScala(this.world.getTurtles()).asScala().isEmpty();
    }

    @Override
    public BufferedImage getSpotlightImage(ViewSettings settings) {
        return this.spotlightDrawer.getImage(this.topology, this.world.targetAgent.xcor(), this.world.targetAgent.ycor(), this.getWidth(settings.patchSize()), this.getHeight(settings.patchSize()), settings.patchSize(), this.world.targetAgent.spotlightSize(), this.darkenPeripheral(settings), this.world.targetAgent.wrapSpotlight());
    }

    public void drawLine(HubNetLine line) {
        this.trailDrawer().drawLine(line.x1, line.y1, line.x2, line.y2, line.color, line.size, line.mode);
    }

    public void stamp(HubNetTurtleStamp turtle) {
        this.trailDrawer().stamp(new TurtleData(turtle), turtle.erase);
    }

    public void stamp(HubNetLinkStamp link) {
        this.trailDrawer().stamp(new LinkData(link), link.erase);
    }

    public void clearDrawing() {
        this.trailDrawer().clearDrawing();
    }

    @Override
    public void paint(Graphics2D g, ViewSettings settings) {
    }

    @Override
    public void exportView(Graphics2D g, ViewSettings settings) {
        throw this.unsupported();
    }

    @Override
    public BufferedImage exportView(ViewSettings settings) {
        throw this.unsupported();
    }

    @Override
    public double graphicsX(double xcor, double patchSize, double viewOffsetX) {
        throw this.unsupported();
    }

    @Override
    public double graphicsY(double ycor, double patchSize, double viewOffsetY) {
        throw this.unsupported();
    }

    private Nothing$ unsupported() {
        throw new UnsupportedOperationException();
    }
}

