/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.connection;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.SocketException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.nlogo.api.Exceptions$;
import org.nlogo.hubnet.connection.Streamable;
import scala.Function0;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public abstract class AbstractConnection
extends Thread {
    public final Streamable org$nlogo$hubnet$connection$AbstractConnection$$connectionStreams;
    private final WritingThread writingThread;
    private final LinkedBlockingQueue<Object> writeQueue;
    private int count;
    private final int RESET_DELAY;
    private final ObjectOutputStream output;
    public final ObjectInputStream org$nlogo$hubnet$connection$AbstractConnection$$input;
    private boolean keepListening;
    public volatile boolean org$nlogo$hubnet$connection$AbstractConnection$$keepWriting;

    public AbstractConnection(String name, Streamable connectionStreams) {
        this.org$nlogo$hubnet$connection$AbstractConnection$$connectionStreams = connectionStreams;
        super(name);
        this.writingThread = new WritingThread(name);
        this.writeQueue = new LinkedBlockingQueue();
        this.count = 0;
        this.RESET_DELAY = 1000;
        this.output = connectionStreams.getOutputStream();
        this.org$nlogo$hubnet$connection$AbstractConnection$$input = connectionStreams.getInputStream();
        this.keepListening = true;
        this.org$nlogo$hubnet$connection$AbstractConnection$$keepWriting = true;
    }

    public LinkedBlockingQueue<Object> writeQueue() {
        return this.writeQueue;
    }

    public ObjectOutputStream output() {
        return this.output;
    }

    @Override
    public void run() {
        this.writingThread.start();
        while (this.keepListening) {
            try {
                this.receiveData(this.org$nlogo$hubnet$connection$AbstractConnection$$input.readObject());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof InterruptedIOException || throwable2 instanceof OptionalDataException || throwable2 instanceof RuntimeException) {
                    Exception e = (Exception)throwable2;
                    this.handleEx(e, false);
                    continue;
                }
                if (throwable2 instanceof SocketException || throwable2 instanceof EOFException) {
                    IOException e = (IOException)throwable2;
                    this.keepListening = false;
                    continue;
                }
                if (throwable2 instanceof IOException) {
                    IOException e = (IOException)throwable2;
                    this.handleEx(e, false);
                    this.keepListening = false;
                    continue;
                }
                throw throwable;
            }
        }
        this.disconnect("Shutting down.");
    }

    public abstract void receiveData(Object var1);

    public abstract void handleEx(Exception var1, boolean var2);

    public void waitForSendData(Object a) throws IOException {
        this.org$nlogo$hubnet$connection$AbstractConnection$$send(a);
    }

    public void sendData(Object a) {
        this.writeQueue().add(a);
    }

    public void stopWriting() {
        this.org$nlogo$hubnet$connection$AbstractConnection$$keepWriting = false;
    }

    public void disconnect(String reason) {
        if (this.keepListening) {
            this.keepListening = false;
            this.stopWriting();
            new Thread(this){
                private final /* synthetic */ AbstractConnection $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super("SocketListener disconnect");
                }

                public void run() {
                    Exceptions$.MODULE$.handling((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{RuntimeException.class}), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.run$$anonfun$1();
                        return BoxedUnit.UNIT;
                    });
                }

                private final void run$$anonfun$1$$anonfun$1() {
                    this.$outer.output().close();
                }

                private final void run$$anonfun$1$$anonfun$2() {
                    this.$outer.org$nlogo$hubnet$connection$AbstractConnection$$input.close();
                }

                private final void run$$anonfun$1$$anonfun$3() {
                    this.$outer.org$nlogo$hubnet$connection$AbstractConnection$$connectionStreams.close();
                }

                private final void run$$anonfun$1() {
                    AbstractConnection.org$nlogo$hubnet$connection$AbstractConnection$$anon$1$$_$warn$1((Function0 & Serializable)() -> {
                        this.run$$anonfun$1$$anonfun$1();
                        return BoxedUnit.UNIT;
                    });
                    AbstractConnection.org$nlogo$hubnet$connection$AbstractConnection$$anon$1$$_$warn$1((Function0 & Serializable)() -> {
                        this.run$$anonfun$1$$anonfun$2();
                        return BoxedUnit.UNIT;
                    });
                    AbstractConnection.org$nlogo$hubnet$connection$AbstractConnection$$anon$1$$_$warn$1((Function0 & Serializable)() -> {
                        this.run$$anonfun$1$$anonfun$3();
                        return BoxedUnit.UNIT;
                    });
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$adapted$1(), run$$anonfun$1$$anonfun$adapted$1(), run$$anonfun$1$$anonfun$adapted$2(), run$$anonfun$1$$anonfun$adapted$3()}, serializedLambda);
                }
            }.start();
            return;
        }
    }

    public int getSendQueueSize() {
        return this.writeQueue().size();
    }

    public void org$nlogo$hubnet$connection$AbstractConnection$$send(Object a) throws IOException {
        ObjectOutputStream objectOutputStream = this.output();
        synchronized (objectOutputStream) {
            BoxedUnit boxedUnit;
            this.output().writeObject(a);
            this.output().flush();
            ++this.count;
            if (this.count % this.RESET_DELAY == 0) {
                this.output().reset();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private static final void warn$1$$anonfun$1(Function0 body$1) {
        body$1.apply$mcV$sp();
    }

    public static final void org$nlogo$hubnet$connection$AbstractConnection$$anon$1$$_$warn$1(Function0 body) {
        Exceptions$.MODULE$.warning((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IOException.class}), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            AbstractConnection.warn$1$$anonfun$1(body);
            return BoxedUnit.UNIT;
        });
    }

    public class WritingThread
    extends Thread {
        public WritingThread(String name) {
            if (AbstractConnection.this == null) {
                throw new NullPointerException();
            }
            super("WritingThread:" + name);
        }

        @Override
        public void run() {
            while (AbstractConnection.this.org$nlogo$hubnet$connection$AbstractConnection$$keepWriting) {
                try {
                    try {
                        Object m = AbstractConnection.this.writeQueue().poll(100L, TimeUnit.MILLISECONDS);
                        if (m == null) continue;
                        AbstractConnection.this.org$nlogo$hubnet$connection$AbstractConnection$$send(m);
                    }
                    catch (IOException ex) {
                        if (!AbstractConnection.this.org$nlogo$hubnet$connection$AbstractConnection$$keepWriting) continue;
                        throw ex;
                    }
                }
                catch (InterruptedIOException e) {
                    AbstractConnection.this.handleEx(e, true);
                }
                catch (IOException e) {
                    AbstractConnection.this.handleEx(e, true);
                    AbstractConnection.this.org$nlogo$hubnet$connection$AbstractConnection$$keepWriting = false;
                }
                catch (InterruptedException e) {
                    Exceptions$.MODULE$.warn(e);
                }
            }
        }

        public final /* synthetic */ AbstractConnection org$nlogo$hubnet$connection$AbstractConnection$WritingThread$$$outer() {
            return AbstractConnection.this;
        }
    }
}

