/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.nlogo.api.Observer;
import org.nlogo.api.Perspective;
import org.nlogo.core.AgentKind;
import org.nlogo.hubnet.mirroring.Agent;

public class AgentPerspective {
    static final long serialVersionUID = 0L;
    final Agent agent;
    final int perspective;
    final double radius;
    final boolean serverMode;

    public AgentPerspective(AgentKind agentClass, long id, int perspective, double radius, boolean serverMode) {
        this.agent = new Agent(id, agentClass);
        this.perspective = perspective;
        this.radius = radius;
        this.serverMode = serverMode;
    }

    public AgentPerspective(org.nlogo.api.Agent a, Perspective p, double radius, boolean serverMode) {
        this.agent = a == null ? new Agent(0L, Observer.class) : new Agent(a.id(), a.getClass());
        this.perspective = p.export();
        this.radius = radius;
        this.serverMode = serverMode;
    }

    public AgentPerspective(DataInputStream is) {
        try {
            this.agent = new Agent(is);
            this.perspective = is.readInt();
            this.radius = is.readDouble();
            this.serverMode = is.readBoolean();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    void serialize(DataOutputStream os) throws IOException {
        this.agent.serialize(os);
        os.writeInt(this.perspective);
        os.writeDouble(this.radius);
        os.writeBoolean(this.serverMode);
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.serialize(new DataOutputStream(bos));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return bos.toByteArray();
    }

    public boolean equals(org.nlogo.api.Agent a, Perspective p) {
        return a == null ? this.agent.type == Agent.AgentType.OBSERVER && this.agent.id == 0L && this.perspective == 0 && this.radius == -1.0 : this.agent.id == a.id() && this.agent.type == Agent.AgentType.fromAgentClass(a.getClass()) && p.export() == this.perspective && this.radius == -1.0;
    }
}

