/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;

public abstract class Overridable {
    private final RollbackStack rollbackStack = new RollbackStack();

    abstract String getMethodName(int var1);

    public void set(int var, Object value) {
        try {
            String methodName = this.getMethodName(var);
            Method getter = this.getClass().getMethod(methodName, new Class[0]);
            Method setter = this.getSetter(methodName, value.getClass());
            Object oldValue = getter.invoke((Object)this, new Object[0]);
            this.rollbackStack.push(this.getSetter(methodName, oldValue.getClass()), oldValue);
            setter.invoke((Object)this, value);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private Method getSetter(String methodName, Class<? extends Object> class1) throws NoSuchMethodException {
        try {
            return this.getClass().getMethod(methodName, class1);
        }
        catch (NoSuchMethodException ex) {
            return this.getClass().getMethod(methodName, Object.class);
        }
    }

    public static int getOverrideIndex(String[] variables, String varName) {
        for (int i = 0; i < variables.length; ++i) {
            if (!varName.equalsIgnoreCase(variables[i])) continue;
            return i;
        }
        return -1;
    }

    public void rollback() {
        this.rollbackStack.rollback(this);
    }

    private class RollbackStack {
        private final LinkedList<Method> methodStack = new LinkedList();
        private final LinkedList<Object> valueStack = new LinkedList();

        private RollbackStack() {
        }

        void push(Method setter, Object value) {
            this.methodStack.addLast(setter);
            this.valueStack.addLast(value);
        }

        void rollback(Object owner) {
            try {
                while (!this.methodStack.isEmpty()) {
                    this.methodStack.removeLast().invoke(owner, this.valueStack.removeLast());
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

