/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Date;
import org.nlogo.api.Exceptions$;
import org.nlogo.hubnet.protocol.DiscoveryMessage;
import org.nlogo.hubnet.protocol.DiscoveryMessage$;
import org.nlogo.hubnet.server.HubNetUtils$;
import scala.Int$;

public class DiscoveryAnnouncer
extends Thread {
    private final InetAddress address;
    private final DiscoveryMessage message;
    private volatile boolean shouldRun;

    public DiscoveryAnnouncer(String uniqueId, String modelName, int portNumber, InetAddress address) {
        this.address = address;
        this.message = DiscoveryMessage$.MODULE$.apply(uniqueId, modelName, portNumber);
        this.shouldRun = true;
    }

    public void shutdown() {
        this.shouldRun = false;
    }

    @Override
    public void run() {
        MulticastSocket multicastSocket;
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_GROUP());
        }
        catch (UnknownHostException uhe) {
            DiscoveryAnnouncer.dump$1("could not map the multicast group " + HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_GROUP() + " to an InetAddress", uhe);
            return;
        }
        InetAddress group = inetAddress;
        try {
            multicastSocket = new MulticastSocket(HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT());
        }
        catch (IOException ioe) {
            DiscoveryAnnouncer.dump$1("Error creating multicast socket to port " + HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT(), ioe);
            return;
        }
        MulticastSocket multicastSocket2 = multicastSocket;
        NetworkInterface netIf = NetworkInterface.getByInetAddress(this.address);
        while (this.shouldRun) {
            byte[] messageBytes = this.message.toByteArray();
            try {
                multicastSocket2.setTimeToLive(63);
                multicastSocket2.setNetworkInterface(netIf);
                multicastSocket2.send(new DatagramPacket(messageBytes, messageBytes.length, group, HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT()));
            }
            catch (IOException ioe) {
                DiscoveryAnnouncer.dump$1("Could not transmit multicast announcement.", ioe);
            }
            try {
                Thread.sleep(Int$.MODULE$.int2long(HubNetUtils$.MODULE$.SERVER_DISCOVERY_ANNOUNCE_INTERVAL()));
            }
            catch (InterruptedException ie) {
                DiscoveryAnnouncer.dump$1("Multicast announcement thread interrupted.\n\t", ie);
            }
        }
        try {
            multicastSocket2.close();
        }
        catch (RuntimeException e) {
            Exceptions$.MODULE$.ignore(e);
        }
    }

    private static final void dump$1(String err, Exception ex) {
        System.err.println("@ " + new Date() + " : ");
        System.err.println("Error: " + err + "\n\t" + ex);
    }
}

