/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server.gui;

import java.awt.Component;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.file.Path;
import org.nlogo.api.AbstractModelLoader;
import org.nlogo.api.HubNetInterface;
import org.nlogo.api.ModelType;
import org.nlogo.awt.EventQueue$;
import org.nlogo.awt.Positioning$;
import org.nlogo.core.Femto$;
import org.nlogo.core.I18N$;
import org.nlogo.core.Model;
import org.nlogo.core.OptionalSection;
import org.nlogo.core.Widget;
import org.nlogo.fileformat.ConversionResult;
import org.nlogo.hubnet.connection.HubNetException;
import org.nlogo.hubnet.connection.NetworkUtils$;
import org.nlogo.hubnet.protocol.ComputerInterface$;
import org.nlogo.hubnet.server.ClientEventListener;
import org.nlogo.hubnet.server.ConnectionManager;
import org.nlogo.hubnet.server.HubNetManager;
import org.nlogo.hubnet.server.gui.ControlCenter;
import org.nlogo.hubnet.server.gui.HubNetClientEditor;
import org.nlogo.hubnet.server.gui.StartupDialog;
import org.nlogo.nvm.DefaultCompilerServices;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.ClientAppInterface;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceFactory;
import org.nlogo.window.MenuBarFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class GUIHubNetManager
extends HubNetManager
implements ThemeSync {
    public final GUIWorkspace org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace;
    private final Component linkParent;
    private final InterfaceFactory ifactory;
    private final MenuBarFactory menuFactory;
    private HubNetClientEditor _clientEditor;
    private String serverName;
    private Option<Tuple2<NetworkInterface, InetAddress>> serverInterface;
    private final ConnectionManager connectionManager;
    private ControlCenter controlCenter;

    public GUIHubNetManager(GUIWorkspace workspace, Component linkParent, InterfaceFactory ifactory, MenuBarFactory menuFactory, AbstractModelLoader loader, Function2<Model, Path, ConversionResult> modelConverter) {
        this.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace = workspace;
        this.linkParent = linkParent;
        this.ifactory = ifactory;
        this.menuFactory = menuFactory;
        super(workspace, loader, modelConverter);
        this._clientEditor = new HubNetClientEditor(workspace, linkParent, ifactory, menuFactory);
        this.serverName = System.getProperty("org.nlogo.hubnet.server.name");
        this.serverInterface = Option$.MODULE$.empty();
        ClientEventListener listener = new ClientEventListener(this){
            private final /* synthetic */ GUIHubNetManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void addClient(String clientId, String remoteAddress) {
                EventQueue$.MODULE$.invokeLater(() -> this.$outer.controlCenter().addClient(clientId, remoteAddress));
            }

            public void clientDisconnect(String clientId) {
                EventQueue$.MODULE$.invokeLater(() -> this.$outer.controlCenter().clientDisconnect(clientId));
            }

            public void logMessage(String message) {
                EventQueue$.MODULE$.invokeLater(() -> this.$outer.controlCenter().logMessage(message));
            }
        };
        this.connectionManager = new ConnectionManager(this, listener, workspace);
        this.controlCenter = null;
    }

    @Override
    public ConnectionManager connectionManager() {
        return this.connectionManager;
    }

    public ControlCenter controlCenter() {
        return this.controlCenter;
    }

    public void controlCenter_$eq(ControlCenter x$1) {
        this.controlCenter = x$1;
    }

    @Override
    public Option<Object> newClient(boolean isRobo, int waitTime) {
        None$ none$;
        ClientAppInterface clientApp = (ClientAppInterface)Femto$.MODULE$.get("org.nlogo.hubnet.client.ClientApp", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        try {
            none$ = Some$.MODULE$.apply((Object)InetAddress.getLocalHost().getHostAddress().toString());
        }
        catch (UnknownHostException ex) {
            none$ = None$.MODULE$;
        }
        None$ host = none$;
        clientApp.startup("", (String)host.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.connectionManager().port(), true, isRobo, Int$.MODULE$.int2long(waitTime), new DefaultCompilerServices(this.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace.compiler()), this.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace.getExtensionManager());
        return Some$.MODULE$.apply((Object)clientApp);
    }

    @Override
    public Seq<Widget> modelWidgets() {
        return this._clientEditor.interfaceWidgets();
    }

    @Override
    public HubNetInterface.ClientInterface currentlyActiveInterface() {
        return ComputerInterface$.MODULE$.apply(this._clientEditor.interfaceWidgets(), this.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace.world().turtleShapeList().shapes(), this.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace.world().linkShapeList().shapes(), ComputerInterface$.MODULE$.$lessinit$greater$default$4());
    }

    @Override
    public Object clientEditor() {
        return this._clientEditor;
    }

    @Override
    public int getInterfaceWidth() {
        return this._clientEditor.interfacePanel().getPreferredSize().width;
    }

    @Override
    public int getInterfaceHeight() {
        return this._clientEditor.interfacePanel().getPreferredSize().height;
    }

    @Override
    public void load(Model model) {
        model.optionalSectionValue("org.nlogo.modelsection.hubnetclient", ClassTag$.MODULE$.apply(OptionalSection.class)).foreach(hubNetWidgets -> this._clientEditor.load((Seq<Widget>)hubNetWidgets));
    }

    @Override
    public Model updateModel(Model m) {
        return m.withOptionalSection("org.nlogo.modelsection.hubnetclient", Some$.MODULE$.apply(this.interfaceWidgets()), (SeqOps)Nil$.MODULE$);
    }

    @Override
    public Seq<Widget> interfaceWidgets() {
        return this._clientEditor.interfaceWidgets();
    }

    public Seq<Widget> getComponent() {
        return this._clientEditor.interfaceWidgets();
    }

    public Seq<Nothing$> defaultComponent() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    @Override
    public void importClientInterface(Model model, boolean client) throws IOException {
        this._clientEditor.close();
        Seq widgets = client ? (Seq)model.optionalSectionValue("org.nlogo.modelsection.hubnetclient", ClassTag$.MODULE$.apply(OptionalSection.class)).getOrElse(GUIHubNetManager::$anonfun$1) : model.widgets();
        this._clientEditor.load(widgets);
        this.openClientEditor();
    }

    @Override
    public void setTitle(String name, String dir, ModelType modelType) {
        this._clientEditor.setTitle(name, dir, modelType);
    }

    @Override
    public void showControlCenter() {
        if (this.controlCenter() == null) {
            this.controlCenter_$eq(new ControlCenter(this.connectionManager(), this.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace.getFrame(), this.serverName, this.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace.modelNameForDisplay(), (Option<InetAddress>)this.serverInterface.map((Function1 & Serializable)_$1 -> (InetAddress)_$1._2())));
            this.controlCenter().pack();
        }
        this.controlCenter().syncTheme();
        this.controlCenter().setVisible(true);
    }

    private void closeControlCenter() {
        if (this.controlCenter() != null) {
            this.controlCenter().dispose();
            return;
        }
    }

    @Override
    public void openClientEditor() {
        Positioning$.MODULE$.moveNextTo(this._clientEditor, this.linkParent);
        this._clientEditor.setVisible(true);
        this._clientEditor.setSize(this._clientEditor.getPreferredSize());
    }

    @Override
    public void closeClientEditor() {
        this._clientEditor.close();
        this._clientEditor.dispose();
        this._clientEditor = new HubNetClientEditor(this.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace, this.linkParent, this.ifactory, this.menuFactory);
    }

    @Override
    public void reset() throws HubNetException {
        if (this.connectionManager().isRunning()) {
            this.connectionManager().shutdown();
            this.closeControlCenter();
        }
        while (this.serverName == null || this.serverName.isEmpty() || this.serverInterface.isEmpty()) {
            Tuple2<String, Option<Tuple2<NetworkInterface, InetAddress>>> tuple2 = this.getNameAndSelectedNetwork();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            Option selectedNetwork = (Option)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)name, (Object)selectedNetwork);
            String name2 = (String)tuple22._1();
            Option selectedNetwork2 = (Option)tuple22._2();
            this.serverName = name2;
            this.serverInterface = selectedNetwork2;
            if (this.serverInterface.isEmpty()) {
                new OptionPane(this.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace.getFrame(), I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().get("edit.hubnet.checkNetwork"), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
                continue;
            }
            if (!this.serverInterface.exists((Function1 & Serializable)_$2 -> ((NetworkInterface)_$2._1()).isLoopback())) continue;
            new OptionPane(this.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace.getFrame(), I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().get("edit.hubnet.noNetwork"), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
        }
        this.serverInterface.foreach(nw -> {
            this.connectionManager().startup(this.serverName, (Tuple2<NetworkInterface, InetAddress>)nw);
            this.showControlCenter();
        });
    }

    @Override
    public void syncMirroring() {
        Option$.MODULE$.apply((Object)this.controlCenter()).foreach(_$3 -> _$3.syncMirroring());
    }

    private Tuple2<String, Option<Tuple2<NetworkInterface, InetAddress>>> getNameAndSelectedNetwork() {
        block3: {
            Option preferredNetworkConnection;
            Seq<Tuple2<NetworkInterface, InetAddress>> networkChoices;
            block2: {
                networkChoices = NetworkUtils$.MODULE$.findViableInterfaces();
                Option<NetworkInterface> preferredNetworkInterface = NetworkUtils$.MODULE$.recallNetworkInterface();
                preferredNetworkConnection = networkChoices.find((Function1 & Serializable)_$4 -> {
                    Object object = _$4._1();
                    Option option = preferredNetworkInterface;
                    return !(object != null ? !object.equals(option) : option != null);
                });
                if (this.serverName == null) break block2;
                String string = this.serverName.trim();
                String string2 = "";
                if ((string == null ? string2 != null : !string.equals(string2)) && !this.serverInterface.isEmpty()) break block3;
            }
            StartupDialog dialog = new StartupDialog(networkChoices, preferredNetworkConnection, this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer.org$nlogo$hubnet$server$gui$GUIHubNetManager$$workspace.getFrame(), (Seq<Tuple2<NetworkInterface, InetAddress>>)networkChoices$1, (Option<Tuple2<NetworkInterface, InetAddress>>)preferredNetworkConnection$1);
                    this.setVisible(true);
                }
            };
            dialog.selectedNetwork().foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    NetworkInterface nic = (NetworkInterface)tuple2._1();
                    NetworkUtils$.MODULE$.rememberNetworkInterface(nic);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return Tuple2$.MODULE$.apply((Object)dialog.getName(), (Object)dialog.selectedNetwork().orElse(() -> GUIHubNetManager.getNameAndSelectedNetwork$$anonfun$2(networkChoices)).orElse(GUIHubNetManager::getNameAndSelectedNetwork$$anonfun$3));
        }
        return Tuple2$.MODULE$.apply((Object)this.serverName, this.serverInterface);
    }

    @Override
    public void disconnect() {
        this.connectionManager().shutdown();
        this.closeControlCenter();
        this.messagesList().clear();
    }

    @Override
    public Option<String> sendFromLocalClient(String clientName, String tag, Object content) {
        return Some$.MODULE$.apply((Object)"unimplemented");
    }

    @Override
    public void syncTheme() {
        this._clientEditor.syncTheme();
        if (this.controlCenter() != null) {
            this.controlCenter().syncTheme();
            return;
        }
    }

    private static final Seq $anonfun$1() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private static final Option getNameAndSelectedNetwork$$anonfun$2(Seq networkChoices$2) {
        return networkChoices$2.headOption();
    }

    private static final Option getNameAndSelectedNetwork$$anonfun$3() {
        return NetworkUtils$.MODULE$.loopbackInterface();
    }
}

