/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.ide;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.nlogo.core.Dialect;
import org.nlogo.core.Femto$;
import org.nlogo.core.Token;
import org.nlogo.core.TokenizerInterface;
import org.nlogo.ide.AutoSuggest;
import org.nlogo.ide.AutoSuggestDocumentListener;
import org.nlogo.ide.CodeCompletionPopup$;
import org.nlogo.ide.SuggestionListRenderer;
import org.nlogo.nvm.ExtensionManager;
import org.nlogo.swing.ScrollPane;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public class CodeCompletionPopup
implements ThemeSync,
Product,
Serializable {
    private final AutoSuggest autoSuggest;
    private final SuggestionListRenderer listRenderer;
    private boolean isPopupEnabled;
    private String lastSuggested;
    private final DefaultListModel<String> dlm;
    private final JList<String> suggestionDisplaylist;
    private final ScrollPane scrollPane;
    private final JDialog window;
    private Option<JTextComponent> editorArea;

    public static CodeCompletionPopup apply() {
        return CodeCompletionPopup$.MODULE$.apply();
    }

    public static CodeCompletionPopup apply(AutoSuggest autoSuggest, SuggestionListRenderer suggestionListRenderer) {
        return CodeCompletionPopup$.MODULE$.apply(autoSuggest, suggestionListRenderer);
    }

    public static CodeCompletionPopup apply(Dialect dialect) {
        return CodeCompletionPopup$.MODULE$.apply(dialect);
    }

    public static CodeCompletionPopup apply(Dialect dialect, ExtensionManager extensionManager) {
        return CodeCompletionPopup$.MODULE$.apply(dialect, extensionManager);
    }

    public static CodeCompletionPopup fromProduct(Product product) {
        return CodeCompletionPopup$.MODULE$.fromProduct(product);
    }

    public static CodeCompletionPopup unapply(CodeCompletionPopup codeCompletionPopup) {
        return CodeCompletionPopup$.MODULE$.unapply(codeCompletionPopup);
    }

    public static SuggestionListRenderer $lessinit$greater$default$2() {
        return CodeCompletionPopup$.MODULE$.$lessinit$greater$default$2();
    }

    public CodeCompletionPopup(AutoSuggest autoSuggest, SuggestionListRenderer listRenderer) {
        this.autoSuggest = autoSuggest;
        this.listRenderer = listRenderer;
        this.isPopupEnabled = false;
        this.lastSuggested = "";
        this.dlm = new DefaultListModel();
        this.suggestionDisplaylist = new JList<String>(this.dlm());
        this.scrollPane = new ScrollPane(this.suggestionDisplaylist(), 22, 30);
        this.window = new JDialog(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.setUndecorated(true);
                this.setMinimumSize(new Dimension(150, 210));
                this.add($outer.scrollPane());
            }
        };
        this.editorArea = None$.MODULE$;
        this.syncTheme();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CodeCompletionPopup)) return false;
        CodeCompletionPopup codeCompletionPopup = (CodeCompletionPopup)object;
        AutoSuggest autoSuggest = this.autoSuggest();
        AutoSuggest autoSuggest2 = codeCompletionPopup.autoSuggest();
        if (autoSuggest == null) {
            if (autoSuggest2 != null) {
                return false;
            }
        } else if (!autoSuggest.equals(autoSuggest2)) return false;
        SuggestionListRenderer suggestionListRenderer = this.listRenderer();
        SuggestionListRenderer suggestionListRenderer2 = codeCompletionPopup.listRenderer();
        if (suggestionListRenderer == null) {
            if (suggestionListRenderer2 != null) {
                return false;
            }
        } else if (!suggestionListRenderer.equals(suggestionListRenderer2)) return false;
        if (!codeCompletionPopup.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CodeCompletionPopup;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "CodeCompletionPopup";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "autoSuggest";
        }
        if (1 == n2) {
            return "listRenderer";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public AutoSuggest autoSuggest() {
        return this.autoSuggest;
    }

    public SuggestionListRenderer listRenderer() {
        return this.listRenderer;
    }

    public boolean isPopupEnabled() {
        return this.isPopupEnabled;
    }

    public void isPopupEnabled_$eq(boolean x$1) {
        this.isPopupEnabled = x$1;
    }

    public String lastSuggested() {
        return this.lastSuggested;
    }

    public void lastSuggested_$eq(String x$1) {
        this.lastSuggested = x$1;
    }

    public DefaultListModel<String> dlm() {
        return this.dlm;
    }

    public JList<String> suggestionDisplaylist() {
        return this.suggestionDisplaylist;
    }

    public ScrollPane scrollPane() {
        return this.scrollPane;
    }

    public JDialog window() {
        return this.window;
    }

    public Option<JTextComponent> editorArea() {
        return this.editorArea;
    }

    public void editorArea_$eq(Option<JTextComponent> x$1) {
        this.editorArea = x$1;
    }

    public void init(JTextComponent editorArea, AutoSuggestDocumentListener autoSuggestDocumentListener) {
        if (this.editorArea().isDefined()) {
            return;
        }
        this.editorArea_$eq((Option<JTextComponent>)Some$.MODULE$.apply((Object)editorArea));
        this.editorArea().foreach(eA -> {
            this.suggestionDisplaylist().setSelectionMode(1);
            this.suggestionDisplaylist().setLayoutOrientation(0);
            this.suggestionDisplaylist().setVisibleRowCount(10);
            this.listRenderer().font_$eq(eA.getFont());
            this.suggestionDisplaylist().setCellRenderer(this.listRenderer());
            this.suggestionDisplaylist().addMouseListener(new MouseAdapter((JTextComponent)eA, autoSuggestDocumentListener, this){
                private final JTextComponent eA$1;
                private final AutoSuggestDocumentListener autoSuggestDocumentListener$1;
                private final /* synthetic */ CodeCompletionPopup $outer;
                {
                    this.eA$1 = eA$5;
                    this.autoSuggestDocumentListener$1 = autoSuggestDocumentListener$5;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void mouseClicked(MouseEvent e) {
                    this.$outer.autoCompleteSuggestion(this.eA$1, this.autoSuggestDocumentListener$1);
                }
            });
            this.suggestionDisplaylist().addKeyListener(new KeyListener((JTextComponent)eA, autoSuggestDocumentListener, this){
                private final JTextComponent eA$2;
                private final AutoSuggestDocumentListener autoSuggestDocumentListener$3;
                private final /* synthetic */ CodeCompletionPopup $outer;
                {
                    this.eA$2 = eA$6;
                    this.autoSuggestDocumentListener$3 = autoSuggestDocumentListener$6;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    switch (c) {
                        case '\u001b': {
                            this.$outer.isPopupEnabled_$eq(false);
                            this.$outer.window().setVisible(false);
                            this.eA$2.getDocument().removeDocumentListener(this.autoSuggestDocumentListener$3);
                            return;
                        }
                        case '\b': {
                            int position = this.eA$2.getCaretPosition();
                            if (position != 0) {
                                this.eA$2.setCaretPosition(position - 1);
                                PlainDocument doc = (PlainDocument)this.eA$2.getDocument();
                                doc.remove(position - 1, 1);
                                return;
                            }
                            return;
                        }
                        case '\n': {
                            this.$outer.autoCompleteSuggestion(this.eA$2, this.autoSuggestDocumentListener$3);
                            return;
                        }
                    }
                    e.setSource(this.eA$2);
                    this.eA$2.dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        });
    }

    public void autoCompleteSuggestion(JTextComponent eA, AutoSuggestDocumentListener autoSuggestDocumentListener) {
        this.isPopupEnabled_$eq(false);
        String suggestion = this.suggestionDisplaylist().getSelectedValue();
        this.lastSuggested_$eq(suggestion);
        Option<Token> tokenOption = this.getTokenTillPosition(eA.getText(), eA.getCaretPosition());
        tokenOption.foreach(token -> {
            int position = eA.getCaretPosition();
            PlainDocument doc = (PlainDocument)eA.getDocument();
            doc.removeDocumentListener(autoSuggestDocumentListener);
            doc.replace(token.start(), position - token.start(), suggestion, null);
            eA.setCaretPosition(token.start() + suggestion.length());
            this.window().setVisible(false);
        });
    }

    public void displayPopup() {
        this.editorArea().foreach(eA -> {
            this.isPopupEnabled_$eq(true);
            this.autoSuggest().refresh();
            Option<Token> tokenOption = this.getTokenTillPosition(eA.getText(), eA.getCaretPosition());
            int position = BoxesRunTime.unboxToInt((Object)tokenOption.map((Function1 & Serializable)_$1 -> _$1.start()).getOrElse(() -> CodeCompletionPopup.$anonfun$2(eA)));
            this.fireUpdatePopup((Option<DocumentEvent>)None$.MODULE$);
            this.placeWindowOnScreen((JTextComponent)eA, position);
        });
        this.syncTheme();
    }

    public void placeWindowOnScreen(JTextComponent eA, int position) {
        int screenHeight = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getHeight();
        if ((double)(this.window().getSize().height + eA.getLocationOnScreen().y) + eA.modelToView2D(position).getY() + (double)eA.getFont().getSize() > (double)screenHeight) {
            this.window().setLocation(eA.getLocationOnScreen().x + (int)eA.modelToView2D(position).getX(), (int)((double)eA.getLocationOnScreen().y + eA.modelToView2D(position).getY() - this.window().getSize().getHeight()));
            return;
        }
        this.window().setLocation(eA.getLocationOnScreen().x + (int)eA.modelToView2D(position).getX(), eA.getLocationOnScreen().y + (int)eA.modelToView2D(position).getY() + eA.getFont().getSize());
    }

    public void fireUpdatePopup(Option<DocumentEvent> docEventOption) {
        this.editorArea().foreach(eA -> {
            IntRef position = IntRef.create((int)eA.getCaretPosition());
            docEventOption.foreach(docEvent -> {
                DocumentEvent.EventType eventType = docEvent.getType();
                DocumentEvent.EventType eventType2 = DocumentEvent.EventType.INSERT;
                DocumentEvent.EventType eventType3 = eventType;
                if (!(eventType2 != null ? !eventType2.equals(eventType3) : eventType3 != null)) {
                    ++position$1.elem;
                    return;
                }
            });
            this.updatePopup(position.elem);
        });
    }

    public void updatePopup(int position) {
        this.editorArea().foreach(eA -> {
            this.dlm().removeAllElements();
            if (this.isPopupEnabled()) {
                Option<Token> tokenOption = this.getTokenTillPosition(eA.getText(), position);
                Seq<String> list = (Seq<String>)((SeqOps)Nil$.MODULE$);
                Option<Token> option = tokenOption;
                if (option instanceof Some) {
                    Token token = (Token)((Some)option).value();
                    String word = token.text().substring(0, position - token.start());
                    if (!token.text().equals(this.lastSuggested())) {
                        list = this.autoSuggest().getSuggestions(word);
                        list.foreach(_$2 -> this.dlm().addElement((String)_$2));
                        if (!list.isEmpty()) {
                            this.lastSuggested_$eq("");
                            this.window().validate();
                            eA.getCaret().setVisible(true);
                            this.suggestionDisplaylist().setSelectedIndex(0);
                        } else {
                            this.isPopupEnabled_$eq(false);
                        }
                    }
                    if (list.isEmpty() || token == null) {
                        this.window().setVisible(false);
                    }
                } else if (None$.MODULE$.equals(option)) {
                    this.window().setVisible(false);
                    this.isPopupEnabled_$eq(false);
                } else {
                    throw new MatchError(option);
                }
            }
            this.window().setVisible(!this.dlm().isEmpty());
        });
    }

    public Option<Token> getTokenTillPosition(String source, int position) {
        TokenizerInterface tokenizerInterface = (TokenizerInterface)Femto$.MODULE$.scalaSingleton("org.nlogo.lex.Tokenizer");
        Iterator<Token> iterator = tokenizerInterface.tokenizeString(source, tokenizerInterface.tokenizeString$default$2());
        return iterator.find((Function1 & Serializable)p -> p.start() < position && p.end() >= position);
    }

    @Override
    public void syncTheme() {
        this.window().getContentPane().setBackground(InterfaceColors$.MODULE$.menuBackground());
        this.scrollPane().setBackground(InterfaceColors$.MODULE$.menuBackground());
        this.suggestionDisplaylist().setBackground(InterfaceColors$.MODULE$.menuBackground());
    }

    public CodeCompletionPopup copy(AutoSuggest autoSuggest, SuggestionListRenderer listRenderer) {
        return new CodeCompletionPopup(autoSuggest, listRenderer);
    }

    public AutoSuggest copy$default$1() {
        return this.autoSuggest();
    }

    public SuggestionListRenderer copy$default$2() {
        return this.listRenderer();
    }

    public AutoSuggest _1() {
        return this.autoSuggest();
    }

    public SuggestionListRenderer _2() {
        return this.listRenderer();
    }

    private static final int $anonfun$2(JTextComponent eA$4) {
        return eA$4.getCaretPosition();
    }
}

