/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Serializable;
import org.nlogo.api.LabExporterType$;
import org.nlogo.api.LabPostProcessorInputFormat;
import org.nlogo.api.LabProtocol;
import org.nlogo.core.LogoList;
import org.nlogo.core.WorldDimensions;
import org.nlogo.lab.Exporter;
import org.nlogo.lab.Exporter$;
import org.nlogo.lab.SpreadsheetExporter;
import org.nlogo.lab.StatsCalculator$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class StatsExporter
extends Exporter {
    private final LabProtocol protocol;
    private final PrintWriter out;
    private final LabPostProcessorInputFormat.Format in;
    private Set<List<Object>> seen;
    private final ListBuffer<List<Object>> paramCombinations;
    private final int countParams;
    private final HashSet<String> numericMetrics;
    private final HashSet<String> listMetrics;
    private final HashSet<String> invalidMetrics;

    public StatsExporter(String modelFileName, WorldDimensions initialDims, LabProtocol protocol, PrintWriter out, LabPostProcessorInputFormat.Format in) {
        this.protocol = protocol;
        this.out = out;
        this.in = in;
        super(modelFileName, initialDims, protocol, out, LabExporterType$.MODULE$.STATS());
        this.seen = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[0]));
        this.paramCombinations = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[0]));
        protocol.refElements().map((Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)_$2 -> _$2._2())).foreach(param -> {
            if (!this.seen.apply(param)) {
                this.paramCombinations().$plus$eq(param);
                this.seen = (Set)this.seen.$plus(param);
                return;
            }
        });
        this.countParams = protocol.refElements().length() > 0 ? ((List)protocol.refElements().toList().apply(0)).length() : 0;
        this.numericMetrics = (HashSet)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.listMetrics = (HashSet)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.invalidMetrics = (HashSet)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public ListBuffer<List<Object>> paramCombinations() {
        return this.paramCombinations;
    }

    public int countParams() {
        return this.countParams;
    }

    public HashSet<String> numericMetrics() {
        return this.numericMetrics;
    }

    public HashSet<String> listMetrics() {
        return this.listMetrics;
    }

    public HashSet<String> invalidMetrics() {
        return this.invalidMetrics;
    }

    public void writeExperimentHeader() {
        ListBuffer metrics = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.protocol.metrics().foreach(m -> {
            if (!this.invalidMetrics().contains(m)) {
                metrics.$plus$eq((Object)StringOps$.MODULE$.format$extension("(mean) %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{m})));
                metrics.$plus$eq((Object)StringOps$.MODULE$.format$extension("(std) %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{m})));
                return;
            }
        });
        List list = ((List)this.protocol.valueSets().apply(0)).map((Function1 & Serializable)_$3 -> _$3.variableName());
        List headers = metrics.toList().$colon$colon((Object)"[step]").$colon$colon$colon(list);
        this.out.println(headers.map((Function1 & Serializable)s -> this.csv().header((String)s)).mkString(","));
        this.out.flush();
    }

    public void writeTableRow(List<Object> params, List<Object> stats, int step) {
        List list = (List)params.$colon$plus((Object)BoxesRunTime.boxToInteger((int)step));
        List writeValues = stats.$colon$colon$colon(list);
        this.out.println(writeValues.map((Function1 & Serializable)obj -> this.csv().data(obj)).mkString(","));
        this.out.flush();
    }

    public Option<HashMap<List<Object>, HashMap<Object, ListBuffer<List<Object>>>>> extractData() {
        LabPostProcessorInputFormat.Format format = this.in;
        if (format instanceof LabPostProcessorInputFormat.Table) {
            LabPostProcessorInputFormat.Table t = (LabPostProcessorInputFormat.Table)format;
            return Some$.MODULE$.apply(this.extractFromTable(t.fileName()));
        }
        if (format instanceof LabPostProcessorInputFormat.Spreadsheet) {
            LabPostProcessorInputFormat.Spreadsheet s = (LabPostProcessorInputFormat.Spreadsheet)format;
            return Some$.MODULE$.apply(this.extractFromSpreadsheet(s.fileName()));
        }
        return None$.MODULE$;
    }

    public void process() {
        Option<HashMap<List<Object>, HashMap<Object, ListBuffer<List<Object>>>>> d = this.extractData();
        Option<HashMap<List<Object>, HashMap<Object, ListBuffer<List<Object>>>>> option = d;
        if (option instanceof Some) {
            HashMap data = (HashMap)((Some)option).value();
            this.writeExportHeader();
            this.writeExperimentHeader();
            this.paramCombinations().foreach(params -> {
                if (data.contains(params)) {
                    HashMap runData = (HashMap)data.apply(params);
                    List sortedSteps = (List)runData.keys().toList().sorted((Ordering)Ordering.Int$.MODULE$);
                    sortedSteps.foreach((Function1)(JFunction1.mcVI.sp & Serializable)step -> {
                        if (runData.contains((Object)BoxesRunTime.boxToInteger((int)step))) {
                            ListBuffer values = (ListBuffer)runData.apply((Object)BoxesRunTime.boxToInteger((int)step));
                            int numMetrics = ((List)values.apply(0)).length();
                            ListBuffer writeData = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMetrics).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                                String metric = (String)this.protocol.metrics().apply(i);
                                if (!this.invalidMetrics().contains((Object)metric)) {
                                    if (this.numericMetrics().contains((Object)metric)) {
                                        List metricValues = ((ListBuffer)values.map((Function1 & Serializable)_$4 -> _$4.apply(i))).toList();
                                        double mean = StatsCalculator$.MODULE$.mean((List<Object>)metricValues);
                                        writeData.$plus$eq((Object)BoxesRunTime.boxToDouble((double)mean));
                                        double std = StatsCalculator$.MODULE$.std((List<Object>)metricValues);
                                        writeData.$plus$eq(Predef$.MODULE$.double2Double(std).isNaN() ? "N/A" : BoxesRunTime.boxToDouble((double)std));
                                        return;
                                    }
                                    if (this.listMetrics().contains((Object)metric)) {
                                        List metricValues = ((ListBuffer)values.map((Function1 & Serializable)_$5 -> _$5.apply(i))).toList();
                                        IntRef maxLength = IntRef.create((int)0);
                                        metricValues.foreach(list -> {
                                            maxLength$1.elem = package$.MODULE$.max(maxLength$1.elem, list.length());
                                        });
                                        ListBuffer means = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[0]));
                                        ListBuffer stds = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maxLength.elem).foreach((Function1 & Serializable)j -> StatsExporter.process$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(metricValues, means, stds, BoxesRunTime.unboxToInt((Object)j)));
                                        writeData.$plus$eq((Object)StringOps$.MODULE$.format$extension("[%s]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{means.mkString(" ")})));
                                        writeData.$plus$eq((Object)StringOps$.MODULE$.format$extension("[%s]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{stds.mkString(" ")})));
                                        return;
                                    }
                                    return;
                                }
                            });
                            this.writeTableRow((List<Object>)params, (List<Object>)writeData.toList(), step);
                            return;
                        }
                    });
                    return;
                }
            });
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        this.out.close();
    }

    /*
     * WARNING - void declaration
     */
    private double handleNonNumeric(String entry, int metricIndex) {
        double d;
        try {
            void var3_3;
            double converted = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(entry));
            if (metricIndex >= 0) {
                String metric = (String)this.protocol.metrics().apply(metricIndex);
                this.numericMetrics().$plus$eq((Object)metric);
            }
            d = var3_3;
        }
        catch (NumberFormatException numberFormatException) {
            if (metricIndex >= 0) {
                String metric = (String)this.protocol.metrics().apply(metricIndex);
                this.invalidMetrics().$plus$eq((Object)metric);
            }
            d = Double.NaN;
        }
        return d;
    }

    private List<Object> handleList(String entry, int metricIndex) {
        List list;
        String noBrackets = entry.replaceAll("[\\[\\]]", "");
        if (noBrackets.length() == 0) {
            return (List)Nil$.MODULE$;
        }
        try {
            List converted = Predef$.MODULE$.wrapRefArray((Object[])noBrackets.split(" ")).toList().map((Function1 & Serializable)_$6 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$6)));
            if (metricIndex >= 0) {
                String metric = (String)this.protocol.metrics().apply(metricIndex);
                if (noBrackets.length() == entry.length() || this.numericMetrics().contains((Object)metric)) {
                    this.invalidMetrics().$plus$eq((Object)metric);
                } else {
                    this.listMetrics().$plus$eq((Object)metric);
                }
            }
            list = converted;
        }
        catch (NumberFormatException numberFormatException) {
            String metric = (String)this.protocol.metrics().apply(metricIndex);
            this.invalidMetrics().$plus$eq((Object)metric);
            list = (List)new .colon.colon((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (List)Nil$.MODULE$);
        }
        return list;
    }

    public HashMap<List<Object>, HashMap<Object, ListBuffer<List<Object>>>> extractFromTable(String fileName) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));
        String line = "";
        int row = 0;
        HashMap data = new HashMap();
        while ((line = bufferedReader.readLine()) != null) {
            ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            ListBuffer measurements = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            if (row > Exporter$.MODULE$.NUM_HEADER_ROWS()) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])line.split(","));
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String entry = (String)tuple2._1();
                        int col = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        String noQuotes = entry.split("\"")[1];
                        if (col > this.countParams()) {
                            int metricIndex = col - (this.countParams() + 2);
                            if (metricIndex > -1 && this.listMetrics().contains(this.protocol.metrics().apply(metricIndex)) || noQuotes.contains("[")) {
                                return (ListBuffer)measurements.$plus$eq(this.handleList(noQuotes, metricIndex));
                            }
                            return (ListBuffer)measurements.$plus$eq((Object)BoxesRunTime.boxToDouble((double)this.handleNonNumeric(noQuotes, metricIndex)));
                        }
                        double n = this.handleNonNumeric(noQuotes, -1);
                        if (Predef$.MODULE$.double2Double(n).isNaN()) {
                            return (ListBuffer)params.$plus$eq((Object)noQuotes);
                        }
                        return (ListBuffer)params.$plus$eq((Object)BoxesRunTime.boxToDouble((double)n));
                    }
                    throw new MatchError((Object)tuple2);
                });
                int step = (int)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(measurements.apply(0).toString()));
                List paramsList = ((ListBuffer)params.drop(1)).toList();
                if (!data.contains((Object)paramsList)) {
                    data.update((Object)paramsList, (Object)new HashMap());
                }
                if (!((HashMap)data.apply((Object)paramsList)).contains((Object)BoxesRunTime.boxToInteger((int)step))) {
                    ((HashMap)data.apply((Object)paramsList)).update((Object)BoxesRunTime.boxToInteger((int)step), (Object)new ListBuffer());
                }
                ((Growable)((HashMap)data.apply((Object)paramsList)).apply((Object)BoxesRunTime.boxToInteger((int)step))).$plus$eq((Object)((ListBuffer)measurements.drop(1)).toList());
            }
            ++row;
        }
        bufferedReader.close();
        return data;
    }

    public HashMap<List<Object>, HashMap<Object, ListBuffer<List<Object>>>> extractFromSpreadsheet(String fileName) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));
        String line = "";
        HashMap data = new HashMap();
        boolean reachedRunData = false;
        while ((line = bufferedReader.readLine()) != null) {
            String[] rowElements = line.split("[,\n]");
            if (reachedRunData) {
                IntRef runNumber = IntRef.create((int)1);
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), rowElements.length - 1).by(this.protocol.metrics().length() + 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    List params = this.protocol.sequentialRunOrder() ? (List)this.paramCombinations().apply((runNumber$1.elem - 1) / this.protocol.repetitions()) : (List)this.paramCombinations().apply((runNumber$1.elem - 1) % this.protocol.repetitions());
                    int step = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(rowElements[i].split("\"")[1]));
                    Object object = Predef$.MODULE$.refArrayOps((Object[])rowElements);
                    Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.slice$extension(object, i + 1, this.protocol.metrics().length() + i + 1));
                    Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object2));
                    List measurements = Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String entry = (String)tuple2._1();
                            int col = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            String noQuotes = entry.split("\"")[1];
                            if (noQuotes.contains("[") || this.listMetrics().contains(this.protocol.metrics().apply(col))) {
                                return this.handleList(noQuotes, col);
                            }
                            return BoxesRunTime.boxToDouble((double)this.handleNonNumeric(noQuotes, col));
                        }
                        throw new MatchError((Object)tuple2);
                    }, ClassTag$.MODULE$.apply(Object.class))).toList();
                    if (!data.contains((Object)params)) {
                        data.update((Object)params, (Object)new HashMap());
                    }
                    if (!((HashMap)data.apply((Object)params)).contains((Object)BoxesRunTime.boxToInteger((int)step))) {
                        ((HashMap)data.apply((Object)params)).update((Object)BoxesRunTime.boxToInteger((int)step), (Object)new ListBuffer());
                    }
                    ((Growable)((HashMap)data.apply((Object)params)).apply((Object)BoxesRunTime.boxToInteger((int)step))).$plus$eq((Object)measurements);
                    ++runNumber$1.elem;
                });
                continue;
            }
            if (rowElements.length <= 0) continue;
            String string = rowElements[0];
            String string2 = "\"[all run data]\"";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String string3 = rowElements[0];
                String string4 = "\"[final value]\"";
                if (string3 != null ? !string3.equals(string4) : string4 != null) continue;
            }
            reachedRunData = true;
        }
        bufferedReader.close();
        return data;
    }

    public HashMap<List<Object>, HashMap<Object, ListBuffer<List<Object>>>> extractFromSpreadsheet(SpreadsheetExporter spreadsheet) {
        HashMap data = new HashMap();
        HashMap<Object, SpreadsheetExporter.Run> spreadsheetData = spreadsheet.runs();
        spreadsheetData.foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int runNumber = BoxesRunTime.unboxToInt((Object)tuple2._1());
                SpreadsheetExporter.Run run = (SpreadsheetExporter.Run)tuple2._2();
                List params = run.settings().map((Function1 & Serializable)_$7 -> _$7._2());
                if (!data.contains((Object)params)) {
                    data.update((Object)params, (Object)new HashMap());
                }
                run.measurements().foreach((Function1 & Serializable)runData -> {
                    int step = (int)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(runData[0].toString()));
                    Object object = Predef$.MODULE$.refArrayOps(runData);
                    Object[] measurements = (Object[])ArrayOps$.MODULE$.drop$extension(object, 1);
                    if (!((HashMap)data.apply((Object)params)).contains((Object)BoxesRunTime.boxToInteger((int)step))) {
                        ((HashMap)data.apply((Object)params)).update((Object)BoxesRunTime.boxToInteger((int)step), (Object)new ListBuffer());
                    }
                    Object object2 = Predef$.MODULE$.refArrayOps(measurements);
                    Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object2));
                    return (ListBuffer)((Growable)((HashMap)data.apply((Object)params)).apply((Object)BoxesRunTime.boxToInteger((int)step))).$plus$eq((Object)Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Object entry = tuple2._1();
                            int col = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            String currentMetric = (String)this.protocol.metrics().apply(col);
                            if (entry instanceof LogoList) {
                                if (this.numericMetrics().contains((Object)currentMetric)) {
                                    this.invalidMetrics().$plus$eq((Object)currentMetric);
                                    return new .colon.colon((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (List)Nil$.MODULE$);
                                }
                                this.listMetrics().$plus$eq((Object)currentMetric);
                                return ((LogoList)entry).toList();
                            }
                            if (this.listMetrics().contains((Object)currentMetric)) {
                                this.invalidMetrics().$plus$eq((Object)currentMetric);
                                return new .colon.colon((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (List)Nil$.MODULE$);
                            }
                            return BoxesRunTime.boxToDouble((double)this.handleNonNumeric(entry.toString(), col));
                        }
                        throw new MatchError((Object)tuple2);
                    }, ClassTag$.MODULE$.apply(Object.class))).toList());
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return data;
    }

    @Override
    public void experimentCompleted() {
        this.process();
    }

    @Override
    public void experimentAborted() {
        this.process();
    }

    private static final /* synthetic */ ListBuffer process$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(List metricValues$1, ListBuffer means$1, ListBuffer stds$1, int j) {
        ListBuffer elementWiseValues = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[0]));
        metricValues$1.foreach(list -> {
            if (j < list.length()) {
                elementWiseValues.$plus$eq(list.apply(j));
                return;
            }
        });
        double mean = StatsCalculator$.MODULE$.mean((List<Object>)elementWiseValues.toList());
        means$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)mean));
        double std = StatsCalculator$.MODULE$.std((List<Object>)elementWiseValues.toList());
        return (ListBuffer)stds$1.$plus$eq(Predef$.MODULE$.double2Double(std).isNaN() ? "N/A" : BoxesRunTime.boxToDouble((double)std));
    }
}

