/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab.gui;

import java.awt.Window;
import java.io.Serializable;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.LabProtocol;
import org.nlogo.api.LabVariableParser$;
import org.nlogo.api.RefValueSet;
import org.nlogo.core.CompilerException;
import org.nlogo.core.I18N;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.editor.Colorizer;
import org.nlogo.lab.gui.ProtocolEditPanel;
import org.nlogo.lab.gui.ProtocolEditable$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.window.DummyErrorHandler;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class ProtocolEditable
implements Editable,
DummyErrorHandler {
    private final LabProtocol protocol;
    private final Window window;
    private final CompilerServices compiler;
    private final Colorizer colorizer;
    private final Object worldLock;
    private final Seq<String> experimentNames;
    private final String classDisplayName;
    private final int sourceOffset;
    private final I18N.Prefix i18nPrefix;
    private String _valueSets;

    public static Seq<String> $lessinit$greater$default$6() {
        return ProtocolEditable$.MODULE$.$lessinit$greater$default$6();
    }

    public ProtocolEditable(LabProtocol protocol, Window window, CompilerServices compiler, Colorizer colorizer, Object worldLock, Seq<String> experimentNames) {
        this.protocol = protocol;
        this.window = window;
        this.compiler = compiler;
        this.colorizer = colorizer;
        this.worldLock = worldLock;
        this.experimentNames = experimentNames;
        this.classDisplayName = "Experiment";
        this.sourceOffset = 0;
        this.i18nPrefix = I18N$Prefix$.MODULE$.apply("tools.behaviorSpace");
        this._valueSets = LabVariableParser$.MODULE$.combineVariables(protocol.constants(), protocol.subExperiments());
    }

    @Override
    public Option<String> helpLink() {
        return Some$.MODULE$.apply((Object)"behaviorspace.html#creating-an-experiment-setup");
    }

    @Override
    public String classDisplayName() {
        return this.classDisplayName;
    }

    @Override
    public int sourceOffset() {
        return this.sourceOffset;
    }

    @Override
    public EditPanel editPanel() {
        return new ProtocolEditPanel(this, this.compiler, this.colorizer);
    }

    public String name() {
        return this.protocol.name();
    }

    public void setName(String s) {
        this.protocol.name_$eq(s.trim());
    }

    public String preExperimentCommands() {
        return this.protocol.preExperimentCommands();
    }

    public void setPreExperimentCommands(String s) {
        this.protocol.preExperimentCommands_$eq(s.trim());
    }

    public String setupCommands() {
        return this.protocol.setupCommands();
    }

    public void setSetupCommands(String s) {
        this.protocol.setupCommands_$eq(s.trim());
    }

    public String goCommands() {
        return this.protocol.goCommands();
    }

    public void setGoCommands(String s) {
        this.protocol.goCommands_$eq(s.trim());
    }

    public String postRunCommands() {
        return this.protocol.postRunCommands();
    }

    public void setPostRunCommands(String s) {
        this.protocol.postRunCommands_$eq(s.trim());
    }

    public String postExperimentCommands() {
        return this.protocol.postExperimentCommands();
    }

    public void setPostExperimentCommands(String s) {
        this.protocol.postExperimentCommands_$eq(s.trim());
    }

    public int repetitions() {
        return this.protocol.repetitions();
    }

    public void setRepetitions(int i) {
        this.protocol.repetitions_$eq(i);
    }

    public boolean sequentialRunOrder() {
        return this.protocol.sequentialRunOrder();
    }

    public void setSequentialRunOrder(boolean b) {
        this.protocol.sequentialRunOrder_$eq(b);
    }

    public boolean runMetricsEveryStep() {
        return this.protocol.runMetricsEveryStep();
    }

    public void setRunMetricsEveryStep(boolean b) {
        this.protocol.runMetricsEveryStep_$eq(b);
    }

    public String runMetricsCondition() {
        return this.protocol.runMetricsCondition();
    }

    public void setRunMetricsCondition(String s) {
        this.protocol.runMetricsCondition_$eq(s.trim());
    }

    public int timeLimit() {
        return this.protocol.timeLimit();
    }

    public void setTimeLimit(int i) {
        this.protocol.timeLimit_$eq(i);
    }

    public String exitCondition() {
        return this.protocol.exitCondition();
    }

    public void setExitCondition(String s) {
        this.protocol.exitCondition_$eq(s.trim());
    }

    public String metrics() {
        return this.protocol.metricsForSaving().mkString("\n");
    }

    public void setMetrics(String s) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])s.split("\n", 0));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.trim(), ClassTag$.MODULE$.apply(String.class)));
        this.protocol.metricsForSaving_$eq((List<String>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2)))).toList());
    }

    public String valueSets() {
        return this._valueSets;
    }

    public void setValueSets(String s) {
        this._valueSets = s.trim();
    }

    @Override
    public boolean editFinished() {
        return this.get().isDefined();
    }

    public Option<LabProtocol> get() {
        Tuple2 tuple2;
        Try<Tuple2<List<RefValueSet>, List<List<RefValueSet>>>> try_ = LabVariableParser$.MODULE$.parseVariables(this.valueSets(), this.repetitions(), this.worldLock, this.compiler);
        if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
            List constants = (List)tuple2._1();
            List subExperiments = (List)tuple2._2();
            this.protocol.constants_$eq((List<RefValueSet>)constants);
            this.protocol.subExperiments_$eq((List<List<RefValueSet>>)subExperiments);
            return Some$.MODULE$.apply((Object)this.protocol);
        }
        if (try_ instanceof Failure) {
            Throwable t = ((Failure)try_).exception();
            this.complain$1(t.getMessage());
            return None$.MODULE$;
        }
        throw new MatchError(try_);
    }

    @Override
    public Option<String> errorString() {
        if (this.name().trim().isEmpty()) {
            return Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().get("edit.behaviorSpace.name.empty"));
        }
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(this.name()), '/') || StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(this.name()), '\\')) {
            return Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().get("edit.behaviorSpace.name.slashes"));
        }
        if (this.experimentNames.contains((Object)this.name().trim())) {
            return Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().getN("edit.behaviorSpace.name.duplicate", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.name().trim()})));
        }
        Try<Tuple2<List<RefValueSet>, List<List<RefValueSet>>>> try_ = LabVariableParser$.MODULE$.parseVariables(this.valueSets(), this.repetitions(), this.worldLock, this.compiler);
        if (try_ instanceof Failure) {
            Throwable t = ((Failure)try_).exception();
            return Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().getN("edit.behaviorSpace.compilerError", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{I18N$.MODULE$.gui().get("edit.behaviorSpace.variableSpec"), t.getMessage()})));
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.metrics().split("\n"));
        return ((Option)ArrayOps$.MODULE$.foldLeft$extension(object, (Object)Option$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                if (None$.MODULE$.equals(option)) {
                    String m = (String)tuple2._2();
                    return this.checkReporter$1(I18N$.MODULE$.gui().get("edit.behaviorSpace.metrics"), m);
                }
                Option e = option;
                return e;
            }
            throw new MatchError((Object)tuple2);
        })).orElse(this::errorString$$anonfun$2).orElse(this::errorString$$anonfun$3).orElse(this::errorString$$anonfun$4).orElse(this::errorString$$anonfun$5).orElse(this::errorString$$anonfun$6).orElse(this::errorString$$anonfun$7).orElse(this::errorString$$anonfun$8);
    }

    private final void complain$1(String message) {
        new OptionPane(this.window, I18N$.MODULE$.gui().apply("invalid", this.i18nPrefix), I18N$.MODULE$.gui().getN("edit.behaviorSpace.invalidVarySpec", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{message})), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
    }

    private final Option checkCommand$1(String name, String text) {
        try {
            String trimmed = text.trim();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(trimmed)) && !trimmed.startsWith(";")) {
                this.compiler.checkCommandSyntax(trimmed);
            }
        }
        catch (CompilerException e) {
            return Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().getN("edit.behaviorSpace.compilerError", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{name, e.getMessage()})));
        }
        return None$.MODULE$;
    }

    private final Option checkReporter$1(String name, String text) {
        try {
            String trimmed = text.trim();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(trimmed)) && !trimmed.startsWith(";")) {
                this.compiler.checkReporterSyntax(trimmed);
            }
        }
        catch (CompilerException e) {
            return Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().getN("edit.behaviorSpace.compilerError", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{name, e.getMessage()})));
        }
        return None$.MODULE$;
    }

    private final Option errorString$$anonfun$2() {
        return this.checkReporter$1(I18N$.MODULE$.gui().get("edit.behaviorSpace.runMetricsCondition"), this.runMetricsCondition());
    }

    private final Option errorString$$anonfun$3() {
        return this.checkCommand$1(I18N$.MODULE$.gui().get("edit.behaviorSpace.preExperimentCommands"), this.preExperimentCommands());
    }

    private final Option errorString$$anonfun$4() {
        return this.checkCommand$1(I18N$.MODULE$.gui().get("edit.behaviorSpace.setupCommands"), this.setupCommands());
    }

    private final Option errorString$$anonfun$5() {
        return this.checkCommand$1(I18N$.MODULE$.gui().get("edit.behaviorSpace.goCommands"), this.goCommands());
    }

    private final Option errorString$$anonfun$6() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.exitCondition().split("\n"));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropWhile$extension(object, (Function1 & Serializable)_$3 -> _$3.trim().startsWith(";")));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropWhile$extension(object2, (Function1 & Serializable)_$4 -> _$4.trim().isEmpty()));
        Option trimmed = ArrayOps$.MODULE$.headOption$extension(object3);
        return trimmed.flatMap((Function1 & Serializable)_$5 -> this.checkReporter$1(I18N$.MODULE$.gui().get("edit.behaviorSpace.exitCondition"), (String)_$5));
    }

    private final Option errorString$$anonfun$7() {
        return this.checkCommand$1(I18N$.MODULE$.gui().get("edit.behaviorSpace.postRunCommands"), this.postRunCommands());
    }

    private final Option errorString$$anonfun$8() {
        return this.checkCommand$1(I18N$.MODULE$.gui().get("edit.behaviorSpace.postExperimentCommands"), this.postExperimentCommands());
    }
}

