/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.parse;

import java.io.Serializable;
import java.util.Locale;
import org.nlogo.core.Application;
import org.nlogo.core.Command;
import org.nlogo.core.CommandBlock;
import org.nlogo.core.Expression;
import org.nlogo.core.Fail$;
import org.nlogo.core.FrontEndProcedure;
import org.nlogo.core.I18N$;
import org.nlogo.core.Let;
import org.nlogo.core.LogoList;
import org.nlogo.core.ProcedureDefinition;
import org.nlogo.core.Reporter;
import org.nlogo.core.ReporterApp;
import org.nlogo.core.ReporterBlock;
import org.nlogo.core.SourceLocatable;
import org.nlogo.core.SourceLocation;
import org.nlogo.core.SourceLocation$;
import org.nlogo.core.Statement;
import org.nlogo.core.Statements;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import org.nlogo.core.Token;
import org.nlogo.core.Token$;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$CloseBrace$;
import org.nlogo.core.TokenType$CloseBracket$;
import org.nlogo.core.TokenType$CloseParen$;
import org.nlogo.core.TokenType$Command$;
import org.nlogo.core.TokenType$Eof$;
import org.nlogo.core.TokenType$Literal$;
import org.nlogo.core.TokenType$OpenBracket$;
import org.nlogo.core.TokenType$OpenParen$;
import org.nlogo.core.TokenType$Reporter$;
import org.nlogo.core.TypeNames$;
import org.nlogo.core.prim.Lambda;
import org.nlogo.core.prim.Lambda$ConciseArguments$;
import org.nlogo.core.prim.Lambda$NoArguments$;
import org.nlogo.core.prim._abstractlet;
import org.nlogo.core.prim._abstractset;
import org.nlogo.core.prim._commandlambda;
import org.nlogo.core.prim._const;
import org.nlogo.core.prim._constcodeblock;
import org.nlogo.core.prim._lambdavariable;
import org.nlogo.core.prim._let;
import org.nlogo.core.prim._let$;
import org.nlogo.core.prim._letname;
import org.nlogo.core.prim._letvariable;
import org.nlogo.core.prim._minus;
import org.nlogo.core.prim._multiassignitem;
import org.nlogo.core.prim._multiassignnest;
import org.nlogo.core.prim._multilet;
import org.nlogo.core.prim._multilet$;
import org.nlogo.core.prim._multiset;
import org.nlogo.core.prim._multiset$;
import org.nlogo.core.prim._reporterlambda;
import org.nlogo.core.prim._set;
import org.nlogo.core.prim._set$;
import org.nlogo.core.prim._symbol;
import org.nlogo.core.prim._unaryminus;
import org.nlogo.core.prim._unknownidentifier;
import org.nlogo.parse.AmbiguousDelayedBlock;
import org.nlogo.parse.ArrowLambdaBlock;
import org.nlogo.parse.DelayedBlock;
import org.nlogo.parse.DelayedBlock$;
import org.nlogo.parse.ExpressionParser;
import org.nlogo.parse.LetScope$;
import org.nlogo.parse.LetVariableScope$;
import org.nlogo.parse.LiteralParser;
import org.nlogo.parse.NullImportHandler$;
import org.nlogo.parse.SplitSet$;
import org.nlogo.parse.SymbolTable;
import org.nlogo.parse.SymbolType;
import org.nlogo.parse.SymbolType$LambdaVariable$;
import org.nlogo.parse.SymbolType$LocalVariable$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BufferedIterator;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Seq$;
import scala.collection.mutable.UnrolledBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

public final class ExpressionParser$
implements Serializable {
    private static final int MinPrecedence;
    private static final String ExpectedCommand;
    private static final String ExpectedCloseBracket;
    private static final String ExpectedCloseParen;
    private static final String ExpectedReporter;
    private static final String InvalidVariadicContext;
    private static final String MissingCloseBracket;
    private static final String MissingCloseParen;
    private static final String MissingInputOnLeft;
    public static final ExpressionParser$ MODULE$;

    private ExpressionParser$() {
    }

    static {
        MODULE$ = new ExpressionParser$();
        MinPrecedence = -1;
        ExpectedCommand = "Expected command.";
        ExpectedCloseBracket = "Expected closing bracket.";
        ExpectedCloseParen = "Expected a closing parenthesis here.";
        ExpectedReporter = "Expected reporter.";
        InvalidVariadicContext = "To use a non-default number of inputs, you need to put parentheses around this.";
        MissingCloseBracket = "No closing bracket for this open bracket.";
        MissingCloseParen = "No closing parenthesis for this open parenthesis.";
        MissingInputOnLeft = "Missing input on the left.";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExpressionParser$.class);
    }

    public ProcedureDefinition apply(FrontEndProcedure procedureDeclaration, Iterator<Token> tokens, SymbolTable scope) {
        BufferedIterator buffered = tokens.buffered();
        scala.collection.immutable.Seq<Statement> statementList = this.parseStatements((BufferedIterator<Token>)buffered, scope, TokenType$Eof$.MODULE$, (Function2<BufferedIterator<Token>, SymbolTable, Tuple2<Statement, SymbolTable>>)(Function2 & Serializable)(_$1, _$2) -> MODULE$.parseStatement((BufferedIterator<Token>)_$1, false, (SymbolTable)((Object)_$2)));
        Statements stmts = new Statements(((SourceLocatable)buffered.head()).filename(), statementList, false);
        int end = ((SourceLocatable)buffered.head()).end() < Integer.MAX_VALUE ? ((SourceLocatable)buffered.head()).start() : stmts.end();
        return new ProcedureDefinition(procedureDeclaration, stmts, end);
    }

    private scala.collection.immutable.Seq<Statement> parseStatements(BufferedIterator<Token> tokens, SymbolTable scope, TokenType terminator, Function2<BufferedIterator<Token>, SymbolTable, Tuple2<Statement, SymbolTable>> f) {
        Buffer b;
        block3: {
            Tuple2 tuple2;
            b = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Statement[0]));
            SymbolTable activeScope = scope;
            while (true) {
                SymbolTable s;
                TokenType tokenType = ((Token)tokens.head()).tpe();
                TokenType tokenType2 = terminator;
                if (!(tokenType == null ? tokenType2 != null : !tokenType.equals(tokenType2))) break block3;
                tuple2 = (Tuple2)f.apply(tokens, (Object)activeScope);
                if (tuple2 == null) break;
                Statement statement = (Statement)tuple2._1();
                SymbolTable symbolTable = (SymbolTable)((Object)tuple2._2());
                Statement stmt = statement;
                SymbolTable s2 = symbolTable;
                if (stmt.command() instanceof _multilet) {
                    activeScope = s2;
                    b.$plus$eq((Object)stmt);
                    ((_multilet)stmt.command()).lets().foreach(command -> this.recurseLets$1(b, (_abstractlet)command));
                    continue;
                }
                Statement stmt2 = statement;
                SymbolTable s3 = symbolTable;
                if (stmt2.command() instanceof _multiset) {
                    activeScope = s3;
                    b.$plus$eq((Object)stmt2);
                    ((_multiset)stmt2.command()).sets().foreach(command -> this.recurseSets$1(s3, b, (_abstractset)command));
                    continue;
                }
                Statement stmt3 = statement;
                activeScope = s = symbolTable;
                b.$plus$eq((Object)stmt3);
            }
            throw new MatchError((Object)tuple2);
        }
        return b.toSeq();
    }

    private Tuple2<Statement, SymbolTable> parseStatement(BufferedIterator<Token> tokens, boolean variadic, SymbolTable scope) {
        Token token = (Token)tokens.head();
        TokenType tokenType = token.tpe();
        if (TokenType$OpenParen$.MODULE$.equals(tokenType)) {
            Tuple2 tuple2;
            Tuple2 tuple22 = this.parseParenthesized(tokens, (Function1 & Serializable)_$3 -> MODULE$.parseStatement((BufferedIterator<Token>)_$3, true, scope), token.filename());
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                throw new MatchError(tuple22);
            }
            Statement stmt = (Statement)tuple2._1();
            SymbolTable newScope = (SymbolTable)((Object)tuple2._2());
            SourceLocation loc = (SourceLocation)tuple22._2();
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)stmt, (Object)newScope, (Object)loc);
            Statement stmt2 = (Statement)tuple3._1();
            SymbolTable newScope2 = (SymbolTable)((Object)tuple3._2());
            SourceLocation loc2 = (SourceLocation)tuple3._3();
            return Tuple2$.MODULE$.apply((Object)stmt2.changeLocation(loc2), (Object)newScope2);
        }
        if (TokenType$Command$.MODULE$.equals(tokenType)) {
            Tuple2 tuple2;
            Tuple2 tuple23;
            Command coreCommand;
            tokens.next();
            Command command = coreCommand = (Command)token.value();
            if (command instanceof _let) {
                _let l = (_let)command;
                tuple23 = LetScope$.MODULE$.apply(l, tokens, scope);
            } else if (command instanceof _set) {
                _set s = (_set)command;
                tuple23 = Tuple2$.MODULE$.apply((Object)SplitSet$.MODULE$.apply(s, tokens), (Object)scope);
            } else {
                tuple23 = tuple2 = Tuple2$.MODULE$.apply((Object)coreCommand, (Object)scope);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Command command2 = (Command)tuple2._1();
            SymbolTable newScope = (SymbolTable)((Object)tuple2._2());
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)command2, (Object)newScope);
            Command command3 = (Command)tuple24._1();
            SymbolTable newScope3 = (SymbolTable)((Object)tuple24._2());
            Statement stmt = new Statement(command3, token.sourceLocation());
            scala.collection.immutable.Seq<Expression> arguments = this.parsePotentiallyVariadicArgumentList(stmt.instruction().syntax(), variadic, stmt, tokens, newScope3);
            return Tuple2$.MODULE$.apply((Object)stmt.withArguments(arguments), (Object)newScope3);
        }
        Object object = token.value();
        if (object instanceof _symbol || object instanceof _unknownidentifier) {
            if (!scope.contains(token.text().toUpperCase(Locale.ENGLISH))) {
                throw Fail$.MODULE$.exception(I18N$.MODULE$.errors().getN("compiler.LetVariable.notDefined", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{token.text().toUpperCase(Locale.ENGLISH)})), token);
            }
        }
        throw Fail$.MODULE$.exception(ExpectedCommand, token);
    }

    private scala.collection.immutable.Seq<Expression> parsePotentiallyVariadicArgumentList(Syntax syntax, boolean variadicContext, Application app, BufferedIterator<Token> tokens, SymbolTable scope) {
        scala.collection.immutable.Seq<Expression> untypedArgs = variadicContext && syntax.isVariadic() ? this.parseVarArgs(syntax, app.sourceLocation(), app.instruction().displayName(), tokens, scope) : this.parseArguments(syntax, app.sourceLocation(), app.instruction().displayName(), tokens, scope);
        return this.resolveTypes(syntax, untypedArgs, app.sourceLocation(), app.instruction().displayName(), scope);
    }

    private scala.collection.immutable.Seq<Expression> resolveTypes(Syntax syntax, scala.collection.immutable.Seq<Expression> untypedArgs, SourceLocation location, String displayName, SymbolTable scope) {
        Seq typedArgs = (Seq)Seq$.MODULE$.apply(untypedArgs);
        int actual1 = 0;
        if (syntax.isInfix()) {
            int tpe = syntax.left();
            Fail$.MODULE$.cAssert(untypedArgs.size() >= 1, (Function0<String>)((Function0 & Serializable)() -> ExpressionParser$.resolveTypes$$anonfun$1(syntax, displayName)), location);
            typedArgs.update(0, (Object)this.resolveType(tpe, (Expression)untypedArgs.apply(0), displayName, scope));
            actual1 = 1;
        }
        int formal1 = 0;
        List<Object> types = syntax.right();
        while (formal1 < types.length() && !Syntax$.MODULE$.compatible(Syntax$.MODULE$.RepeatableType(), BoxesRunTime.unboxToInt((Object)types.apply(formal1)))) {
            if (formal1 == types.length() - 1 && untypedArgs.size() == types.length() - 1 && Syntax$.MODULE$.compatible(Syntax$.MODULE$.OptionalType(), BoxesRunTime.unboxToInt((Object)types.apply(formal1)))) {
                return typedArgs.toSeq();
            }
            Fail$.MODULE$.cAssert(untypedArgs.size() > actual1, (Function0<String>)((Function0 & Serializable)() -> ExpressionParser$.resolveTypes$$anonfun$2(syntax, displayName)), location);
            typedArgs.update(actual1, (Object)this.resolveType(BoxesRunTime.unboxToInt((Object)types.apply(formal1)), (Expression)untypedArgs.apply(actual1), displayName, scope));
            ++formal1;
            ++actual1;
        }
        if (formal1 < types.length()) {
            int actual2 = untypedArgs.size() - 1;
            int formal2 = types.length() - 1;
            while (formal2 >= 0 && !Syntax$.MODULE$.compatible(Syntax$.MODULE$.RepeatableType(), BoxesRunTime.unboxToInt((Object)types.apply(formal2)))) {
                Fail$.MODULE$.cAssert(untypedArgs.size() > actual2 && actual2 > -1, (Function0<String>)((Function0 & Serializable)() -> ExpressionParser$.resolveTypes$$anonfun$3(syntax, displayName)), location);
                typedArgs.update(actual2, (Object)this.resolveType(BoxesRunTime.unboxToInt((Object)types.apply(formal2)), (Expression)untypedArgs.apply(actual2), displayName, scope));
                --formal2;
                --actual2;
            }
            while (actual1 <= actual2) {
                typedArgs.update(actual1, (Object)this.resolveType(BoxesRunTime.unboxToInt((Object)types.apply(formal1)), (Expression)untypedArgs.apply(actual1), displayName, scope));
                ++actual1;
            }
        }
        return typedArgs.toSeq();
    }

    private scala.collection.immutable.Seq<Expression> parseArguments(Syntax syntax, SourceLocation sourceLocation, String displayName, BufferedIterator<Token> tokens, SymbolTable scope) {
        Buffer args = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), syntax.rightDefault()).foreach((Function1 & Serializable)i -> ExpressionParser$.parseArguments$$anonfun$1(args, syntax, tokens, sourceLocation, displayName, scope, BoxesRunTime.unboxToInt((Object)i)));
        if (syntax.takesOptionalCommandBlock()) {
            Expression expression;
            TokenType tokenType = ((Token)tokens.head()).tpe();
            TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
            if (!(tokenType != null ? !tokenType.equals(tokenType$OpenBracket$) : tokenType$OpenBracket$ != null)) {
                expression = this.parseArgExpression(syntax, tokens, sourceLocation, displayName, BoxesRunTime.unboxToInt((Object)syntax.right().last()), scope);
            } else {
                String file = ((SourceLocatable)tokens.head()).filename();
                int location = BoxesRunTime.unboxToInt((Object)args.lastOption().map((Function1 & Serializable)_$4 -> _$4.end()).getOrElse(() -> ExpressionParser$.$anonfun$5(sourceLocation)));
                expression = new CommandBlock(new Statements(file), SourceLocation$.MODULE$.apply(location, location, file), true);
            }
            Expression newExp = expression;
            args.$plus$eq((Object)newExp);
        }
        return args.toSeq();
    }

    private scala.collection.immutable.Seq<Expression> parseVarArgs(Syntax syntax, SourceLocation sourceLocation, String displayName, BufferedIterator<Token> tokens, SymbolTable scope) {
        return this.parseArgument$1(syntax, sourceLocation, displayName, tokens, syntax.right(), scope, (scala.collection.immutable.Seq)((SeqOps)Nil$.MODULE$));
    }

    private Expression parseArgExpression(Syntax syntax, BufferedIterator<Token> tokens, SourceLocation sourceLocation, String displayName, int goalType, SymbolTable scope) {
        Expression expression;
        try {
            expression = this.parseExpressionInternal(tokens, false, syntax.precedence(), goalType, scope);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ExpressionParser.MissingPrefixException || throwable2 instanceof ExpressionParser.UnexpectedTokenException) {
            } else {
                throw throwable;
            }
            TokenType tokenType = ((Token)tokens.head()).tpe();
            throw TokenType$CloseParen$.MODULE$.equals(tokenType) ? Fail$.MODULE$.exception("Unexpected closing parenthesis.", ((Token)tokens.head()).sourceLocation()) : (TokenType$CloseBracket$.MODULE$.equals(tokenType) ? Fail$.MODULE$.exception("Unexpected closing bracket.", ((Token)tokens.head()).sourceLocation()) : (TokenType$CloseBrace$.MODULE$.equals(tokenType) ? Fail$.MODULE$.exception("Unexpected closing brace.", ((Token)tokens.head()).sourceLocation()) : Fail$.MODULE$.exception(this.missingInput(syntax, displayName, true), sourceLocation)));
        }
        return expression;
    }

    private String missingInput(Syntax syntax, String displayName, boolean right) {
        String result;
        boolean variadicMessage;
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        LazyRef lazyRef3 = new LazyRef();
        LazyRef lazyRef4 = new LazyRef();
        boolean bl = variadicMessage = right && syntax.isVariadic() && syntax.minimum() == 0;
        String string = variadicMessage ? displayName + " expected " + syntax.rightDefault() + " " + this.inputName$1(lazyRef, syntax) + " on the right or any number of inputs when surrounded by parentheses" : (result = right ? displayName + " expected" + this.variadicQuantifier$1(lazyRef2, syntax) + " " + syntax.rightDefault() + " " + this.inputName$1(lazyRef, syntax) + this.infixQuantifier$1(lazyRef3, syntax) : displayName + " expected " + TypeNames$.MODULE$.aName(syntax.left()) + " on the left");
        if (!right) {
            return result;
        }
        if (this.rightArgs$1(lazyRef4, syntax).forall((Function1 & Serializable)_$6 -> {
            String string = _$6;
            String string2 = "any input";
            return !(string != null ? !string.equals(string2) : string2 != null);
        })) {
            return result + ".";
        }
        if (this.rightArgs$1(lazyRef4, syntax).size() == 1) {
            return result + ", " + this.rightArgs$1(lazyRef4, syntax).mkString() + ".";
        }
        return result + ", " + ((IterableOnceOps)this.rightArgs$1(lazyRef4, syntax).toList().dropRight(1)).mkString(", ") + " and " + this.rightArgs$1(lazyRef4, syntax).last() + ".";
    }

    private Expression resolveType(int goalType, Expression originalArg, String instruction, SymbolTable scope) {
        Expression expression;
        Expression expression2 = originalArg;
        if (expression2 instanceof DelayedBlock) {
            DelayedBlock block = (DelayedBlock)expression2;
            expression = this.parseDelayedBlock(block, goalType, scope);
        } else {
            expression = originalArg;
        }
        Expression arg = expression;
        Fail$.MODULE$.cAssert(Syntax$.MODULE$.compatible(goalType, arg.reportedType()), (Function0<String>)((Function0 & Serializable)() -> ExpressionParser$.resolveType$$anonfun$1(goalType, arg, instruction)), arg);
        return arg;
    }

    public Expression parseExpression(BufferedIterator<Token> tokens, boolean variadic, int goalType, SymbolTable scope) {
        Expression expression;
        try {
            expression = this.parseExpressionInternal(tokens, variadic, MinPrecedence, goalType, scope);
        }
        catch (ExpressionParser.MissingPrefixException e) {
            throw Fail$.MODULE$.exception(MissingInputOnLeft, e.token());
        }
        catch (ExpressionParser.UnexpectedTokenException e) {
            throw Fail$.MODULE$.exception(ExpectedReporter, e.token());
        }
        return expression;
    }

    private <A> Tuple2<A, SourceLocation> parseParenthesized(BufferedIterator<Token> tokens, Function1<BufferedIterator<Token>, A> parse, String filename) {
        Token openParen = (Token)tokens.next();
        TokenType tokenType = openParen.tpe();
        TokenType$OpenParen$ tokenType$OpenParen$ = TokenType$OpenParen$.MODULE$;
        if (tokenType == null ? tokenType$OpenParen$ != null : !tokenType.equals(tokenType$OpenParen$)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        Object node = parse.apply(tokens);
        Token closeParen = (Token)tokens.next();
        TokenType tokenType2 = closeParen.tpe();
        TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
        Fail$.MODULE$.cAssert(tokenType2 == null ? tokenType$Eof$ != null : !tokenType2.equals(tokenType$Eof$), (Function0<String>)((Function0 & Serializable)ExpressionParser$::parseParenthesized$$anonfun$1), openParen);
        TokenType tokenType3 = closeParen.tpe();
        TokenType$CloseParen$ tokenType$CloseParen$ = TokenType$CloseParen$.MODULE$;
        Fail$.MODULE$.cAssert(!(tokenType3 != null ? !tokenType3.equals(tokenType$CloseParen$) : tokenType$CloseParen$ != null), (Function0<String>)((Function0 & Serializable)ExpressionParser$::parseParenthesized$$anonfun$2), closeParen);
        return Tuple2$.MODULE$.apply(node, (Object)SourceLocation$.MODULE$.apply(openParen.start(), closeParen.end(), filename));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Expression parseExpressionInternal(BufferedIterator<Token> tokens, boolean variadic, int precedence, int goalType, SymbolTable scope) {
        Expression expression;
        Token token = (Token)tokens.head();
        boolean wantAnyLambda = goalType == (Syntax$.MODULE$.ReporterType() | Syntax$.MODULE$.CommandType());
        boolean wantReporterLambda = wantAnyLambda || goalType == Syntax$.MODULE$.ReporterType();
        boolean wantCommandLambda = wantAnyLambda || goalType == Syntax$.MODULE$.CommandType();
        TokenType tokenType = token.tpe();
        if (TokenType$OpenParen$.MODULE$.equals(tokenType)) {
            Tuple2 tuple2 = this.parseParenthesized(tokens, (Function1 & Serializable)ts -> {
                Expression exp = MODULE$.parseExpression((BufferedIterator<Token>)ts, true, goalType, scope);
                TokenType tokenType = ((Token)ts.head()).tpe();
                TokenType$Command$ tokenType$Command$ = TokenType$Command$.MODULE$;
                Fail$.MODULE$.cAssert(tokenType == null ? tokenType$Command$ != null : !tokenType.equals(tokenType$Command$), (Function0<String>)((Function0 & Serializable)ExpressionParser$::$anonfun$6$$anonfun$1), token);
                return exp;
            }, token.filename());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Expression expr = (Expression)tuple2._1();
            SourceLocation loc = (SourceLocation)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)expr, (Object)loc);
            Expression expr2 = (Expression)tuple22._1();
            SourceLocation loc2 = (SourceLocation)tuple22._2();
            expression = expr2.changeLocation(loc2);
        } else if (TokenType$OpenBracket$.MODULE$.equals(tokenType)) {
            expression = this.delayBlock(token, tokens, scope);
        } else if ((TokenType$Reporter$.MODULE$.equals(tokenType) || TokenType$Command$.MODULE$.equals(tokenType)) && Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.SymbolType())) {
            tokens.next();
            _symbol symbol = new _symbol();
            token.refine(symbol, token.refine$default$2(), token.refine$default$3());
            expression = new ReporterApp(symbol, token.sourceLocation());
        } else if (TokenType$Reporter$.MODULE$.equals(tokenType) || TokenType$Literal$.MODULE$.equals(tokenType)) {
            Tuple2 tuple2;
            Tuple2 tuple23;
            tokens.next();
            TokenType tokenType2 = token.tpe();
            if (TokenType$Literal$.MODULE$.equals(tokenType2)) {
                _const coreReporter = new _const(token.value());
                coreReporter.token_$eq(token);
                tuple23 = Tuple2$.MODULE$.apply((Object)coreReporter.syntax(), (Object)new ReporterApp(coreReporter, token.sourceLocation()));
            } else {
                if (!TokenType$Reporter$.MODULE$.equals(tokenType2)) {
                    throw package$.MODULE$.error("unexpected token type: " + token.tpe());
                }
                Reporter coreReporter = (Reporter)token.value();
                if (coreReporter instanceof _symbol || coreReporter instanceof _unknownidentifier) {
                    tuple23 = goalType == Syntax$.MODULE$.SymbolType() ? Tuple2$.MODULE$.apply((Object)coreReporter.syntax(), (Object)new ReporterApp(coreReporter, token.sourceLocation())) : (Tuple2)LetVariableScope$.MODULE$.apply(coreReporter, token, scope).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Reporter letReporter = (Reporter)tuple2._1();
                            SymbolTable newScope = (SymbolTable)((Object)((Object)tuple2._2()));
                            return Tuple2$.MODULE$.apply((Object)letReporter.syntax(), (Object)new ReporterApp(letReporter, token.sourceLocation()));
                        }
                        throw new MatchError((Object)tuple2);
                    }).getOrElse(() -> ExpressionParser$.$anonfun$8(token));
                } else if (!coreReporter.syntax().isInfix() || wantReporterLambda) {
                    tuple23 = Tuple2$.MODULE$.apply((Object)coreReporter.syntax(), (Object)new ReporterApp(coreReporter, token.sourceLocation()));
                } else {
                    if (!(coreReporter instanceof _minus) || !variadic) {
                        throw new ExpressionParser.MissingPrefixException(token);
                    }
                    _unaryminus r2 = new _unaryminus();
                    r2.token_$eq(token);
                    tuple23 = tuple2 = Tuple2$.MODULE$.apply((Object)r2.syntax(), (Object)new ReporterApp(r2, token.sourceLocation()));
                }
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Syntax syntax = (Syntax)tuple2._1();
            ReporterApp rApp = (ReporterApp)tuple2._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)syntax, (Object)rApp);
            Syntax syntax2 = (Syntax)tuple24._1();
            ReporterApp rApp2 = (ReporterApp)tuple24._2();
            expression = wantReporterLambda && !variadic && !this.wantsSymbolicValue(rApp2.reporter()) && (wantAnyLambda || syntax2.totalDefault() > 0) ? this.expandConciseReporterLambda(rApp2, rApp2.reporter(), scope) : rApp2.withArguments(this.parsePotentiallyVariadicArgumentList(syntax2, variadic, rApp2, tokens, scope));
        } else if (TokenType$Command$.MODULE$.equals(tokenType) && wantCommandLambda) {
            tokens.next();
            expression = this.expandConciseCommandLambda(token, scope);
        } else {
            throw new ExpressionParser.UnexpectedTokenException(token);
        }
        DelayedBlock expr = expression;
        return this.parseMore(expr, tokens, precedence, scope);
    }

    private Tuple2<scala.collection.immutable.Seq<String>, scala.collection.immutable.Seq<ReporterApp>> syntheticVariables(int count, Token token, SymbolTable scope) {
        Tuple2 tuple2 = (Tuple2)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).foldLeft((Object)Tuple2$.MODULE$.apply((Object)((SeqOps)Nil$.MODULE$), (Object)scope), (Function2 & Serializable)(x$1, x$2) -> ExpressionParser$.$anonfun$9((Tuple2)x$1, BoxesRunTime.unboxToInt((Object)x$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq varNames = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq varNames2 = varNames;
        scala.collection.immutable.Seq varApps = (scala.collection.immutable.Seq)varNames2.map((Function1 & Serializable)vn -> {
            _lambdavariable lv = new _lambdavariable((String)vn, true);
            lv.token_$eq(token);
            return new ReporterApp(lv, SourceLocation$.MODULE$.apply(token.start(), token.end(), token.filename()));
        });
        return Tuple2$.MODULE$.apply((Object)varNames2, (Object)varApps);
    }

    private ReporterApp expandConciseReporterLambda(ReporterApp rApp, Reporter reporter, SymbolTable scope) {
        int argsCount = reporter.syntax().totalMinimum();
        Tuple2<scala.collection.immutable.Seq<String>, scala.collection.immutable.Seq<ReporterApp>> tuple2 = this.syntheticVariables(argsCount, reporter.token(), scope);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Seq varNames = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq varApps = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)varNames, (Object)varApps);
        scala.collection.immutable.Seq varNames2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq varApps2 = (scala.collection.immutable.Seq)tuple22._2();
        _reporterlambda lambda = new _reporterlambda(Lambda$ConciseArguments$.MODULE$.apply((scala.collection.immutable.Seq<String>)varNames2, (scala.collection.immutable.Seq<Object>)reporter.syntax().allArgs()));
        lambda.token_$eq(reporter.token());
        return new ReporterApp(lambda, (scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)rApp.withArguments((scala.collection.immutable.Seq<Expression>)varApps2), (List)Nil$.MODULE$))), reporter.token().sourceLocation());
    }

    private ReporterApp expandConciseCommandLambda(Token token, SymbolTable scope) {
        Command coreCommand = (Command)token.value();
        if (!coreCommand.syntax().canBeConcise()) {
            throw new ExpressionParser.UnexpectedTokenException(token);
        }
        Tuple2<scala.collection.immutable.Seq<String>, scala.collection.immutable.Seq<ReporterApp>> tuple2 = this.syntheticVariables(coreCommand.syntax().totalDefault(), coreCommand.token(), scope);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Seq varNames = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq varApps = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)varNames, (Object)varApps);
        scala.collection.immutable.Seq varNames2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq varApps2 = (scala.collection.immutable.Seq)tuple22._2();
        scala.collection.immutable.Seq stmtArgs = coreCommand.syntax().takesOptionalCommandBlock() ? (scala.collection.immutable.Seq)varApps2.$colon$plus((Object)new CommandBlock(new Statements(token.filename()), token.sourceLocation(), true)) : varApps2;
        _commandlambda lambda = new _commandlambda(Lambda$ConciseArguments$.MODULE$.apply((scala.collection.immutable.Seq<String>)varNames2, (scala.collection.immutable.Seq<Object>)coreCommand.syntax().allArgs()));
        lambda.token_$eq(token);
        Statement stmt = new Statement(coreCommand, (scala.collection.immutable.Seq<Expression>)stmtArgs, token.sourceLocation());
        CommandBlock commandBlock = this.commandBlockWithStatements(token.sourceLocation(), (scala.collection.immutable.Seq<Statement>)((scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)stmt, (List)Nil$.MODULE$))), true);
        return new ReporterApp(lambda, (scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)commandBlock, (List)Nil$.MODULE$))), token.sourceLocation());
    }

    private CommandBlock commandBlockWithStatements(SourceLocation sourceLocation, scala.collection.immutable.Seq<Statement> stmts, boolean synthetic) {
        Statements statements = new Statements(sourceLocation.filename(), stmts);
        return new CommandBlock(statements, sourceLocation, synthetic);
    }

    private boolean commandBlockWithStatements$default$3() {
        return false;
    }

    public Expression parseMore(Expression originalExpr, BufferedIterator<Token> tokens, int precedence, SymbolTable scope) {
        Expression expr = originalExpr;
        boolean done = false;
        while (!done) {
            Token token = (Token)tokens.head();
            TokenType tokenType = token.tpe();
            TokenType$Reporter$ tokenType$Reporter$ = TokenType$Reporter$.MODULE$;
            if (!(tokenType != null ? !tokenType.equals(tokenType$Reporter$) : tokenType$Reporter$ != null)) {
                Reporter coreReporter = (Reporter)token.value();
                Syntax syntax = coreReporter.syntax();
                if (syntax.isInfix() && (syntax.precedence() > precedence || syntax.isRightAssociative() && syntax.precedence() == precedence)) {
                    tokens.next();
                    Fail$.MODULE$.cAssert(expr != null, (Function0<String>)((Function0 & Serializable)ExpressionParser$::parseMore$$anonfun$1), token);
                    SourceLocation sourceLocation = SourceLocation$.MODULE$.apply(expr.start(), token.end(), token.filename());
                    scala.collection.immutable.Seq<Expression> untypedArgs = this.parseArguments(syntax, sourceLocation, coreReporter.displayName(), tokens, scope);
                    Expression expression = expr;
                    scala.collection.immutable.Seq<Expression> typedArgs = this.resolveTypes(syntax, (scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)untypedArgs.$plus$colon((Object)expression)), sourceLocation, coreReporter.displayName(), scope);
                    int n = ((SourceLocatable)typedArgs.last()).end();
                    int n2 = sourceLocation.copy$default$1();
                    String string = sourceLocation.copy$default$3();
                    expr = new ReporterApp(coreReporter, typedArgs, sourceLocation.copy(n2, n, string));
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return expr;
    }

    private DelayedBlock delayBlock(Token openBracket, BufferedIterator<Token> tokens, SymbolTable scope) {
        scala.collection.immutable.Seq collectedBlock = this.collect$1(openBracket, tokens, (Buffer)new UnrolledBuffer(ClassTag$.MODULE$.apply(Token.class)), 0).toSeq();
        return DelayedBlock$.MODULE$.apply(openBracket, (scala.collection.immutable.Seq<Token>)((scala.collection.immutable.Seq)collectedBlock.tail()), scope);
    }

    private Expression parseDelayedBlock(DelayedBlock block, int goalType, SymbolTable scope) {
        boolean listNotWanted;
        BufferedIterator tokens = ((IterableOnce)block.tokens().tail()).iterator().buffered();
        boolean bl = listNotWanted = !Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.ListType());
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.CodeBlockType())) {
            return this.parseCodeBlock(block, (BufferedIterator<Token>)tokens);
        }
        if (block.isArrowLambda() && !block.isCommand()) {
            return this.buildReporterLambda$1(tokens, block, ((ArrowLambdaBlock)block).arguments());
        }
        if (block.isArrowLambda() && block.isCommand()) {
            return this.buildCommandLambda$1(tokens, block, ((ArrowLambdaBlock)block).arguments());
        }
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.ReporterBlockType())) {
            Tuple2 tuple2 = this.reporterApp$1(tokens, block, tokens, goalType, scope);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ReporterApp expr = (ReporterApp)tuple2._1();
            Token lastToken = (Token)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)expr, (Object)lastToken);
            ReporterApp expr2 = (ReporterApp)tuple22._1();
            Token lastToken2 = (Token)tuple22._2();
            return new ReporterBlock(expr2, SourceLocation$.MODULE$.apply(block.openBracket().start(), lastToken2.end(), lastToken2.filename()));
        }
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.CommandBlockType())) {
            Tuple2 tuple2 = this.statementList$1(block, tokens, scope);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Seq stmtList = (scala.collection.immutable.Seq)tuple2._1();
            Token lastToken = (Token)tuple2._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)stmtList, (Object)lastToken);
            scala.collection.immutable.Seq stmtList2 = (scala.collection.immutable.Seq)tuple23._1();
            Token lastToken3 = (Token)tuple23._2();
            return this.commandBlockWithStatements(lastToken3.sourceLocation().copy(block.openBracket().start(), lastToken3.sourceLocation().copy$default$2(), lastToken3.sourceLocation().copy$default$3()), (scala.collection.immutable.Seq<Statement>)stmtList2, this.commandBlockWithStatements$default$3());
        }
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.ReporterType()) && !block.isCommand() && listNotWanted) {
            return this.buildReporterLambda$1(tokens, block, Lambda$NoArguments$.MODULE$.apply(false));
        }
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.CommandType()) && block.isCommand() && listNotWanted) {
            return this.buildCommandLambda$1(tokens, block, Lambda$NoArguments$.MODULE$.apply(false));
        }
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.ListType())) {
            Tuple2<LogoList, Token> tuple2 = new LiteralParser(NullImportHandler$.MODULE$).parseLiteralList(block.openBracket(), (Iterator<Token>)tokens);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            LogoList list = (LogoList)tuple2._1();
            Token closeBracket = (Token)tuple2._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)list, (Object)closeBracket);
            LogoList list2 = (LogoList)tuple24._1();
            Token closeBracket2 = (Token)tuple24._2();
            _const tmp = new _const(list2);
            tmp.token_$eq(new Token("", TokenType$Literal$.MODULE$, null, SourceLocation$.MODULE$.apply(block.openBracket().start(), closeBracket2.end(), closeBracket2.filename())));
            return new ReporterApp(tmp, SourceLocation$.MODULE$.apply(block.openBracket().start(), closeBracket2.end(), closeBracket2.filename()));
        }
        throw Fail$.MODULE$.exception("Expected " + TypeNames$.MODULE$.aName(goalType) + " here, rather than a list or block.", block);
    }

    private ReporterApp parseCodeBlock(DelayedBlock block, BufferedIterator<Token> tokens) {
        scala.collection.immutable.Seq<Token> seq;
        DelayedBlock delayedBlock = block;
        if (delayedBlock instanceof ArrowLambdaBlock) {
            ArrowLambdaBlock alb = (ArrowLambdaBlock)delayedBlock;
            seq = alb.allTokens();
        } else if (delayedBlock instanceof AmbiguousDelayedBlock) {
            AmbiguousDelayedBlock adl = (AmbiguousDelayedBlock)delayedBlock;
            seq = adl.tokens();
        } else {
            DelayedBlock b = delayedBlock;
            throw new IllegalStateException();
        }
        scala.collection.immutable.Seq<Token> tokens2 = seq;
        this.check$1(block, (scala.collection.immutable.Seq)tokens2.dropRight(2), this.check$default$2$1());
        _constcodeblock tmp = new _constcodeblock((scala.collection.immutable.Seq<Token>)((scala.collection.immutable.Seq)((IterableOps)tokens2.tail()).dropRight(2)));
        tmp.token_$eq((Token)tokens2.head());
        return new ReporterApp(tmp, SourceLocation$.MODULE$.apply(((SourceLocatable)tokens2.head()).start(), block.end(), ((SourceLocatable)tokens2.head()).filename()));
    }

    private boolean wantsSymbolicValue(Reporter reporter) {
        return Syntax$.MODULE$.compatible(reporter.syntax().left(), Syntax$.MODULE$.CodeBlockType() | Syntax$.MODULE$.SymbolType()) || reporter.syntax().right().exists((Function1)(JFunction1.mcZI.sp & Serializable)arg -> Syntax$.MODULE$.compatible(arg, Syntax$.MODULE$.CodeBlockType() | Syntax$.MODULE$.SymbolType()));
    }

    private final void recurseLets$1(Buffer b$1, _abstractlet command2) {
        _abstractlet _abstractlet2 = command2;
        if (_abstractlet2 instanceof _let) {
            _let _let2 = (_let)_abstractlet2;
            _let _let3 = _let$.MODULE$.unapply(_let2);
            Option<Let> option = _let3._1();
            Option<String> option2 = _let3._2();
            if (option instanceof Some) {
                Let l = (Let)((Some)option).value();
                _let let = _let2;
                _multiassignitem item = new _multiassignitem();
                item.token_$eq(l.token());
                ReporterApp expression = new ReporterApp(item, (scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)((SeqOps)Nil$.MODULE$)), l.token().sourceLocation());
                ReporterApp letName = new ReporterApp(new _letname(), l.token().sourceLocation());
                scala.collection.immutable.Seq letArgs = (scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)letName, (List)new .colon.colon((Object)expression, (List)Nil$.MODULE$)));
                Statement letStatement = new Statement(let, (scala.collection.immutable.Seq<Expression>)letArgs, l.token().sourceLocation());
                b$1.$plus$eq((Object)letStatement);
                return;
            }
        }
        if (_abstractlet2 instanceof _multilet) {
            scala.collection.immutable.Seq<_abstractlet> seq;
            _multilet _multilet2 = (_multilet)_abstractlet2;
            _multilet _multilet3 = _multilet$.MODULE$.unapply(_multilet2);
            scala.collection.immutable.Seq<_abstractlet> lets = seq = _multilet3._1();
            _multilet let = _multilet2;
            _multiassignnest enter = new _multiassignnest("LET", lets.size());
            enter.token_$eq(let.token());
            b$1.$plus$eq((Object)new Statement(enter, let.token().sourceLocation()));
            lets.foreach(command -> this.recurseLets$1(b$1, (_abstractlet)command));
            return;
        }
    }

    private static final SymbolType $anonfun$2(String varName$1, _set set$1) {
        throw Fail$.MODULE$.exception("There is no variable called " + varName$1 + ".", set$1.token().sourceLocation());
    }

    private final void recurseSets$1(SymbolTable s$1, Buffer b$2, _abstractset command2) {
        _set _set2;
        _abstractset _abstractset2 = command2;
        if (_abstractset2 instanceof _set && _set$.MODULE$.unapply(_set2 = (_set)_abstractset2)) {
            ReporterApp reporterApp;
            _set set = _set2;
            Object object = set.token().value();
            if (object instanceof _unknownidentifier) {
                Reporter reporter;
                _unknownidentifier uv = (_unknownidentifier)object;
                String varName = set.token().text().toUpperCase(Locale.ENGLISH);
                SymbolType tpe = (SymbolType)s$1.get(varName).getOrElse(() -> ExpressionParser$.$anonfun$2(varName, set));
                SymbolType symbolType = tpe;
                if (symbolType instanceof SymbolType.LocalVariable) {
                    Let let;
                    SymbolType.LocalVariable localVariable = SymbolType$LocalVariable$.MODULE$.unapply((SymbolType.LocalVariable)symbolType);
                    Let let2 = let = localVariable._1();
                    _letvariable v = new _letvariable(let2);
                    v.token_$eq(set.token());
                    reporter = v;
                } else {
                    reporter = uv;
                }
                Reporter variable = reporter;
                reporterApp = new ReporterApp(variable, (scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)((SeqOps)Nil$.MODULE$)), set.token().sourceLocation());
            } else if (object instanceof Reporter) {
                Reporter r = (Reporter)object;
                reporterApp = new ReporterApp(r, (scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)((SeqOps)Nil$.MODULE$)), set.token().sourceLocation());
            } else {
                throw Fail$.MODULE$.exception("Command found in multi-set where a variable name was expected: " + set.token().text().toUpperCase(Locale.ENGLISH) + ".", set.token().sourceLocation());
            }
            ReporterApp setVar = reporterApp;
            _multiassignitem item = new _multiassignitem();
            item.token_$eq(set.token());
            ReporterApp expression = new ReporterApp(item, (scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)((SeqOps)Nil$.MODULE$)), set.token().sourceLocation());
            scala.collection.immutable.Seq setArgs = (scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)setVar, (List)new .colon.colon((Object)expression, (List)Nil$.MODULE$)));
            b$2.$plus$eq((Object)new Statement(set, (scala.collection.immutable.Seq<Expression>)setArgs, set.token().sourceLocation()));
            return;
        }
        if (_abstractset2 instanceof _multiset) {
            scala.collection.immutable.Seq<_abstractset> seq;
            _multiset _multiset2 = (_multiset)_abstractset2;
            _multiset _multiset3 = _multiset$.MODULE$.unapply(_multiset2);
            scala.collection.immutable.Seq<_abstractset> sets = seq = _multiset3._1();
            _multiset set = _multiset2;
            _multiassignnest enter = new _multiassignnest("SET", sets.size());
            enter.token_$eq(set.token());
            b$2.$plus$eq((Object)new Statement(enter, set.token().sourceLocation()));
            sets.foreach(command -> this.recurseSets$1(s$1, b$2, (_abstractset)command));
            return;
        }
        _abstractset c = _abstractset2;
        throw new IllegalStateException();
    }

    private static final String resolveTypes$$anonfun$1(Syntax syntax$1, String displayName$1) {
        return MODULE$.missingInput(syntax$1, displayName$1, false);
    }

    private static final String resolveTypes$$anonfun$2(Syntax syntax$2, String displayName$2) {
        return MODULE$.missingInput(syntax$2, displayName$2, true);
    }

    private static final String resolveTypes$$anonfun$3(Syntax syntax$3, String displayName$3) {
        return MODULE$.missingInput(syntax$3, displayName$3, true);
    }

    private static final /* synthetic */ Buffer parseArguments$$anonfun$1(Buffer args$1, Syntax syntax$4, BufferedIterator tokens$1, SourceLocation sourceLocation$1, String displayName$4, SymbolTable scope$2, int i) {
        return (Buffer)args$1.$plus$eq((Object)MODULE$.parseArgExpression(syntax$4, (BufferedIterator<Token>)tokens$1, sourceLocation$1, displayName$4, BoxesRunTime.unboxToInt((Object)syntax$4.right().apply(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(i), syntax$4.right().size() - 1))), scope$2));
    }

    private static final int $anonfun$5(SourceLocation sourceLocation$2) {
        return sourceLocation$2.end();
    }

    private static final String parseArgument$1$$anonfun$1() {
        return InvalidVariadicContext;
    }

    private final scala.collection.immutable.Seq parseArgument$1(Syntax syntax$5, SourceLocation sourceLocation$3, String displayName$5, BufferedIterator toks, List goalTypes, SymbolTable scope, scala.collection.immutable.Seq parsedArgs) {
        while (true) {
            List newGoals;
            Token token;
            if ((token = (Token)toks.head()) != null) {
                Token token2 = Token$.MODULE$.unapply(token);
                String string = token2._1();
                TokenType tokenType = token2._2();
                Object object = token2._3();
                if (TokenType$CloseParen$.MODULE$.equals(tokenType)) {
                    return parsedArgs;
                }
                if (TokenType$Reporter$.MODULE$.equals(tokenType) && object instanceof Reporter) {
                    Reporter rep = (Reporter)object;
                    if (BoxesRunTime.unboxToInt((Object)goalTypes.head()) != Syntax$.MODULE$.ReporterType() && rep.syntax().isInfix()) {
                        Fail$.MODULE$.cAssert(parsedArgs.size() == syntax$5.totalDefault(), (Function0<String>)((Function0 & Serializable)ExpressionParser$::parseArgument$1$$anonfun$1), sourceLocation$3);
                        return parsedArgs;
                    }
                }
            }
            Expression newExp = this.parseArgExpression(syntax$5, (BufferedIterator<Token>)toks, sourceLocation$3, displayName$5, BoxesRunTime.unboxToInt((Object)goalTypes.head()), scope);
            List list = newGoals = ((IterableOnceOps)goalTypes.tail()).nonEmpty() ? (List)goalTypes.tail() : goalTypes;
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)parsedArgs.$colon$plus((Object)newExp);
            goalTypes = list;
            parsedArgs = seq;
        }
    }

    private final String inputName$lzyINIT1$1(LazyRef inputName$lzy1$1, Syntax syntax$6) {
        String string;
        LazyRef lazyRef = inputName$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(inputName$lzy1$1.initialized() ? inputName$lzy1$1.value() : inputName$lzy1$1.initialize((Object)(syntax$6.rightDefault() > 1 ? "inputs" : "input")));
        }
        return string;
    }

    private final String inputName$1(LazyRef inputName$lzy1$2, Syntax syntax$7) {
        return (String)(inputName$lzy1$2.initialized() ? inputName$lzy1$2.value() : this.inputName$lzyINIT1$1(inputName$lzy1$2, syntax$7));
    }

    private final String variadicQuantifier$lzyINIT1$1(LazyRef variadicQuantifier$lzy1$1, Syntax syntax$8) {
        String string;
        LazyRef lazyRef = variadicQuantifier$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(variadicQuantifier$lzy1$1.initialized() ? variadicQuantifier$lzy1$1.value() : variadicQuantifier$lzy1$1.initialize((Object)(syntax$8.isVariadic() ? " at least" : "")));
        }
        return string;
    }

    private final String variadicQuantifier$1(LazyRef variadicQuantifier$lzy1$2, Syntax syntax$9) {
        return (String)(variadicQuantifier$lzy1$2.initialized() ? variadicQuantifier$lzy1$2.value() : this.variadicQuantifier$lzyINIT1$1(variadicQuantifier$lzy1$2, syntax$9));
    }

    private final String infixQuantifier$lzyINIT1$1(LazyRef infixQuantifier$lzy1$1, Syntax syntax$10) {
        String string;
        LazyRef lazyRef = infixQuantifier$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(infixQuantifier$lzy1$1.initialized() ? infixQuantifier$lzy1$1.value() : infixQuantifier$lzy1$1.initialize((Object)(syntax$10.isInfix() ? " on the right" : "")));
        }
        return string;
    }

    private final String infixQuantifier$1(LazyRef infixQuantifier$lzy1$2, Syntax syntax$11) {
        return (String)(infixQuantifier$lzy1$2.initialized() ? infixQuantifier$lzy1$2.value() : this.infixQuantifier$lzyINIT1$1(infixQuantifier$lzy1$2, syntax$11));
    }

    private static final /* synthetic */ String rightArgs$lzyINIT1$1$$anonfun$1(int _$5) {
        return TypeNames$.MODULE$.aName(_$5).replaceFirst("anything", "any input");
    }

    private final List rightArgs$lzyINIT1$1(LazyRef rightArgs$lzy1$1, Syntax syntax$12) {
        List list;
        LazyRef lazyRef = rightArgs$lzy1$1;
        synchronized (lazyRef) {
            list = (List)(rightArgs$lzy1$1.initialized() ? rightArgs$lzy1$1.value() : rightArgs$lzy1$1.initialize((Object)syntax$12.right().map((Function1 & Serializable)_$5 -> ExpressionParser$.rightArgs$lzyINIT1$1$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$5)))));
        }
        return list;
    }

    private final List rightArgs$1(LazyRef rightArgs$lzy1$2, Syntax syntax$13) {
        return (List)(rightArgs$lzy1$2.initialized() ? rightArgs$lzy1$2.value() : this.rightArgs$lzyINIT1$1(rightArgs$lzy1$2, syntax$13));
    }

    private static final String resolveType$$anonfun$1(int goalType$1, Expression arg$1, String instruction$1) {
        int displayedReportedType = (goalType$1 & Syntax$.MODULE$.ReferenceType()) == 0 && (arg$1.reportedType() & ~Syntax$.MODULE$.ReferenceType()) != 0 ? arg$1.reportedType() & ~Syntax$.MODULE$.ReferenceType() : arg$1.reportedType();
        return instruction$1 + " expected this input to be " + TypeNames$.MODULE$.aName(goalType$1) + ", but got " + TypeNames$.MODULE$.aName(displayedReportedType) + " instead";
    }

    private static final String parseParenthesized$$anonfun$1() {
        return MissingCloseParen;
    }

    private static final String parseParenthesized$$anonfun$2() {
        return ExpectedCloseParen;
    }

    private static final String $anonfun$6$$anonfun$1() {
        return MissingCloseParen;
    }

    private static final Tuple2 $anonfun$8(Token token$3) {
        throw Fail$.MODULE$.exception(I18N$.MODULE$.errors().getN("compiler.LetVariable.notDefined", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{token$3.text().toUpperCase(Locale.ENGLISH)})), token$3);
    }

    private static final /* synthetic */ Tuple2 $anonfun$9(Tuple2 x$1, int x$2) {
        Tuple2 tuple2;
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToInteger((int)x$2));
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
            scala.collection.immutable.Seq acc = (scala.collection.immutable.Seq)tuple2._1();
            SymbolTable s = (SymbolTable)((Object)tuple2._2());
            Tuple2<String, SymbolTable> tuple23 = s.withFreshSymbol(SymbolType$LambdaVariable$.MODULE$, s.withFreshSymbol$default$2());
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            String varName = (String)tuple23._1();
            SymbolTable newScope = (SymbolTable)((Object)tuple23._2());
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)varName, (Object)newScope);
            String varName2 = (String)tuple24._1();
            SymbolTable newScope2 = (SymbolTable)((Object)tuple24._2());
            return Tuple2$.MODULE$.apply(acc.$colon$plus((Object)varName2), (Object)newScope2);
        }
        throw new MatchError((Object)tuple22);
    }

    private static final String parseMore$$anonfun$1() {
        return MissingInputOnLeft;
    }

    private final scala.collection.immutable.Seq collect$1(Token openBracket$1, BufferedIterator tokens, Buffer acc, int nesting) {
        while (true) {
            Token token = (Token)tokens.next();
            TokenType tokenType = token.tpe();
            TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
            if (!(tokenType != null ? !tokenType.equals(tokenType$OpenBracket$) : tokenType$OpenBracket$ != null)) {
                Buffer buffer = (Buffer)acc.$plus$eq((Object)token);
                int n = nesting + 1;
                acc = buffer;
                nesting = n;
                continue;
            }
            TokenType tokenType2 = token.tpe();
            TokenType$CloseBracket$ tokenType$CloseBracket$ = TokenType$CloseBracket$.MODULE$;
            if (!(tokenType2 != null ? !tokenType2.equals(tokenType$CloseBracket$) : tokenType$CloseBracket$ != null)) {
                if (nesting == 1) {
                    return ((IterableOnceOps)acc.$plus$eq((Object)token)).toSeq();
                }
                Buffer buffer = (Buffer)acc.$plus$eq((Object)token);
                int n = nesting - 1;
                acc = buffer;
                nesting = n;
                continue;
            }
            TokenType tokenType3 = token.tpe();
            TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
            if (!(tokenType3 == null ? tokenType$Eof$ != null : !tokenType3.equals(tokenType$Eof$))) break;
            acc = (Buffer)acc.$plus$eq((Object)token);
        }
        throw Fail$.MODULE$.exception(MissingCloseBracket, openBracket$1);
    }

    private static final String $anonfun$11$$anonfun$1() {
        return MissingCloseBracket;
    }

    private final Tuple2 statementList$1(DelayedBlock block$1, BufferedIterator i, SymbolTable scope) {
        scala.collection.immutable.Seq<Statement> stmts = this.parseStatements((BufferedIterator<Token>)i, scope, TokenType$CloseBracket$.MODULE$, (Function2<BufferedIterator<Token>, SymbolTable, Tuple2<Statement, SymbolTable>>)(Function2 & Serializable)(ts, s) -> {
            TokenType tokenType = ((Token)ts.head()).tpe();
            TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
            Fail$.MODULE$.cAssert(tokenType == null ? tokenType$Eof$ != null : !tokenType.equals(tokenType$Eof$), (Function0<String>)((Function0 & Serializable)ExpressionParser$::$anonfun$11$$anonfun$1), block$1.openBracket());
            return MODULE$.parseStatement((BufferedIterator<Token>)ts, false, (SymbolTable)((Object)s));
        });
        return Tuple2$.MODULE$.apply(stmts, i.next());
    }

    private static final String reporterApp$1$$anonfun$1() {
        return MissingCloseBracket;
    }

    private static final String reporterApp$1$$anonfun$2() {
        return ExpectedCloseBracket;
    }

    private final Tuple2 reporterApp$1(BufferedIterator tokens$2, DelayedBlock block$3, BufferedIterator i, int expressionGoal, SymbolTable scope) {
        Expression expr = this.resolveType(Syntax$.MODULE$.WildcardType(), this.parseExpression((BufferedIterator<Token>)tokens$2, false, expressionGoal, scope), null, scope);
        Token lastToken = (Token)tokens$2.next();
        TokenType tokenType = lastToken.tpe();
        TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
        Fail$.MODULE$.cAssert(tokenType == null ? tokenType$Eof$ != null : !tokenType.equals(tokenType$Eof$), (Function0<String>)((Function0 & Serializable)ExpressionParser$::reporterApp$1$$anonfun$1), block$3.openBracket());
        TokenType tokenType2 = lastToken.tpe();
        TokenType$CloseBracket$ tokenType$CloseBracket$ = TokenType$CloseBracket$.MODULE$;
        Fail$.MODULE$.cAssert(!(tokenType2 != null ? !tokenType2.equals(tokenType$CloseBracket$) : tokenType$CloseBracket$ != null), (Function0<String>)((Function0 & Serializable)ExpressionParser$::reporterApp$1$$anonfun$2), lastToken);
        return Tuple2$.MODULE$.apply((Object)((ReporterApp)expr), (Object)lastToken);
    }

    private final ReporterApp buildReporterLambda$1(BufferedIterator tokens$3, DelayedBlock block$4, Lambda.Arguments args) {
        Tuple2 tuple2 = this.reporterApp$1(tokens$3, block$4, tokens$3, Syntax$.MODULE$.WildcardType(), block$4.internalScope());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReporterApp expr = (ReporterApp)tuple2._1();
        Token closeBracket = (Token)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)expr, (Object)closeBracket);
        ReporterApp expr2 = (ReporterApp)tuple22._1();
        Token closeBracket2 = (Token)tuple22._2();
        _reporterlambda lambda = new _reporterlambda(args);
        lambda.token_$eq(block$4.openBracket());
        return new ReporterApp(lambda, (scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)expr2, (List)Nil$.MODULE$))), SourceLocation$.MODULE$.apply(block$4.openBracket().start(), closeBracket2.end(), block$4.filename()));
    }

    private final ReporterApp buildCommandLambda$1(BufferedIterator tokens$4, DelayedBlock block$5, Lambda.Arguments args) {
        Tuple2 tuple2 = this.statementList$1(block$5, tokens$4, block$5.internalScope());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq stmtList = (scala.collection.immutable.Seq)tuple2._1();
        Token closeBracket = (Token)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)stmtList, (Object)closeBracket);
        scala.collection.immutable.Seq stmtList2 = (scala.collection.immutable.Seq)tuple22._1();
        Token closeBracket2 = (Token)tuple22._2();
        _commandlambda lambda = new _commandlambda(args);
        lambda.token_$eq(block$5.openBracket());
        CommandBlock blockArg = this.commandBlockWithStatements(SourceLocation$.MODULE$.apply(block$5.openBracket().start(), closeBracket2.end(), block$5.filename()), (scala.collection.immutable.Seq<Statement>)stmtList2, this.commandBlockWithStatements$default$3());
        return new ReporterApp(lambda, (scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)blockArg, (List)Nil$.MODULE$))), SourceLocation$.MODULE$.apply(block$5.openBracket().start(), closeBracket2.end(), block$5.filename()));
    }

    private final void check$1(DelayedBlock block$6, scala.collection.immutable.Seq remaining, scala.collection.immutable.Seq stack) {
        while (true) {
            block19: {
                block21: {
                    block20: {
                        block16: {
                            block18: {
                                block17: {
                                    if (remaining.isEmpty()) {
                                        if (!stack.isEmpty()) {
                                            TokenType tokenType = ((Token)stack.head()).tpe();
                                            TokenType$OpenParen$ tokenType$OpenParen$ = TokenType$OpenParen$.MODULE$;
                                            if (!(tokenType != null ? !tokenType.equals(tokenType$OpenParen$) : tokenType$OpenParen$ != null)) {
                                                throw Fail$.MODULE$.exception("Expected close paren here", (SourceLocatable)block$6.tokens().last());
                                            }
                                            return;
                                        }
                                        return;
                                    }
                                    TokenType tokenType = ((Token)remaining.head()).tpe();
                                    TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
                                    if (!(tokenType != null ? !tokenType.equals(tokenType$OpenBracket$) : tokenType$OpenBracket$ != null)) {
                                        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)remaining.tail();
                                        Token token = (Token)remaining.head();
                                        scala.collection.immutable.Seq seq2 = (scala.collection.immutable.Seq)stack.$plus$colon((Object)token);
                                        remaining = seq;
                                        stack = seq2;
                                        continue;
                                    }
                                    TokenType tokenType2 = ((Token)remaining.head()).tpe();
                                    TokenType$OpenParen$ tokenType$OpenParen$ = TokenType$OpenParen$.MODULE$;
                                    if (!(tokenType2 != null ? !tokenType2.equals(tokenType$OpenParen$) : tokenType$OpenParen$ != null)) {
                                        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)remaining.tail();
                                        Token token = (Token)remaining.head();
                                        scala.collection.immutable.Seq seq3 = (scala.collection.immutable.Seq)stack.$plus$colon((Object)token);
                                        remaining = seq;
                                        stack = seq3;
                                        continue;
                                    }
                                    TokenType tokenType3 = ((Token)remaining.head()).tpe();
                                    TokenType$CloseBracket$ tokenType$CloseBracket$ = TokenType$CloseBracket$.MODULE$;
                                    if (tokenType3 != null ? !tokenType3.equals(tokenType$CloseBracket$) : tokenType$CloseBracket$ != null) break block16;
                                    if (!stack.isEmpty()) {
                                        TokenType tokenType4 = ((Token)stack.head()).tpe();
                                        TokenType$OpenParen$ tokenType$OpenParen$2 = TokenType$OpenParen$.MODULE$;
                                        if (!(tokenType4 != null ? !tokenType4.equals(tokenType$OpenParen$2) : tokenType$OpenParen$2 != null)) {
                                            throw Fail$.MODULE$.exception("Expected close paren before close bracket here", (SourceLocatable)remaining.head());
                                        }
                                    }
                                    if (stack.isEmpty()) break block17;
                                    TokenType tokenType5 = ((Token)stack.head()).tpe();
                                    TokenType$OpenBracket$ tokenType$OpenBracket$2 = TokenType$OpenBracket$.MODULE$;
                                    if (!(tokenType5 == null ? tokenType$OpenBracket$2 != null : !tokenType5.equals(tokenType$OpenBracket$2))) break block18;
                                }
                                throw Fail$.MODULE$.exception("Closing bracket has no matching open bracket here", (SourceLocatable)remaining.head());
                            }
                            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)remaining.tail();
                            scala.collection.immutable.Seq seq4 = (scala.collection.immutable.Seq)stack.tail();
                            remaining = seq;
                            stack = seq4;
                            continue;
                        }
                        TokenType tokenType = ((Token)remaining.head()).tpe();
                        TokenType$CloseParen$ tokenType$CloseParen$ = TokenType$CloseParen$.MODULE$;
                        if (tokenType != null ? !tokenType.equals(tokenType$CloseParen$) : tokenType$CloseParen$ != null) break block19;
                        if (!stack.isEmpty()) {
                            TokenType tokenType6 = ((Token)stack.head()).tpe();
                            TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
                            if (!(tokenType6 != null ? !tokenType6.equals(tokenType$OpenBracket$) : tokenType$OpenBracket$ != null)) {
                                throw Fail$.MODULE$.exception("Expected close bracket before close paren here", (SourceLocatable)remaining.head());
                            }
                        }
                        if (stack.isEmpty()) break block20;
                        TokenType tokenType7 = ((Token)stack.head()).tpe();
                        TokenType$OpenParen$ tokenType$OpenParen$ = TokenType$OpenParen$.MODULE$;
                        if (!(tokenType7 == null ? tokenType$OpenParen$ != null : !tokenType7.equals(tokenType$OpenParen$))) break block21;
                    }
                    throw Fail$.MODULE$.exception("Closing paren has no matching open paren here", (SourceLocatable)remaining.head());
                }
                scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)remaining.tail();
                scala.collection.immutable.Seq seq5 = (scala.collection.immutable.Seq)stack.tail();
                remaining = seq;
                stack = seq5;
                continue;
            }
            remaining = (scala.collection.immutable.Seq)remaining.tail();
        }
    }

    private final scala.collection.immutable.Seq check$default$2$1() {
        return (scala.collection.immutable.Seq)((SeqOps)Nil$.MODULE$);
    }
}

