/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.util.Hashtable;
import org.nlogo.api.Agent;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Perspective;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.core.Shape;
import org.nlogo.core.ShapeListTracker;
import org.nlogo.render.BoxRenderer;
import org.nlogo.render.HorizCylinderRenderer;
import org.nlogo.render.LinkDrawer;
import org.nlogo.render.SpotlightDrawer;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.render.TorusRenderer;
import org.nlogo.render.TrailDrawer;
import org.nlogo.render.TurtleDrawer;
import org.nlogo.render.VertCylinderRenderer;
import scala.collection.Iterable;
import scala.collection.Seq;

public abstract class AbstractRenderer
implements RendererInterface {
    public final World world;
    public final LinkDrawer linkDrawer;
    public final TurtleDrawer turtleDrawer;
    private final TrailDrawer _trailDrawer;
    public TopologyRenderer topology;
    public final SpotlightDrawer spotlightDrawer = new SpotlightDrawer();
    private boolean _renderLabelsAsRectangles = false;
    private static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    Agent outlineAgent;
    private int[] patchColors;
    private Image patchImage;
    private static final ColorModel COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255);

    @Override
    public TrailDrawerInterface trailDrawer() {
        return this._trailDrawer;
    }

    public boolean renderLabelsAsRectangles() {
        return this._renderLabelsAsRectangles;
    }

    @Override
    public void setRenderLabelsAsRectangles(boolean b) {
        this._renderLabelsAsRectangles = b;
    }

    public AbstractRenderer(World world, ShapeListTracker turtleShapes, ShapeListTracker linkShapes) {
        this.world = world;
        this.linkDrawer = new LinkDrawer(linkShapes);
        this.turtleDrawer = new TurtleDrawer(turtleShapes);
        this._trailDrawer = new TrailDrawer(world, this.turtleDrawer, this.linkDrawer);
        this.changeTopology(world.wrappingAllowedInX(), world.wrappingAllowedInY());
    }

    @Override
    public void changeTopology(boolean wrapX, boolean wrapY) {
        this.topology = wrapX ? (wrapY ? new TorusRenderer(this.world) : new VertCylinderRenderer(this.world)) : (wrapY ? new HorizCylinderRenderer(this.world) : new BoxRenderer(this.world));
        this._trailDrawer.setTopology(this.topology);
    }

    public int getWidth(double patchSize) {
        return (int)StrictMath.round((double)this.world.worldWidth() * patchSize);
    }

    public int getHeight(double patchSize) {
        return (int)StrictMath.round((double)this.world.worldHeight() * patchSize);
    }

    @Override
    public void outlineAgent(Agent agent) {
        this.outlineAgent = agent;
    }

    protected abstract void paintPatchLabels(GraphicsInterface var1, double var2);

    protected abstract void paintTurtles(GraphicsInterface var1, double var2);

    protected abstract void paintLinks(GraphicsInterface var1, double var2);

    protected abstract BufferedImage getSpotlightImage(ViewSettings var1);

    protected abstract boolean anyTurtles();

    @Override
    public void prepareToPaint(ViewSettings settings, int width, int height) {
        this.topology.prepareToPaint(settings, width, height);
    }

    @Override
    public void paint(GraphicsInterface g, ViewSettings settings) {
        this.topology.prepareToPaint(settings, this.getWidth(settings.patchSize()), this.getHeight(settings.patchSize()));
        this.topology.fillBackground(g);
        this.paintPatches(g, settings.patchSize());
        if (!this._trailDrawer.drawingBlank || WINDOWS && this.anyTurtles() && settings.workspaceContext().workspaceGUI()) {
            this.topology.paintViewImage(g, this._trailDrawer.getAndCreateDrawing(false));
        }
        g.setStrokeControl();
        this.paintLinks(g, settings.patchSize());
        this.paintTurtles(g, settings.patchSize());
        if (settings.drawSpotlight() && this.spotlightAgent(settings.perspective())) {
            g.drawImage(this.getSpotlightImage(settings));
        }
    }

    private void paintPatches(GraphicsInterface g, double patchSize) {
        g.antiAliasing(false);
        if (this.world.patchesAllBlack()) {
            this.topology.paintAllPatchesBlack(g);
        } else {
            this.setUpPatchImage();
            this.topology.paintViewImage(g, this.patchImage);
        }
        g.antiAliasing(true);
        this.paintPatchLabels(g, patchSize);
    }

    private void setUpPatchImage() {
        if (this.patchColors != this.world.patchColors()) {
            this.patchColors = this.world.patchColors();
            this.patchImage = new BufferedImage(COLOR_MODEL, Raster.createWritableRaster(COLOR_MODEL.createCompatibleSampleModel(this.world.worldWidth(), this.world.worldHeight()), new DataBufferInt(this.patchColors, this.patchColors.length), new Point(0, 0)), true, new Hashtable());
        }
    }

    @Override
    public void resetCache(double patchSize) {
        this.turtleDrawer.shapes.resetCache(patchSize);
    }

    public void replaceTurtleShapes(Seq<Shape> shapes) {
        this.turtleDrawer.shapes.shapeTracker.replaceShapes((Iterable<Shape>)shapes);
    }

    public void replaceLinkShapes(Seq<Shape> shapes) {
        this.linkDrawer.linkShapeTracker.replaceShapes((Iterable<Shape>)shapes);
    }

    protected boolean darkenPeripheral(ViewSettings settings) {
        return settings.perspective().kind() == 3 && settings.renderPerspective();
    }

    protected boolean spotlightAgent(Perspective perspective) {
        return perspective.kind() == 3 || perspective.kind() == 2 || perspective.kind() == 1;
    }
}

