/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.render.Drawable;
import org.nlogo.shape.VectorShape;

class CachedShape
implements Drawable {
    private final BufferedImage image;
    private final int imageSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedShape(VectorShape shape, int cellSize, int angle, double turtleSize, Color color) {
        this.imageSize = cellSize * (int)StrictMath.ceil(turtleSize);
        this.image = new BufferedImage(this.imageSize, this.imageSize, 2);
        Graphics2DWrapper g = new Graphics2DWrapper((Graphics2D)this.image.getGraphics());
        g.antiAliasing(true);
        try {
            shape.paint(g, color, 0.0, 0.0, turtleSize, cellSize, angle, 0.0);
        }
        finally {
            g.dispose();
        }
    }

    @Override
    public void draw(GraphicsInterface g, double size) {
        g.drawImage(this.image);
    }

    @Override
    public double adjustSize(double turtleSize, double patchSize) {
        return 0.0;
    }

    int getPixelCount() {
        return this.imageSize * this.imageSize;
    }
}

