/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Color;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.Patch;
import org.nlogo.api.Turtle;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.api.WorldWithWorldRenderable;
import org.nlogo.core.AgentKindJ;
import org.nlogo.render.AbstractRenderer;
import scala.collection.Iterator;

public class Renderer
extends AbstractRenderer {
    public Renderer(WorldWithWorldRenderable world) {
        this(world, false);
    }

    public Renderer(WorldWithWorldRenderable world, boolean renderLabelsAsRectangles) {
        super(world, world.turtleShapes(), world.linkShapes());
        this.setRenderLabelsAsRectangles(renderLabelsAsRectangles);
    }

    @Override
    public void paint(Graphics2D g, ViewSettings settings) {
        this.paint(new Graphics2DWrapper(g, this.renderLabelsAsRectangles()), settings);
    }

    @Override
    protected void paintPatchLabels(GraphicsInterface g, double patchSize) {
        if (this.world.patchesWithLabels() > 0) {
            int patchCount = this.world.patches().count();
            for (int i = 0; i < patchCount; ++i) {
                Patch patch = this.world.getPatch(i);
                if (!patch.hasLabel()) continue;
                this.drawPatchLabel(g, patch, patchSize);
            }
        }
        if (this.outlineAgent instanceof Patch) {
            Patch patch = (Patch)this.outlineAgent;
            this.topology.drawWrappedRect(g, Color.getComplement(Color.getColor(patch.pcolor())), 1.0f, patch.pxcor(), patch.pycor(), 1.0, patchSize, false);
        }
    }

    @Override
    protected void paintLinks(GraphicsInterface g, double patchSize) {
        int linksDrawn = 0;
        Iterator iter = this.world.program().linkBreeds().keys().iterator();
        while (iter.hasNext()) {
            AgentSet breed = this.world.getLinkBreed((String)iter.next());
            for (Agent a : breed.agents()) {
                this.linkDrawer.drawLink(g, this.topology, (Link)a, patchSize, false);
                ++linksDrawn;
            }
        }
        if (linksDrawn < this.world.links().count()) {
            for (Agent a : this.world.links().agents()) {
                Link link = (Link)a;
                if (link.getBreed() != this.world.links()) continue;
                this.linkDrawer.drawLink(g, this.topology, link, patchSize, false);
            }
        }
        if (this.outlineAgent instanceof Link) {
            this.linkDrawer.drawLink(g, this.topology, (Link)this.outlineAgent, patchSize, true);
        }
    }

    @Override
    protected void paintTurtles(GraphicsInterface g, double patchSize) {
        int turtlesDrawn = 0;
        Iterator iter = this.world.program().breeds().keys().iterator();
        while (iter.hasNext()) {
            AgentSet breed = this.world.getBreed((String)iter.next());
            if (breed.kind() != AgentKindJ.Turtle()) continue;
            for (Agent a : breed.agents()) {
                this.turtleDrawer.drawTurtle(g, this.topology, (Turtle)a, patchSize);
                ++turtlesDrawn;
            }
        }
        if (turtlesDrawn < this.world.turtles().count()) {
            for (Agent a : this.world.turtles().agents()) {
                Turtle turtle = (Turtle)a;
                if (turtle.getBreed() != this.world.turtles()) continue;
                this.turtleDrawer.drawTurtle(g, this.topology, turtle, patchSize);
            }
        }
        if (this.outlineAgent instanceof Turtle) {
            this.turtleDrawer.drawTurtleWithOutline(g, this.topology, (Turtle)this.outlineAgent, patchSize);
        }
    }

    private void drawPatchLabel(GraphicsInterface g, Patch patch, double patchSize) {
        this.topology.drawLabelHelper(g, patch.pxcor(), patch.pycor(), patch.labelString(), patch.labelColor(), patchSize, 1.0);
    }

    Agent targetAgent() {
        return this.world.observer().targetAgent();
    }

    @Override
    protected BufferedImage getSpotlightImage(ViewSettings settings) {
        double ycor;
        double xcor;
        double spotlightSize;
        boolean wrap = false;
        Agent agent = this.targetAgent();
        if (agent instanceof Turtle) {
            Turtle turtle = (Turtle)agent;
            spotlightSize = turtle.size() * 2.0;
            xcor = turtle.xcor();
            ycor = turtle.ycor();
            wrap = true;
        } else if (agent instanceof Link) {
            Link link = (Link)agent;
            spotlightSize = link.size();
            xcor = link.midpointX();
            ycor = link.midpointY();
        } else {
            Patch patch = (Patch)agent;
            spotlightSize = 2.0;
            xcor = patch.pxcor();
            ycor = patch.pycor();
        }
        return this.spotlightDrawer.getImage(this.topology, xcor, ycor, this.getWidth(settings.patchSize()), this.getHeight(settings.patchSize()), settings.patchSize(), spotlightSize, this.darkenPeripheral(settings), wrap);
    }

    @Override
    protected boolean anyTurtles() {
        return this.world.turtles().count() > 0;
    }

    @Override
    public double graphicsX(double xcor, double patchSize, double viewOffsetX) {
        return this.topology.graphicsX(xcor, patchSize, viewOffsetX);
    }

    @Override
    public double graphicsY(double ycor, double patchSize, double viewOffsetY) {
        return this.topology.graphicsY(ycor, patchSize, viewOffsetY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage exportView(ViewSettings settings) {
        BufferedImage image = new BufferedImage(this.getWidth(settings.patchSize()), this.getHeight(settings.patchSize()), 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Font font = g.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), settings.fontSize());
        g.setFont(newFont);
        World world = this.world;
        synchronized (world) {
            this.paint(g, settings);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportView(Graphics2D g, ViewSettings settings) {
        World world = this.world;
        synchronized (world) {
            this.paint(g, settings);
        }
    }
}

