/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm;

import java.io.Serializable;
import org.nlogo.sdm.Converter;
import org.nlogo.sdm.EOLToken$;
import org.nlogo.sdm.Model;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.Rate;
import org.nlogo.sdm.Reservoir;
import org.nlogo.sdm.Stock;
import org.nlogo.sdm.Token;
import org.nlogo.sdm.Tokenizer;
import org.nlogo.sdm.WordToken;
import org.nlogo.sdm.WordToken$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class Loader$
implements Serializable {
    public static final Loader$ MODULE$ = new Loader$();

    private Loader$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Loader$.class);
    }

    public Option<Model> load(String input) {
        Seq lines = Source$.MODULE$.fromString(this.mungeClassNames(input)).getLines().map((Function1 & Serializable)_$1 -> _$1.trim()).filter((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2))).toSeq();
        Option option = lines.headOption();
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            String dt = (String)((Some)option).value();
            Model model = this.buildModel(new Tokenizer(((IterableOnceOps)lines.tail()).mkString("", "\n", "\n")), StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(dt)), StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(input)).drop(1).mkString("\n"));
            return Some$.MODULE$.apply((Object)model);
        }
        throw new MatchError((Object)option);
    }

    public String mungeClassNames(String input) {
        return input.replaceAll(" *org.nlogo.sdm.Stock ", "org.nlogo.sdm.gui.WrappedStock ").replaceAll(" *org.nlogo.sdm.Rate ", "org.nlogo.sdm.gui.WrappedRate ").replaceAll(" *org.nlogo.sdm.Reservoir ", "org.nlogo.sdm.gui.WrappedReservoir").replaceAll(" *org.nlogo.sdm.Converter ", "org.nlogo.sdm.gui.WrappedConverter").replaceAll("org.nlogo.aggregate.gui", "org.nlogo.sdm.gui");
    }

    private Model buildModel(Tokenizer tokens, double dt, String serializedGUI) {
        scala.collection.mutable.Map lineMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        ObjectRef model = ObjectRef.create(null);
        block0: while (tokens.hasNext()) {
            Token token = tokens.next();
            if (token instanceof WordToken) {
                String string;
                WordToken wordToken = WordToken$.MODULE$.unapply((WordToken)token);
                String name = string = wordToken._1();
                this.readElement(name, tokens).foreach(me -> {
                    ModelElement modelElement = me;
                    if (modelElement instanceof Model) {
                        Model m = (Model)modelElement;
                        Predef$.MODULE$.require((Model)model$1.elem == null, () -> Loader$.buildModel$$anonfun$1$$anonfun$1(tokens));
                        model$1.elem = m.copy(m.copy$default$1(), m.copy$default$2(), m.copy$default$3(), serializedGUI);
                        ((Model)model$1.elem).setDt(dt);
                    } else if (modelElement instanceof Stock) {
                        Stock s = (Stock)modelElement;
                        lineMap.update((Object)BoxesRunTime.boxToInteger((int)tokens.lineNumber()), (Object)s);
                    } else if (modelElement instanceof Rate) {
                        Rate r = (Rate)modelElement;
                        MODULE$.setSourceSink(r, tokens, (Map<Object, ModelElement>)lineMap);
                    }
                    ((Model)model$1.elem).addElement((ModelElement)me);
                });
            } else {
                throw new Exception("Invalid SDM Model");
            }
            while (tokens.hasNext()) {
                Token token2 = tokens.next();
                EOLToken$ eOLToken$ = EOLToken$.MODULE$;
                if (!(token2 == null ? eOLToken$ != null : !token2.equals(eOLToken$))) continue block0;
            }
        }
        return (Model)model.elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<ModelElement> readElement(String name, Tokenizer tokens) {
        String string = name;
        switch (string == null ? 0 : string.hashCode()) {
            case -2021919711: {
                if (!"org.nlogo.sdm.gui.WrappedRate".equals(string)) throw new MatchError((Object)string);
                Rate rate = new Rate();
                rate.expression_$eq(tokens.string());
                rate.name_$eq(tokens.string());
                return Some$.MODULE$.apply((Object)rate);
            }
            case -2018325647: {
                if ("org.jhotdraw.figures.ChopEllipseConnector".equals(string)) return None$.MODULE$;
                throw new MatchError((Object)string);
            }
            case -1822501952: {
                if ("org.nlogo.sdm.gui.ConverterFigure".equals(string)) return None$.MODULE$;
                throw new MatchError((Object)string);
            }
            case -1263157578: {
                if ("org.nlogo.sdm.gui.StockFigure".equals(string)) return None$.MODULE$;
                throw new MatchError((Object)string);
            }
            case -676488353: {
                if ("org.nlogo.sdm.gui.BindingConnection".equals(string)) return None$.MODULE$;
                throw new MatchError((Object)string);
            }
            case -421035581: {
                if (!"org.nlogo.sdm.gui.AggregateDrawing".equals(string)) throw new MatchError((Object)string);
                Model model = new Model("Test Model", 1.0);
                return Some$.MODULE$.apply((Object)model);
            }
            case -179783218: {
                if ("org.nlogo.sdm.gui.WrappedReservoir".equals(string)) return None$.MODULE$;
                throw new MatchError((Object)string);
            }
            case 28955249: {
                if ("org.jhotdraw.contrib.ChopDiamondConnector".equals(string)) return None$.MODULE$;
                throw new MatchError((Object)string);
            }
            case 362524994: {
                if ("org.nlogo.sdm.gui.RateConnection".equals(string)) return None$.MODULE$;
                throw new MatchError((Object)string);
            }
            case 1162130255: {
                if ("org.nlogo.sdm.gui.ReservoirFigure".equals(string)) return None$.MODULE$;
                throw new MatchError((Object)string);
            }
            case 1246872988: {
                if ("org.jhotdraw.standard.ChopBoxConnector".equals(string)) return None$.MODULE$;
                throw new MatchError((Object)string);
            }
            case 1646783491: {
                if ("org.nlogo.sdm.gui.ChopRateConnector".equals(string)) return None$.MODULE$;
                throw new MatchError((Object)string);
            }
            case 1742488319: {
                if (!"org.nlogo.sdm.gui.WrappedConverter".equals(string)) throw new MatchError((Object)string);
                Converter converter = new Converter();
                converter.expression_$eq(tokens.string());
                converter.name_$eq(tokens.string());
                return Some$.MODULE$.apply((Object)converter);
            }
            case 1746483189: {
                if (!"org.nlogo.sdm.gui.WrappedStock".equals(string)) throw new MatchError((Object)string);
                Stock stock = new Stock();
                stock.name_$eq(tokens.string());
                stock.initialValueExpression_$eq(tokens.string());
                stock.nonNegative_$eq(tokens.boolean());
                return Some$.MODULE$.apply((Object)stock);
            }
        }
        throw new MatchError((Object)string);
    }

    private void setSourceSink(Rate rate, Tokenizer tokens, Map<Object, ModelElement> lineMap) {
        WordToken wordToken;
        String string;
        Token token = tokens.next();
        if (token instanceof WordToken && "REF".equals(string = (wordToken = WordToken$.MODULE$.unapply((WordToken)token))._1())) {
            WordToken wordToken2;
            String string2;
            rate.source_$eq(this.getSourceOrSink(tokens, lineMap));
            Token token2 = tokens.next();
            rate.sink_$eq(token2 instanceof WordToken && "REF".equals(string2 = (wordToken2 = WordToken$.MODULE$.unapply((WordToken)token2))._1()) ? this.getSourceOrSink(tokens, lineMap) : new Reservoir());
            return;
        }
        tokens.next();
        tokens.next();
        rate.sink_$eq(this.getSourceOrSink(tokens, lineMap));
        rate.source_$eq(this.getSourceOrSink(tokens, lineMap));
    }

    private Stock getSourceOrSink(Tokenizer tokens, Map<Object, ModelElement> lineMap) {
        return (Stock)lineMap.get((Object)BoxesRunTime.boxToInteger((int)(tokens.number() + 1))).map((Function1 & Serializable)_$3 -> (Stock)_$3).getOrElse(Loader$::getSourceOrSink$$anonfun$2);
    }

    private static final Object buildModel$$anonfun$1$$anonfun$1(Tokenizer tokens$2) {
        return tokens$2.diagnostics();
    }

    private static final Stock getSourceOrSink$$anonfun$2() {
        return new Reservoir();
    }
}

