/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.nlogo.core.CompilerException;
import org.nlogo.core.LiteralParser;
import org.nlogo.sdm.Converter;
import org.nlogo.sdm.Model;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.Rate;
import org.nlogo.sdm.Reservoir;
import org.nlogo.sdm.Stock;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public class Translator {
    private final LiteralParser compiler;
    private final ListBuffer<Stock> stocks;
    private final ListBuffer<Rate> rates;
    private final ListBuffer<Converter> converters;
    private final ListBuffer<Converter> constantConverters;
    private final String dt;

    public Translator(Model model, LiteralParser compiler) {
        this.compiler = compiler;
        this.stocks = new ListBuffer();
        this.rates = new ListBuffer();
        this.converters = new ListBuffer();
        this.constantConverters = new ListBuffer();
        this.dt = BoxesRunTime.boxToDouble((double)model.dt()).toString();
        model.elements().withFilter((Function1 & Serializable)element -> !element.name().isEmpty()).foreach((Function1 & Serializable)element -> {
            ModelElement modelElement = element;
            if (modelElement instanceof Reservoir) {
                return BoxedUnit.UNIT;
            }
            if (modelElement instanceof Stock) {
                Stock s = (Stock)modelElement;
                return this.stocks().$plus$eq((Object)s);
            }
            if (modelElement instanceof Rate) {
                Rate r = (Rate)modelElement;
                if (!r.expression().isEmpty()) {
                    this.rates().$plus$eq((Object)r);
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            if (modelElement instanceof Converter) {
                Converter c = (Converter)modelElement;
                if (!c.expression().isEmpty()) {
                    if (this.isConstant(c.expression().toUpperCase(Locale.ENGLISH))) {
                        this.constantConverters().$plus$eq((Object)c);
                        return BoxedUnit.UNIT;
                    }
                    this.converters().$plus$eq((Object)c);
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
    }

    public ListBuffer<Stock> stocks() {
        return this.stocks;
    }

    public ListBuffer<Rate> rates() {
        return this.rates;
    }

    public ListBuffer<Converter> converters() {
        return this.converters;
    }

    public ListBuffer<Converter> constantConverters() {
        return this.constantConverters;
    }

    public String dt() {
        return this.dt;
    }

    public String source() {
        Object[] sortedStocks = (Stock[])this.stocks().toArray(ClassTag$.MODULE$.apply(Stock.class));
        Arrays.sort(sortedStocks, new StockComparator());
        ObjectRef globals = ObjectRef.create((Object)"");
        ObjectRef procedures = ObjectRef.create((Object)"");
        ObjectRef plots = ObjectRef.create((Object)"");
        globals.elem = (String)globals.elem + ";; System dynamics model globals\nglobals [\n";
        procedures.elem = (String)procedures.elem + ";; Initializes the system dynamics model.\n;; Call this in your model's SETUP procedure.\n";
        procedures.elem = (String)procedures.elem + ("to system-dynamics-setup\n  reset-ticks\n  set dt " + this.dt() + "\n");
        if (!this.constantConverters().isEmpty()) {
            globals.elem = (String)globals.elem + "  ;; constants\n";
            procedures.elem = (String)procedures.elem + "  ;; initialize constant values\n";
            this.constantConverters().foreach(cc -> {
                globals$1.elem = (String)globals$1.elem + ("  " + cc.name() + "\n");
                procedures$1.elem = (String)procedures$1.elem + this.initialValueExpressionForConverter((Converter)cc);
            });
        }
        if (!this.stocks().isEmpty()) {
            globals.elem = (String)globals.elem + "  ;; stock values\n";
            procedures.elem = (String)procedures.elem + "  ;; initialize stock values\n";
            Object object = Predef$.MODULE$.refArrayOps(sortedStocks);
            ArrayOps$.MODULE$.foreach$extension(object, s -> {
                globals$2.elem = (String)globals$2.elem + ("  " + s.name() + "\n");
                procedures$2.elem = (String)procedures$2.elem + this.initialValueExpressionForStock((Stock)s);
            });
        }
        globals.elem = (String)globals.elem + "  ;; size of each step, see SYSTEM-DYNAMICS-GO\n  dt\n";
        globals.elem = (String)globals.elem + "]\n\n";
        procedures.elem = (String)procedures.elem + "end\n\n";
        procedures.elem = (String)procedures.elem + ";; Step through the system dynamics model by performing next iteration of Euler's method.\n";
        procedures.elem = (String)procedures.elem + ";; Call this in your model's GO procedure.\n";
        procedures.elem = (String)procedures.elem + "to system-dynamics-go\n";
        plots.elem = (String)plots.elem + ";; Plot the current state of the system dynamics model's stocks\n";
        plots.elem = (String)plots.elem + ";; Call this procedure in your plot's update commands.\n";
        plots.elem = (String)plots.elem + "to system-dynamics-do-plot\n";
        if (!this.converters().isEmpty() || !this.rates().isEmpty()) {
            procedures.elem = (String)procedures.elem + "\n  ;; compute variable and flow values once per step\n";
            this.converters().foreach(c -> {
                procedures$3.elem = (String)procedures$3.elem + ("  let local-" + c.name() + " " + c.name() + "\n");
            });
            this.rates().foreach(r -> {
                procedures$4.elem = (String)procedures$4.elem + ("  let local-" + r.name() + " " + r.name() + "\n");
            });
        }
        if (!this.stocks().isEmpty()) {
            procedures.elem = (String)procedures.elem + "\n  ;; update stock values\n  ;; use temporary variables so order of computation doesn't affect result.\n";
            Object object = Predef$.MODULE$.refArrayOps(sortedStocks);
            ArrayOps$.MODULE$.foreach$extension(object, s -> {
                procedures$5.elem = (String)procedures$5.elem + this.updateStockExpression((Stock)s);
                plots$1.elem = (String)plots$1.elem + ("  if plot-pen-exists? \"" + s.name() + "\" [\n");
                plots$1.elem = (String)plots$1.elem + ("    set-current-plot-pen \"" + s.name() + "\"\n");
                plots$1.elem = (String)plots$1.elem + ("    plotxy ticks " + s.name() + "\n");
                plots$1.elem = (String)plots$1.elem + "  ]\n";
            });
            Object object2 = Predef$.MODULE$.refArrayOps(sortedStocks);
            ArrayOps$.MODULE$.foreach$extension(object2, s -> {
                procedures$6.elem = (String)procedures$6.elem + ("  set " + s.name() + " new-" + s.name() + "\n");
            });
        }
        procedures.elem = (String)procedures.elem + "\n  tick-advance dt\nend\n\n";
        plots.elem = (String)plots.elem + "end\n\n";
        this.rates().foreach(r -> {
            procedures$7.elem = (String)procedures$7.elem + this.procedureForRate((Rate)r);
        });
        this.converters().foreach(c -> {
            procedures$8.elem = (String)procedures$8.elem + this.procedureForConverter((Converter)c);
        });
        return (String)globals.elem + (String)procedures.elem + (String)plots.elem;
    }

    private String procedureForRate(Rate r) {
        return ";; Report value of flow\nto-report " + r.name() + "\n  report ( " + (r.expression() == null ? "0" : r.expression()) + "\n  ) * dt\nend\n\n";
    }

    public String procedureForConverter(Converter c) {
        return ";; Report value of variable\nto-report " + c.name() + "\n  report " + (c.expression() == null ? "0" : c.expression()) + "\nend\n\n";
    }

    public String initialValueExpressionForStock(Stock s) {
        return "  set " + s.name() + " " + (s.initialValueExpression() != null ? s.initialValueExpression() : "0") + "\n";
    }

    public String initialValueExpressionForConverter(Converter c) {
        return "  set " + c.name() + " " + (c.expression() != null ? c.expression() : "0") + "\n";
    }

    public String updateStockExpression(Stock s) {
        ObjectRef expr = ObjectRef.create((Object)("  let new-" + s.name() + (s.nonNegative() ? " max( list 0 ( " : " ( ") + s.name() + " "));
        this.rates().foreach(r -> {
            String string = r.source().name();
            String string2 = s.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                expr$1.elem = (String)expr$1.elem + ("- local-" + r.name() + " ");
            }
            String string3 = r.sink().name();
            String string4 = s.name();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                expr$1.elem = (String)expr$1.elem + ("+ local-" + r.name() + " ");
                return;
            }
        });
        if (s.nonNegative()) {
            expr.elem = (String)expr.elem + ") ";
        }
        return (String)expr.elem + ")\n";
    }

    public boolean isConstant(String s) {
        boolean bl;
        try {
            this.compiler.readFromString(s);
            bl = true;
        }
        catch (CompilerException compilerException) {
            bl = false;
        }
        return bl;
    }

    public class StockComparator
    implements Comparator<Stock> {
        public StockComparator() {
            if (Translator.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public int compare(Stock s1, Stock s2) {
            String sname1 = s1.name().toUpperCase(Locale.ENGLISH);
            String sname2 = s2.name().toUpperCase(Locale.ENGLISH);
            String sexp1 = s1.initialValueExpression().toUpperCase(Locale.ENGLISH);
            String sexp2 = s2.initialValueExpression().toUpperCase(Locale.ENGLISH);
            if (Translator.this.isConstant(sexp1)) {
                if (Translator.this.isConstant(sexp2)) {
                    return sname1.compareTo(sname2);
                }
                return -1;
            }
            if (Translator.this.isConstant(sexp2)) {
                return 1;
            }
            return sname1.compareTo(sname2);
        }

        public final /* synthetic */ Translator org$nlogo$sdm$Translator$StockComparator$$$outer() {
            return Translator.this;
        }
    }
}

