/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm.gui;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.DragTracker;
import org.jhotdraw.standard.SelectionTool;
import org.nlogo.sdm.Model;
import org.nlogo.sdm.gui.AggregateConnectionTool;
import org.nlogo.sdm.gui.AggregateModelEditor;
import org.nlogo.sdm.gui.AggregateUndoableTool;
import org.nlogo.sdm.gui.BindingConnection;
import org.nlogo.sdm.gui.ConverterFigure;
import org.nlogo.sdm.gui.RateConnection;
import org.nlogo.sdm.gui.RateConnectionTool;
import org.nlogo.sdm.gui.StockFigure;
import scala.collection.immutable.List;
import scala.jdk.javaapi.CollectionConverters;

class InspectionTool
extends SelectionTool {
    private final AggregateModelEditor editor;
    private Model model;
    private RateConnectionTool rct;
    private AggregateConnectionTool link;

    InspectionTool(AggregateModelEditor editor, Model model) {
        super((DrawingEditor)editor);
        this.editor = editor;
        this.model = model;
    }

    protected void inspectFigure(Figure f) {
        this.editor.inspectFigure(f);
    }

    public void fillInputs(Figure figure, DrawingView view) {
        FigureEnumeration figNum = view.getConnectionFigures(figure);
        if (figNum == null) {
            return;
        }
        String currentName = "";
        ArrayList<String> lst = new ArrayList<String>();
        while (figNum.hasNextFigure()) {
            BindingConnection c;
            Figure nFig = figNum.nextFigure();
            if (!(nFig instanceof BindingConnection) || (c = (BindingConnection)nFig).getEndConnector().owner() != figure) continue;
            Figure start = c.getStartConnector().owner();
            if (start instanceof RateConnection) {
                currentName = ((RateConnection)start).nameWrapper();
            } else if (start instanceof ConverterFigure) {
                currentName = ((ConverterFigure)start).nameWrapper();
            } else if (start instanceof StockFigure) {
                currentName = ((StockFigure)start).nameWrapper();
            }
            if (currentName == null || currentName == "") continue;
            lst.add(currentName);
        }
        if (figure instanceof ConverterFigure) {
            ((ConverterFigure)figure).inputs((List<String>)CollectionConverters.asScala(lst).toList());
        } else if (figure instanceof RateConnection) {
            ((RateConnection)figure).inputs((List<String>)CollectionConverters.asScala(lst).toList());
        }
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        DrawingView view = (DrawingView)e.getSource();
        this.setView(view);
        if (!e.isMetaDown()) {
            if (e.getClickCount() == 2) {
                Figure figure = this.drawing().findFigure(e.getX(), e.getY());
                this.fillInputs(figure, view);
                if (figure != null) {
                    this.inspectFigure(figure);
                    return;
                }
            }
            super.mouseDown(e, x, y);
        } else {
            this.link = new AggregateConnectionTool(this.model, this.editor, (ConnectionFigure)new BindingConnection());
            this.rct = new RateConnectionTool(this.model, this.editor, (ConnectionFigure)new RateConnection());
            this.link.mouseDown(e, x, y);
            this.rct.mouseDown(e, x, y);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (!e.isMetaDown()) {
            super.mouseUp(e, x, y);
        } else {
            if (this.link != null) {
                this.link.mouseUp(e, x, y);
            }
            if (this.rct != null) {
                this.rct.mouseUp(e, x, y);
            }
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (!e.isMetaDown()) {
            super.mouseDrag(e, x, y);
        } else {
            this.link.mouseDrag(e, x, y);
            this.rct.mouseDrag(e, x, y);
        }
    }

    protected Tool createDragTracker(Figure f) {
        return new AggregateUndoableTool((Tool)new DragTracker(this.editor(), f), this.editor);
    }
}

