/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureVisitor;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.Options;
import org.nlogo.editor.Colorizer;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.Rate;
import org.nlogo.sdm.Reservoir;
import org.nlogo.sdm.Stock;
import org.nlogo.sdm.gui.ChopRateConnector;
import org.nlogo.sdm.gui.ModelElementFigure;
import org.nlogo.sdm.gui.RateEditPanel;
import org.nlogo.sdm.gui.Utils;
import org.nlogo.sdm.gui.WrappedRate;
import org.nlogo.sdm.gui.Wrapper;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.List;

public class RateConnection
extends LineConnection
implements ModelElementFigure,
Editable {
    static final int ICON_SIZE = 25;
    private Rate rate;
    private String name;
    private transient CompilerServices compiler;
    private transient Colorizer colorizer;
    private transient ExtensionManager extensionManager;
    private boolean dirty = false;

    public RateConnection() {
        this.setEndDecoration(null);
        this.setStartDecoration(null);
        this.rate = new Rate();
        this.rate.setSelected("Select");
    }

    public void setConstructorDeps(CompilerServices compiler, Colorizer colorizer, ExtensionManager extensionManager) {
        this.compiler = compiler;
        this.colorizer = colorizer;
        this.extensionManager = extensionManager;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public ModelElement getModelElement() {
        return this.rate;
    }

    @Override
    public boolean anyErrors() {
        return false;
    }

    @Override
    public void error(Object o, Exception e) {
    }

    @Override
    public Option<Exception> error(Object key) {
        return Option.apply(null);
    }

    @Override
    public int sourceOffset() {
        return 0;
    }

    public boolean containsPoint(int x, int y) {
        Rectangle bounds = this.displayBox();
        bounds.grow(4, 4);
        if (!bounds.contains(x, y)) {
            return false;
        }
        Point middle = this.middlePoint();
        return 12L >= Geom.length((int)x, (int)y, (int)middle.x, (int)middle.y);
    }

    public boolean canConnect(Figure start, Figure end) {
        ModelElement source = ((ModelElementFigure)start).getModelElement();
        ModelElement sink = ((ModelElementFigure)end).getModelElement();
        if (sink == source) {
            return false;
        }
        if (!(source instanceof Stock)) {
            return false;
        }
        if (!(sink instanceof Stock)) {
            return false;
        }
        return !(source instanceof Reservoir) || !(sink instanceof Reservoir);
    }

    public void handleConnect(Figure start, Figure end) {
        this.rate.setSource((Stock)((ModelElementFigure)start).getModelElement());
        this.rate.setSink((Stock)((ModelElementFigure)end).getModelElement());
        this.initializeMiddlePoint();
    }

    public boolean canConnect() {
        return true;
    }

    public Connector connectorAt(int x, int y) {
        return new ChopRateConnector((Figure)this);
    }

    public Rectangle displayBox() {
        Rectangle r = super.displayBox();
        r.grow(30, 50);
        return r;
    }

    public Insets connectionInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void draw(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.draw(g);
        if (this.getModelElement() != null) {
            String displayname;
            g.setColor(Color.BLACK);
            Color oldColor = g.getColor();
            if (!this.getModelElement().isComplete()) {
                g.setColor(Color.RED);
            }
            if ((displayname = this.getModelElement().getName()).length() == 0) {
                displayname = "?";
            }
            Point center = this.middlePoint();
            int labelX = center.x - 25 - 3;
            int labelY = center.y - 25 + 50;
            Font oldFont = g.getFont();
            g.setFont(oldFont.deriveFont(2, 10.0f));
            Utils.drawStringInBox(g, displayname, labelX, labelY);
            g.setFont(oldFont);
            g.setColor(oldColor);
        }
    }

    public void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        int[] ycors;
        int[] xcors;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int mx = x1 + (x2 - x1) / 2;
        int my = y1 + (y2 - y1) / 2;
        int wx = 4;
        int wy = 4;
        int a = 6;
        int aw = 8;
        if (x2 < x1) {
            aw = -aw;
            wx = -wx;
        }
        if (y2 < y1) {
            wy = -wy;
            a = -a;
        }
        if (StrictMath.abs(x2 - x1) < StrictMath.abs(y2 - y1)) {
            if (y1 > y2) {
                a = -a;
                aw = -aw;
            }
            if (x1 > x2) {
                aw = -aw;
                a = -a;
            }
            xcors = new int[]{x1 - wx, x1 - wx, x2 - wx, x2 - wx, x2 - wx - a, x2, x2 + wx + a, x2 + wx, x2 + wx, x1 + wx, x1 + wx};
            ycors = new int[]{y1, my + wy, my + wy, y2 - aw, y2 - aw, y2 + aw, y2 - aw, y2 - aw, my - wy, my - wy, y1};
        } else {
            xcors = new int[]{x1, mx + wx, mx + wx, x2 - aw, x2 - aw, x2 + aw, x2 - aw, x2 - aw, mx - wx, mx - wx, x1};
            ycors = new int[]{y1 - wy, y1 - wy, y2 - wy, y2 - wy, y2 - wy - a, y2, y2 + wy + a, y2 + wy, y2 + wy, y1 + wy, y1 + wy};
        }
        g.setColor(Color.LIGHT_GRAY);
        g.fillPolygon(xcors, ycors, 11);
        g.setColor(Color.BLACK);
        g.drawPolyline(xcors, ycors, 11);
        this.drawIcon(g);
    }

    private void drawIcon(Graphics g) {
        Point middle = this.middlePoint();
        int cx = middle.x;
        int cy = middle.y;
        int cs = 25;
        g.setColor(Color.GRAY);
        g.fillPolygon(new int[]{cx - 1, cx + 1, cx + 1, cx + cs / 2 - 2, cx + cs / 2 - 4, cx - cs / 2 + 4, cx - cs / 2 + 2, cx - 1, cx - 1}, new int[]{cy - 14, cy - 14, cy - cs, cy - cs, cy - (cs + 2), cy - (cs + 2), cy - cs, cy - cs, cy - 14}, 9);
        g.setColor(Color.BLACK);
        g.drawPolygon(new int[]{cx - 1, cx + 1, cx + 1, cx + cs / 2 - 2, cx + cs / 2 - 4, cx - cs / 2 + 4, cx - cs / 2 + 2, cx - 1, cx - 1}, new int[]{cy - 14, cy - 14, cy - cs, cy - cs, cy - (cs + 2), cy - (cs + 2), cy - cs, cy - cs, cy - 14}, 9);
        g.setColor(Color.GRAY);
        g.fillOval(cx - cs / 2, cy - cs / 2 - 4, cs, cs);
        g.setColor(Color.BLACK);
        g.drawOval(cx - cs / 2, cy - cs / 2 - 4, cs, cs);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(Wrapper.wrap(this.rate));
    }

    private Point middlePoint() {
        if (this.pointCount() != 3) {
            Point end = this.endPoint();
            Point start = this.startPoint();
            return new Point((start.x + end.x) / 2, (start.y + end.y) / 2);
        }
        return this.pointAt(1);
    }

    private void initializeMiddlePoint() {
        Point end = this.endPoint();
        Point start = this.startPoint();
        Point middle = new Point();
        middle.x = (start.x + end.x) / 2;
        middle.y = (start.y + end.y) / 2;
        if (this.pointCount() == 2) {
            this.insertPointAt(middle, 1);
        } else {
            this.setPointAt(middle, 1);
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.rate = ((WrappedRate)dr.readStorable()).rate;
    }

    public void visit(FigureVisitor visitor) {
        FigureEnumeration f = this.getDependendFigures();
        visitor.visitFigure((Figure)this);
        while (f.hasNextFigure()) {
            Figure fig = f.nextFigure();
            fig.visit(visitor);
        }
    }

    public synchronized void removeDependendFigure(Figure oldDependendFigure) {
    }

    public int splitSegment(int x, int y) {
        return -1;
    }

    public boolean joinSegments(int x, int y) {
        return false;
    }

    public void setPointAt(Point p, int i) {
        if (i >= 0) {
            super.setPointAt(p, i);
        }
    }

    @Override
    public Option<String> helpLink() {
        return Option.apply(null);
    }

    @Override
    public EditPanel editPanel() {
        return new RateEditPanel(this, this.compiler, this.colorizer, this.extensionManager);
    }

    @Override
    public boolean dirty() {
        return this.dirty;
    }

    @Override
    public String classDisplayName() {
        return "Flow";
    }

    @Override
    public boolean editFinished() {
        return true;
    }

    public void nameWrapper(String name) {
        this.dirty = this.dirty || !this.rate.getName().equals(name);
        this.rate.setName(name);
    }

    public String nameWrapper() {
        return this.rate.getName();
    }

    public void expressionWrapper(String expression) {
        this.dirty = this.dirty || !this.rate.getExpression().equals(expression);
        this.rate.setExpression(expression);
    }

    public String expressionWrapper() {
        return this.rate.getExpression();
    }

    public void bivalentWrapper(boolean bivalent) {
        this.dirty = this.dirty || this.rate.isBivalent() != bivalent;
        this.rate.setBivalent(bivalent);
    }

    public boolean bivalentWrapper() {
        return this.rate.isBivalent();
    }

    public void inputs(Options<String> newInputs) {
        String newChoice = newInputs.chosenName();
        String oldChoice = this.rate.getSelected();
        this.rate.setSelected(newChoice);
        if (!"Select".equals(newChoice) && !oldChoice.equals(newChoice)) {
            String oldExpression = this.rate.getExpression();
            String newExpression = oldExpression.trim() + " " + newChoice + " ";
            this.rate.setExpression(newExpression);
        }
    }

    public Options<String> inputs() {
        Options<String> inputs = new Options<String>();
        inputs.addOption("Select", "unused");
        inputs.selectByName("Select");
        Iterator ins = this.rate.getInputs().iterator();
        while (ins.hasNext()) {
            inputs.addOption((String)ins.next(), "unused");
        }
        String name = this.rate.getSelected();
        if (name != "") {
            inputs.selectByName(name);
        }
        return inputs;
    }

    public void inputs(List<String> ls) {
        this.rate.setInputs(ls);
    }
}

