/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.core.Shape;
import org.nlogo.core.Shape$RgbColor$;
import org.nlogo.shape.Element$;
import scala.Int$;
import scala.Predef$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public abstract class Element
implements Shape.Element,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    private Color awtColor;
    private boolean filled;
    private boolean marked;
    private boolean selected;

    public static int SHAPE_WIDTH() {
        return Element$.MODULE$.SHAPE_WIDTH();
    }

    public static int round(double d) {
        return Element$.MODULE$.round(d);
    }

    public static Color $lessinit$greater$default$1() {
        return Element$.MODULE$.$lessinit$greater$default$1();
    }

    public Element(Color awtColor) {
        this.awtColor = awtColor;
        this.filled = false;
        this.marked = false;
        this.selected = false;
    }

    public Color awtColor() {
        return this.awtColor;
    }

    public void awtColor_$eq(Color x$1) {
        this.awtColor = x$1;
    }

    @Override
    public boolean filled() {
        return this.filled;
    }

    public void filled_$eq(boolean x$1) {
        this.filled = x$1;
    }

    @Override
    public boolean marked() {
        return this.marked;
    }

    public void marked_$eq(boolean x$1) {
        this.marked = x$1;
    }

    @Override
    public Shape.RgbColor color() {
        return Shape$RgbColor$.MODULE$.apply(this.awtColor().getRed(), this.awtColor().getGreen(), this.awtColor().getBlue(), this.awtColor().getAlpha());
    }

    public boolean selected() {
        return this.selected;
    }

    public void selected_$eq(boolean x$1) {
        this.selected = x$1;
    }

    public Color displayColor(Color turtleColor) {
        if (this.marked() && turtleColor != null) {
            return turtleColor;
        }
        if (turtleColor == null || this.awtColor().getAlpha() == turtleColor.getAlpha()) {
            return this.awtColor();
        }
        return new Color(this.awtColor().getRed(), this.awtColor().getGreen(), this.awtColor().getBlue(), turtleColor.getAlpha());
    }

    public abstract Rectangle bounds();

    public abstract Point[] getHandles();

    public abstract String toReadableString();

    public abstract void modify(Point var1, Point var2);

    public abstract void draw(GraphicsInterface var1, Color var2, double var3, double var5);

    public abstract void rotateLeft();

    public abstract void rotateRight();

    public abstract void flipHorizontal();

    public abstract void flipVertical();

    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        return object;
    }

    public abstract void reshapeElement(Point var1, Point var2);

    public abstract void setModifiedPoint(Point var1);

    public abstract boolean contains(Point var1);

    public abstract void moveElement(int var1, int var2);

    public boolean shouldSave() {
        return true;
    }

    public Rectangle createRect(Point start, Point end) {
        return new Rectangle(StrictMath.min(start.x, end.x), StrictMath.min(start.y, end.y), StrictMath.abs(start.x - end.x), StrictMath.abs(start.y - end.y));
    }

    public Point rotatePoint(Point point, Point pivot, int angle) {
        Point rotatedPoint = new Point(point.x, 2 * pivot.y - point.y);
        double radius = this.distance(rotatedPoint, pivot);
        if (radius == 0.0) {
            return rotatedPoint;
        }
        double newAngle = StrictMath.atan((double)(rotatedPoint.y - pivot.y) / (double)(rotatedPoint.x - pivot.x));
        if (rotatedPoint.x < pivot.x) {
            newAngle += Math.PI;
        }
        if (newAngle < 0.0) {
            newAngle += Math.PI * 2;
        }
        double newx = (double)pivot.x + radius * StrictMath.cos(newAngle -= Math.PI * 2 * (double)angle / (double)360);
        double newy = (double)pivot.y + radius * StrictMath.sin(newAngle);
        newy = (double)(2 * pivot.y) - newy;
        return new Point((int)StrictMath.rint(newx), (int)StrictMath.rint(newy));
    }

    public double distance(Point center, Point circum) {
        return StrictMath.sqrt(StrictMath.pow(Int$.MODULE$.int2double(center.y - circum.y), 2.0) + StrictMath.pow(Int$.MODULE$.int2double(center.x - circum.x), 2.0));
    }

    public int min(int[] array) {
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(array).min((Ordering)Ordering.Int$.MODULE$));
    }

    public int max(int[] array) {
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(array).max((Ordering)Ordering.Int$.MODULE$));
    }

    public void select() {
        this.selected_$eq(true);
    }

    public void deselect() {
        this.selected_$eq(false);
    }
}

