/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Element;
import org.nlogo.shape.Element$;
import org.nlogo.shape.Line;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;
import org.nlogo.shape.VectorShape;
import org.nlogo.shape.VectorShape$;
import org.nlogo.shape.editor.EditorDialog;
import org.nlogo.shape.editor.ElementType;
import org.nlogo.shape.editor.ElementType$Circle$;
import org.nlogo.shape.editor.ElementType$Line$;
import org.nlogo.shape.editor.ElementType$Polygon$;
import org.nlogo.shape.editor.ElementType$Rectangle$;
import org.nlogo.swing.Utils$;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class ShapeView
extends JPanel
implements PropertyChangeListener {
    private final EditorDialog editorDialog;
    private final VectorShape shape;
    private Point start;
    private Point last;
    private Point previous;
    private Option<Element> tempElement;
    private Option<Element> selectedElement;
    private Seq<Point> handles;
    private boolean draggingHandle;
    private boolean draggingElement;
    private int handleIndex;

    public ShapeView(EditorDialog editorDialog, VectorShape shape) {
        this.editorDialog = editorDialog;
        this.shape = shape;
        this.start = new Point(0, 0);
        this.last = new Point(0, 0);
        this.previous = new Point(0, 0);
        this.tempElement = None$.MODULE$;
        this.selectedElement = None$.MODULE$;
        this.handles = (Seq)((SeqOps)Nil$.MODULE$);
        this.draggingHandle = false;
        this.draggingElement = false;
        this.handleIndex = -1;
        this.setBackground(Color.DARK_GRAY.darker().darker());
        this.setOpaque(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        MouseInputAdapter handler = new MouseInputAdapter(this){
            private final /* synthetic */ ShapeView $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mousePressed(MouseEvent e) {
                this.$outer.org$nlogo$shape$editor$ShapeView$$mousePressed(e);
            }

            public void mouseMoved(MouseEvent e) {
                this.$outer.org$nlogo$shape$editor$ShapeView$$mouseMoved(e);
            }

            public void mouseDragged(MouseEvent e) {
                this.$outer.org$nlogo$shape$editor$ShapeView$$mouseDragged(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.$outer.org$nlogo$shape$editor$ShapeView$$mouseReleased(e);
            }
        };
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    public int getHandleIndex() {
        return this.handleIndex;
    }

    public Option<Element> getSelectedElement() {
        return this.selectedElement;
    }

    public void selectElement(Element element) {
        this.selectedElement = Some$.MODULE$.apply((Object)element);
        element.select();
    }

    public void setTempElement(Element element) {
        this.tempElement = Option$.MODULE$.apply((Object)element);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 300);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(300, 300);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.repaint();
    }

    private int gridGapX() {
        return this.getWidth() / VectorShape$.MODULE$.NUM_GRID_LINES();
    }

    private int gridGapY() {
        return this.getHeight() / VectorShape$.MODULE$.NUM_GRID_LINES();
    }

    private Point snapPointToGrid(Point point) {
        return new Point((int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)point.x / (double)this.gridGapX())) * this.gridGapX(), (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)point.y / (double)this.gridGapY())) * this.gridGapY());
    }

    public void selfFinishPolygon(boolean add) {
        this.tempElement.foreach(_$1 -> {
            Element element = _$1;
            if (element instanceof Polygon) {
                Polygon p = (Polygon)element;
                p.selfClose();
                p.filled_$eq(this.editorDialog.isFillShapes());
                this.editorDialog.makeUndoableDraw(p);
                if (add) {
                    this.shape.add(p);
                }
                this.tempElement = None$.MODULE$;
                return;
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2DWrapper g2d = new Graphics2DWrapper(Utils$.MODULE$.initGraphics2D(g));
        if (this.editorDialog.isRotatable()) {
            g2d.setColor(Color.DARK_GRAY.darker());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setColor(Color.BLACK);
            g.fillOval(0, 0, this.getWidth(), this.getHeight());
        }
        g2d.setColor(Color.DARK_GRAY.darker());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), VectorShape$.MODULE$.NUM_GRID_LINES()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            g2d.drawLine(Int$.MODULE$.int2double(i * Element$.MODULE$.round(Int$.MODULE$.int2double(this.gridGapX()))), 0.0, Int$.MODULE$.int2double(i * Element$.MODULE$.round(Int$.MODULE$.int2double(this.gridGapX()))), Int$.MODULE$.int2double(this.getHeight()));
            g2d.drawLine(0.0, Int$.MODULE$.int2double(i * Element$.MODULE$.round(Int$.MODULE$.int2double(this.gridGapY()))), Int$.MODULE$.int2double(this.getWidth()), Int$.MODULE$.int2double(i * Element$.MODULE$.round(Int$.MODULE$.int2double(this.gridGapY()))));
        });
        g2d.setColor(Color.DARK_GRAY);
        g2d.drawLine((double)this.getWidth() / 2.0, 0.0, (double)this.getWidth() / 2.0, Int$.MODULE$.int2double(this.getHeight()));
        g2d.drawLine(0.0, (double)this.getHeight() / 2.0, Int$.MODULE$.int2double(this.getWidth()), (double)this.getWidth() / 2.0);
        g2d.drawLine(0.0, Int$.MODULE$.int2double(VectorShape$.MODULE$.NUM_GRID_LINES() * Element$.MODULE$.round(Int$.MODULE$.int2double(this.gridGapY()))), Int$.MODULE$.int2double(this.getWidth()), Int$.MODULE$.int2double(VectorShape$.MODULE$.NUM_GRID_LINES() * Element$.MODULE$.round(Int$.MODULE$.int2double(this.gridGapY()))));
        g2d.antiAliasing(true);
        this.shape.getElements().foreach(element -> {
            g2d.setColor(element.awtColor());
            element.draw(g2d, null, 300.0, 0.0);
        });
        this.tempElement.foreach(element -> {
            g2d.setColor(this.editorDialog.getElementColor());
            element.draw(g2d, null, 300.0, 0.0);
        });
        this.handles = (Seq)this.selectedElement.map((Function1 & Serializable)_$2 -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])_$2.getHandles());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)handle -> {
                g2d.setColor(Color.WHITE);
                g.drawRect(handle.x - 2, handle.y - 2, 4, 4);
                g2d.setColor(Color.BLACK);
                g.fillRect(handle.x - 1, handle.y - 1, 3, 3);
                return handle;
            }, ClassTag$.MODULE$.apply(Point.class)));
            return ArrayOps$.MODULE$.toSeq$extension(object2);
        }).getOrElse(this::paintComponent$$anonfun$5);
    }

    private int checkHandles(Point start) {
        return this.handles.indexWhere((Function1 & Serializable)handle -> start$1.x < handle.x + 3 && start$1.x > handle.x - 3 && start$1.y < handle.y + 3 && start$1.y > handle.y - 3);
    }

    private void selectHandle(int index, Element lastElement) {
        this.draggingHandle = true;
        this.handleIndex = index;
        lastElement.setModifiedPoint((Point)this.handles.apply(index));
        this.editorDialog.makeUndoableModification((Element)this.selectedElement.get(), this.shape.getElements().indexOf(this.selectedElement.get()));
    }

    public void deselectAll() {
        this.shape.getElements().foreach(_$3 -> _$3.deselect());
        this.selectedElement = None$.MODULE$;
        this.shape.changed();
        this.repaint();
    }

    private void checkElements(Point start) {
        int index = this.checkHandles(start);
        if (index != -1 && this.selectedElement.isDefined()) {
            this.selectHandle(index, (Element)this.selectedElement.get());
            return;
        }
        Option option = ((IterableOnceOps)this.shape.getElements().reverse()).find((Function1 & Serializable)_$4 -> _$4.contains(start));
        if (option instanceof Some) {
            Element element = (Element)((Some)option).value();
            this.draggingElement = true;
            this.selectedElement.foreach(_$5 -> _$5.deselect());
            element.select();
            this.selectedElement = Some$.MODULE$.apply((Object)element);
            this.editorDialog.makeUndoableModification(element, this.shape.getElements().indexOf((Object)element));
            this.shape.changed();
            this.repaint();
            return;
        }
        this.deselectAll();
        this.repaint();
    }

    public void org$nlogo$shape$editor$ShapeView$$mousePressed(MouseEvent e) {
        this.start = e.getPoint();
        if (this.editorDialog.isEditingElements()) {
            this.checkElements(this.start);
        }
        this.start = this.editorDialog.isSnapToGrid() ? this.snapPointToGrid(e.getPoint()) : e.getPoint();
        this.last = this.start;
        Element element = (Element)this.tempElement.getOrElse(ShapeView::mousePressed$$anonfun$1);
        if (element instanceof Polygon) {
            Polygon p = (Polygon)element;
            p.addNewPoint(this.start);
            this.repaint();
            return;
        }
        ElementType elementType = this.editorDialog.getElementType();
        ElementType$Polygon$ elementType$Polygon$ = ElementType$Polygon$.MODULE$;
        if (!(elementType != null ? !elementType.equals(elementType$Polygon$) : elementType$Polygon$ != null)) {
            this.tempElement = this.createElement(this.start, this.start);
            this.editorDialog.makeUndoableUnfinishedPolygon();
            return;
        }
    }

    public void org$nlogo$shape$editor$ShapeView$$mouseMoved(MouseEvent e) {
        this.last = this.editorDialog.isSnapToGrid() ? this.snapPointToGrid(e.getPoint()) : e.getPoint();
        this.tempElement.foreach(_$6 -> {
            Element element = _$6;
            if (element instanceof Polygon) {
                Polygon p = (Polygon)element;
                p.modifyPoint(this.last);
                this.repaint();
                return;
            }
        });
    }

    public void org$nlogo$shape$editor$ShapeView$$mouseDragged(MouseEvent e) {
        this.previous = this.last;
        this.last = this.editorDialog.isSnapToGrid() ? this.snapPointToGrid(e.getPoint()) : e.getPoint();
        if (this.editorDialog.isEditingElements()) {
            if (this.draggingHandle) {
                this.selectedElement.foreach(_$7 -> _$7.reshapeElement((Point)this.handles.apply(this.handleIndex), this.last));
            } else if (this.draggingElement) {
                this.selectedElement.foreach(_$8 -> _$8.moveElement(this.last.x - this.previous.x, this.last.y - this.previous.y));
            }
        }
        ElementType elementType = this.editorDialog.getElementType();
        ElementType$Polygon$ elementType$Polygon$ = ElementType$Polygon$.MODULE$;
        if (elementType == null ? elementType$Polygon$ != null : !elementType.equals(elementType$Polygon$)) {
            this.tempElement = this.tempElement.map((Function1 & Serializable)element -> {
                element.modify(this.start, this.last);
                return element;
            }).orElse(this::mouseDragged$$anonfun$4);
        }
        this.repaint();
    }

    public void org$nlogo$shape$editor$ShapeView$$mouseReleased(MouseEvent e) {
        if (this.editorDialog.isEditingElements()) {
            if (this.draggingHandle) {
                this.draggingHandle = false;
                this.shape.changed();
            } else if (this.draggingElement) {
                this.draggingElement = false;
                this.shape.changed();
            }
        }
        this.tempElement.foreach(element -> {
            Element element2 = element;
            if (element2 instanceof Polygon) {
                Polygon p = (Polygon)element2;
                if (e.getClickCount() == 2) {
                    p.finishUp();
                    if (p.xCoords().size() >= 3) {
                        p.filled_$eq(this.editorDialog.isFillShapes());
                        this.shape.add(p);
                        this.editorDialog.makeUndoableDraw(p);
                        p.select();
                        this.selectedElement = Some$.MODULE$.apply((Object)p);
                        this.editorDialog.setEditingElements(true);
                        this.shape.changed();
                    }
                    this.tempElement = None$.MODULE$;
                }
            } else {
                element.filled_$eq(this.editorDialog.isFillShapes());
                this.shape.add((Element)element);
                this.editorDialog.makeUndoableDraw((Element)element);
                element.select();
                this.selectedElement = Some$.MODULE$.apply(element);
                this.editorDialog.setEditingElements(true);
                this.shape.changed();
                this.tempElement = None$.MODULE$;
            }
            this.repaint();
        });
    }

    private Option<Element> createElement(Point start, Point last) {
        if (!this.editorDialog.isEditingElements()) {
            ElementType elementType = this.editorDialog.getElementType();
            if (ElementType$Line$.MODULE$.equals(elementType)) {
                return Some$.MODULE$.apply((Object)new Line(start, last, this.editorDialog.getElementColor()));
            }
            if (ElementType$Rectangle$.MODULE$.equals(elementType)) {
                return Some$.MODULE$.apply((Object)new Rectangle(start, last, this.editorDialog.getElementColor()));
            }
            if (ElementType$Circle$.MODULE$.equals(elementType)) {
                return Some$.MODULE$.apply((Object)new Circle(start, last, this.editorDialog.getElementColor()));
            }
            if (ElementType$Polygon$.MODULE$.equals(elementType)) {
                return Some$.MODULE$.apply((Object)new Polygon(start, this.editorDialog.getElementColor()));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private final Seq paintComponent$$anonfun$5() {
        return this.handles;
    }

    private static final Element mousePressed$$anonfun$1() {
        return null;
    }

    private final Option mouseDragged$$anonfun$4() {
        return this.createElement(this.start, this.last);
    }
}

