/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.JobOwner;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.api.Options;
import org.nlogo.awt.Mouse$;
import org.nlogo.core.AgentKind;
import org.nlogo.core.Button;
import org.nlogo.core.Button$;
import org.nlogo.core.I18N$;
import org.nlogo.core.Widget;
import org.nlogo.editor.Colorizer;
import org.nlogo.nvm.Procedure;
import org.nlogo.swing.ScalableIcon;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.window.ButtonEditPanel;
import org.nlogo.window.ButtonWidget$;
import org.nlogo.window.ButtonWidget$ButtonType$;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import org.nlogo.window.Events;
import org.nlogo.window.JobWidget;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public class ButtonWidget
extends JobWidget
implements Editable,
MouseListener,
MouseMotionListener,
Events.JobRemovedEvent.Handler,
Events.TickStateChangeEvent.Handler {
    private final CompilerServices compiler;
    private final Colorizer colorizer;
    private ScalableIcon foreverIcon;
    private ScalableIcon foreverIconPressed;
    private ScalableIcon foreverIconDisabled;
    private ButtonType _buttonType;
    private final JLabel keyLabel;
    private final JLabel nameLabel;
    private final JLabel foreverLabel;
    private final JLabel agentLabel;
    private boolean foreverOn;
    private boolean setupFinished;
    private boolean _buttonUp;
    private boolean _forever;
    private boolean _goTime;
    private Option<Object> _actionKey;
    private boolean _keyEnabled;
    private boolean hover;
    private boolean lastMousePressedWasPopupTrigger;
    private boolean running;
    private boolean stopping;
    private String _name;

    public static int PrefHeight() {
        return ButtonWidget$.MODULE$.PrefHeight();
    }

    public ButtonWidget(MersenneTwisterFast random, CompilerServices compiler, Colorizer colorizer) {
        this.compiler = compiler;
        this.colorizer = colorizer;
        super(random);
        this.foreverIcon = Utils$.MODULE$.iconScaledWithColor("/images/forever.png", 15, 15, InterfaceColors$.MODULE$.buttonText());
        this.foreverIconPressed = Utils$.MODULE$.iconScaledWithColor("/images/forever.png", 15, 15, InterfaceColors$.MODULE$.buttonTextPressed());
        this.foreverIconDisabled = Utils$.MODULE$.iconScaledWithColor("/images/forever.png", 15, 15, InterfaceColors$.MODULE$.buttonTextDisabled());
        this._buttonType = ButtonWidget$ButtonType$.MODULE$.ObserverButton();
        this.keyLabel = new JLabel();
        this.nameLabel = new JLabel(I18N$.MODULE$.gui().get("edit.button.previewName"));
        this.foreverLabel = new JLabel(this.foreverIcon);
        this.agentLabel = new JLabel();
        this.keyLabel().setFont(this.keyLabel().getFont().deriveFont(12.0f));
        this.agentLabel().setVisible(false);
        this.keyLabel().addMouseListener(this);
        this.nameLabel().addMouseListener(this);
        this.foreverLabel().addMouseListener(this);
        this.agentLabel().addMouseListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridheight = 2;
        c.insets = new Insets(3, 6, 3, 0);
        this.add((Component)this.agentLabel(), c);
        c.weightx = 1.0;
        c.insets = new Insets(3, 6, 3, 3);
        this.add((Component)this.nameLabel(), c);
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 11;
        c.insets = new Insets(3, 0, 0, 3);
        this.add((Component)this.keyLabel(), c);
        c.gridy = 1;
        c.anchor = 15;
        c.insets = new Insets(0, 0, 3, 3);
        this.add((Component)this.foreverLabel(), c);
        this.initGUI();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.foreverOn = false;
        this.setupFinished = false;
        this._buttonUp = true;
        this._forever = false;
        this._goTime = false;
        this._actionKey = None$.MODULE$;
        this._keyEnabled = false;
        this.hover = false;
        this.lastMousePressedWasPopupTrigger = false;
        this.running = false;
        this.stopping = false;
        this._name = "";
    }

    private MersenneTwisterFast random$accessor() {
        return super.random();
    }

    public JLabel keyLabel() {
        return this.keyLabel;
    }

    public JLabel nameLabel() {
        return this.nameLabel;
    }

    public JLabel foreverLabel() {
        return this.foreverLabel;
    }

    public JLabel agentLabel() {
        return this.agentLabel;
    }

    @Override
    public void initGUI() {
        this.nameLabel().setFont(this.nameLabel().getFont().deriveFont(this._boldState()));
    }

    @Override
    public EditPanel editPanel() {
        return new ButtonEditPanel(this, this.compiler, this.colorizer);
    }

    @Override
    public Option<Editable> getEditable() {
        return Some$.MODULE$.apply((Object)this);
    }

    public void buttonType_$eq(ButtonType bt) {
        this._buttonType = bt;
        Option<ImageIcon> option = this._buttonType.img(false);
        if (None$.MODULE$.equals(option)) {
            this.agentLabel().setVisible(false);
        } else if (option instanceof Some) {
            ImageIcon img = (ImageIcon)((Some)option).value();
            this.agentLabel().setVisible(true);
            this.agentLabel().setIcon(img);
        } else {
            throw new MatchError(option);
        }
        this.repaint();
    }

    public ButtonType buttonType() {
        return this._buttonType;
    }

    @Override
    public AgentKind kind() {
        return this.buttonType().agentKind();
    }

    @Override
    public void agentKind(AgentKind c) {
    }

    public Options<String> agentOptions() {
        return this.buttonType().toAgentOptions();
    }

    public void setAgentOptions(Options<String> newAgentOptions) {
        if (!BoxesRunTime.equals((Object)newAgentOptions.chosenValue(), (Object)this.agentOptions().chosenValue())) {
            this.buttonType_$eq(ButtonWidget$ButtonType$.MODULE$.apply(newAgentOptions.chosenValue()));
            this.recompile();
            this.repaint();
            return;
        }
    }

    public boolean foreverOn() {
        return this.foreverOn;
    }

    public void foreverOn_$eq(boolean x$1) {
        this.foreverOn = x$1;
    }

    public boolean setupFinished() {
        return this.setupFinished;
    }

    public void setupFinished_$eq(boolean x$1) {
        this.setupFinished = x$1;
    }

    public boolean buttonUp() {
        return this._buttonUp;
    }

    public void buttonUp_$eq(boolean newButtonUp) {
        if (newButtonUp) {
            this.foreverOn_$eq(false);
        }
        this._buttonUp = newButtonUp;
        if (!this.buttonUp()) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            return;
        }
    }

    public boolean _forever() {
        return this._forever;
    }

    public void _forever_$eq(boolean x$1) {
        this._forever = x$1;
    }

    public boolean forever() {
        return this._forever();
    }

    public void setForever(boolean newForever) {
        if (newForever != this._forever()) {
            this._forever_$eq(newForever);
            this.stopping_$eq(false);
            this.recompile();
            this.repaint();
            return;
        }
    }

    public boolean goTime() {
        return this._goTime;
    }

    public void setGoTime(boolean value) {
        this._goTime = value;
    }

    public char actionKey() {
        return BoxesRunTime.unboxToChar((Object)this._actionKey.getOrElse(ButtonWidget::actionKey$$anonfun$1));
    }

    public void setActionKey(char newActionKey) {
        char c = newActionKey;
        this._actionKey = '\u0000' == c ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)newActionKey));
        this.keyLabel().setText((String)this._actionKey.map((Function1 & Serializable)_$5 -> ButtonWidget.setActionKey$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$5))).getOrElse(ButtonWidget::setActionKey$$anonfun$2));
        this.keyLabel().setVisible(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.keyLabel().getText())));
        this.repaint();
    }

    public boolean keyEnabled() {
        return this._keyEnabled;
    }

    public void keyEnabled(boolean newKeyEnabled) {
        if (this._keyEnabled != newKeyEnabled) {
            this._keyEnabled = newKeyEnabled;
            this.repaint();
            return;
        }
    }

    public void keyTriggered() {
        if (this.error().isEmpty()) {
            this.buttonUp_$eq(false);
            this.respondToClick(true);
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.error().isEmpty() && !e.isPopupTrigger() && this.isEnabled() && !this.lastMousePressedWasPopupTrigger && !this.disabledWaitingForSetup()) {
            e.translatePoint(this.getX(), this.getY());
            this.respondToClick(this.getBounds().contains(e.getPoint()));
            return;
        }
    }

    private boolean disabledWaitingForSetup() {
        return this.goTime() && !this.setupFinished();
    }

    private void respondToClick(boolean inBounds) {
        if (this.disabledWaitingForSetup()) {
            this.buttonUp_$eq(true);
            return;
        }
        if (this.error().isEmpty()) {
            if (this.forever()) {
                if (inBounds) {
                    this.foreverOn_$eq(!this.foreverOn());
                    this.buttonUp_$eq(!this.foreverOn());
                    this.action();
                    return;
                }
                this.buttonUp_$eq(!this.foreverOn());
                return;
            }
            this.buttonUp_$eq(true);
            if (inBounds) {
                this.action();
                return;
            }
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        new Events.InputBoxLoseFocusEvent().raise(this);
        this.lastMousePressedWasPopupTrigger = e.isPopupTrigger();
        if (this.error().isEmpty() && !e.isPopupTrigger() && Mouse$.MODULE$.hasButton1(e) && this.isEnabled() && !this.disabledWaitingForSetup()) {
            this.buttonUp_$eq(false);
            return;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.error().isEmpty()) {
            if (Mouse$.MODULE$.hasButton1(e) && this.isEnabled()) {
                e.translatePoint(this.getX(), this.getY());
                if (this.getBounds().contains(e.getPoint()) && !e.isPopupTrigger() && !this.disabledWaitingForSetup()) {
                    this.buttonUp_$eq(false);
                    return;
                }
                if (!this.forever() || !this.foreverOn()) {
                    this.buttonUp_$eq(true);
                    return;
                }
                return;
            }
            return;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.hover = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hover = false;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isPopupTrigger() && this.error().isDefined() && !this.lastMousePressedWasPopupTrigger && Mouse$.MODULE$.hasButton1(e)) {
            new Events.EditWidgetEvent(this).raise(this);
            return;
        }
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("tabs.run.widgets.button");
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public boolean stopping() {
        return this.stopping;
    }

    public void stopping_$eq(boolean x$1) {
        this.stopping = x$1;
    }

    @Override
    public boolean isButton() {
        return true;
    }

    @Override
    public boolean isTurtleForeverButton() {
        ButtonType buttonType = this.buttonType();
        ButtonType buttonType2 = ButtonWidget$ButtonType$.MODULE$.TurtleButton();
        return !(buttonType != null ? !((Object)buttonType).equals(buttonType2) : buttonType2 != null) && this.forever();
    }

    @Override
    public boolean isLinkForeverButton() {
        ButtonType buttonType = this.buttonType();
        ButtonType buttonType2 = ButtonWidget$ButtonType$.MODULE$.LinkButton();
        return !(buttonType != null ? !((Object)buttonType).equals(buttonType2) : buttonType2 != null) && this.forever();
    }

    public String name() {
        return this._name;
    }

    public void setVarName(String newName) {
        this._name = newName;
        this.chooseDisplayName();
    }

    @Override
    public void procedure_$eq(Procedure p) {
        super.procedure_$eq(p);
    }

    public void action() {
        if (this.error().isEmpty()) {
            if (this.forever() || !this.running()) {
                if (!this.forever() || this.running()) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                }
                if (this.forever() && this.running()) {
                    this.foreverOn_$eq(true);
                    this.buttonUp_$eq(false);
                    this.stopping_$eq(true);
                } else {
                    this.stopping_$eq(false);
                    this.running_$eq(true);
                }
                if (this.forever() && this.buttonUp()) {
                    new Events.RemoveJobEvent(this).raise(this);
                    return;
                }
                if (this.forever() && !this.buttonUp() && this.stopping()) {
                    new Events.JobStoppingEvent(this).raise(this);
                    return;
                }
                new Events.AddJobEvent(this, this.agents(), this.procedure()).raise(this);
                return;
            }
            return;
        }
    }

    @Override
    public void handle(Events.JobRemovedEvent e) {
        JobOwner jobOwner = e.owner;
        ButtonWidget buttonWidget = this;
        if (!(jobOwner != null ? !jobOwner.equals(buttonWidget) : buttonWidget != null)) {
            this.popUpStoppingButton();
            return;
        }
    }

    @Override
    public void handle(Events.TickStateChangeEvent e) {
        this.setupFinished_$eq(e.tickCounterInitialized);
        this.repaint();
    }

    public void popUpStoppingButton() {
        this.buttonUp_$eq(true);
        this.running_$eq(false);
        this.stopping_$eq(false);
        this.repaint();
        this.setCursor(null);
    }

    private void chooseDisplayName() {
        String string = this.name();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = this.getSourceName();
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                this.displayName(I18N$.MODULE$.gui().get("edit.button.previewName"));
            } else {
                this.displayName(this.getSourceName());
            }
        } else {
            this.displayName(this.name());
        }
        this.nameLabel().setText(this.displayName());
        this.repaint();
    }

    private String getSourceName() {
        return this.innerSource().trim().replaceAll("\\s+", " ");
    }

    @Override
    public void innerSource_$eq(String newInnerSource) {
        super.innerSource_$eq(newInnerSource);
        this.chooseDisplayName();
    }

    public String wrapSource() {
        return this.innerSource();
    }

    public void setWrapSource(String newInnerSource) {
        String string = newInnerSource;
        String string2 = this.innerSource();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.innerSource_$eq(newInnerSource);
            this.recompile();
            return;
        }
    }

    public void recompile() {
        String header = "to __button [] " + this.buttonType().toHeaderCode() + (this.forever() ? " loop [ " : "");
        String footer = "\n" + (this.forever() ? "__foreverbuttonend ] " : "__done ") + "end";
        new Events.RemoveJobEvent(this).raise(this);
        this.source(header, this.innerSource(), footer);
        this.chooseDisplayName();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this._oldSize()) {
            return new Dimension(55, 33);
        }
        return new Dimension(55, 35);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.getMinimumSize().width), super.getPreferredSize().width + 12), ButtonWidget$.MODULE$.PrefHeight());
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean drawAsUp;
        boolean bl = drawAsUp = this.buttonUp() && !this.running();
        if (this.disabledWaitingForSetup()) {
            if (this.error().isDefined()) {
                this.setBackgroundColor(InterfaceColors$.MODULE$.widgetTextError());
                this.keyLabel().setForeground(InterfaceColors$.MODULE$.buttonText());
                this.nameLabel().setForeground(InterfaceColors$.MODULE$.buttonText());
                this.foreverLabel().setIcon(this.foreverIcon);
            } else {
                this.setBackgroundColor(InterfaceColors$.MODULE$.buttonBackgroundDisabled());
                this.keyLabel().setForeground(InterfaceColors$.MODULE$.buttonTextDisabled());
                this.nameLabel().setForeground(InterfaceColors$.MODULE$.buttonTextDisabled());
                this.foreverLabel().setIcon(this.foreverIconDisabled);
            }
        } else if (drawAsUp) {
            this.setBackgroundColor(this.error().isDefined() ? InterfaceColors$.MODULE$.widgetTextError() : (this.hover ? InterfaceColors$.MODULE$.buttonBackgroundHover() : InterfaceColors$.MODULE$.buttonBackground()));
            this.keyLabel().setForeground(InterfaceColors$.MODULE$.buttonText());
            this.nameLabel().setForeground(InterfaceColors$.MODULE$.buttonText());
            this.foreverLabel().setIcon(this.foreverIcon);
        } else {
            this.setBackgroundColor(this.error().isDefined() ? InterfaceColors$.MODULE$.widgetTextError() : (this.hover ? InterfaceColors$.MODULE$.buttonBackgroundPressedHover() : InterfaceColors$.MODULE$.buttonBackgroundPressed()));
            this.keyLabel().setForeground(InterfaceColors$.MODULE$.buttonTextPressed());
            if (this.error().isEmpty()) {
                this.nameLabel().setForeground(InterfaceColors$.MODULE$.buttonTextPressed());
            }
            this.foreverLabel().setIcon(this.foreverIconPressed);
        }
        this.foreverLabel().setVisible(this.forever());
        if (this.nameLabel().getPreferredSize().width > this.nameLabel().getWidth()) {
            this.nameLabel().setToolTipText((String)(this.disabledWaitingForSetup() ? "(disabled) " + this.nameLabel().getText() : this.nameLabel().getText()));
        } else {
            this.nameLabel().setToolTipText(this.disabledWaitingForSetup() ? "(disabled)" : null);
        }
        super.paintComponent(g);
    }

    @Override
    public void syncTheme() {
        this.foreverIcon = Utils$.MODULE$.iconScaledWithColor("/images/forever.png", 15, 15, InterfaceColors$.MODULE$.buttonText());
        this.foreverIconPressed = Utils$.MODULE$.iconScaledWithColor("/images/forever.png", 15, 15, InterfaceColors$.MODULE$.buttonTextPressed());
        this.foreverIconDisabled = Utils$.MODULE$.iconScaledWithColor("/images/forever.png", 15, 15, InterfaceColors$.MODULE$.buttonTextDisabled());
    }

    @Override
    public Widget model() {
        Rectangle b = this.getUnzoomedBounds();
        None$ savedActionKey = this.actionKey() == '\u0000' || this.actionKey() == ' ' ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)this.actionKey()));
        Option<String> option = this.RichWidgetString(this.name()).potentiallyEmptyStringToOption();
        int n = b.x;
        int n2 = b.y;
        int n3 = b.width;
        int n4 = b.height;
        boolean bl = this._oldSize();
        Option<String> option2 = this.RichWidgetString(this.innerSource()).potentiallyEmptyStringToOption();
        boolean bl2 = this.forever();
        AgentKind agentKind = this.buttonType().agentKind();
        boolean bl3 = this.goTime();
        return Button$.MODULE$.apply(option2, n, n2, n3, n4, bl, option, bl2, agentKind, (Option<Object>)savedActionKey, bl3);
    }

    @Override
    public void load(Widget model) {
        Widget widget = model;
        if (widget instanceof Button) {
            Button button = (Button)widget;
            this.setForever(button.forever());
            this.buttonType_$eq(ButtonWidget$ButtonType$.MODULE$.apply(button.buttonKind()));
            button.actionKey().foreach((Function1 & Serializable)v1 -> {
                this.load$$anonfun$1(BoxesRunTime.unboxToChar((Object)v1));
                return BoxedUnit.UNIT;
            });
            this.setGoTime(button.disableUntilTicksStart());
            this.setVarName(this.RichStringOption(button.display()).optionToPotentiallyEmptyString());
            button.source().foreach(newInnerSource -> this.setWrapSource((String)newInnerSource));
            this.oldSize(button.oldSize());
            this.setSize(button.width(), button.height());
            this.chooseDisplayName();
            return;
        }
    }

    private static final char actionKey$$anonfun$1() {
        return '\u0000';
    }

    private static final /* synthetic */ String setActionKey$$anonfun$1(char _$5) {
        return BoxesRunTime.boxToCharacter((char)_$5).toString();
    }

    private static final String setActionKey$$anonfun$2() {
        return "";
    }

    private final /* synthetic */ void load$$anonfun$1(char _$6) {
        this.setActionKey(_$6);
    }

    public static class ButtonType
    implements Product,
    Serializable {
        private final String name;
        private final AgentKind agentKind;
        private final Option<ImageIcon> img;
        private final Option<ImageIcon> darkImg;

        public static ButtonType LinkButton() {
            return ButtonWidget$ButtonType$.MODULE$.LinkButton();
        }

        public static ButtonType ObserverButton() {
            return ButtonWidget$ButtonType$.MODULE$.ObserverButton();
        }

        public static ButtonType PatchButton() {
            return ButtonWidget$ButtonType$.MODULE$.PatchButton();
        }

        public static ButtonType TurtleButton() {
            return ButtonWidget$ButtonType$.MODULE$.TurtleButton();
        }

        public static ButtonType apply(AgentKind agentKind) {
            return ButtonWidget$ButtonType$.MODULE$.apply(agentKind);
        }

        public static ButtonType apply(String string) {
            return ButtonWidget$ButtonType$.MODULE$.apply(string);
        }

        public static ButtonType apply(String string, AgentKind agentKind, Option<ImageIcon> option, Option<ImageIcon> option2) {
            return ButtonWidget$ButtonType$.MODULE$.apply(string, agentKind, option, option2);
        }

        public static List<ButtonType> buttonTypes() {
            return ButtonWidget$ButtonType$.MODULE$.buttonTypes();
        }

        public static ImageIcon darkImage(ImageIcon imageIcon) {
            return ButtonWidget$ButtonType$.MODULE$.darkImage(imageIcon);
        }

        public static Options<String> defaultAgentOptions() {
            return ButtonWidget$ButtonType$.MODULE$.defaultAgentOptions();
        }

        public static ButtonType fromProduct(Product product) {
            return ButtonWidget$ButtonType$.MODULE$.fromProduct(product);
        }

        public static AgentKind getAgentClass(String string) {
            return ButtonWidget$ButtonType$.MODULE$.getAgentClass(string);
        }

        public static ButtonType unapply(ButtonType buttonType) {
            return ButtonWidget$ButtonType$.MODULE$.unapply(buttonType);
        }

        public ButtonType(String name, AgentKind agentKind, Option<ImageIcon> img, Option<ImageIcon> darkImg) {
            this.name = name;
            this.agentKind = agentKind;
            this.img = img;
            this.darkImg = darkImg;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ButtonType)) return false;
            ButtonType buttonType = (ButtonType)object;
            String string = this.name();
            String string2 = buttonType.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            AgentKind agentKind = this.agentKind();
            AgentKind agentKind2 = buttonType.agentKind();
            if (agentKind == null) {
                if (agentKind2 != null) {
                    return false;
                }
            } else if (!agentKind.equals(agentKind2)) return false;
            Option<ImageIcon> option = this.img();
            Option<ImageIcon> option2 = buttonType.img();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<ImageIcon> option3 = this.darkImg();
            Option<ImageIcon> option4 = buttonType.darkImg();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!buttonType.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ButtonType;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ButtonType";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "agentKind";
                }
                case 2: {
                    return "img";
                }
                case 3: {
                    return "darkImg";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public AgentKind agentKind() {
            return this.agentKind;
        }

        public Option<ImageIcon> img() {
            return this.img;
        }

        public Option<ImageIcon> darkImg() {
            return this.darkImg;
        }

        public Option<ImageIcon> img(boolean dark) {
            if (dark) {
                return this.darkImg();
            }
            return this.img();
        }

        public String toHeaderCode() {
            return "__" + this.name().toLowerCase() + "code ";
        }

        public Options<String> toAgentOptions() {
            Options<String> opts = ButtonWidget$ButtonType$.MODULE$.defaultAgentOptions();
            opts.selectValue(this.name());
            return opts;
        }

        public ButtonType copy(String name, AgentKind agentKind, Option<ImageIcon> img, Option<ImageIcon> darkImg) {
            return new ButtonType(name, agentKind, img, darkImg);
        }

        public String copy$default$1() {
            return this.name();
        }

        public AgentKind copy$default$2() {
            return this.agentKind();
        }

        public Option<ImageIcon> copy$default$3() {
            return this.img();
        }

        public Option<ImageIcon> copy$default$4() {
            return this.darkImg();
        }

        public String _1() {
            return this.name();
        }

        public AgentKind _2() {
            return this.agentKind();
        }

        public Option<ImageIcon> _3() {
            return this.img();
        }

        public Option<ImageIcon> _4() {
            return this.darkImg();
        }
    }
}

