/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.nlogo.agent.InputBoxConstraint;
import org.nlogo.agent.World$;
import org.nlogo.api.Approximate$;
import org.nlogo.api.Color$;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Dump$;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.LogoException;
import org.nlogo.api.Options;
import org.nlogo.api.ValueConstraint;
import org.nlogo.awt.Fonts$;
import org.nlogo.awt.Hierarchy$;
import org.nlogo.awt.Positioning$;
import org.nlogo.core.BoxedValue;
import org.nlogo.core.CompilerException;
import org.nlogo.core.I18N$;
import org.nlogo.core.LogoList;
import org.nlogo.core.NumericInput;
import org.nlogo.core.NumericInput$;
import org.nlogo.core.NumericInput$ColorLabel$;
import org.nlogo.core.NumericInput$NumberLabel$;
import org.nlogo.core.StringInput;
import org.nlogo.core.StringInput$;
import org.nlogo.core.StringInput$CommandLabel$;
import org.nlogo.core.StringInput$ReporterLabel$;
import org.nlogo.core.StringInput$StringLabel$;
import org.nlogo.core.Widget;
import org.nlogo.editor.AbstractEditorArea;
import org.nlogo.swing.Button;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.DialogButton;
import org.nlogo.swing.MouseUtils;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.swing.RoundedBorderPanel;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.Transparent;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.DoubleOnly$;
import org.nlogo.window.Editable;
import org.nlogo.window.Events;
import org.nlogo.window.InputBox$;
import org.nlogo.window.InputBox$InputType$;
import org.nlogo.window.JFXColorPicker;
import org.nlogo.window.JFXColorPicker$;
import org.nlogo.window.NLColorValue;
import org.nlogo.window.NLNumber$;
import org.nlogo.window.RGBA$;
import org.nlogo.window.SingleErrorWidget;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public abstract class InputBox
extends SingleErrorWidget
implements Editable,
Events.InputBoxLoseFocusEvent.Handler {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(InputBox.class.getDeclaredField("InputType$lzy1"));
    public final AbstractEditorArea org$nlogo$window$InputBox$$textArea;
    private final AbstractEditorArea editDialogTextArea;
    public final CompilerServices org$nlogo$window$InputBox$$compiler;
    public final Component org$nlogo$window$InputBox$$nextComponent;
    private final JLabel widgetLabel;
    private InputDialog dialog;
    public boolean org$nlogo$window$InputBox$$_hasFocus;
    public final EditorKit org$nlogo$window$InputBox$$codeEditorKit;
    private InputType inputType;
    public final InputBoxConstraint org$nlogo$window$InputBox$$constraint;
    private final Button changeButton;
    private final ColorButton colorSwatch;
    public final InputScrollPane org$nlogo$window$InputBox$$scroller;
    private String text;
    private String oldText;
    private Option<Object> value;
    private boolean multiline;
    private boolean errorShowing;
    private Options<InputType> typeOptions;
    private String name;
    private boolean nameChanged;
    private boolean editing;
    private volatile Object InputType$lzy1;

    public static int MinHeight() {
        return InputBox$.MODULE$.MinHeight();
    }

    public static int MinWidth() {
        return InputBox$.MODULE$.MinWidth();
    }

    public InputBox(AbstractEditorArea textArea, AbstractEditorArea editDialogTextArea, CompilerServices compiler, Component nextComponent) {
        this.org$nlogo$window$InputBox$$textArea = textArea;
        this.editDialogTextArea = editDialogTextArea;
        this.org$nlogo$window$InputBox$$compiler = compiler;
        this.org$nlogo$window$InputBox$$nextComponent = nextComponent;
        this.widgetLabel = new JLabel(I18N$.MODULE$.gui().get("edit.input.previewName"));
        this.dialog = null;
        this.org$nlogo$window$InputBox$$_hasFocus = false;
        this.org$nlogo$window$InputBox$$codeEditorKit = textArea.getEditorKit();
        this.inputType = new StringInputType();
        this.org$nlogo$window$InputBox$$constraint = new InputBoxConstraint(this.inputType().baseName(), this.inputType().defaultValue());
        this.changeButton = new Button("Change", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (this.dialog() == null || !this.dialog().isVisible()) {
                this.editing_$eq(true);
                this.dialog_$eq(new InputDialog(this, Hierarchy$.MODULE$.getFrame(this), this.name(), this.inputType(), editDialogTextArea));
                this.dialog().setVisible(true);
                ((JTextComponent)((Object)editDialogTextArea)).setText(((JTextComponent)((Object)textArea)).getText());
                ((JTextComponent)((Object)editDialogTextArea)).selectAll();
                return;
            }
        });
        this.colorSwatch = new ColorButton();
        this.org$nlogo$window$InputBox$$scroller = new InputScrollPane(this, textArea);
        this.text = "";
        this.oldText = "";
        this.value = None$.MODULE$;
        this.multiline = false;
        this.errorShowing = false;
        this.typeOptions = new Options();
        this.name = "";
        this.nameChanged = false;
        this.editing = false;
        this.InputType().addTypeOptions(this.typeOptions());
        this.typeOptions().selectValue(this.inputType());
        textArea.setEditorKit(this.inputType().getEditorKit());
        ((JComponent)((Object)textArea)).setFont(this.inputType().getFont());
        textArea.enableBracketMatcher(this.inputType().enableBracketMatcher());
        this.multiline(this.multiline());
        this.setLayout(new GridBagLayout());
        this.initGUI();
        this.colorSwatch().setVisible(false);
        ((Component)((Object)textArea)).addFocusListener(new FocusListener(this){
            private final /* synthetic */ InputBox $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void focusGained(FocusEvent e) {
                this.$outer.org$nlogo$window$InputBox$$_hasFocus = true;
                this.$outer.editing_$eq(true);
            }

            public void focusLost(FocusEvent e) {
                this.$outer.org$nlogo$window$InputBox$$_hasFocus = false;
                if (this.$outer.editing()) {
                    try {
                        this.$outer.inputText(this.$outer.inputType().readValue(((JTextComponent)((Object)this.$outer.org$nlogo$window$InputBox$$textArea)).getText()));
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof LogoException || throwable2 instanceof CompilerException || throwable2 instanceof ValueConstraint.Violation) {
                            Exception ex = (Exception)throwable2;
                            this.$outer.inputText(this.$outer.oldText());
                        }
                        throw throwable;
                    }
                    this.$outer.editing_$eq(false);
                    return;
                }
            }
        });
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("tabs.run.widgets.input");
    }

    public JLabel widgetLabel() {
        return this.widgetLabel;
    }

    public InputDialog dialog() {
        return this.dialog;
    }

    public void dialog_$eq(InputDialog x$1) {
        this.dialog = x$1;
    }

    public InputType inputType() {
        return this.inputType;
    }

    public void inputType_$eq(InputType x$1) {
        this.inputType = x$1;
    }

    public Button changeButton() {
        return this.changeButton;
    }

    public ColorButton colorSwatch() {
        return this.colorSwatch;
    }

    public String text() {
        return this.text;
    }

    public void text_$eq(String x$1) {
        this.text = x$1;
    }

    public String oldText() {
        return this.oldText;
    }

    public void oldText_$eq(String x$1) {
        this.oldText = x$1;
    }

    public Option<Object> value() {
        return this.value;
    }

    public void value_$eq(Option<Object> x$1) {
        this.value = x$1;
    }

    public String valueText() {
        return this.text();
    }

    public Object valueObject() {
        return this.value().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void valueObject(Object value) {
        this.valueObject(value, false);
    }

    public void valueObject(Object value, boolean raiseEvent) {
        this.oldText_$eq(this.text());
        this.text_$eq(Dump$.MODULE$.logoObject(this.toAnyRef(value)));
        this.value_$eq((Option<Object>)Option$.MODULE$.apply(this.toAnyRef(value)));
        String string = this.text();
        String string2 = ((JTextComponent)((Object)this.org$nlogo$window$InputBox$$textArea)).getText();
        if (string == null ? string2 != null : !string.equals(string2)) {
            ((JTextComponent)((Object)this.org$nlogo$window$InputBox$$textArea)).setText(this.text());
        }
        new Events.DirtyEvent((Option<String>)None$.MODULE$).raise(this);
    }

    public Object toAnyRef(Object value) {
        Object object = value;
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return BoxesRunTime.boxToDouble((double)d);
        }
        if (object instanceof Object) {
            Object a = object;
            return a;
        }
        Object v = object;
        throw new IllegalStateException();
    }

    public void inputText(Object input) {
        if (input != null) {
            this.valueObject(input, true);
            return;
        }
    }

    public boolean multiline() {
        return this.multiline;
    }

    public void multiline_$eq(boolean x$1) {
        this.multiline = x$1;
    }

    public void multiline(boolean multiline) {
        this.multiline_$eq(multiline);
        this.changeButton().setVisible(this.inputType().changeVisible());
        this.editing_$eq(false);
        ((JComponent)((Object)this.org$nlogo$window$InputBox$$textArea)).getInputMap().put(KeyStroke.getKeyStroke(27, 0), new CancelAction());
        ((JComponent)((Object)this.org$nlogo$window$InputBox$$textArea)).getInputMap().put(KeyStroke.getKeyStroke(10, 0), multiline ? null : new TransferFocusAction());
        ((JComponent)((Object)this.org$nlogo$window$InputBox$$textArea)).getInputMap().put(KeyStroke.getKeyStroke(9, 0), new TransferFocusAction());
    }

    public void updateKeyBindings() {
    }

    public boolean errorShowing() {
        return this.errorShowing;
    }

    public void errorShowing_$eq(boolean x$1) {
        this.errorShowing = x$1;
    }

    public Options<InputType> typeOptions() {
        return this.typeOptions;
    }

    public void typeOptions_$eq(Options<InputType> x$1) {
        this.typeOptions = x$1;
    }

    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    public boolean nameChanged() {
        return this.nameChanged;
    }

    public void nameChanged_$eq(boolean x$1) {
        this.nameChanged = x$1;
    }

    public void name(String name) {
        this.name(name, true);
    }

    public void name(String name, boolean sendEvent) {
        this.name_$eq(name);
        String string = name;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.displayName(I18N$.MODULE$.gui().get("edit.input.previewName"));
        } else {
            this.displayName(name);
        }
        this.widgetLabel().setText(this.displayName());
    }

    public String nameWrapper() {
        return this.name();
    }

    public void setNameWrapper(String name) {
        String string = name;
        String string2 = this.name();
        this.nameChanged_$eq((string != null ? !string.equals(string2) : string2 != null) || this.nameChanged());
        this.name(name, false);
    }

    public boolean editing() {
        return this.editing;
    }

    public void editing_$eq(boolean x$1) {
        this.editing = x$1;
    }

    public void stopEdit() {
        this.editing_$eq(false);
        this.transferFocus();
        this.org$nlogo$window$InputBox$$nextComponent.requestFocus();
    }

    @Override
    public void initGUI() {
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.insets = this._oldSize() ? new Insets(this.zoom(3.0), this.zoom(6.0), this.zoom(6.0), this.zoom(6.0)) : new Insets(this.zoom(6.0), this.zoom(8.0), this.zoom(6.0), this.zoom(8.0));
        this.add((Component)this.widgetLabel(), c);
        this.widgetLabel().setFont(this.widgetLabel().getFont().deriveFont(this._boldState()));
        c.gridx = 1;
        c.weightx = 0.0;
        c.anchor = 13;
        c.insets = this._oldSize() ? new Insets(this.zoom(3.0), 0, this.zoom(6.0), this.zoom(6.0)) : new Insets(this.zoom(8.0), 0, this.zoom(6.0), this.zoom(8.0));
        this.add((Component)this.changeButton(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = this._oldSize() ? new Insets(0, this.zoom(6.0), this.zoom(6.0), this.zoom(6.0)) : new Insets(0, this.zoom(8.0), this.zoom(8.0), this.zoom(8.0));
        this.org$nlogo$window$InputBox$$scroller.initGUI();
        this.add((Component)this.org$nlogo$window$InputBox$$scroller, c);
        this.add((Component)this.colorSwatch(), c);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setBackgroundColor(InterfaceColors$.MODULE$.inputBackground());
        this.widgetLabel().setForeground(InterfaceColors$.MODULE$.widgetText());
        super.paintComponent(g);
        if (this.widgetLabel().getPreferredSize().width > this.widgetLabel().getWidth()) {
            this.widgetLabel().setToolTipText(this.widgetLabel().getText());
        } else {
            this.widgetLabel().setToolTipText(null);
        }
        if (this.isHover()) {
            Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
            if (this.colorSwatch().isVisible()) {
                g2d.setPaint(new LinearGradientPaint(this.colorSwatch().getX(), this.colorSwatch().getY() + 3, this.colorSwatch().getX(), this.colorSwatch().getY() + this.colorSwatch().getHeight() + 3, new float[]{0.0f, 1.0f}, new Color[]{InterfaceColors$.MODULE$.widgetHoverShadow(), InterfaceColors$.MODULE$.Transparent()}));
                g2d.fillRoundRect(this.colorSwatch().getX(), this.colorSwatch().getY() + 3, this.colorSwatch().getWidth(), this.colorSwatch().getHeight(), 6, 6);
                return;
            }
            g2d.setPaint(new LinearGradientPaint(this.org$nlogo$window$InputBox$$scroller.getX(), this.org$nlogo$window$InputBox$$scroller.getY() + 3, this.org$nlogo$window$InputBox$$scroller.getX(), this.org$nlogo$window$InputBox$$scroller.getY() + this.org$nlogo$window$InputBox$$scroller.getHeight() + 3, new float[]{0.0f, 1.0f}, new Color[]{InterfaceColors$.MODULE$.widgetHoverShadow(), InterfaceColors$.MODULE$.Transparent()}));
            g2d.fillRoundRect(this.org$nlogo$window$InputBox$$scroller.getX(), this.org$nlogo$window$InputBox$$scroller.getY() + 3, this.org$nlogo$window$InputBox$$scroller.getWidth(), this.org$nlogo$window$InputBox$$scroller.getHeight(), 6, 6);
            return;
        }
    }

    @Override
    public void syncTheme() {
        this.colorSwatch().syncTheme();
        this.org$nlogo$window$InputBox$$scroller.syncTheme();
        this.changeButton().syncTheme();
        if (this.dialog() != null) {
            this.dialog().syncTheme();
            return;
        }
    }

    public void org$nlogo$window$InputBox$$showError(Exception ex) {
        Frame frame = Hierarchy$.MODULE$.getFrame(this);
        if (frame != null) {
            String msg = ex.getMessage();
            if (msg.startsWith("REPORT expected 1 input.")) {
                msg = I18N$.MODULE$.gui().get("edit.input.invalid.message");
            }
            new OptionPane(frame, I18N$.MODULE$.gui().getN("edit.input.invalid.title", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.inputType()})), msg, OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
            return;
        }
    }

    @Override
    public void handle(Events.InputBoxLoseFocusEvent e) {
        if (this.org$nlogo$window$InputBox$$_hasFocus) {
            this.transferFocus();
            return;
        }
    }

    @Override
    public void updateConstraints() {
        if (this.name().length() > 0) {
            new Events.AddInputBoxConstraintEvent(this.name(), this.org$nlogo$window$InputBox$$constraint).raise(this);
            return;
        }
    }

    @Override
    public boolean editFinished() {
        super.editFinished();
        this.name(this.name(), this.nameChanged());
        this.nameChanged_$eq(false);
        try {
            this.inputText(this.org$nlogo$window$InputBox$$constraint.coerceValue(this.inputType().readValue(this.text())));
        }
        catch (LogoException ex) {
            throw new IllegalStateException(ex);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof CompilerException || throwable2 instanceof ValueConstraint.Violation) {
                Exception ex = (Exception)throwable2;
                this.org$nlogo$window$InputBox$$showError(ex);
            }
            throw throwable;
        }
        return true;
    }

    public void setTypeOptions(Options<InputType> typeOptions) {
        this.typeOptions_$eq(typeOptions);
        String string = this.inputType().displayName();
        String string2 = typeOptions.chosenValue().displayName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.inputType_$eq(typeOptions.chosenValue());
            this.org$nlogo$window$InputBox$$constraint.setType(this.inputType().baseName(), this.inputType().defaultValue());
            try {
                this.org$nlogo$window$InputBox$$constraint.assertConstraint(this.toAnyRef(this.value()));
            }
            catch (ValueConstraint.Violation v) {
                this.valueObject(this.inputType().defaultValue(), true);
            }
            this.org$nlogo$window$InputBox$$textArea.setEditorKit(this.inputType().getEditorKit());
            ((JComponent)((Object)this.org$nlogo$window$InputBox$$textArea)).setFont(this.inputType().getFont());
            this.org$nlogo$window$InputBox$$textArea.enableBracketMatcher(this.inputType().enableBracketMatcher());
            this.changeButton().setVisible(this.inputType().changeVisible());
            this.inputType().colorPanel(this.colorSwatch());
        }
        this.org$nlogo$window$InputBox$$scroller.scrollPane().setHorizontalScrollBarPolicy(this.inputType().multiline() ? 30 : 31);
        this.multiline(this.inputType().multiline());
        if (this.dialog() != null) {
            this.dialog().dispose();
            this.dialog_$eq(null);
            return;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this._oldSize()) {
            return new Dimension(InputBox$.MODULE$.MinWidth(), InputBox$.MODULE$.MinHeight());
        }
        return new Dimension(100, 60);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._oldSize()) {
            Dimension result = super.getPreferredSize();
            Insets insets = this.getInsets();
            result.width = ((JComponent)((Object)this.org$nlogo$window$InputBox$$textArea)).getPreferredSize().width + insets.left + insets.right + ((JComponent)((Object)this.org$nlogo$window$InputBox$$textArea)).getInsets().right + ((JComponent)((Object)this.org$nlogo$window$InputBox$$textArea)).getInsets().left + 4;
            return new Dimension(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(InputBox$.MODULE$.MinWidth()), result.width), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(InputBox$.MODULE$.MinHeight()), result.height));
        }
        return new Dimension(250, 60);
    }

    @Override
    public void load(Widget model) {
        Widget widget = model;
        if (widget instanceof org.nlogo.core.InputBox) {
            org.nlogo.core.InputBox input = (org.nlogo.core.InputBox)widget;
            this.name(input.varName());
            this.multiline(input.multiline());
            this.setType$1(input.boxedValue());
            try {
                this.setValue$1(input.boxedValue());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof CompilerException || throwable2 instanceof ValueConstraint.Violation || throwable2 instanceof LogoException) {
                    Exception e = (Exception)throwable2;
                    this.setValue$1(input.boxedValue().default());
                }
                throw throwable;
            }
            this.oldSize(input.oldSize());
            this.setSize(input.width(), input.height());
            return;
        }
    }

    @Override
    public Widget model() {
        Rectangle b = this.getUnzoomedBounds();
        BoxedValue boxedValue = this.inputType().boxValue(this.text());
        int n = b.x;
        int n2 = b.y;
        int n3 = b.width;
        int n4 = b.height;
        boolean bl = this._oldSize();
        Option<String> option = this.RichWidgetString(this.name()).potentiallyEmptyStringToOption();
        return org.nlogo.core.InputBox$.MODULE$.apply(option, n, n2, n3, n4, bl, boxedValue);
    }

    @Override
    public boolean exportable() {
        return true;
    }

    @Override
    public String getDefaultExportName() {
        return "export.txt";
    }

    @Override
    public boolean hasContextMenu() {
        return true;
    }

    public final InputBox$InputType$ InputType() {
        Object object = this.InputType$lzy1;
        if (object instanceof InputBox$InputType$) {
            return (InputBox$InputType$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (InputBox$InputType$)this.InputType$lzyINIT1();
    }

    private Object InputType$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.InputType$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    InputBox$InputType$ inputBox$InputType$ = null;
                    try {
                        inputBox$InputType$ = new InputBox$InputType$(this);
                        serializable = inputBox$InputType$ == null ? LazyVals.NullValue$.MODULE$ : inputBox$InputType$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.InputType$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return inputBox$InputType$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Font plainFont() {
        return new Font(Fonts$.MODULE$.platformMonospacedFont(), 0, 12);
    }

    public static final /* synthetic */ boolean org$nlogo$window$InputBox$SelectColorActionListener$$_$_$$anonfun$1(Object _$1) {
        return _$1 instanceof Double;
    }

    private final void setType$1(BoxedValue i) {
        this.inputType_$eq(this.InputType().create(i));
        this.org$nlogo$window$InputBox$$textArea.setEditorKit(this.inputType().getEditorKit());
        ((JComponent)((Object)this.org$nlogo$window$InputBox$$textArea)).setFont(this.inputType().getFont());
        this.org$nlogo$window$InputBox$$textArea.enableBracketMatcher(this.inputType().enableBracketMatcher());
        this.typeOptions().selectByName(this.inputType().displayName());
        this.org$nlogo$window$InputBox$$constraint.setType(this.inputType().baseName(), this.inputType().defaultValue());
        this.changeButton().setVisible(this.inputType().changeVisible());
    }

    private final void setValue$1(BoxedValue i) {
        BoxedValue boxedValue = i;
        if (boxedValue instanceof NumericInput) {
            NumericInput numericInput = NumericInput$.MODULE$.unapply((NumericInput)boxedValue);
            double d = numericInput._1();
            NumericInput.NumericKind numericKind = numericInput._2();
            double value = d;
            this.valueObject(BoxesRunTime.boxToDouble((double)value), true);
            return;
        }
        if (boxedValue instanceof StringInput) {
            StringInput stringInput = StringInput$.MODULE$.unapply((StringInput)boxedValue);
            String string = stringInput._1();
            StringInput.StringKind stringKind = stringInput._2();
            boolean bl = stringInput._3();
            String value = string;
            this.valueObject(value, true);
            return;
        }
        throw new MatchError((Object)boxedValue);
    }

    public static final /* synthetic */ boolean org$nlogo$window$InputBox$ColorInputType$$_$_$$anonfun$2(Object _$2) {
        return _$2 instanceof Double;
    }

    public class CancelAction
    extends AbstractAction {
        public CancelAction() {
            if (InputBox.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((JTextComponent)((Object)InputBox.this.org$nlogo$window$InputBox$$textArea)).setText(InputBox.this.text());
            InputBox.this.stopEdit();
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$CancelAction$$$outer() {
            return InputBox.this;
        }
    }

    public class ColorButton
    extends JButton
    implements Transparent,
    MouseUtils,
    RoundedBorderPanel,
    ThemeSync {
        private boolean org$nlogo$swing$MouseUtils$$useHandCursor;
        private boolean org$nlogo$swing$MouseUtils$$hover;
        private boolean org$nlogo$swing$MouseUtils$$pressed;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$borderColor;
        private int org$nlogo$swing$RoundedBorderPanel$$diameter;
        private boolean org$nlogo$swing$RoundedBorderPanel$$hoverEnabled;
        private boolean org$nlogo$swing$RoundedBorderPanel$$pressedEnabled;
        private Color color;

        public ColorButton() {
            if (InputBox.this == null) {
                throw new NullPointerException();
            }
            Transparent.$init$(this);
            MouseUtils.$init$(this);
            RoundedBorderPanel.$init$(this);
            this.color = Color.black;
            this.setBorder(null);
            this.setFont(this.getFont().deriveFont(9.0f));
            this.addActionListener(new SelectColorActionListener());
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$useHandCursor() {
            return this.org$nlogo$swing$MouseUtils$$useHandCursor;
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$hover() {
            return this.org$nlogo$swing$MouseUtils$$hover;
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$pressed() {
            return this.org$nlogo$swing$MouseUtils$$pressed;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$useHandCursor_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$useHandCursor = x$1;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$hover_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$hover = x$1;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$pressed_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$pressed = x$1;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$borderColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$borderColor;
        }

        @Override
        public int org$nlogo$swing$RoundedBorderPanel$$diameter() {
            return this.org$nlogo$swing$RoundedBorderPanel$$diameter;
        }

        @Override
        public boolean org$nlogo$swing$RoundedBorderPanel$$hoverEnabled() {
            return this.org$nlogo$swing$RoundedBorderPanel$$hoverEnabled;
        }

        @Override
        public boolean org$nlogo$swing$RoundedBorderPanel$$pressedEnabled() {
            return this.org$nlogo$swing$RoundedBorderPanel$$pressedEnabled;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$borderColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$borderColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$diameter_$eq(int x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$diameter = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$hoverEnabled_$eq(boolean x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$hoverEnabled = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$pressedEnabled_$eq(boolean x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$pressedEnabled = x$1;
        }

        @Override
        public /* synthetic */ void org$nlogo$swing$RoundedBorderPanel$$super$paintComponent(Graphics x$0) {
            super.paintComponent(x$0);
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setBackgroundColor(this.color);
            this.setDiameter(Int$.MODULE$.int2double(InputBox.this.zoom(6.0)));
            RoundedBorderPanel.paintComponent$(this, g);
        }

        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        public void syncTheme() {
            this.setBorderColor(InterfaceColors$.MODULE$.inputBorder());
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$ColorButton$$$outer() {
            return InputBox.this;
        }
    }

    public class ColorInputType
    extends InputType {
        public ColorInputType(EditorKit kit) {
            if (InputBox.this == null) {
                throw new NullPointerException();
            }
            super(InputBox.this, "Color", "color", kit, InputBox.this.plainFont());
        }

        @Override
        public Object readValue(String text) throws CompilerException {
            return InputBox.this.org$nlogo$window$InputBox$$compiler.readNumberFromString(text);
        }

        @Override
        public BoxedValue boxValue(String text) {
            Double num = InputBox.this.org$nlogo$window$InputBox$$compiler.readNumberFromString(text);
            return NumericInput$.MODULE$.apply(num, NumericInput$ColorLabel$.MODULE$);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void colorPanel(ColorButton panel) {
            panel.setVisible(true);
            InputBox.this.org$nlogo$window$InputBox$$scroller.setVisible(false);
            if (InputBox.this.value().exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, org$nlogo$window$InputBox$ColorInputType$$_$_$$anonfun$2(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)())) {
                cv = Predef$.MODULE$.double2Double(Color$.MODULE$.modulateDouble(BoxesRunTime.unboxToDouble((Object)InputBox.this.value().get())));
                v0 = Tuple2$.MODULE$.apply((Object)cv, (Object)Color$.MODULE$.getColor(cv));
            } else {
                v0 = Tuple2$.MODULE$.apply((Object)Predef$.MODULE$.double2Double(0.0), (Object)Color.BLACK);
            }
            var2_3 = v0;
            colorval = (Double)var2_3._1();
            c = (Color)var2_3._2();
            panel.setColor(c);
            panel.setForeground(Predef$.MODULE$.Double2double(colorval) % (double)10 > (double)5 ? Color.BLACK : Color.WHITE);
            var6_6 = colorval;
            if (var6_6 == null) ** GOTO lbl-1000
            var7_7 = var6_6;
            d = var7_7;
            if (d == 0.0) {
                v1 = "0 (black)";
            } else {
                d = var7_7;
                if (d == 9.9) {
                    v1 = "9.9 (white)";
                } else lbl-1000:
                // 2 sources

                {
                    c = var6_6;
                    index = (int)(Predef$.MODULE$.Double2double(c) / (double)10);
                    baseColor = index * 10 + 5;
                    v1 = Dump$.MODULE$.number(c) + " (" + Color$.MODULE$.getColorNameByIndex(index) + (String)(Predef$.MODULE$.Double2double(c) > (double)baseColor ? " + " + Dump$.MODULE$.number(Approximate$.MODULE$.approximate(Predef$.MODULE$.Double2double(c) - (double)baseColor, 1)) : (Predef$.MODULE$.Double2double(c) < (double)baseColor ? " - " + Dump$.MODULE$.number(Approximate$.MODULE$.approximate((double)baseColor - Predef$.MODULE$.Double2double(c), 1)) : "")) + ")";
                }
            }
            panel.setText((String)v1);
        }

        @Override
        public boolean changeVisible() {
            return false;
        }

        @Override
        public boolean enableMultiline() {
            return false;
        }

        @Override
        public Object defaultValue() {
            return BoxesRunTime.boxToDouble((double)15.0);
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$ColorInputType$$$outer() {
            return InputBox.this;
        }
    }

    public class CommandInputType
    extends InputType {
        public CommandInputType(EditorKit kit) {
            if (InputBox.this == null) {
                throw new NullPointerException();
            }
            super(InputBox.this, "String (commands)", "string.commands", kit, InputBox.this.plainFont());
        }

        @Override
        public boolean enableBracketMatcher() {
            return true;
        }

        @Override
        public Object readValue(String text) throws CompilerException, ValueConstraint.Violation {
            InputBox.this.org$nlogo$window$InputBox$$constraint.assertConstraint(text);
            Exceptions$.MODULE$.ignoring((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{CompilerException.class}), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.readValue$$anonfun$2(text);
                return BoxedUnit.UNIT;
            });
            return text;
        }

        @Override
        public BoxedValue boxValue(String text) {
            return StringInput$.MODULE$.apply(text, StringInput$CommandLabel$.MODULE$, this.multiline());
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$CommandInputType$$$outer() {
            return InputBox.this;
        }

        private final void readValue$$anonfun$2(String text$2) {
            InputBox.this.org$nlogo$window$InputBox$$compiler.checkCommandSyntax(text$2);
        }
    }

    public class InputDialog
    extends JDialog
    implements ThemeSync {
        private final InputType inputType;
        private final AbstractEditorArea textArea;
        private final JLabel label;
        private final InputScrollPane scrollPane;
        private final DialogButton okButton;
        private final DialogButton cancelButton;
        private final /* synthetic */ InputBox $outer;

        public InputDialog(InputBox $outer, Frame parent, String title, InputType inputType, AbstractEditorArea textArea) {
            this.inputType = inputType;
            this.textArea = textArea;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(parent, title);
            this.label = new JLabel(inputType.toString());
            this.scrollPane = new InputScrollPane($outer, textArea);
            this.okButton = new DialogButton(true, I18N$.MODULE$.gui().get("common.buttons.ok"), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    Object value = inputType.readValue(((JTextComponent)((Object)textArea)).getText());
                    $outer.inputText(value);
                    $outer.editing_$eq(false);
                    this.dispose();
                    $outer.dialog_$eq(null);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof LogoException || throwable2 instanceof CompilerException || throwable2 instanceof ValueConstraint.Violation) {
                        Exception ex = (Exception)throwable2;
                        $outer.org$nlogo$window$InputBox$$showError(ex);
                    }
                    throw throwable;
                }
            });
            AbstractAction cancelAction = new AbstractAction(this){
                private final /* synthetic */ InputDialog $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(I18N$.MODULE$.gui().get("common.buttons.cancel"));
                }

                public void actionPerformed(ActionEvent e) {
                    this.$outer.dispose();
                    this.$outer.org$nlogo$window$InputBox$InputDialog$$$outer().editing_$eq(false);
                    this.$outer.org$nlogo$window$InputBox$InputDialog$$$outer().dialog_$eq(null);
                }
            };
            this.cancelButton = new DialogButton(false, cancelAction);
            this.setResizable(true);
            textArea.setEditorKit(inputType.getEditorKit());
            ((JComponent)((Object)textArea)).setFont(inputType.getFont());
            textArea.enableBracketMatcher(inputType.enableBracketMatcher());
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets($outer.zoom(3.0), $outer.zoom(3.0), $outer.zoom(3.0), $outer.zoom(3.0));
            c.gridwidth = 0;
            c.anchor = 17;
            this.getContentPane().add((Component)this.label, c);
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            this.getContentPane().add((Component)this.scrollPane, c);
            c.gridy = 2;
            c.anchor = 13;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.getContentPane().add((Component)new ButtonPanel((Seq<JComponent>)((Seq)((SeqOps)new .colon.colon((Object)this.okButton, (List)new .colon.colon((Object)this.cancelButton, (List)Nil$.MODULE$))))), c);
            Utils$.MODULE$.addEscKeyAction(this, (Action)cancelAction);
            this.pack();
            Positioning$.MODULE$.center(this, parent);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ InputDialog $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void windowClosing(WindowEvent e) {
                    this.$outer.dispose();
                    this.$outer.org$nlogo$window$InputBox$InputDialog$$$outer().editing_$eq(false);
                    this.$outer.org$nlogo$window$InputBox$InputDialog$$$outer().dialog_$eq(null);
                }
            });
            Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
            this.syncTheme();
        }

        public void setText(String text) {
            ((JTextComponent)((Object)this.textArea)).setText(text);
            ((JTextComponent)((Object)this.textArea)).selectAll();
        }

        @Override
        public void syncTheme() {
            this.getContentPane().setBackground(InterfaceColors$.MODULE$.dialogBackground());
            this.label.setForeground(InterfaceColors$.MODULE$.dialogText());
            ((JComponent)((Object)this.textArea)).setBackground(InterfaceColors$.MODULE$.textAreaBackground());
            ((JComponent)((Object)this.textArea)).setForeground(InterfaceColors$.MODULE$.textAreaText());
            ((JTextComponent)((Object)this.textArea)).setCaretColor(InterfaceColors$.MODULE$.textAreaText());
            this.scrollPane.syncTheme();
            this.okButton.syncTheme();
            this.cancelButton.syncTheme();
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$InputDialog$$$outer() {
            return this.$outer;
        }
    }

    public class InputScrollPane
    extends JPanel
    implements Transparent,
    MouseUtils,
    RoundedBorderPanel,
    ThemeSync {
        private boolean org$nlogo$swing$MouseUtils$$useHandCursor;
        private boolean org$nlogo$swing$MouseUtils$$hover;
        private boolean org$nlogo$swing$MouseUtils$$pressed;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$borderColor;
        private int org$nlogo$swing$RoundedBorderPanel$$diameter;
        private boolean org$nlogo$swing$RoundedBorderPanel$$hoverEnabled;
        private boolean org$nlogo$swing$RoundedBorderPanel$$pressedEnabled;
        public final AbstractEditorArea org$nlogo$window$InputBox$InputScrollPane$$textArea;
        private final ScrollPane scrollPane;
        private final /* synthetic */ InputBox $outer;

        public InputScrollPane(InputBox $outer, AbstractEditorArea textArea) {
            this.org$nlogo$window$InputBox$InputScrollPane$$textArea = textArea;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Transparent.$init$(this);
            MouseUtils.$init$(this);
            RoundedBorderPanel.$init$(this);
            this.scrollPane = new ScrollPane(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super((Component)((Object)$outer.org$nlogo$window$InputBox$InputScrollPane$$textArea), 20, 31);
                    this.setBorder(null);
                }
            };
            ((JComponent)((Object)textArea)).setOpaque(false);
            ((JComponent)((Object)textArea)).setBackground(InterfaceColors$.MODULE$.Transparent());
            this.setLayout(new GridBagLayout());
            this.initGUI();
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$useHandCursor() {
            return this.org$nlogo$swing$MouseUtils$$useHandCursor;
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$hover() {
            return this.org$nlogo$swing$MouseUtils$$hover;
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$pressed() {
            return this.org$nlogo$swing$MouseUtils$$pressed;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$useHandCursor_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$useHandCursor = x$1;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$hover_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$hover = x$1;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$pressed_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$pressed = x$1;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$borderColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$borderColor;
        }

        @Override
        public int org$nlogo$swing$RoundedBorderPanel$$diameter() {
            return this.org$nlogo$swing$RoundedBorderPanel$$diameter;
        }

        @Override
        public boolean org$nlogo$swing$RoundedBorderPanel$$hoverEnabled() {
            return this.org$nlogo$swing$RoundedBorderPanel$$hoverEnabled;
        }

        @Override
        public boolean org$nlogo$swing$RoundedBorderPanel$$pressedEnabled() {
            return this.org$nlogo$swing$RoundedBorderPanel$$pressedEnabled;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$borderColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$borderColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$diameter_$eq(int x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$diameter = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$hoverEnabled_$eq(boolean x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$hoverEnabled = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$pressedEnabled_$eq(boolean x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$pressedEnabled = x$1;
        }

        @Override
        public /* synthetic */ void org$nlogo$swing$RoundedBorderPanel$$super$paintComponent(Graphics x$0) {
            super.paintComponent(x$0);
        }

        public ScrollPane scrollPane() {
            return this.scrollPane;
        }

        public void initGUI() {
            this.removeAll();
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.insets = new Insets(this.$outer.zoom(3.0), this.$outer.zoom(3.0), this.$outer.zoom(3.0), this.$outer.zoom(3.0));
            this.add((Component)this.scrollPane(), c);
            ((JTextComponent)((Object)this.org$nlogo$window$InputBox$InputScrollPane$$textArea)).setMargin(new Insets(this.$outer.zoom(2.0), this.$outer.zoom(6.0), this.$outer.zoom(2.0), this.$outer.zoom(6.0)));
        }

        @Override
        public void paintComponent(Graphics g) {
            ((Component)((Object)this.org$nlogo$window$InputBox$InputScrollPane$$textArea)).setSize(this.scrollPane().getWidth() - 10, this.scrollPane().getHeight());
            this.setDiameter(Int$.MODULE$.int2double(this.$outer.zoom(6.0)));
            RoundedBorderPanel.paintComponent$(this, g);
        }

        @Override
        public void syncTheme() {
            this.setBackgroundColor(InterfaceColors$.MODULE$.displayAreaBackground());
            this.setBorderColor(InterfaceColors$.MODULE$.inputBorder());
            ((JComponent)((Object)this.org$nlogo$window$InputBox$InputScrollPane$$textArea)).setForeground(InterfaceColors$.MODULE$.displayAreaText());
            ((JTextComponent)((Object)this.org$nlogo$window$InputBox$InputScrollPane$$textArea)).setCaretColor(InterfaceColors$.MODULE$.displayAreaText());
            this.scrollPane().setBackground(InterfaceColors$.MODULE$.displayAreaBackground());
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$InputScrollPane$$$outer() {
            return this.$outer;
        }
    }

    public class InputType
    implements Product,
    Serializable {
        private final String baseName;
        private final String i18nKey;
        private final EditorKit editorKit;
        private final Font font;
        private final /* synthetic */ InputBox $outer;

        public InputType(InputBox $outer, String baseName, String i18nKey, EditorKit editorKit, Font font) {
            this.baseName = baseName;
            this.i18nKey = i18nKey;
            this.editorKit = editorKit;
            this.font = font;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof InputType;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "InputType";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "baseName";
                }
                case 1: {
                    return "i18nKey";
                }
                case 2: {
                    return "editorKit";
                }
                case 3: {
                    return "font";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String baseName() {
            return this.baseName;
        }

        public String i18nKey() {
            return this.i18nKey;
        }

        public EditorKit editorKit() {
            return this.editorKit;
        }

        public Font font() {
            return this.font;
        }

        public Object defaultValue() {
            return "";
        }

        public boolean multiline() {
            return this.$outer.multiline();
        }

        public void multiline(boolean newMultiline) {
            this.$outer.multiline(newMultiline);
        }

        public String toString() {
            return this.displayName();
        }

        public String saveName() {
            return this.baseName();
        }

        public String displayName() {
            return I18N$.MODULE$.gui().get("edit.input.type." + this.i18nKey());
        }

        public EditorKit getEditorKit() {
            return this.editorKit();
        }

        public Font getFont() {
            return this.font();
        }

        public void colorPanel(ColorButton panel) {
            panel.setVisible(false);
            this.$outer.org$nlogo$window$InputBox$$scroller.setVisible(true);
        }

        public Object readValue(String text) throws CompilerException, LogoException, ValueConstraint.Violation {
            this.$outer.org$nlogo$window$InputBox$$constraint.assertConstraint(text);
            return text;
        }

        public boolean changeVisible() {
            return this.multiline();
        }

        public boolean enableMultiline() {
            return true;
        }

        public boolean enableBracketMatcher() {
            return false;
        }

        public boolean equals(Object a) {
            Object object = a;
            if (object instanceof InputType && ((InputType)object).org$nlogo$window$InputBox$InputType$$$outer() == this.$outer) {
                InputType inputType = (InputType)object;
                InputType inputType2 = this.$outer.InputType().unapply(inputType);
                String string = inputType2._1();
                String string2 = inputType2._2();
                EditorKit editorKit = inputType2._3();
                Font font = inputType2._4();
                String bn = string;
                InputType it = inputType;
                String string3 = bn;
                String string4 = this.baseName();
                return !(string3 != null ? !string3.equals(string4) : string4 != null);
            }
            return false;
        }

        public BoxedValue boxValue(String text) {
            return StringInput$.MODULE$.apply(text, StringInput$StringLabel$.MODULE$, this.multiline());
        }

        public InputType copy(String baseName, String i18nKey, EditorKit editorKit, Font font) {
            return new InputType(this.$outer, baseName, i18nKey, editorKit, font);
        }

        public String copy$default$1() {
            return this.baseName();
        }

        public String copy$default$2() {
            return this.i18nKey();
        }

        public EditorKit copy$default$3() {
            return this.editorKit();
        }

        public Font copy$default$4() {
            return this.font();
        }

        public String _1() {
            return this.baseName();
        }

        public String _2() {
            return this.i18nKey();
        }

        public EditorKit _3() {
            return this.editorKit();
        }

        public Font _4() {
            return this.font();
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$InputType$$$outer() {
            return this.$outer;
        }
    }

    public class NumberInputType
    extends InputType {
        public NumberInputType(EditorKit kit) {
            if (InputBox.this == null) {
                throw new NullPointerException();
            }
            super(InputBox.this, "Number", "number", kit, InputBox.this.plainFont());
        }

        @Override
        public Object readValue(String text) throws CompilerException {
            return InputBox.this.org$nlogo$window$InputBox$$compiler.readNumberFromString(text);
        }

        @Override
        public BoxedValue boxValue(String text) {
            if (text.isEmpty()) {
                return NumericInput$.MODULE$.apply(0.0, NumericInput$NumberLabel$.MODULE$);
            }
            Double num = InputBox.this.org$nlogo$window$InputBox$$compiler.readNumberFromString(text);
            return NumericInput$.MODULE$.apply(num, NumericInput$NumberLabel$.MODULE$);
        }

        @Override
        public boolean multiline() {
            return false;
        }

        @Override
        public boolean enableMultiline() {
            return false;
        }

        @Override
        public Object defaultValue() {
            return World$.MODULE$.Zero();
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$NumberInputType$$$outer() {
            return InputBox.this;
        }
    }

    public class ReporterInputType
    extends InputType {
        public ReporterInputType(EditorKit kit) {
            if (InputBox.this == null) {
                throw new NullPointerException();
            }
            super(InputBox.this, "String (reporter)", "string.reporter", kit, InputBox.this.plainFont());
        }

        @Override
        public Object defaultValue() {
            return "0";
        }

        @Override
        public boolean enableBracketMatcher() {
            return true;
        }

        @Override
        public Object readValue(String text) throws CompilerException, ValueConstraint.Violation {
            InputBox.this.org$nlogo$window$InputBox$$constraint.assertConstraint(text);
            Exceptions$.MODULE$.ignoring((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{CompilerException.class}), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.readValue$$anonfun$1(text);
                return BoxedUnit.UNIT;
            });
            return text;
        }

        @Override
        public BoxedValue boxValue(String text) {
            return StringInput$.MODULE$.apply(text, StringInput$ReporterLabel$.MODULE$, this.multiline());
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$ReporterInputType$$$outer() {
            return InputBox.this;
        }

        private final void readValue$$anonfun$1(String text$1) {
            InputBox.this.org$nlogo$window$InputBox$$compiler.checkReporterSyntax(text$1);
        }
    }

    public class SelectColorActionListener
    implements ActionListener {
        public SelectColorActionListener() {
            if (InputBox.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NLColorValue nLColorValue;
            LogoList list;
            Object object = InputBox.this.valueObject();
            if (object instanceof LogoList && (list = (LogoList)object).length() > 2 && list.toVector().take(3).forall(InputBox::org$nlogo$window$InputBox$SelectColorActionListener$$_$_$$anonfun$1)) {
                SeqOps seqOps;
                Seq seq = (Seq)list.take(3);
                if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq), 3) != 0) {
                    throw new IllegalStateException();
                }
                double d = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0));
                double d2 = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1));
                double d3 = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 2));
                double r = d;
                double g = d2;
                double b = d3;
                Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)r), (Object)BoxesRunTime.boxToDouble((double)g), (Object)BoxesRunTime.boxToDouble((double)b));
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                double r2 = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                double g2 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double b2 = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)r2), (Object)BoxesRunTime.boxToDouble((double)g2), (Object)BoxesRunTime.boxToDouble((double)b2));
                double r3 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                double g3 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                double b3 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                double a = list.length() > 3 && list.apply(3) instanceof Double ? BoxesRunTime.unboxToDouble((Object)list.apply(3)) : (double)RGBA$.MODULE$.MaxAlpha();
                nLColorValue = RGBA$.MODULE$.apply(r3, g3, b3, a);
            } else if (object instanceof Double) {
                Double num = (Double)object;
                nLColorValue = NLNumber$.MODULE$.apply(Predef$.MODULE$.Double2double(num));
            } else {
                throw new Exception("Invalid color format: " + InputBox.this.valueObject());
            }
            NLColorValue currValue = nLColorValue;
            new JFXColorPicker(Hierarchy$.MODULE$.getFrame(InputBox.this), true, DoubleOnly$.MODULE$, (Option<NLColorValue>)Option$.MODULE$.apply((Object)currValue), x -> InputBox.this.valueObject(BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x))), true), JFXColorPicker$.MODULE$.$lessinit$greater$default$6()).setVisible(true);
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$SelectColorActionListener$$$outer() {
            return InputBox.this;
        }
    }

    public class StringInputType
    extends InputType {
        public StringInputType() {
            if (InputBox.this == null) {
                throw new NullPointerException();
            }
            super(InputBox.this, "String", "string", InputBox.this.org$nlogo$window$InputBox$$textArea.getEditorKitForContentType("String"), UIManager.getFont("Label.font").deriveFont(12.0f));
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$StringInputType$$$outer() {
            return InputBox.this;
        }
    }

    public class TransferFocusAction
    extends AbstractAction {
        public TransferFocusAction() {
            if (InputBox.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InputBox.this.transferFocus();
            InputBox.this.org$nlogo$window$InputBox$$nextComponent.requestFocus();
        }

        public final /* synthetic */ InputBox org$nlogo$window$InputBox$TransferFocusAction$$$outer() {
            return InputBox.this;
        }
    }
}

